package Wikibase::Datatype;

use strict;
use warnings;

our $VERSION = 0.09;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Wikibase::Datatype - Wikibase datatypes.

=head1 DESCRIPTION

This distributions is set of datatypes for Wikibase.

=head1 SEE ALSO

=over

=item L<Wikibase::Datatype::Form>

Wikibase form datatype.

=item L<Wikibase::Datatype::Item>

Wikibase item datatype.

=item L<Wikibase::Datatype::Lexeme>

Wikibase lexeme datatype.

=item L<Wikibase::Datatype::Mediainfo>

Wikibase mediainfo datatype.

=item L<Wikibase::Datatype::MediainfoSnak>

Wikibase mediainfo snak datatype.

=item L<Wikibase::Datatype::Reference>

Wikibase reference datatype.

=item L<Wikibase::Datatype::Sense>

Wikibase sense datatype.

=item L<Wikibase::Datatype::Sitelink>

Wikibase sitelink datatype.

=item L<Wikibase::Datatype::Snak>

Wikibase snak datatype.

=item L<Wikibase::Datatype::Statement>

Wikibase statement datatype.

=item L<Wikibase::Datatype::Utils>

Wikibase datatype utilities.

=item L<Wikibase::Datatype::Value>

Wikibase value datatype.

=item L<Wikibase::Datatype::Value::Globecoordinate>

Wikibase globe coordinate value datatype.

=item L<Wikibase::Datatype::Value::Item>

Wikibase item value datatype.

=item L<Wikibase::Datatype::Value::Monolingual>

Wikibase monolingual value datatype.

=item L<Wikibase::Datatype::Value::Property>

Wikibase property value datatype.

=item L<Wikibase::Datatype::Value::Quantity>

Wikibase quantity value datatype.

=item L<Wikibase::Datatype::Value::String>

Wikibase string value datatype.

=item L<Wikibase::Datatype::Value::Time>

Wikibase time value datatype.

=back

Another projects:

=over

=item L<Wikibase::Datatype::Struct>

Wikibase structure serialization.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Wikibase-Datatype>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© Michal Josef Špaček 2020-2021

BSD 2-Clause License

=head1 VERSION

0.09

=cut
