# Generated by default/object.tt
package Paws::EKS::AddonInfo;
  use Moose;
  has AddonName => (is => 'ro', isa => 'Str', request_name => 'addonName', traits => ['NameInRequest']);
  has AddonVersions => (is => 'ro', isa => 'ArrayRef[Paws::EKS::AddonVersionInfo]', request_name => 'addonVersions', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::AddonInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::AddonInfo object:

  $service_obj->Method(Att1 => { AddonName => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::AddonInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->AddonName

=head1 DESCRIPTION

Information about an add-on.

=head1 ATTRIBUTES


=head2 AddonName => Str

The name of the add-on.


=head2 AddonVersions => ArrayRef[L<Paws::EKS::AddonVersionInfo>]

An object that represents information about available add-on versions
and compatible Kubernetes versions.


=head2 Type => Str

The type of the add-on.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

