#!/usr/bin/perl

# vim:ts=2:sw=2:et:sta:syntax=perl
use Test::More (
  skip_all => 'that book is broken',
  #'no_plan'
  );

# TODO make one of these for a smaller book
# and some mechanism to skip the slower tests

use strict;
use warnings;

BEGIN { use_ok('dtRdr::Book') };

BEGIN { use_ok('dtRdr::Book::ThoutBook_1_0') };

my $uri = 'test_packages/Offset-OK-Perl 5.8 Documentation.xml';

my $book = dtRdr::Book::ThoutBook_1_0->new();
isa_ok($book, 'dtRdr::Book');

ok(eval {$book->load_uri($uri)}, 'load');
ok((not $@), 'whee') or die;

my ($metadata) = $book->get_metadata();
isa_ok($metadata, 'dtRdr::Metadata');

TODO: {
  local $TODO = "test a whole book and check the metadata/css";
  ok($metadata->get('css'), 'css');
}

my $toc = $book->toc;
isa_ok($toc, 'dtRdr::TOC');
is($toc->get_title, 'Perl 5.8.6 Documentation', "Check TOC title");

my (@children_toc) = $book->toc->children;
is(scalar(@children_toc), 15, "Check TOC children");
is_deeply(\@children_toc, [$toc->children], 'tops and root children match');
isa_ok($_, 'dtRdr::TOC', 'child') for(@children_toc);

is(
  $children_toc[1]->get_title(),
  'perl - Practical Extraction and Report Language',
  "check first child toc title"
  );
my $testfile;
{
  local $/;
  $testfile = <DATA>;
  # Cheating a little here and stripping off any trailing whitespace
  # and newlines, since it was too much of a pain to get the data
  # segment to match the return from the book. (Which, I suppose,
  # should be fixed...)
  chomp $testfile;
  $testfile =~ s/\s//g;
}

my $html = $book->get_content(($children_toc[1]->get_children())[0]);
# Like with the data segment, strip off any trailing spaces and
# newlines for ease of matching
chomp $html;
$html =~ s/\s//g;

TODO: {
	local $TODO = 'make expect tests work again?';
  warn "TODO $TODO";
  is($html, $testfile, "Check HTML return");
}
{ # maybe less fragile than a literal expect test:
	my ($h,$t) = ($html, $testfile);
	$_ =~ s/[^\w]//g for($h,$t);
	my $like = like($h, qr/$t/is, "Rough check on HTML content");
}



__END__
<pkg:outlineMarker OutlineName="NAME" id="lib_Pod_perl_html_name">
  <h1><a name="name">NAME</a></h1>
<p>perl - Practical Extraction and Report Language</p>
</pkg:outlineMarker>

 
