use 5.008_001;
use strict;

# Script to fetch the list of HTML5 entities from w3.org and output
# the code to generate a hash of allowed entities.

use LWP::Simple;
use JSON;
use HTML::Entities qw/%entity2char/;

my $entities_json = get("http://www.w3.org/TR/html5/entities.json");
my $entities = decode_json $entities_json;

print "# Generated by html5_entities.pl\n";
my $start = 'my %html5_entity = map { "&" . $_ . ";" => 1 } qw/';
print $start;
my $len = length($start);

foreach my $entity (keys %$entities) {
    my $tmp = $entity;

    $tmp =~ s/^&//;
    next if exists $entity2char{$tmp};

    $tmp =~ s/;$//;
    next if exists $entity2char{$tmp};

    $tmp = " " . $tmp;
    if ($len + length($tmp) > 80) {
        print "\n   ";
        $len = 3;
    }

    $len += length($tmp);
    print $tmp;
}

print "/;\n"
