# Generated by default/object.tt
package Paws::NimbleStudio::StudioComponent;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has Configuration => (is => 'ro', isa => 'Paws::NimbleStudio::StudioComponentConfiguration', request_name => 'configuration', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Ec2SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'ec2SecurityGroupIds', traits => ['NameInRequest']);
  has InitializationScripts => (is => 'ro', isa => 'ArrayRef[Paws::NimbleStudio::StudioComponentInitializationScript]', request_name => 'initializationScripts', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has ScriptParameters => (is => 'ro', isa => 'ArrayRef[Paws::NimbleStudio::ScriptParameterKeyValue]', request_name => 'scriptParameters', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has StatusCode => (is => 'ro', isa => 'Str', request_name => 'statusCode', traits => ['NameInRequest']);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has StudioComponentId => (is => 'ro', isa => 'Str', request_name => 'studioComponentId', traits => ['NameInRequest']);
  has Subtype => (is => 'ro', isa => 'Str', request_name => 'subtype', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::NimbleStudio::Tags', request_name => 'tags', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);
  has UpdatedAt => (is => 'ro', isa => 'Str', request_name => 'updatedAt', traits => ['NameInRequest']);
  has UpdatedBy => (is => 'ro', isa => 'Str', request_name => 'updatedBy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::StudioComponent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::StudioComponent object:

  $service_obj->Method(Att1 => { Arn => $value, ..., UpdatedBy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::StudioComponent object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

A network that is used by a studioE<rsquo>s users and workflows,
including render farm, Active Directory, licensing, and file system.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the resource.


=head2 Configuration => L<Paws::NimbleStudio::StudioComponentConfiguration>

The configuration of the studio component, based on component type.


=head2 CreatedAt => Str

The Unix epoch timestamp in seconds for when the resource was created.


=head2 CreatedBy => Str

The user ID of the user that created the studio component.


=head2 Description => Str

A human-readable description for the studio component resource.


=head2 Ec2SecurityGroupIds => ArrayRef[Str|Undef]

The EC2 security groups that control access to the studio component.


=head2 InitializationScripts => ArrayRef[L<Paws::NimbleStudio::StudioComponentInitializationScript>]

Initialization scripts for studio components.


=head2 Name => Str

A friendly name for the studio component resource.


=head2 ScriptParameters => ArrayRef[L<Paws::NimbleStudio::ScriptParameterKeyValue>]

Parameters for the studio component scripts.


=head2 State => Str

The current state.


=head2 StatusCode => Str

The status code.


=head2 StatusMessage => Str

The status message for the studio component.


=head2 StudioComponentId => Str

The unique identifier for a studio component resource.


=head2 Subtype => Str

The specific subtype of a studio component.


=head2 Tags => L<Paws::NimbleStudio::Tags>

A collection of labels, in the form of key:value pairs, that apply to
this resource.


=head2 Type => Str

The type of the studio component.


=head2 UpdatedAt => Str

The Unix epoch timestamp in seconds for when the resource was updated.


=head2 UpdatedBy => Str

The user ID of the user that most recently updated the resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

