#!/usr/bin/perl -w
#
#    numberformat.pl
#
#    $Id: numberformat.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno);
use utf8;

use ExtUtils::testlib;
use ICU::NumberFormat;

print "<pre>\n";
my $show_currencyformat = 1;
my $show_numberformat = 1;
my $explain_nbsp = 1;
my $orig_currency = 6_123_456.0789;
my $orig_number = 1_234_567.987654;


if ($show_currencyformat) {
    print "orig_currency = $orig_currency\n\n";

    # default locale
    print "default:\n";
    my $cf = ICU::NumberFormat->createCurrencyInstance();
    my $currency_str = $cf->format($orig_currency);
    print "    currency_str (default) = $currency_str\n";
    my $parsed_currency = $cf->parse($currency_str);
    print "    parsed_currency (default) = $parsed_currency\n";

    show_currencyFormat('en_US', $orig_currency);
    show_currencyFormat('ja_JP', $orig_currency);
    show_currencyFormat('de_DE', $orig_currency);
    show_currencyFormat('fr_FR', $orig_currency);
}

sub show_currencyFormat {
    my ($locale_str, $currency) = @_;

    print "$locale_str\n";
    my $l = new ICU::Locale($locale_str);
    my $cf = ICU::NumberFormat->createCurrencyInstance($l);
    my $currency_str = $cf->format($currency);
    my $MinIntegerDigits = $cf->getMinimumIntegerDigits();
    my $MinFractionDigits = $cf->getMinimumFractionDigits();
    print "    currency_str ($locale_str) ($MinIntegerDigits.$MinFractionDigits) = $currency_str\n";
    my $parsed_currency = $cf->parse($currency_str);
    print "    parsed_currency ($locale_str) = $parsed_currency\n";
}

if ($show_numberformat) {
    print "\n\norig_number = $orig_number\n\n";

    # default locale
    print "default:\n";
    my $cf = ICU::NumberFormat->createInstance();
    my $number_str = $cf->format($orig_number);
    print "    number_str (default) = $number_str\n";
    my $parsed_number = $cf->parse($number_str);
    print "    parsed_number (default) = $parsed_number\n";

    show_numberFormat('en_US', $orig_number);
    show_numberFormat('ja_JP', $orig_number);
    show_numberFormat('de_DE', $orig_number);
    show_numberFormat('fr_FR', $orig_number);
}

sub show_numberFormat {
    my ($locale_str, $number) = @_;

    print "$locale_str\n";
    my $l = new ICU::Locale($locale_str);
    my $cf = ICU::NumberFormat->createInstance($l);
    my $number_str = $cf->format($number);
    my $MinIntegerDigits = $cf->getMinimumIntegerDigits();
    my $MinFractionDigits = $cf->getMinimumFractionDigits();
    print "    number_str ($locale_str) ($MinIntegerDigits.$MinFractionDigits) = $number_str\n";
    my $parsed_number = $cf->parse($number_str);
    print "    parsed_number ($locale_str) = $parsed_number\n";
}

if ($explain_nbsp) {
    print "(note the fr thousands separater spaces are non-breaking spaces (nbsp).)\n";
    print "(In UTF8 nbsp (0xA0) encodes to 0xC2 0xA0)\n";
    print "(displayed in a Latin1 font 0xC2 is an 'A' with a accent and 0xA0 is a space)\n";
}

print "</pre>\n";
exit(0);
