# Generated by default/object.tt
package Paws::Honeycode::DataItem;
  use Moose;
  has FormattedValue => (is => 'ro', isa => 'Str', request_name => 'formattedValue', traits => ['NameInRequest']);
  has OverrideFormat => (is => 'ro', isa => 'Str', request_name => 'overrideFormat', traits => ['NameInRequest']);
  has RawValue => (is => 'ro', isa => 'Str', request_name => 'rawValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::DataItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::DataItem object:

  $service_obj->Method(Att1 => { FormattedValue => $value, ..., RawValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::DataItem object:

  $result = $service_obj->Method(...);
  $result->Att1->FormattedValue

=head1 DESCRIPTION

The data in a particular data cell defined on the screen.

=head1 ATTRIBUTES


=head2 FormattedValue => Str

The formatted value of the data. e.g. John Smith.


=head2 OverrideFormat => Str

The overrideFormat is optional and is specified only if a particular
row of data has a different format for the data than the default format
defined on the screen or the table.


=head2 RawValue => Str

The raw value of the data. e.g. jsmith@example.com



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

