package Langertha::Spec::Mistral;
# ABSTRACT: Pre-computed OpenAPI operations for Mistral
our $VERSION = '0.300';

# AUTO-GENERATED by maint/generate_spec_data.pl -- do not edit manually.
# Source: share/mistral.yaml (67 operations)

my $DATA;

sub data {
  $DATA //= {
    server_url => 'https://api.mistral.ai',
    operations => {
      'agents_api_v1_agents_create' => { method => 'POST', path => '/v1/agents', content_type => 'application/json' },
      'agents_api_v1_agents_create_or_update_alias' => { method => 'PUT', path => '/v1/agents/{agent_id}/aliases' },
      'agents_api_v1_agents_delete' => { method => 'DELETE', path => '/v1/agents/{agent_id}' },
      'agents_api_v1_agents_get' => { method => 'GET', path => '/v1/agents/{agent_id}' },
      'agents_api_v1_agents_get_version' => { method => 'GET', path => '/v1/agents/{agent_id}/versions/{version}' },
      'agents_api_v1_agents_list' => { method => 'GET', path => '/v1/agents' },
      'agents_api_v1_agents_list_version_aliases' => { method => 'GET', path => '/v1/agents/{agent_id}/aliases' },
      'agents_api_v1_agents_list_versions' => { method => 'GET', path => '/v1/agents/{agent_id}/versions' },
      'agents_api_v1_agents_update' => { method => 'PATCH', path => '/v1/agents/{agent_id}', content_type => 'application/json' },
      'agents_api_v1_agents_update_version' => { method => 'PATCH', path => '/v1/agents/{agent_id}/version' },
      'agents_api_v1_conversations_append' => { method => 'POST', path => '/v1/conversations/{conversation_id}', content_type => 'application/json' },
      'agents_api_v1_conversations_delete' => { method => 'DELETE', path => '/v1/conversations/{conversation_id}' },
      'agents_api_v1_conversations_get' => { method => 'GET', path => '/v1/conversations/{conversation_id}' },
      'agents_api_v1_conversations_history' => { method => 'GET', path => '/v1/conversations/{conversation_id}/history' },
      'agents_api_v1_conversations_list' => { method => 'GET', path => '/v1/conversations' },
      'agents_api_v1_conversations_messages' => { method => 'GET', path => '/v1/conversations/{conversation_id}/messages' },
      'agents_api_v1_conversations_restart' => { method => 'POST', path => '/v1/conversations/{conversation_id}/restart', content_type => 'application/json' },
      'agents_api_v1_conversations_start' => { method => 'POST', path => '/v1/conversations', content_type => 'application/json' },
      'agents_completion_v1_agents_completions_post' => { method => 'POST', path => '/v1/agents/completions', content_type => 'application/json' },
      'audio_api_v1_transcriptions_post' => { method => 'POST', path => '/v1/audio/transcriptions', content_type => 'multipart/form-data' },
      'chat_classifications_v1_chat_classifications_post' => { method => 'POST', path => '/v1/chat/classifications', content_type => 'application/json' },
      'chat_completion_v1_chat_completions_post' => { method => 'POST', path => '/v1/chat/completions', content_type => 'application/json' },
      'chat_moderations_v1_chat_moderations_post' => { method => 'POST', path => '/v1/chat/moderations', content_type => 'application/json' },
      'classifications_v1_classifications_post' => { method => 'POST', path => '/v1/classifications', content_type => 'application/json' },
      'delete_model_v1_models__model_id__delete' => { method => 'DELETE', path => '/v1/models/{model_id}' },
      'embeddings_v1_embeddings_post' => { method => 'POST', path => '/v1/embeddings', content_type => 'application/json' },
      'files_api_routes_delete_file' => { method => 'DELETE', path => '/v1/files/{file_id}' },
      'files_api_routes_download_file' => { method => 'GET', path => '/v1/files/{file_id}/content' },
      'files_api_routes_get_signed_url' => { method => 'GET', path => '/v1/files/{file_id}/url' },
      'files_api_routes_list_files' => { method => 'GET', path => '/v1/files' },
      'files_api_routes_retrieve_file' => { method => 'GET', path => '/v1/files/{file_id}' },
      'files_api_routes_upload_file' => { method => 'POST', path => '/v1/files', content_type => 'multipart/form-data' },
      'fim_completion_v1_fim_completions_post' => { method => 'POST', path => '/v1/fim/completions', content_type => 'application/json' },
      'jobs_api_routes_batch_cancel_batch_job' => { method => 'POST', path => '/v1/batch/jobs/{job_id}/cancel' },
      'jobs_api_routes_batch_create_batch_job' => { method => 'POST', path => '/v1/batch/jobs', content_type => 'application/json' },
      'jobs_api_routes_batch_get_batch_job' => { method => 'GET', path => '/v1/batch/jobs/{job_id}' },
      'jobs_api_routes_batch_get_batch_jobs' => { method => 'GET', path => '/v1/batch/jobs' },
      'jobs_api_routes_fine_tuning_archive_fine_tuned_model' => { method => 'POST', path => '/v1/fine_tuning/models/{model_id}/archive' },
      'jobs_api_routes_fine_tuning_cancel_fine_tuning_job' => { method => 'POST', path => '/v1/fine_tuning/jobs/{job_id}/cancel' },
      'jobs_api_routes_fine_tuning_create_fine_tuning_job' => { method => 'POST', path => '/v1/fine_tuning/jobs', content_type => 'application/json' },
      'jobs_api_routes_fine_tuning_get_fine_tuning_job' => { method => 'GET', path => '/v1/fine_tuning/jobs/{job_id}' },
      'jobs_api_routes_fine_tuning_get_fine_tuning_jobs' => { method => 'GET', path => '/v1/fine_tuning/jobs' },
      'jobs_api_routes_fine_tuning_start_fine_tuning_job' => { method => 'POST', path => '/v1/fine_tuning/jobs/{job_id}/start' },
      'jobs_api_routes_fine_tuning_unarchive_fine_tuned_model' => { method => 'DELETE', path => '/v1/fine_tuning/models/{model_id}/archive' },
      'jobs_api_routes_fine_tuning_update_fine_tuned_model' => { method => 'PATCH', path => '/v1/fine_tuning/models/{model_id}', content_type => 'application/json' },
      'libraries_create_v1' => { method => 'POST', path => '/v1/libraries', content_type => 'application/json' },
      'libraries_delete_v1' => { method => 'DELETE', path => '/v1/libraries/{library_id}' },
      'libraries_documents_delete_v1' => { method => 'DELETE', path => '/v1/libraries/{library_id}/documents/{document_id}' },
      'libraries_documents_get_extracted_text_signed_url_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/documents/{document_id}/extracted-text-signed-url' },
      'libraries_documents_get_signed_url_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/documents/{document_id}/signed-url' },
      'libraries_documents_get_status_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/documents/{document_id}/status' },
      'libraries_documents_get_text_content_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/documents/{document_id}/text_content' },
      'libraries_documents_get_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/documents/{document_id}' },
      'libraries_documents_list_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/documents' },
      'libraries_documents_reprocess_v1' => { method => 'POST', path => '/v1/libraries/{library_id}/documents/{document_id}/reprocess' },
      'libraries_documents_update_v1' => { method => 'PUT', path => '/v1/libraries/{library_id}/documents/{document_id}', content_type => 'application/json' },
      'libraries_documents_upload_v1' => { method => 'POST', path => '/v1/libraries/{library_id}/documents', content_type => 'multipart/form-data' },
      'libraries_get_v1' => { method => 'GET', path => '/v1/libraries/{library_id}' },
      'libraries_list_v1' => { method => 'GET', path => '/v1/libraries' },
      'libraries_share_create_v1' => { method => 'PUT', path => '/v1/libraries/{library_id}/share', content_type => 'application/json' },
      'libraries_share_delete_v1' => { method => 'DELETE', path => '/v1/libraries/{library_id}/share', content_type => 'application/json' },
      'libraries_share_list_v1' => { method => 'GET', path => '/v1/libraries/{library_id}/share' },
      'libraries_update_v1' => { method => 'PUT', path => '/v1/libraries/{library_id}', content_type => 'application/json' },
      'list_models_v1_models_get' => { method => 'GET', path => '/v1/models' },
      'moderations_v1_moderations_post' => { method => 'POST', path => '/v1/moderations', content_type => 'application/json' },
      'ocr_v1_ocr_post' => { method => 'POST', path => '/v1/ocr', content_type => 'application/json' },
      'retrieve_model_v1_models__model_id__get' => { method => 'GET', path => '/v1/models/{model_id}' },
    },
  };
  return $DATA;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Langertha::Spec::Mistral - Pre-computed OpenAPI operations for Mistral

=head1 VERSION

version 0.300

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/Getty/langertha/issues>.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de> L<https://raudss.us/>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
