# NOTE: Derived from ../blib/lib/XML/miniXQL/Parser.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package XML::miniXQL::Parser;

#line 248 "../blib/lib/XML/miniXQL/Parser.pm (autosplit into ../blib/lib/auto/XML/miniXQL/Parser/_comparePart.al)"
sub _comparePart {
	my ($a, $b) = @_;

	my $a_elem;
	my $a_attribs = '';
	my $a_attribs_ref;

	if ($a =~ /(.*)\[(.*)\]/) {
		$a_elem = $1;
		$a_attribs = $2;
	}
	else {
		$a_elem = $a;
	}

	my $b_elem;
	my $b_attribs = '';
	my $b_attribs_ref;

	if ($b =~ /(.*)\[(.*)\]/) {
		$b_elem = $1;
		$b_attribs = $2;
	}
	else {
		$b_elem = $b;
	}

	return 0 if !defined $b_elem;
	if ($a_elem ne $b_elem) {
		return 0;
	}

	if (!$b_attribs && !$a_attribs) {
		return 1;
	}

	# Element is same - now split attribs
	foreach (split /\s+and\s+/, $a_attribs) {
		my ($key, $value) = split /\s*=\s*/;
		$a_attribs_ref->{$key} = $value;
	}

	foreach (split /\s+and\s+/, $b_attribs) {
		my ($key, $value) = split /\s*=\s*/;
		$b_attribs_ref->{$key} = $value;
	}

	foreach (keys (%{$a_attribs_ref})) {
		if (!defined($b_attribs_ref->{$_})) {
			return 0;
		}
		if ($a_attribs_ref->{$_} ne $b_attribs_ref->{$_}) {
			return 0;
		}
	}

	return 1;

}

1;
1;
# end of XML::miniXQL::Parser::_comparePart
