#!/usr/bin/perl

use 5.010;
use strict;
use warnings;
use utf8;

use Test::More;

use Math::Polygon::Tree;


our @TESTS = (
    [
        poly_file => \*DATA,
        [ [[35.2284227,54.7442032],[35.2280966,54.7442021],[35.2280953,54.7443255],[35.2284214,54.7443267]],
            , 1, 'house 1' ],
#        [ [], 1, '' ],
    ],
);


for my $item ( @TESTS ) {
    my ($case, $contour, @tests) = @$item;
    my $t = Math::Polygon::Tree->new($contour, {prepare_rough=>1});

    for my $test ( @tests ) { 
        my ($in, $expected, $name) = @$test;
        my $got = $t->contains_polygon_rough($in);
        is( $got, $expected, "$case: $name" );
    }
}


done_testing();



__DATA__
city

1
   35.2113957   54.7512731 
   35.2174137   54.7534097 
   35.2188157   54.7536475 
   35.2206193   54.7535706 
   35.2219572   54.7535626 
   35.2238047   54.7538698 
   35.2272283   54.7547773 
   35.2301853   54.7552213 
   35.2321415   54.7554494 
   35.2323299   54.7553213 
   35.2324926   54.7552228 
   35.2325652   54.755199  
   35.2326535   54.7551889 
   35.232679    54.7551707 
   35.2326892   54.7551215 
   35.2326552   54.7550503 
   35.2325646   54.7549873 
   35.2325636   54.7549525 
   35.2325985   54.7549347 
   35.2327227   54.7547756 
   35.2327987   54.7547303 
   35.232958    54.7547289 
   35.2330806   54.7547515 
   35.2331518   54.7547549 
   35.233186    54.7547388 
   35.2331934   54.7547077 
   35.2331468   54.7546525 
   35.2331395   54.754603  
   35.2329678   54.7545124 
   35.2329458   54.7544657 
   35.2329997   54.7543794 
   35.233012    54.7543271 
   35.2329825   54.7542988 
   35.2330306   54.7542327 
   35.2331198   54.7542309 
   35.2331934   54.7542606 
   35.2332816   54.754395  
   35.2334925   54.7544049 
   35.23362     54.7544063 
   35.2336788   54.7543865 
   35.2337107   54.7543469 
   35.2337475   54.7542479 
   35.2338038   54.75418   
   35.2338087   54.7540753 
   35.2338896   54.753996  
   35.2339387   54.7539635 
   35.2338847   54.7538998 
   35.2338602   54.7538347 
   35.233897    54.7538065 
   35.2340171   54.7538404 
   35.2340515   54.7538913 
   35.2340858   54.7538913 
   35.2342255   54.7538135 
   35.2342451   54.7537484 
   35.2342402   54.7536904 
   35.2342795   54.7536282 
   35.2343334   54.7535829 
   35.2343456   54.7535235 
   35.234152    54.7534952 
   35.234125    54.7534414 
   35.2341642   54.7533848 
   35.2342525   54.7533792 
   35.2343064   54.753324  
   35.2342795   54.7532816 
   35.2341912   54.7532589 
   35.2340245   54.7531542 
   35.2339387   54.7531514 
   35.2339117   54.7532037 
   35.2338455   54.7532052 
   35.2337769   54.7531627 
   35.2337278   54.7530891 
   35.2337646   54.7530552 
   35.2338749   54.7530566 
   35.2339632   54.753041  
   35.2340269   54.7530028 
   35.2340515   54.7529547 
   35.2341103   54.752925  
   35.2341789   54.7529222 
   35.2342574   54.7529576 
   35.2343383   54.7529802 
   35.2344216   54.752976  
   35.234505    54.7530028 
   35.2345623   54.7530048 
   35.2346325   54.7529816 
   35.2346742   54.7529349 
   35.2346619   54.7528797 
   35.2346276   54.7528118 
   35.2345516   54.752768  
   35.2345246   54.7527227 
   35.2345271   54.7526534 
   35.2344315   54.7525968 
   35.2342133   54.7526505 
   35.2341838   54.7526986 
   35.2341348   54.7527425 
   35.2340711   54.7527411 
   35.2339926   54.7527057 
   35.23387     54.7526166 
   35.2338308   54.7525529 
   35.2338504   54.7524935 
   35.2339264   54.7524652 
   35.2340171   54.7524666 
   35.234098    54.7525402 
   35.2341397   54.7525586 
   35.2342084   54.7525515 
   35.2342451   54.7525034 
   35.2342427   54.7524553 
   35.2342721   54.7524199 
   35.2343726   54.7524044 
   35.2343947   54.7523647 
   35.2343309   54.7522912 
   35.2341716   54.7522233 
   35.2340073   54.7522247 
   35.2339352   54.7522474 
   35.2338823   54.7522883 
   35.2338725   54.7523336 
   35.2338087   54.7523902 
   35.2335881   54.7524199 
   35.2334802   54.7524312 
   35.2333724   54.7524284 
   35.2332571   54.7524072 
   35.2331493   54.7523647 
   35.2330463   54.7523563 
   35.2329899   54.752369  
   35.2329286   54.7523463 
   35.232806    54.7522459 
   35.232708    54.7522233 
   35.2325315   54.7521553 
   35.2324628   54.7521836 
   35.2324285   54.7522289 
   35.2324604   54.7522572 
   35.2325265   54.7522827 
   35.2326222   54.7523534 
   35.2325952   54.7524029 
   35.2325069   54.7524199 
   35.2323304   54.7524765 
   35.2322594   54.7524742 
   35.232191    54.752454  
   35.2321533   54.7524178 
   35.2321345   54.7522847 
   35.2321157   54.752071  
   35.232149    54.7519454 
   35.2322475   54.751802  
   35.2323777   54.7517522 
   35.2324831   54.7516872 
   35.2325911   54.7516137 
   35.2327025   54.7516073 
   35.2327417   54.751591  
   35.2327549   54.7515489 
   35.2327194   54.7514815 
   35.2327118   54.7514133 
   35.2327326   54.7513905 
   35.2327395   54.7513417 
   35.2326922   54.7513296 
   35.2326922   54.75129   
   35.2327844   54.751213  
   35.2328648   54.7511258 
   35.2329432   54.7511134 
   35.2330903   54.7511394 
   35.2331099   54.7511677 
   35.2330942   54.7512005 
   35.2329766   54.7512334 
   35.2329668   54.7512662 
   35.2330276   54.7512832 
   35.2331295   54.7512764 
   35.2331982   54.7512832 
   35.2332472   54.7513115 
   35.2332551   54.7513386 
   35.2333276   54.7514405 
   35.2334022   54.7514416 
   35.2334532   54.7514032 
   35.2335061   54.7513805 
   35.2334826   54.7512594 
   35.2334277   54.7511145 
   35.2333688   54.7510907 
   35.2333217   54.751059  
   35.2333159   54.7510104 
   35.2333747   54.7509775 
   35.2333884   54.7509493 
   35.2333551   54.7509085 
   35.2333296   54.7508689 
   35.2332747   54.7508519 
   35.2332178   54.7508519 
   35.2331707   54.7508259 
   35.233104    54.7508236 
   35.2330962   54.7508632 
   35.2330648   54.7508949 
   35.2329844   54.7508949 
   35.2329334   54.7508791 
   35.2328177   54.7508745 
   35.2327079   54.7509028 
   35.2326255   54.7508859 
   35.232598    54.7508496 
   35.2326078   54.7507964 
   35.2325529   54.750758  
   35.2324529   54.7507172 
   35.2323489   54.7506176 
   35.2323803   54.7505746 
   35.2325058   54.7505157 
   35.2326961   54.7505327 
   35.2329314   54.7505542 
   35.233006    54.7505497 
   35.2330217   54.7505044 
   35.2329726   54.7504614 
   35.2328628   54.7504229 
   35.2328236   54.7503776 
   35.2328412   54.7503165 
   35.2328452   54.7502701 
   35.2327608   54.7502305 
   35.2326176   54.7502214 
   35.2325098   54.7501841 
   35.2321901   54.7499645 
   35.2320626   54.7499282 
   35.2319312   54.7498173 
   35.231941    54.7497664 
   35.2318841   54.7497268 
   35.2318037   54.7496147 
   35.2317861   54.749523  
   35.2318586   54.74948   
   35.23199     54.7494347 
   35.2320868   54.7493819 
   35.2320901   54.749317  
   35.2320485   54.7492913 
   35.2319449   54.7492649 
   35.2318151   54.7492671 
   35.2317074   54.749236  
   35.2316296   54.7490944 
   35.2317612   54.7490425 
   35.2319168   54.7489907 
   35.2320303   54.7488743 
   35.2321069   54.7487831 
   35.2321165   54.7487002 
   35.2322245   54.7486156 
   35.2322101   54.7484967 
   35.2326462   54.749068  
   35.2340932   54.7490357 
   35.2342205   54.7491    
   35.2375627   54.7490117 
   35.2393662   54.748964  
   35.2392557   54.7504439 
   35.2464798   54.7514406 
   35.2490692   54.7518447 
   35.2511115   54.7521635 
   35.2516472   54.7522644 
   35.2521131   54.7520461 
   35.2529135   54.7519683 
   35.2555412   54.7494366 
   35.2576264   54.7500302 
   35.2580964   54.7494662 
   35.2582042   54.7492614 
   35.2581846   54.7491025 
   35.2574934   54.7488389 
   35.2556778   54.7482426 
   35.2523899   54.7472237 
   35.2525781   54.7470084 
   35.2518268   54.7467574 
   35.2510025   54.7465383 
   35.251229    54.7461323 
   35.2500882   54.7458829 
   35.2506163   54.7437955 
   35.2510758   54.7438221 
   35.2511246   54.7434518 
   35.2515309   54.7433771 
   35.2518335   54.7434312 
   35.2519826   54.7435141 
   35.2521418   54.7437867 
   35.2526124   54.7437592 
   35.2534907   54.7435295 
   35.2536272   54.7434021 
   35.253048    54.742587  
   35.2520494   54.7428311 
   35.2519564   54.7427241 
   35.2516249   54.7427564 
   35.2512241   54.741289  
   35.2520018   54.7412072 
   35.2521111   54.7399761 
   35.2520943   54.7393714 
   35.2526631   54.734945  
   35.2519077   54.7334389 
   35.2517456   54.7324351 
   35.2522128   54.7312742 
   35.2514963   54.7300595 
   35.245189    54.7300251 
   35.242397    54.7296819 
   35.2409577   54.7296551 
   35.2400996   54.729459  
   35.2380085   54.7292413 
   35.2382482   54.7291326 
   35.2392447   54.729132  
   35.2398878   54.7284706 
   35.2365437   54.7280359 
   35.2360584   54.727171  
   35.237149    54.7267589 
   35.2366512   54.7263283 
   35.2380713   54.7251259 
   35.2381181   54.7246729 
   35.2386308   54.7227402 
   35.2395708   54.7224107 
   35.2397133   54.7220876 
   35.238665    54.721579  
   35.2390904   54.7204002 
   35.2395538   54.7201511 
   35.240841    54.7199271 
   35.2423056   54.7194415 
   35.2438472   54.7188344 
   35.2447786   54.7181722 
   35.2464407   54.7166533 
   35.2463811   54.7163587 
   35.2482291   54.7143557 
   35.2501706   54.7136238 
   35.2524461   54.7106499 
   35.2422536   54.7131322 
   35.2401355   54.7137432 
   35.2193675   54.7219093 
   35.2194283   54.7219964 
   35.217196    54.7228267 
   35.2171398   54.7232701 
   35.2150758   54.726754  
   35.214129    54.7279526 
   35.2140971   54.729348  
   35.2135241   54.7299308 
   35.2118709   54.7296582 
   35.2110726   54.7314906 
   35.213791    54.7320157 
   35.2116955   54.7331033 
   35.2097262   54.7344853 
   35.2092926   54.7348481 
   35.209277    54.7349461 
   35.2094569   54.7351235 
   35.2099357   54.7354274 
   35.2094776   54.7356739 
   35.2083902   54.7359641 
   35.2079923   54.7362261 
   35.2074415   54.736523  
   35.2068042   54.7369897 
   35.2117488   54.7386249 
   35.2125665   54.7390897 
   35.2135261   54.7399957 
   35.2133375   54.7400724 
   35.2127951   54.7402304 
   35.2124344   54.7403311 
   35.2106092   54.7409568 
   35.2098751   54.7411868 
   35.2060841   54.7408486 
   35.2056558   54.7414792 
   35.2054594   54.7415887 
   35.2048883   54.7422651 
   35.2042195   54.7429335 
   35.207034    54.743125  
   35.2080113   54.7434053 
   35.2086786   54.7439375 
   35.2089253   54.74487   
   35.2079467   54.7462009 
   35.2074522   54.7472198 
   35.2074919   54.7486893 
   35.208169    54.7496737 
   35.2089295   54.7503731 
   35.2097764   54.7508114 
   35.2113957   54.7512731 
END

END
