/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.net.MalformedURLException;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=HtmlLink.class)
public class HTMLLinkElement
extends HTMLElement {
    private CSSStyleSheet sheet_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public HTMLLinkElement() {
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlLink link = (HtmlLink)this.getDomNodeOrDie();
        String href = link.getHrefAttribute();
        if (href.isEmpty()) {
            return href;
        }
        try {
            return ((HtmlPage)link.getPage()).getFullyQualifiedUrl(href).toString();
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlLink)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlLink)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter
    public String getType() {
        return ((HtmlLink)this.getDomNodeOrDie()).getTypeAttribute();
    }

    public CSSStyleSheet getSheet() {
        if (this.sheet_ == null) {
            this.sheet_ = CSSStyleSheet.loadStylesheet(this.getWindow(), this, (HtmlLink)this.getDomNodeOrDie(), null);
        }
        return this.sheet_;
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter(value={SupportedBrowser.FF})
    public DOMTokenList getRelList() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }
}

