# Generated by default/object.tt
package Paws::ECRPublic::RepositoryCatalogData;
  use Moose;
  has AboutText => (is => 'ro', isa => 'Str', request_name => 'aboutText', traits => ['NameInRequest']);
  has Architectures => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'architectures', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LogoUrl => (is => 'ro', isa => 'Str', request_name => 'logoUrl', traits => ['NameInRequest']);
  has MarketplaceCertified => (is => 'ro', isa => 'Bool', request_name => 'marketplaceCertified', traits => ['NameInRequest']);
  has OperatingSystems => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'operatingSystems', traits => ['NameInRequest']);
  has UsageText => (is => 'ro', isa => 'Str', request_name => 'usageText', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECRPublic::RepositoryCatalogData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECRPublic::RepositoryCatalogData object:

  $service_obj->Method(Att1 => { AboutText => $value, ..., UsageText => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECRPublic::RepositoryCatalogData object:

  $result = $service_obj->Method(...);
  $result->Att1->AboutText

=head1 DESCRIPTION

The catalog data for a repository. This data is publicly visible in the
Amazon ECR Public Gallery.

=head1 ATTRIBUTES


=head2 AboutText => Str

The longform description of the contents of the repository. This text
appears in the repository details on the Amazon ECR Public Gallery.


=head2 Architectures => ArrayRef[Str|Undef]

The architecture tags that are associated with the repository.

Only supported operating system tags appear publicly in the Amazon ECR
Public Gallery. For more information, see RepositoryCatalogDataInput.


=head2 Description => Str

The short description of the repository.


=head2 LogoUrl => Str

The URL containing the logo associated with the repository.


=head2 MarketplaceCertified => Bool

Whether or not the repository is certified by AWS Marketplace.


=head2 OperatingSystems => ArrayRef[Str|Undef]

The operating system tags that are associated with the repository.

Only supported operating system tags appear publicly in the Amazon ECR
Public Gallery. For more information, see RepositoryCatalogDataInput.


=head2 UsageText => Str

The longform usage details of the contents of the repository. The usage
text provides context for users of the repository.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECRPublic>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

