#!/usr/local/bin/perl -w
#
use Graphics::VTK;



use Tk;
use Graphics::VTK::Tk;
$MW = Tk::MainWindow->new;

$VTK_DATA = 0;
$VTK_DATA = $ENV{VTK_DATA};
# Append, read, and write every cell type
# get the interactor ui
use Graphics::VTK::Tk::vtkInt;
# create a scene with one of each cell type
$voxelPoints = Graphics::VTK::Points->new;
$voxelPoints->SetNumberOfPoints(8);
$voxelPoints->InsertPoint(0,0,0,0);
$voxelPoints->InsertPoint(1,1,0,0);
$voxelPoints->InsertPoint(2,0,1,0);
$voxelPoints->InsertPoint(3,1,1,0);
$voxelPoints->InsertPoint(4,0,0,1);
$voxelPoints->InsertPoint(5,1,0,1);
$voxelPoints->InsertPoint(6,0,1,1);
$voxelPoints->InsertPoint(7,1,1,1);
$voxelScalars = Graphics::VTK::Scalars->new;
$voxelScalars->SetNumberOfScalars(8);
$voxelScalars->InsertScalar(0,0);
$voxelScalars->InsertScalar(1,1);
$voxelScalars->InsertScalar(2,0);
$voxelScalars->InsertScalar(3,0);
$voxelScalars->InsertScalar(4,0);
$voxelScalars->InsertScalar(5,0);
$voxelScalars->InsertScalar(6,0);
$voxelScalars->InsertScalar(7,0);
$aVoxel = Graphics::VTK::Voxel->new;
$aVoxel->GetPointIds->SetId(0,0);
$aVoxel->GetPointIds->SetId(1,1);
$aVoxel->GetPointIds->SetId(2,2);
$aVoxel->GetPointIds->SetId(3,3);
$aVoxel->GetPointIds->SetId(4,4);
$aVoxel->GetPointIds->SetId(5,5);
$aVoxel->GetPointIds->SetId(6,6);
$aVoxel->GetPointIds->SetId(7,7);
$aVoxelGrid = Graphics::VTK::UnstructuredGrid->new;
$aVoxelGrid->Allocate(1,1);
$aVoxelGrid->InsertNextCell($aVoxel->GetCellType,$aVoxel->GetPointIds);
$aVoxelGrid->SetPoints($voxelPoints);
$aVoxelGrid->GetPointData->SetScalars($voxelScalars);
$aVoxelTransform = Graphics::VTK::Transform->new;
$aVoxelTransform->Translate(0,0,0);
$transformVoxel = Graphics::VTK::TransformFilter->new;
$transformVoxel->SetInput($aVoxelGrid);
$transformVoxel->SetTransform($aVoxelTransform);
$hexahedronPoints = Graphics::VTK::Points->new;
$hexahedronPoints->SetNumberOfPoints(8);
$hexahedronPoints->InsertPoint(0,0,0,0);
$hexahedronPoints->InsertPoint(1,1,0,0);
$hexahedronPoints->InsertPoint(2,1,1,0);
$hexahedronPoints->InsertPoint(3,0,1,0);
$hexahedronPoints->InsertPoint(4,0,0,1);
$hexahedronPoints->InsertPoint(5,1,0,1);
$hexahedronPoints->InsertPoint(6,1,1,1);
$hexahedronPoints->InsertPoint(7,0,1,1);
$hexahedronScalars = Graphics::VTK::Scalars->new;
$hexahedronScalars->SetNumberOfScalars(8);
$hexahedronScalars->InsertScalar(0,0);
$hexahedronScalars->InsertScalar(1,1);
$hexahedronScalars->InsertScalar(2,0);
$hexahedronScalars->InsertScalar(3,0);
$hexahedronScalars->InsertScalar(4,0);
$hexahedronScalars->InsertScalar(5,0);
$hexahedronScalars->InsertScalar(6,0);
$hexahedronScalars->InsertScalar(7,0);
$aHexahedron = Graphics::VTK::Hexahedron->new;
$aHexahedron->GetPointIds->SetId(0,0);
$aHexahedron->GetPointIds->SetId(1,1);
$aHexahedron->GetPointIds->SetId(2,2);
$aHexahedron->GetPointIds->SetId(3,3);
$aHexahedron->GetPointIds->SetId(4,4);
$aHexahedron->GetPointIds->SetId(5,5);
$aHexahedron->GetPointIds->SetId(6,6);
$aHexahedron->GetPointIds->SetId(7,7);
$aHexahedronGrid = Graphics::VTK::UnstructuredGrid->new;
$aHexahedronGrid->Allocate(1,1);
$aHexahedronGrid->InsertNextCell($aHexahedron->GetCellType,$aHexahedron->GetPointIds);
$aHexahedronGrid->SetPoints($hexahedronPoints);
$aHexahedronGrid->GetPointData->SetScalars($hexahedronScalars);
$aHexahedronTransform = Graphics::VTK::Transform->new;
$aHexahedronTransform->Translate(2,0,0);
$transformHexahedron = Graphics::VTK::TransformFilter->new;
$transformHexahedron->SetInput($aHexahedronGrid);
$transformHexahedron->SetTransform($aHexahedronTransform);
$tetraPoints = Graphics::VTK::Points->new;
$tetraPoints->SetNumberOfPoints(4);
$tetraPoints->InsertPoint(0,0,0,0);
$tetraPoints->InsertPoint(1,1,0,0);
$tetraPoints->InsertPoint(2,'.5',1,0);
$tetraPoints->InsertPoint(3,'.5','.5',1);
$tetraScalars = Graphics::VTK::Scalars->new;
$tetraScalars->SetNumberOfScalars(4);
$tetraScalars->InsertScalar(0,1);
$tetraScalars->InsertScalar(1,0);
$tetraScalars->InsertScalar(2,0);
$tetraScalars->InsertScalar(3,0);
$aTetra = Graphics::VTK::Tetra->new;
$aTetra->GetPointIds->SetId(0,0);
$aTetra->GetPointIds->SetId(1,1);
$aTetra->GetPointIds->SetId(2,2);
$aTetra->GetPointIds->SetId(3,3);
$aTetraGrid = Graphics::VTK::UnstructuredGrid->new;
$aTetraGrid->Allocate(1,1);
$aTetraGrid->InsertNextCell($aTetra->GetCellType,$aTetra->GetPointIds);
$aTetraGrid->SetPoints($tetraPoints);
$aTetraGrid->GetPointData->SetScalars($tetraScalars);
$aTetraTransform = Graphics::VTK::Transform->new;
$aTetraTransform->Translate(4,0,0);
$transformTetra = Graphics::VTK::TransformFilter->new;
$transformTetra->SetInput($aTetraGrid);
$transformTetra->SetTransform($aTetraTransform);
$wedgePoints = Graphics::VTK::Points->new;
$wedgePoints->SetNumberOfPoints(6);
$wedgePoints->InsertPoint(0,0,1,0);
$wedgePoints->InsertPoint(1,0,0,0);
$wedgePoints->InsertPoint(2,0,'.5','.5');
$wedgePoints->InsertPoint(3,1,1,0);
$wedgePoints->InsertPoint(4,1,0,0);
$wedgePoints->InsertPoint(5,1,'.5','.5');
$wedgeScalars = Graphics::VTK::Scalars->new;
$wedgeScalars->SetNumberOfScalars(6);
$wedgeScalars->InsertScalar(0,1);
$wedgeScalars->InsertScalar(1,1);
$wedgeScalars->InsertScalar(2,0);
$wedgeScalars->InsertScalar(3,1);
$wedgeScalars->InsertScalar(4,1);
$wedgeScalars->InsertScalar(5,0);
$aWedge = Graphics::VTK::Wedge->new;
$aWedge->GetPointIds->SetId(0,0);
$aWedge->GetPointIds->SetId(1,1);
$aWedge->GetPointIds->SetId(2,2);
$aWedge->GetPointIds->SetId(3,3);
$aWedge->GetPointIds->SetId(4,4);
$aWedge->GetPointIds->SetId(5,5);
$aWedgeGrid = Graphics::VTK::UnstructuredGrid->new;
$aWedgeGrid->Allocate(1,1);
$aWedgeGrid->InsertNextCell($aWedge->GetCellType,$aWedge->GetPointIds);
$aWedgeGrid->SetPoints($wedgePoints);
$aWedgeGrid->GetPointData->SetScalars($wedgeScalars);
$aWedgeTransform = Graphics::VTK::Transform->new;
$aWedgeTransform->Translate(6,0,0);
$transformWedge = Graphics::VTK::TransformFilter->new;
$transformWedge->SetInput($aWedgeGrid);
$transformWedge->SetTransform($aWedgeTransform);
$pyramidPoints = Graphics::VTK::Points->new;
$pyramidPoints->SetNumberOfPoints(5);
$pyramidPoints->InsertPoint(0,0,0,0);
$pyramidPoints->InsertPoint(1,1,0,0);
$pyramidPoints->InsertPoint(2,1,1,0);
$pyramidPoints->InsertPoint(3,0,1,0);
$pyramidPoints->InsertPoint(4,'.5','.5',1);
$pyramidScalars = Graphics::VTK::Scalars->new;
$pyramidScalars->SetNumberOfScalars(5);
$pyramidScalars->InsertScalar(0,1);
$pyramidScalars->InsertScalar(1,1);
$pyramidScalars->InsertScalar(2,1);
$pyramidScalars->InsertScalar(3,1);
$pyramidScalars->InsertScalar(4,0);
$aPyramid = Graphics::VTK::Pyramid->new;
$aPyramid->GetPointIds->SetId(0,0);
$aPyramid->GetPointIds->SetId(1,1);
$aPyramid->GetPointIds->SetId(2,2);
$aPyramid->GetPointIds->SetId(3,3);
$aPyramid->GetPointIds->SetId(4,4);
$aPyramidGrid = Graphics::VTK::UnstructuredGrid->new;
$aPyramidGrid->Allocate(1,1);
$aPyramidGrid->InsertNextCell($aPyramid->GetCellType,$aPyramid->GetPointIds);
$aPyramidGrid->SetPoints($pyramidPoints);
$aPyramidGrid->GetPointData->SetScalars($pyramidScalars);
$aPyramidTransform = Graphics::VTK::Transform->new;
$aPyramidTransform->Translate(8,0,0);
$transformPyramid = Graphics::VTK::TransformFilter->new;
$transformPyramid->SetInput($aPyramidGrid);
$transformPyramid->SetTransform($aPyramidTransform);
$pixelPoints = Graphics::VTK::Points->new;
$pixelPoints->SetNumberOfPoints(4);
$pixelPoints->InsertPoint(0,0,0,0);
$pixelPoints->InsertPoint(1,1,0,0);
$pixelPoints->InsertPoint(2,0,1,0);
$pixelPoints->InsertPoint(3,1,1,0);
$pixelScalars = Graphics::VTK::Scalars->new;
$pixelScalars->SetNumberOfScalars(4);
$pixelScalars->InsertScalar(0,1);
$pixelScalars->InsertScalar(1,0);
$pixelScalars->InsertScalar(2,0);
$pixelScalars->InsertScalar(3,0);
$aPixel = Graphics::VTK::Pixel->new;
$aPixel->GetPointIds->SetId(0,0);
$aPixel->GetPointIds->SetId(1,1);
$aPixel->GetPointIds->SetId(2,2);
$aPixel->GetPointIds->SetId(3,3);
$aPixelGrid = Graphics::VTK::UnstructuredGrid->new;
$aPixelGrid->Allocate(1,1);
$aPixelGrid->InsertNextCell($aPixel->GetCellType,$aPixel->GetPointIds);
$aPixelGrid->SetPoints($pixelPoints);
$aPixelGrid->GetPointData->SetScalars($pixelScalars);
$aPixelTransform = Graphics::VTK::Transform->new;
$aPixelTransform->Translate(0,0,2);
$transformPixel = Graphics::VTK::TransformFilter->new;
$transformPixel->SetInput($aPixelGrid);
$transformPixel->SetTransform($aPixelTransform);
$quadPoints = Graphics::VTK::Points->new;
$quadPoints->SetNumberOfPoints(4);
$quadPoints->InsertPoint(0,0,0,0);
$quadPoints->InsertPoint(1,1,0,0);
$quadPoints->InsertPoint(2,1,1,0);
$quadPoints->InsertPoint(3,0,1,0);
$quadScalars = Graphics::VTK::Scalars->new;
$quadScalars->SetNumberOfScalars(4);
$quadScalars->InsertScalar(0,1);
$quadScalars->InsertScalar(1,0);
$quadScalars->InsertScalar(2,0);
$quadScalars->InsertScalar(3,0);
$aQuad = Graphics::VTK::Quad->new;
$aQuad->GetPointIds->SetId(0,0);
$aQuad->GetPointIds->SetId(1,1);
$aQuad->GetPointIds->SetId(2,2);
$aQuad->GetPointIds->SetId(3,3);
$aQuadGrid = Graphics::VTK::UnstructuredGrid->new;
$aQuadGrid->Allocate(1,1);
$aQuadGrid->InsertNextCell($aQuad->GetCellType,$aQuad->GetPointIds);
$aQuadGrid->SetPoints($quadPoints);
$aQuadGrid->GetPointData->SetScalars($quadScalars);
$aQuadTransform = Graphics::VTK::Transform->new;
$aQuadTransform->Translate(2,0,2);
$transformQuad = Graphics::VTK::TransformFilter->new;
$transformQuad->SetInput($aQuadGrid);
$transformQuad->SetTransform($aQuadTransform);
$trianglePoints = Graphics::VTK::Points->new;
$trianglePoints->SetNumberOfPoints(3);
$trianglePoints->InsertPoint(0,0,0,0);
$trianglePoints->InsertPoint(1,1,0,0);
$trianglePoints->InsertPoint(2,'.5','.5',0);
$triangleScalars = Graphics::VTK::Scalars->new;
$triangleScalars->SetNumberOfScalars(3);
$triangleScalars->InsertScalar(0,1);
$triangleScalars->InsertScalar(1,0);
$triangleScalars->InsertScalar(2,0);
$aTriangle = Graphics::VTK::Triangle->new;
$aTriangle->GetPointIds->SetId(0,0);
$aTriangle->GetPointIds->SetId(1,1);
$aTriangle->GetPointIds->SetId(2,2);
$aTriangleGrid = Graphics::VTK::UnstructuredGrid->new;
$aTriangleGrid->Allocate(1,1);
$aTriangleGrid->InsertNextCell($aTriangle->GetCellType,$aTriangle->GetPointIds);
$aTriangleGrid->SetPoints($trianglePoints);
$aTriangleGrid->GetPointData->SetScalars($triangleScalars);
$aTriangleTransform = Graphics::VTK::Transform->new;
$aTriangleTransform->Translate(4,0,2);
$transformTriangle = Graphics::VTK::TransformFilter->new;
$transformTriangle->SetInput($aTriangleGrid);
$transformTriangle->SetTransform($aTriangleTransform);
$polygonPoints = Graphics::VTK::Points->new;
$polygonPoints->SetNumberOfPoints(4);
$polygonPoints->InsertPoint(0,0,0,0);
$polygonPoints->InsertPoint(1,1,0,0);
$polygonPoints->InsertPoint(2,1,1,0);
$polygonPoints->InsertPoint(3,0,1,0);
$polygonScalars = Graphics::VTK::Scalars->new;
$polygonScalars->SetNumberOfScalars(4);
$polygonScalars->InsertScalar(0,1);
$polygonScalars->InsertScalar(1,0);
$polygonScalars->InsertScalar(2,0);
$polygonScalars->InsertScalar(3,0);
$aPolygon = Graphics::VTK::Polygon->new;
$aPolygon->GetPointIds->SetNumberOfIds(4);
$aPolygon->GetPointIds->SetId(0,0);
$aPolygon->GetPointIds->SetId(1,1);
$aPolygon->GetPointIds->SetId(2,2);
$aPolygon->GetPointIds->SetId(3,3);
$aPolygonGrid = Graphics::VTK::UnstructuredGrid->new;
$aPolygonGrid->Allocate(1,1);
$aPolygonGrid->InsertNextCell($aPolygon->GetCellType,$aPolygon->GetPointIds);
$aPolygonGrid->SetPoints($polygonPoints);
$aPolygonGrid->GetPointData->SetScalars($polygonScalars);
$aPolygonTransform = Graphics::VTK::Transform->new;
$aPolygonTransform->Translate(6,0,2);
$transformPolygon = Graphics::VTK::TransformFilter->new;
$transformPolygon->SetInput($aPolygonGrid);
$transformPolygon->SetTransform($aPolygonTransform);
$triangleStripPoints = Graphics::VTK::Points->new;
$triangleStripPoints->SetNumberOfPoints(5);
$triangleStripPoints->InsertPoint(0,0,1,0);
$triangleStripPoints->InsertPoint(1,0,0,0);
$triangleStripPoints->InsertPoint(2,1,1,0);
$triangleStripPoints->InsertPoint(3,1,0,0);
$triangleStripPoints->InsertPoint(4,2,1,0);
$triangleStripScalars = Graphics::VTK::Scalars->new;
$triangleStripScalars->SetNumberOfScalars(5);
$triangleStripScalars->InsertScalar(0,1);
$triangleStripScalars->InsertScalar(1,0);
$triangleStripScalars->InsertScalar(2,0);
$triangleStripScalars->InsertScalar(3,0);
$triangleStripScalars->InsertScalar(4,0);
$aTriangleStrip = Graphics::VTK::TriangleStrip->new;
$aTriangleStrip->GetPointIds->SetNumberOfIds(5);
$aTriangleStrip->GetPointIds->SetId(0,0);
$aTriangleStrip->GetPointIds->SetId(1,1);
$aTriangleStrip->GetPointIds->SetId(2,2);
$aTriangleStrip->GetPointIds->SetId(3,3);
$aTriangleStrip->GetPointIds->SetId(4,4);
$aTriangleStripGrid = Graphics::VTK::UnstructuredGrid->new;
$aTriangleStripGrid->Allocate(1,1);
$aTriangleStripGrid->InsertNextCell($aTriangleStrip->GetCellType,$aTriangleStrip->GetPointIds);
$aTriangleStripGrid->SetPoints($triangleStripPoints);
$aTriangleStripGrid->GetPointData->SetScalars($triangleStripScalars);
$aTriangleStripTransform = Graphics::VTK::Transform->new;
$aTriangleStripTransform->Translate(8,0,2);
$transformTriangleStrip = Graphics::VTK::TransformFilter->new;
$transformTriangleStrip->SetInput($aTriangleStripGrid);
$transformTriangleStrip->SetTransform($aTriangleStripTransform);
$linePoints = Graphics::VTK::Points->new;
$linePoints->SetNumberOfPoints(2);
$linePoints->InsertPoint(0,0,0,0);
$linePoints->InsertPoint(1,1,1,0);
$lineScalars = Graphics::VTK::Scalars->new;
$lineScalars->SetNumberOfScalars(2);
$lineScalars->InsertScalar(0,1);
$lineScalars->InsertScalar(1,0);
$aLine = Graphics::VTK::Line->new;
$aLine->GetPointIds->SetId(0,0);
$aLine->GetPointIds->SetId(1,1);
$aLineGrid = Graphics::VTK::UnstructuredGrid->new;
$aLineGrid->Allocate(1,1);
$aLineGrid->InsertNextCell($aLine->GetCellType,$aLine->GetPointIds);
$aLineGrid->SetPoints($linePoints);
$aLineGrid->GetPointData->SetScalars($lineScalars);
$aLineTransform = Graphics::VTK::Transform->new;
$aLineTransform->Translate(0,0,4);
$transformLine = Graphics::VTK::TransformFilter->new;
$transformLine->SetInput($aLineGrid);
$transformLine->SetTransform($aLineTransform);
$polyLinePoints = Graphics::VTK::Points->new;
$polyLinePoints->SetNumberOfPoints(3);
$polyLinePoints->InsertPoint(0,0,0,0);
$polyLinePoints->InsertPoint(1,1,1,0);
$polyLinePoints->InsertPoint(2,1,0,0);
$polyLineScalars = Graphics::VTK::Scalars->new;
$polyLineScalars->SetNumberOfScalars(3);
$polyLineScalars->InsertScalar(0,1);
$polyLineScalars->InsertScalar(1,0);
$polyLineScalars->InsertScalar(2,0);
$aPolyLine = Graphics::VTK::PolyLine->new;
$aPolyLine->GetPointIds->SetNumberOfIds(3);
$aPolyLine->GetPointIds->SetId(0,0);
$aPolyLine->GetPointIds->SetId(1,1);
$aPolyLine->GetPointIds->SetId(2,2);
$aPolyLineGrid = Graphics::VTK::UnstructuredGrid->new;
$aPolyLineGrid->Allocate(1,1);
$aPolyLineGrid->InsertNextCell($aPolyLine->GetCellType,$aPolyLine->GetPointIds);
$aPolyLineGrid->SetPoints($polyLinePoints);
$aPolyLineGrid->GetPointData->SetScalars($polyLineScalars);
$aPolyLineTransform = Graphics::VTK::Transform->new;
$aPolyLineTransform->Translate(2,0,4);
$transformPolyLine = Graphics::VTK::TransformFilter->new;
$transformPolyLine->SetInput($aPolyLineGrid);
$transformPolyLine->SetTransform($aPolyLineTransform);
$vertexPoints = Graphics::VTK::Points->new;
$vertexPoints->SetNumberOfPoints(1);
$vertexPoints->InsertPoint(0,0,0,0);
$vertexScalars = Graphics::VTK::Scalars->new;
$vertexScalars->SetNumberOfScalars(1);
$vertexScalars->InsertScalar(0,1);
$aVertex = Graphics::VTK::Vertex->new;
$aVertex->GetPointIds->SetId(0,0);
$aVertexGrid = Graphics::VTK::UnstructuredGrid->new;
$aVertexGrid->Allocate(1,1);
$aVertexGrid->InsertNextCell($aVertex->GetCellType,$aVertex->GetPointIds);
$aVertexGrid->SetPoints($vertexPoints);
$aVertexGrid->GetPointData->SetScalars($vertexScalars);
$aVertexTransform = Graphics::VTK::Transform->new;
$aVertexTransform->Translate(0,0,6);
$transformVertex = Graphics::VTK::TransformFilter->new;
$transformVertex->SetInput($aVertexGrid);
$transformVertex->SetTransform($aVertexTransform);
$polyVertexPoints = Graphics::VTK::Points->new;
$polyVertexPoints->SetNumberOfPoints(3);
$polyVertexPoints->InsertPoint(0,0,0,0);
$polyVertexPoints->InsertPoint(1,1,0,0);
$polyVertexPoints->InsertPoint(2,1,1,0);
$polyVertexScalars = Graphics::VTK::Scalars->new;
$polyVertexScalars->SetNumberOfScalars(3);
$polyVertexScalars->InsertScalar(0,1);
$polyVertexScalars->InsertScalar(1,0);
$polyVertexScalars->InsertScalar(2,0);
$aPolyVertex = Graphics::VTK::PolyVertex->new;
$aPolyVertex->GetPointIds->SetNumberOfIds(3);
$aPolyVertex->GetPointIds->SetId(0,0);
$aPolyVertex->GetPointIds->SetId(1,1);
$aPolyVertex->GetPointIds->SetId(2,2);
$aPolyVertexGrid = Graphics::VTK::UnstructuredGrid->new;
$aPolyVertexGrid->Allocate(1,1);
$aPolyVertexGrid->InsertNextCell($aPolyVertex->GetCellType,$aPolyVertex->GetPointIds);
$aPolyVertexGrid->SetPoints($polyVertexPoints);
$aPolyVertexGrid->GetPointData->SetScalars($polyVertexScalars);
$aPolyVertexTransform = Graphics::VTK::Transform->new;
$aPolyVertexTransform->Translate(2,0,6);
$transformPolyVertex = Graphics::VTK::TransformFilter->new;
$transformPolyVertex->SetInput($aPolyVertexGrid);
$transformPolyVertex->SetTransform($aPolyVertexTransform);
# Okay, append the data
$appendF = Graphics::VTK::AppendFilter->new;
$appendF->AddInput($transformVoxel->GetOutput);
$appendF->AddInput($transformHexahedron->GetOutput);
$appendF->AddInput($transformTetra->GetOutput);
$appendF->AddInput($transformWedge->GetOutput);
$appendF->AddInput($transformPyramid->GetOutput);
$appendF->AddInput($transformPixel->GetOutput);
$appendF->AddInput($transformQuad->GetOutput);
$appendF->AddInput($transformTriangle->GetOutput);
$appendF->AddInput($transformPolygon->GetOutput);
$appendF->AddInput($transformTriangleStrip->GetOutput);
$appendF->AddInput($transformLine->GetOutput);
$appendF->AddInput($transformPolyLine->GetOutput);
$appendF->AddInput($transformVertex->GetOutput);
$appendF->AddInput($transformPolyVertex->GetOutput);
# Write it out and display it
$writer = Graphics::VTK::UnstructuredGridWriter->new;
$writer->SetInput($appendF->GetOutput);
$writer->SetFileName("appendCells.vtk");
$writer->Write;
$mapper = Graphics::VTK::DataSetMapper->new;
$mapper->SetInput($appendF->GetOutput);
$allCellsActor = Graphics::VTK::Actor->new;
$allCellsActor->SetMapper($mapper);
# Read it in and display
$reader = Graphics::VTK::UnstructuredGridReader->new;
$reader->SetFileName("appendCells.vtk");
$mapper2 = Graphics::VTK::DataSetMapper->new;
$mapper2->SetInput($reader->GetOutput);
$allCellsActor2 = Graphics::VTK::Actor->new;
$allCellsActor2->SetMapper($mapper2);
# graphics stuff
$ren1 = Graphics::VTK::Renderer->new;
$ren1->SetViewport(0,0,0.5,1.0);
$ren2 = Graphics::VTK::Renderer->new;
$ren2->SetViewport(0.5,0,1.0,1.0);
$renWin = Graphics::VTK::RenderWindow->new;
$renWin->AddRenderer($ren1);
$renWin->AddRenderer($ren2);
$iren = Graphics::VTK::RenderWindowInteractor->new;
$iren->SetRenderWindow($renWin);
$ren1->SetBackground(1,1,1);
$ren2->SetBackground(1,1,1);
$renWin->SetSize(750,250);
$ren1->AddActor($allCellsActor);
$ren2->AddActor($allCellsActor2);
$renWin->Render;
$ren1->GetActiveCamera->Azimuth(30);
$ren1->GetActiveCamera->Elevation(20);
$ren1->GetActiveCamera->Dolly(2);
$ren1->ResetCameraClippingRange;
$ren2->GetActiveCamera->Azimuth(30);
$ren2->GetActiveCamera->Elevation(20);
$ren2->GetActiveCamera->Dolly(2);
$ren2->ResetCameraClippingRange;
# render the image
$iren->SetUserMethod(
 sub
  {
   $MW->{'.vtkInteract'}->deiconify;
  }
);
$iren->Initialize;
$MW->withdraw;
$renWin->SetFileName("appendCells.tcl.ppm");
#renWin SaveImageAsPPM
Graphics::VTK::Tk::vtkInt::vtkInteract($MW);

Tk->MainLoop;
