/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dbf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.parser.dbf.DBFColumnHeader;
import org.apache.tika.parser.dbf.DBFReader;

class DBFCell {
    private final DBFColumnHeader.ColType colType;
    private final byte[] bytes;
    private final int decimalCount;
    int bytesReadLast = 0;

    DBFCell(DBFColumnHeader.ColType colType, int fieldLength, int decimalCount) {
        this.colType = colType;
        this.decimalCount = decimalCount;
        this.bytes = new byte[fieldLength];
    }

    String getString(Charset charset) {
        switch (this.colType) {
            case C: {
                return new String(this.getBytes(), charset).trim();
            }
            case D: {
                return this.getFormattedDate();
            }
            case N: {
                return new String(this.getBytes(), StandardCharsets.US_ASCII).trim();
            }
            case L: {
                return new String(this.getBytes(), StandardCharsets.US_ASCII).trim();
            }
            case T: {
                return this.getFormattedDateTime();
            }
        }
        return new String(this.getBytes(), StandardCharsets.US_ASCII).trim();
    }

    boolean read(InputStream is) throws IOException {
        this.bytesReadLast = IOUtils.read(is, this.bytes);
        if (DBFReader.STRICT && this.bytesReadLast != this.bytes.length) {
            throw new IOException("Truncated record, only read " + this.bytesReadLast + " bytes, but should have read: " + this.bytes.length);
        }
        return this.bytesReadLast > 0;
    }

    byte[] getBytes() {
        byte[] ret = new byte[this.bytesReadLast];
        System.arraycopy(this.bytes, 0, ret, 0, this.bytesReadLast);
        return ret;
    }

    DBFColumnHeader.ColType getColType() {
        return this.colType;
    }

    public String toString() {
        return "DBFCell{colType=" + (Object)((Object)this.colType) + ", bytes=" + Arrays.toString(this.bytes) + ", decimalCount=" + this.decimalCount + '}';
    }

    DBFCell deepCopy() {
        DBFCell cell = new DBFCell(this.colType, this.bytes.length, this.decimalCount);
        cell.bytesReadLast = this.bytesReadLast;
        System.arraycopy(this.bytes, 0, cell.bytes, 0, this.bytesReadLast);
        return cell;
    }

    private String getFormattedDate() {
        byte[] dateBytes = this.getBytes();
        if (dateBytes.length < 8) {
            return "";
        }
        String year = new String(dateBytes, 0, 4, StandardCharsets.US_ASCII);
        String month = new String(dateBytes, 4, 2, StandardCharsets.US_ASCII);
        String day = new String(dateBytes, 6, 2, StandardCharsets.US_ASCII);
        for (String s : new String[]{year, month, day}) {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return String.format(Locale.ROOT, "%s/%s/%s", month, day, year);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFormattedDateTime() {
        Calendar baseCalendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        baseCalendar.set(-4712, 0, 1, 0, 0, 0);
        byte[] bytes = this.getBytes();
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.getBytes());){
            int date = EndianUtils.readIntLE(is);
            int time = EndianUtils.readIntLE(is);
            baseCalendar.add(5, date);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
            String string = df.format(baseCalendar.getTime());
            return string;
        }
        catch (IOException | EndianUtils.BufferUnderrunException exception) {
            return "";
        }
    }
}

