/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return string == null || string.length() == 0 || StringUtil.SQLEqualsIgnoreCase(string, "BUILTIN");
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Monitor.exceptionStartingModule(noSuchAlgorithmException);
        }
        this.setAuthenticationService(this);
    }

    public boolean authenticateUser(String string, String string2, String string3, Properties properties) {
        if (string == null) {
            return false;
        }
        String string4 = null;
        String string5 = null;
        String string6 = "derby.user.".concat(string);
        string4 = this.getDatabaseProperty(string6);
        if (string4 != null) {
            string5 = this.encryptPassword(string2);
        } else {
            string4 = this.getSystemProperty(string6);
            string5 = string2;
        }
        if (string4 == null) {
            return false;
        }
        return string4.equals(string5);
    }
}

