# Copyright (c) 2005 - 2006 Hans Jeuken. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

# This file was generated from the 'ansys.xml' file of the syntax highlight
# engine of the kate text editor (http://www.kate-editor.org

#kate xml version 1.0
#kate author Giovanni Bacci (giovanni@castellodilari.it)
#generated: Sun Feb  3 22:02:04 2008, localtime

package Syntax::Highlight::Engine::Kate::Ansys;

our $VERSION = '0.10';

use strict;
use warnings;
use base('Syntax::Highlight::Engine::Kate::Template');

sub new {
   my $proto = shift;
   my $class = ref($proto) || $proto;
   my $self = $class->SUPER::new(@_);
   $self->attributes({
      'APDLcmd' => 'Function',
      'AUX12cmds' => 'Function',
      'AUX15cmds' => 'Function',
      'AUX2cmds' => 'Function',
      'AUX3cmds' => 'Function',
      'Commands' => 'Others',
      'DBcmd' => 'Function',
      'DISPLAYcmds' => 'Function',
      'GRPH_cmds' => 'Function',
      'Keyword' => 'Keyword',
      'Labels' => 'Char',
      'MatProp' => 'DataType',
      'Normal Text' => 'Normal',
      'NumFloat' => 'Float',
      'NumInt' => 'DecVal',
      'OPTIMIZATIONcmds' => 'Function',
      'POST1Commands' => 'Function',
      'POST26Commands' => 'Function',
      'PREP7Commands' => 'Function',
      'PROBcmds' => 'Function',
      'REDUORDERcmds' => 'Function',
      'RUNSTATcmds' => 'Function',
      'SESSIONcmd' => 'Function',
      'SOLUCommands' => 'Function',
      'String' => 'String',
      'comment' => 'Comment',
      'error' => 'Error',
      'functions_arg' => 'Keyword',
      'variable' => 'Others',
   });
   $self->listAdd('APDL_commands',
      '*ABBR',
      '*AFUN',
      '*ASK',
      '*CFCLOS',
      '*CFOPEN',
      '*CFWRITE',
      '*CREATE',
      '*CYCLE',
      '*DEL',
      '*DIM',
      '*DO',
      '*DOWHILE',
      '*ELSE',
      '*ELSEIF',
      '*END',
      '*ENDDO',
      '*ENDIF',
      '*EXIT',
      '*GET',
      '*GO',
      '*IF',
      '*MFOURI',
      '*MFUN',
      '*MOPER',
      '*MSG',
      '*MWRITE',
      '*REPEAT',
      '*RETURN',
      '*SET',
      '*SREAD',
      '*STATUS',
      '*TAXIS',
      '*TOPER',
      '*TREAD',
      '*ULIB',
      '*USE',
      '*VABS',
      '*VCOL',
      '*VCUM',
      '*VEDIT',
      '*VFACT',
      '*VFILL',
      '*VFUN',
      '*VGET',
      '*VITRP',
      '*VLEN',
      '*VMASK',
      '*VOPER',
      '*VPLOT',
      '*VPUT',
      '*VREAD',
      '*VSCFUN',
      '*VSTAT',
      '*VWRITE',
      '/DFLAB',
      '/DIRECTORY',
      '/INQUIRE',
      '/MAIL',
      '/PMACRO',
      '/PSEARCH',
      '/TEE',
      '/UCMD',
      '/WAIT',
      'ABBRES',
      'ABBSAV',
      'GET',
      'PARRES',
      'PARSAV',
   );
   $self->listAdd('POST1_commands',
      '/ANFILE',
      '/CYCEXPAND',
      '/EFACET',
      '/EXPAND',
      '/FORMAT',
      '/HEADER',
      '/PAGE',
      '/POST1',
      'ANCNTR',
      'ANCUT',
      'ANCYC',
      'ANDATA',
      'ANDSCL',
      'ANDYNA',
      'ANFLOW',
      'ANHARM',
      'ANIM',
      'ANISOS',
      'ANMODE',
      'ANMRES',
      'ANTIME',
      'APPEND',
      'AVPRIN',
      'AVRES',
      'BFINT',
      'CBDOF',
      'CMSFILE',
      'CURR2D',
      'CYCPHASE',
      'DATADEF',
      'DEFINE',
      'DESOL',
      'DETAB',
      'DISPLAY',
      'DNSOL',
      'EMAGERR',
      'EMF',
      'EMFT',
      'ERNORM',
      'ESORT',
      'ETABLE',
      'EUSORT',
      'EXPAND',
      'FC',
      'FCCHECK',
      'FCDELE',
      'FCLIST',
      'FE',
      'FELIST',
      'FILE',
      'FL',
      'FLLIST',
      'FLREAD',
      'FLUXV',
      'FMAGSUM',
      'FOR2D',
      'FORCE',
      'FP',
      'FPLIST',
      'FS',
      'FSDELE',
      'FSLIST',
      'FSNODE',
      'FSPLOT',
      'FSSECT',
      'FSSPARM',
      'FSUM',
      'FTCALC',
      'FTSIZE',
      'FTWRITE',
      'HFANG',
      'HFARRAY',
      'HFNEAR',
      'HFPOWER',
      'HFSYM',
      'HRCPLX',
      'IMPD',
      'INRES',
      'INTSRF',
      'IRLIST',
      'KCALC',
      'LAYER',
      'LCABS',
      'LCASE',
      'LCCALC',
      'LCDEF',
      'LCFACT',
      'LCFILE',
      'LCOPER',
      'LCSEL',
      'LCSUM',
      'LCWRITE',
      'LCZERO',
      'MMF',
      'NFORCE',
      'NSORT',
      'NUSORT',
      'PADELE',
      'PAGET',
      'PAPUT',
      'PARESU',
      'PASAVE',
      'PATH',
      'PCALC',
      'PCROSS',
      'PDEF',
      'PDOT',
      'PGRSET',
      'PLCONV',
      'PLCRACK',
      'PLDISP',
      'PLESOL',
      'PLETAB',
      'PLF2D',
      'PLHFFAR',
      'PLLS',
      'PLNSOL',
      'PLPAGM',
      'PLPATH',
      'PLSCH',
      'PLSECT',
      'PLSYZ',
      'PLTRAC',
      'PLVECT',
      'PLVECT',
      'PMAP',
      'POINT',
      'POWERH',
      'PPATH',
      'PPLOT',
      'PRANGE',
      'PRCONV',
      'PRERR',
      'PRESOL',
      'PRETAB',
      'PRHFFAR',
      'PRINT',
      'PRITER',
      'PRJSOL',
      'PRNLD',
      'PRNSOL',
      'PRPATH',
      'PRRFOR',
      'PRRSOL',
      'PRSECT',
      'PRSSOL',
      'PRSYZ',
      'PRVECT',
      'PRVECT',
      'PSEL',
      'PVECT',
      'QFACT',
      'RAPPND',
      'REFLCOEF',
      'RESET',
      'RMFLVEC',
      'RSPLIT',
      'RSYS',
      'SABS',
      'SADD',
      'SALLOW',
      'SENERGY',
      'SET',
      'SEXP',
      'SFACT',
      'SFCALC',
      'SHELL',
      'SMAX',
      'SMIN',
      'SMULT',
      'SORT',
      'SPARM',
      'SPEC',
      'SPOINT',
      'SSUM',
      'SUBSET',
      'SUCALC',
      'SUCR',
      'SUDEL',
      'SUEVAL',
      'SUGET',
      'SUMAP',
      'SUMTYPE',
      'SUPL',
      'SUPR',
      'SURESU',
      'SUSAVE',
      'SUSEL',
      'SUVECT',
      'TALLOW',
      'TORQ2D',
      'TORQC2D',
      'TORQSUM',
      'TRPDEL',
      'TRPLIS',
      'TRPOIN',
      'TRTIME',
      'VCROSS',
      'VDOT',
   );
   $self->listAdd('POST26_cmds',
      '/POST26',
      '/RGB',
      'ABS',
      'ADD',
      'ANSOL',
      'ATAN',
      'CFACT',
      'CLOG',
      'CONJUG',
      'CVAR',
      'DATA',
      'DEFINE',
      'DERIV',
      'EDREAD',
      'ESOL',
      'EXP',
      'EXTREM',
      'FILE',
      'FILLDATA',
      'FORCE',
      'GAPF',
      'GSSOL',
      'IMAGIN',
      'INT1',
      'JSOL',
      'LARGE',
      'LAYERP26',
      'LINES',
      'NLOG',
      'NPRINT',
      'NSOL',
      'NSTORE',
      'NUMVAR',
      'OPERATE',
      'PLCPLX',
      'PLOTTING',
      'PLTIME',
      'PLVAR',
      'PMGTRAN',
      'PRCPLX',
      'PRINT',
      'PROD',
      'PRTIME',
      'PRVAR',
      'QUOT',
      'REALVAR',
      'RESET',
      'RESP',
      'RFORCE',
      'RPSD',
      'SHELL',
      'SMALL',
      'SMOOTH',
      'SOLU',
      'SPREAD',
      'SQRT',
      'STORE',
      'TIMERANGE',
      'TVAR',
      'VARDEL',
      'VARNAM',
      'VGET',
      'VPUT',
      'XVAR',
   );
   $self->listAdd('aux12_cmds',
      '/AUX12',
      'EMIS',
      'GEOM',
      'MPRINT',
      'SPACE',
      'STEF',
      'VFQUERY',
      'VTYPE',
      'WRITE',
   );
   $self->listAdd('aux15_cmds',
      '/AUX15',
      'IGESIN',
      'IOPTN',
   );
   $self->listAdd('aux2_cmds',
      '/AUX2',
      'DUMP',
      'FILEAUX2',
      'FORM',
      'HBMAT',
   );
   $self->listAdd('aux3_cmds',
      '/AUX3',
      'COMPRESS',
      'DELETE',
      'FILEAUX3',
      'LIST',
      'MODIFY',
      'UNDELETE',
   );
   $self->listAdd('database_cmds',
      '/CLEAR',
      '/SMBC',
      '/STITLE',
      '/TITLE',
      '/UNITS',
      'ALLSEL',
      'ASEL',
      'ASLL',
      'ASLV',
      'CLOCAL',
      'CM',
      'CMDELE',
      'CMEDIT',
      'CMGRP',
      'CMLIST',
      'CMMOD',
      'CMPLOT',
      'CMSEL',
      'CS',
      'CSCIR',
      'CSDELE',
      'CSKP',
      'CSLIST',
      'CSWPLA',
      'CSYS',
      'DOFSEL',
      'ESEL',
      'ESLA',
      'ESLL',
      'ESLN',
      'ESLV',
      'FITEM',
      'FLST',
      'KSEL',
      'KSLL',
      'KSLN',
      'KWPAVE',
      'KWPLAN',
      'LOCAL',
      'LSEL',
      'LSLA',
      'LSLK',
      'LWPLAN',
      'NSEL',
      'NSLA',
      'NSLE',
      'NSLK',
      'NSLL',
      'NSLV',
      'NWPAVE',
      'NWPLAN',
      'PARTSEL',
      'RESUME',
      'SAVE',
      'STAT',
      'UNDO',
      'VSEL',
      'VSLA',
      'WPAVE',
      'WPCSYS',
      'WPLANE',
      'WPOFFS',
      'WPROTA',
      'WPSTYL',
   );
   $self->listAdd('display_cmds',
      '/CMAP',
      '/DEVDISP',
      '/SEG',
      '/SHOWDISP',
      'FILEDISP',
      'FINISH',
      'GRPH',
      'HELPDISP',
      'NOCOLOR',
      'PLOT',
      'STAT',
      'TERM',
      'TRANS',
   );
   $self->listAdd('elements',
      'BEAM161',
      'BEAM188',
      'BEAM189',
      'BEAM23',
      'BEAM24',
      'BEAM3',
      'BEAM4',
      'BEAM44',
      'BEAM54',
      'CIRCU124',
      'CIRCU125',
      'CIRCU94',
      'COMBI165',
      'COMBIN14',
      'COMBIN37',
      'COMBIN39',
      'COMBIN40',
      'COMBIN7',
      'CONTA171',
      'CONTA172',
      'CONTA173',
      'CONTA174',
      'CONTA175',
      'CONTA178',
      'CONTAC12',
      'CONTAC52',
      'FLUID116',
      'FLUID129',
      'FLUID130',
      'FLUID136',
      'FLUID138',
      'FLUID139',
      'FLUID141',
      'FLUID142',
      'FLUID29',
      'FLUID30',
      'FLUID38',
      'FLUID79',
      'FLUID80',
      'FLUID81',
      'FOLLW201',
      'HF118',
      'HF119',
      'HF120',
      'HYPER158',
      'HYPER56',
      'HYPER58',
      'HYPER74',
      'HYPER84',
      'HYPER86',
      'INFIN110',
      'INFIN111',
      'INFIN47',
      'INFIN9',
      'INTER115',
      'INTER192',
      'INTER193',
      'INTER194',
      'INTER195',
      'LINK1',
      'LINK10',
      'LINK11',
      'LINK160',
      'LINK167',
      'LINK180',
      'LINK31',
      'LINK32',
      'LINK33',
      'LINK34',
      'LINK68',
      'LINK8',
      'MASS166',
      'MASS21',
      'MASS71',
      'MATRIX27',
      'MATRIX50',
      'MESH200',
      'MPC184',
      'PIPE16',
      'PIPE17',
      'PIPE18',
      'PIPE20',
      'PIPE59',
      'PIPE60',
      'PLANE121',
      'PLANE13',
      'PLANE145',
      'PLANE146',
      'PLANE162',
      'PLANE182',
      'PLANE183',
      'PLANE2',
      'PLANE223',
      'PLANE230',
      'PLANE25',
      'PLANE35',
      'PLANE42',
      'PLANE53',
      'PLANE55',
      'PLANE67',
      'PLANE75',
      'PLANE77',
      'PLANE78',
      'PLANE82',
      'PLANE83',
      'PRETS179',
      'ROM144',
      'SHELL131',
      'SHELL132',
      'SHELL143',
      'SHELL150',
      'SHELL157',
      'SHELL163',
      'SHELL181',
      'SHELL208',
      'SHELL209',
      'SHELL28',
      'SHELL41',
      'SHELL43',
      'SHELL51',
      'SHELL57',
      'SHELL61',
      'SHELL63',
      'SHELL91',
      'SHELL93',
      'SHELL99',
      'SOLID117',
      'SOLID122',
      'SOLID123',
      'SOLID127',
      'SOLID128',
      'SOLID147',
      'SOLID148',
      'SOLID164',
      'SOLID168',
      'SOLID185',
      'SOLID186',
      'SOLID187',
      'SOLID191',
      'SOLID226',
      'SOLID227',
      'SOLID231',
      'SOLID232',
      'SOLID45',
      'SOLID46',
      'SOLID5',
      'SOLID62',
      'SOLID64',
      'SOLID65',
      'SOLID69',
      'SOLID70',
      'SOLID87',
      'SOLID90',
      'SOLID92',
      'SOLID95',
      'SOLID96',
      'SOLID97',
      'SOLID98',
      'SOLSH190',
      'SOURC36',
      'SURF151',
      'SURF152',
      'SURF153',
      'SURF154',
      'SURF251',
      'SURF252',
      'TARGE169',
      'TARGE170',
      'TRANS109',
      'TRANS126',
      'VISCO106',
      'VISCO107',
      'VISCO108',
      'VISCO88',
      'VISCO89',
   );
   $self->listAdd('force-displacement-labels',
      'AMPS',
      'AX',
      'AYAZ',
      'CHRG',
      'CSGX',
      'CSGY',
      'CSGZ',
      'ENDS',
      'ENKE',
      'FLOW',
      'FX',
      'FY',
      'FZ',
      'HBOT',
      'HE2',
      'HE3',
      'HEAT',
      'HTOP',
      'MAG',
      'MX',
      'MY',
      'MZ',
      'PRES',
      'ROTX',
      'ROTY',
      'ROTZ',
      'SP01',
      'SP02',
      'SP03',
      'SP04',
      'SP05',
      'SP06',
      'TBOT',
      'TE2',
      'TE3',
      'TEMP',
      'TTOP',
      'UX',
      'UY',
      'UZ',
      'VOLT',
      'VX',
      'VY',
      'VZ',
      'WARP',
   );
   $self->listAdd('graphic_cmds',
      '/AN3D',
      '/ANGLE',
      '/ANNOT',
      '/ANUM',
      '/AUTO',
      '/AXLAB',
      '/CFORMAT',
      '/CLABEL',
      '/CMAP',
      '/COLOR',
      '/CONTOUR',
      '/CPLANE',
      '/CTYPE',
      '/CVAL',
      '/DEVICE',
      '/DIST',
      '/DSCALE',
      '/DV3D',
      '/EDGE',
      '/ERASE',
      '/ESHAPE',
      '/FACET',
      '/FOCUS',
      '/GCMD',
      '/GCOLUMN',
      '/GFILE',
      '/GFORMAT',
      '/GLINE',
      '/GMARKER',
      '/GRAPHICS',
      '/GRESUME',
      '/GRID',
      '/GROPT',
      '/GRTYP',
      '/GSAVE',
      '/GTHK',
      '/GTYPE',
      '/HBC',
      '/ICLWID',
      '/ICSCALE',
      '/IMAGE',
      '/LARC',
      '/LIGHT',
      '/LINE',
      '/LSPEC',
      '/LSYMBOL',
      '/MREP',
      '/NOERASE',
      '/NORMAL',
      '/NUMBER',
      '/PBC',
      '/PBF',
      '/PCIRCLE',
      '/PCOPY',
      '/PICE',
      '/PLOPTS',
      '/PMORE',
      '/PNUM',
      '/POLYGON',
      '/PSF',
      '/PSPEC',
      '/PSTATUS',
      '/PSYMB',
      '/PWEDGE',
      '/RATIO',
      '/REPLOT',
      '/RESET',
      '/SEG',
      '/SHADE',
      '/SHOW',
      '/SHRINK',
      '/SSCALE',
      '/TLABEL',
      '/TRIAD',
      '/TRLCY',
      '/TSPEC',
      '/TXTRE',
      '/TYPE',
      '/UDOC',
      '/USER',
      '/VCONE',
      '/VIEW',
      '/VSCALE',
      '/VUP',
      '/WINDOW',
      '/XFRM',
      '/XRANGE',
      '/YRANGE',
      '/ZOOM',
      'DSYS',
      'ERASE',
      'GMFACE',
      'GPLOT',
      'HPGL',
      'IMMED',
      'JPEG',
      'PGSELE',
      'PNGR',
      'PSCR',
      'TIFF',
   );
   $self->listAdd('material_properties',
      'ALPX',
      'ALPY',
      'ALPZ',
      'C',
      'CTEX',
      'CTEY',
      'CTEZ',
      'DAMP',
      'DENS',
      'DMPR',
      'EMIS',
      'ENTH',
      'EX',
      'EY',
      'EZ',
      'GXY',
      'GXY',
      'GXZ',
      'GYZ',
      'HF',
      'KXX',
      'KYY',
      'KZZ',
      'LSST',
      'MGXX',
      'MGYY',
      'MGZZ',
      'MU',
      'MURX',
      'MURY',
      'MURZ',
      'NUXY',
      'NUXY',
      'NUXZ',
      'NUYZ',
      'PERX',
      'PRXY',
      'PRXZ',
      'PRYZ',
      'QRATE',
      'REFT',
      'RSVX',
      'RSVY',
      'RSVZ',
      'SBKX',
      'SONC',
      'THSX',
      'THSY',
      'THSZ',
      'VISC',
   );
   $self->listAdd('optimization_cmds',
      '/OPT',
      'OPADD',
      'OPANL',
      'OPCLR',
      'OPDATA',
      'OPDEL',
      'OPEQN',
      'OPEXE',
      'OPFACT',
      'OPFRST',
      'OPGRAD',
      'OPKEEP',
      'OPLFA',
      'OPLGR',
      'OPLIST',
      'OPLOOP',
      'OPLSW',
      'OPMAKE',
      'OPPRNT',
      'OPRAND',
      'OPRESU',
      'OPRFA',
      'OPRGR',
      'OPRSW',
      'OPSAVE',
      'OPSEL',
      'OPSUBP',
      'OPSWEEP',
      'OPTYPE',
      'OPUSER',
      'OPVAR',
      'PLVAROPT',
      'PRVAROPT',
      'TOCOMP',
      'TODEF',
      'TOEXE',
      'TOFREQ',
      'TOGRAPH',
      'TOLIST',
      'TOLOOP',
      'TOPLOT',
      'TOPRINT',
      'TOSTAT',
      'TOTYPE',
      'TOVAR',
      'XVAROPT',
   );
   $self->listAdd('parametric_functions',
      'ABS',
      'ACOS',
      'ASIN',
      'ATAN',
      'ATAN2',
      'CHRVAL',
      'COS',
      'COSH',
      'EXP',
      'GDIS',
      'LOG',
      'LOG10',
      'LWCASE',
      'MOD',
      'NINT',
      'RAND',
      'SIGN',
      'SIN',
      'SINH',
      'SQRT',
      'TAN',
      'TANH',
      'UPCASE',
      'VALCHR',
   );
   $self->listAdd('prep7_commands',
      '*EVAL',
      '*MOONEY',
      '/CYCEXPAND',
      '/MPLIB',
      '/SECLIB',
      'A',
      'AADD',
      'AATT',
      'ACCAT',
      'ACLEAR',
      'ADELE',
      'ADGL',
      'ADRAG',
      'AESIZE',
      'AFILLT',
      'AFLIST',
      'AFSURF',
      'AGEN',
      'AGLUE',
      'AINA',
      'AINP',
      'AINV',
      'AL',
      'ALIST',
      'ALPFILL',
      'AMAP',
      'AMESH',
      'ANORM',
      'AOFFST',
      'AOVLAP',
      'APLOT',
      'APTN',
      'ARCOLLAPSE',
      'ARDETACH',
      'AREAS',
      'AREFINE',
      'AREVERSE',
      'ARFILL',
      'ARMERGE',
      'AROTAT',
      'ARSCALE',
      'ARSPLIT',
      'ARSYM',
      'ASBA',
      'ASBL',
      'ASBV',
      'ASBW',
      'ASKIN',
      'ASUB',
      'ASUM',
      'ATRAN',
      'BELLOW',
      'BEND',
      'BLC4',
      'BLC5',
      'BLOCK',
      'BOOL',
      'BOPTN',
      'BRANCH',
      'BSAX',
      'BSM1',
      'BSM2',
      'BSMD',
      'BSPLIN',
      'BSS1',
      'BSS2',
      'BSTE',
      'BSTQ',
      'BTOL',
      'CDOPT',
      'CDREAD',
      'CDWRITE',
      'CE',
      'CECHECK',
      'CECYC',
      'CEDELE',
      'CEINTF',
      'CELIST',
      'CENTER',
      'CEQN',
      'CERIG',
      'CESGEN',
      'CHECK',
      'CHKMSH',
      'CIRCLE',
      'CLRMSHLN',
      'CNCHECK',
      'CON4',
      'CONE',
      'COUPLE',
      'CP',
      'CPCYC',
      'CPDELE',
      'CPINTF',
      'CPLGEN',
      'CPLIST',
      'CPNGEN',
      'CPSGEN',
      'CYCLIC',
      'CYCOPT',
      'CYL4',
      'CYL5',
      'CYLIND',
      'DAMORPH',
      'DEMORPH',
      'DESIZE',
      'DIG',
      'DIGIT',
      'DMOVE',
      'DOF',
      'DSET',
      'DSURF',
      'DVMORPH',
      'E',
      'EDASMP',
      'EDBOUND',
      'EDBX',
      'EDCGEN',
      'EDCLIST',
      'EDCMORE',
      'EDCNSTR',
      'EDCONTACT',
      'EDCRB',
      'EDCURVE',
      'EDDBL',
      'EDDC',
      'EDELE',
      'EDIPART',
      'EDLCS',
      'EDMP',
      'EDNB',
      'EDNDTSD',
      'EDNROT',
      'EDPART',
      'EDPC',
      'EDSP',
      'EDWELD',
      'EGEN',
      'EINTF',
      'ELEM',
      'ELIST',
      'EMID',
      'EMODIF',
      'EMORE',
      'EMSYM',
      'EMTGEN',
      'EMUNIT',
      'EN',
      'ENDRELEASE',
      'ENGEN',
      'ENORM',
      'ENSYM',
      'EORIENT',
      'EORIENT',
      'EPLOT',
      'EREAD',
      'EREFINE',
      'ERRANG',
      'ESIZE',
      'ESURF',
      'ESYM',
      'ESYS',
      'ESYS',
      'ET',
      'ETCONTROL',
      'ETDELE',
      'ETLIST',
      'ETYPE',
      'EWRITE',
      'EXTOPT',
      'FATIGUE',
      'FC',
      'FCCHECK',
      'FCDELE',
      'FCLIST',
      'FEBODY',
      'FECONS',
      'FEFOR',
      'FESURF',
      'FILL',
      'FLANGE',
      'FLDATA',
      'FLDATA1',
      'FLDATA10',
      'FLDATA11',
      'FLDATA12',
      'FLDATA13',
      'FLDATA14',
      'FLDATA15',
      'FLDATA16',
      'FLDATA17',
      'FLDATA18',
      'FLDATA19',
      'FLDATA2',
      'FLDATA20',
      'FLDATA20A',
      'FLDATA20B',
      'FLDATA21',
      'FLDATA22',
      'FLDATA23',
      'FLDATA24',
      'FLDATA24A',
      'FLDATA24B',
      'FLDATA24C',
      'FLDATA24D',
      'FLDATA24E',
      'FLDATA24F',
      'FLDATA24G',
      'FLDATA24H',
      'FLDATA25',
      'FLDATA26',
      'FLDATA27',
      'FLDATA28',
      'FLDATA29',
      'FLDATA3',
      'FLDATA30',
      'FLDATA31',
      'FLDATA32',
      'FLDATA33',
      'FLDATA34',
      'FLDATA35',
      'FLDATA36',
      'FLDATA37',
      'FLDATA38',
      'FLDATA39',
      'FLDATA4',
      'FLDATA40',
      'FLDATA4A',
      'FLDATA5',
      'FLDATA6',
      'FLDATA7',
      'FLDATA8',
      'FLDATA9',
      'FLOTRAN',
      'FSAN',
      'FSCO',
      'FSDT',
      'FSIN',
      'FSIT',
      'FSOR',
      'FSOU',
      'FSRE',
      'FSSTAT',
      'FSTI',
      'FSTR',
      'FVMESH',
      'GAPFINISH',
      'GAPLIST',
      'GAPMERGE',
      'GAPOPT',
      'GAPPLOT',
      'GEOMETRY',
      'GSGDATA',
      'GSUM',
      'GSUM',
      'GSUM',
      'GSUM',
      'HFEREFINE',
      'HPTCREATE',
      'HPTDELETE',
      'ICVFRC',
      'IGESOUT',
      'IMESH',
      'K',
      'KATTA',
      'KBETW',
      'KCENTER',
      'KCLEAR',
      'KDELE',
      'KDIST',
      'KESIZE',
      'KEYOPT',
      'KEYPTS',
      'KFILL',
      'KGEN',
      'KL',
      'KLIST',
      'KMESH',
      'KMODIF',
      'KMOVE',
      'KNODE',
      'KPLOT',
      'KPSCALE',
      'KREFINE',
      'KSCALE',
      'KSCON',
      'KSUM',
      'KSYMM',
      'KTRAN',
      'L',
      'L2ANG',
      'L2TAN',
      'LANG',
      'LARC',
      'LAREA',
      'LATT',
      'LAYLIST',
      'LAYPLOT',
      'LCCAT',
      'LCLEAR',
      'LCOMB',
      'LCSL',
      'LDELE',
      'LDIV',
      'LDRAG',
      'LESIZE',
      'LEXTND',
      'LFILLT',
      'LFSURF',
      'LGEN',
      'LGLUE',
      'LINA',
      'LINE',
      'LINL',
      'LINP',
      'LINV',
      'LLIST',
      'LMESH',
      'LNCOLLAPSE',
      'LNDETACH',
      'LNFILL',
      'LNMERGE',
      'LNSPLIT',
      'LOVLAP',
      'LPLOT',
      'LPTN',
      'LREFINE',
      'LREVERSE',
      'LROTAT',
      'LSBA',
      'LSBL',
      'LSBV',
      'LSBW',
      'LSSCALE',
      'LSTR',
      'LSUM',
      'LSYMM',
      'LTAN',
      'LTRAN',
      'MAT',
      'MAT',
      'MATER',
      'MCHECK',
      'MESHING',
      'MITER',
      'MODMSH',
      'MOPT',
      'MORPH',
      'MOVE',
      'MP',
      'MPAMOD',
      'MPCHG',
      'MPCOPY',
      'MPDATA',
      'MPDELE',
      'MPDRES',
      'MPLIST',
      'MPPLOT',
      'MPREAD',
      'MPTEMP',
      'MPTGEN',
      'MPTRES',
      'MPWRITE',
      'MSADV',
      'MSCAP',
      'MSDATA',
      'MSHAPE',
      'MSHCOPY',
      'MSHKEY',
      'MSHMID',
      'MSHPATTERN',
      'MSMASS',
      'MSMETH',
      'MSMIR',
      'MSNOMF',
      'MSPROP',
      'MSQUAD',
      'MSRELAX',
      'MSSOLU',
      'MSSPEC',
      'MSTERM',
      'MSVARY',
      'N',
      'NANG',
      'NDELE',
      'NDIST',
      'NDSURF',
      'NGEN',
      'NKPT',
      'NLIST',
      'NMODIF',
      'NODES',
      'NOOFFSET',
      'NOORDER',
      'NPLOT',
      'NREAD',
      'NREFINE',
      'NROTAT',
      'NRRANG',
      'NSCALE',
      'NSMOOTH',
      'NSVR',
      'NSYM',
      'NUMCMP',
      'NUMMRG',
      'NUMOFF',
      'NUMSTR',
      'NWRITE',
      'PCIRC',
      'PCORRO',
      'PDRAG',
      'PERBC2D',
      'PFLUID',
      'PGAP',
      'PHYSICS',
      'PINSUL',
      'PIPE',
      'PLVFRC',
      'PMETH',
      'PMLOPT',
      'PMLSIZE',
      'POLY',
      'POPT',
      'PPRES',
      'PRI2',
      'PRIM',
      'PRISM',
      'PRSSOL',
      'PSMESH',
      'PSPEC',
      'PSPRNG',
      'PTEMP',
      'PTXY',
      'PUNIT',
      'QUAD',
      'R',
      'RACE',
      'RBE3',
      'RCON',
      'RDELE',
      'REAL',
      'REAL',
      'RECTNG',
      'REDUCE',
      'REORDER',
      'RLIST',
      'RMODIF',
      'RMORE',
      'RPOLY',
      'RPR4',
      'RPRISM',
      'RTHICK',
      'RUN',
      'SARPLOT',
      'SDELETE',
      'SE',
      'SECDATA',
      'SECJOINT',
      'SECLOCK',
      'SECNUM',
      'SECOFFSET',
      'SECPLOT',
      'SECREAD',
      'SECSTOP',
      'SECTYPE',
      'SECWRITE',
      'SEDLIST',
      'SELISTL',
      'SELM',
      'SESYMM',
      'SETFGAP',
      'SETRAN',
      'SHPP',
      'SHSD',
      'SLIST',
      'SLPPLOT',
      'SLSPLOT',
      'SMRTSIZE',
      'SOURCE',
      'SOURCE',
      'SPH4',
      'SPH5',
      'SPHERE',
      'SPLINE',
      'SPLOT',
      'SSBT',
      'SSLN',
      'SSMT',
      'SSPA',
      'SSPB',
      'SSPD',
      'SSPE',
      'SSPM',
      'SWADD',
      'SWDEL',
      'SWGEN',
      'SWLIST',
      'TB',
      'TBCOPY',
      'TBDATA',
      'TBDELE',
      'TBFIELD',
      'TBFT',
      'TBLE',
      'TBLIST',
      'TBMODIF',
      'TBPLOT',
      'TBPT',
      'TBTEMP',
      'TCHG',
      'TEE',
      'TIMP',
      'TORUS',
      'TRANSFER',
      'TSHAP',
      'TYPE',
      'TYPE',
      'TZAMESH',
      'TZDELE',
      'TZEGEN',
      'UIMP',
      'UPGEOM',
      'V',
      'VA',
      'VADD',
      'VALVE',
      'VATT',
      'VCLEAR',
      'VCVFILL',
      'VDELE',
      'VDGL',
      'VDRAG',
      'VEORIENT',
      'VEXT',
      'VGEN',
      'VGLUE',
      'VIMP',
      'VINP',
      'VINV',
      'VLIST',
      'VLSCALE',
      'VMESH',
      'VOFFST',
      'VOLUMES',
      'VOVLAP',
      'VPLOT',
      'VPTN',
      'VROTAT',
      'VSBA',
      'VSBV',
      'VSBW',
      'VSUM',
      'VSWEEP',
      'VSYMM',
      'VTRAN',
      'WAVES',
      'WERASE',
      'WFRONT',
      'WMID',
      'WMORE',
      'WSORT',
      'WSTART',
   );
   $self->listAdd('probabilistic_cmds',
      '/PDS',
      'PDANL',
      'PDCDF',
      'PDCLR',
      'PDCMAT',
      'PDCORR',
      'PDDMCS',
      'PDDOEL',
      'PDEXE',
      'PDHIST',
      'PDINQR',
      'PDMETH',
      'PDPINV',
      'PDPLOT',
      'PDPROB',
      'PDRESU',
      'PDROPT',
      'PDSAVE',
      'PDSCAT',
      'PDSENS',
      'PDSHIS',
      'PDUSER',
      'PDVAR',
      'PDWRITE',
      'RSFIT',
      'RSPLOT',
      'RSPRNT',
      'RSSIMS',
   );
   $self->listAdd('reduced_order_cmds',
      'DCVSWP',
      'RMALIST',
      'RMANL',
      'RMASTER',
      'RMCAP',
      'RMCLIST',
      'RMLVSCALE',
      'RMMLIST',
      'RMMRANGE',
      'RMMSELECT',
      'RMNDISP',
      'RMNEVEC',
      'RMPORDER',
      'RMRESUME',
      'RMRGENERATE',
      'RMROPTIONS',
      'RMRPLOT',
      'RMRSTATUS',
      'RMSAVE',
      'RMSMPLE',
      'RMUSE',
      'RMXPORT',
   );
   $self->listAdd('runstats_cmds',
      '/RUNST',
      'RALL',
      'RFILSZ',
      'RITER',
      'RMEMRY',
      'RSPEED',
      'RSTAT',
      'RTIMST',
      'RWFRNT',
   );
   $self->listAdd('session_cmds',
      '*LIST',
      '/ASSIGN',
      '/AUX12',
      '/AUX15',
      '/AUX2',
      '/AUX3',
      '/BATCH',
      '/CLOG',
      '/COM',
      '/CONFIG',
      '/COPY',
      '/CWD',
      '/DELETE',
      '/EOF',
      '/EXIT',
      '/FDELE',
      '/FILNAME',
      '/FTYPE',
      '/GO',
      '/GOLIST',
      '/GOPR',
      '/INPUT',
      '/MENU',
      '/MSTART',
      '/NERR',
      '/NOLIST',
      '/NOPR',
      '/OPT',
      '/OUTPUT',
      '/POST1',
      '/POST26',
      '/PREP7',
      '/QUIT',
      '/RENAME',
      '/RUNST',
      '/SOLU',
      '/STATUS',
      '/SYP',
      '/SYS',
      '/UI',
      '/UIS',
      'FINISH',
      'HELP',
      'KEYW',
      'LGWRITE',
      'MEMM',
   );
   $self->listAdd('solution_commands',
      '/GST',
      '/PMETH',
      '/SOLU',
      'ABEXTRACT',
      'ACEL',
      'ADAMS',
      'ADAPT',
      'ADDAM',
      'ALPHAD',
      'ANTYPE',
      'ARCLENA',
      'ARCTRM',
      'AREMESH',
      'AUTOTS',
      'BCSOPTION',
      'BETAD',
      'BF',
      'BFA',
      'BFADELE',
      'BFALIST',
      'BFCUM',
      'BFDELE',
      'BFE',
      'BFECUM',
      'BFEDELE',
      'BFELIST',
      'BFESCAL',
      'BFK',
      'BFKDELE',
      'BFKLIST',
      'BFL',
      'BFLDELE',
      'BFLIST',
      'BFLLIST',
      'BFSCALE',
      'BFTRAN',
      'BFUNIF',
      'BFV',
      'BFVDELE',
      'BFVLIST',
      'BIOOPT',
      'BIOT',
      'BUCOPT',
      'CECHECK',
      'CECMOD',
      'CGLOC',
      'CGOMGA',
      'CHECK',
      'CMACEL',
      'CMATRIX',
      'CMDOMEGA',
      'CMOMEGA',
      'CMSOPT',
      'CNCHECK',
      'CNVTOL',
      'COVAL',
      'CQC',
      'CRPLIM',
      'CUTCONTROL',
      'CYCOPT',
      'D',
      'DA',
      'DADELE',
      'DALIST',
      'DCGOMG',
      'DCUM',
      'DDELE',
      'DEACT',
      'DELTIM',
      'DJ',
      'DJDELE',
      'DJLIST',
      'DK',
      'DKDELE',
      'DKLIST',
      'DL',
      'DLDELE',
      'DLIST',
      'DLLIST',
      'DMPEXT',
      'DMPRAT',
      'DOMEGA',
      'DSCALE',
      'DSOPT',
      'DSPROC',
      'DSUM',
      'DSYM',
      'DTRAN',
      'DYNOPT',
      'EALIVE',
      'EDADAPT',
      'EDALE',
      'EDBVIS',
      'EDCADAPT',
      'EDCPU',
      'EDCSC',
      'EDCTS',
      'EDDAMP',
      'EDDRELAX',
      'EDDUMP',
      'EDENERGY',
      'EDFPLOT',
      'EDGCALE',
      'EDHGLS',
      'EDHIST',
      'EDHTIME',
      'EDINT',
      'EDIS',
      'EDLOAD',
      'EDOPT',
      'EDOUT',
      'EDPL',
      'EDPVEL',
      'EDRC',
      'EDRD',
      'EDRI',
      'EDRST',
      'EDRUN',
      'EDSHELL',
      'EDSOLV',
      'EDSTART',
      'EDTERM',
      'EDTP',
      'EDVEL',
      'EDWRITE',
      'EKILL',
      'EMATWRITE',
      'EQSLV',
      'ERESX',
      'ESCHECK',
      'ESSOLV',
      'ESTIF',
      'EXPASS',
      'EXPSOL',
      'F',
      'FCUM',
      'FDELE',
      'FJ',
      'FJDELE',
      'FJLIST',
      'FK',
      'FKDELE',
      'FKLIST',
      'FLIST',
      'FLOCHECK',
      'FMAGBC',
      'FREQ',
      'FSAN',
      'FSCALE',
      'FSCO',
      'FSDT',
      'FSIN',
      'FSIT',
      'FSOR',
      'FSOU',
      'FSRE',
      'FSRS',
      'FSRS',
      'FSSOLV',
      'FSSTAT',
      'FSTI',
      'FSTR',
      'FTRAN',
      'GAP',
      'GAUGE',
      'GENOPT',
      'GMATRIX',
      'GP',
      'GPDELE',
      'GPLIST',
      'GRP',
      'GSBDATA',
      'GSLIST',
      'HARFRQ',
      'HEMIOPT',
      'HFEIGOPT',
      'HFPA',
      'HFPCSWP',
      'HFPORT',
      'HFSCAT',
      'HFSWEEP',
      'HMAGSOLV',
      'HREXP',
      'HROPT',
      'HROUT',
      'IC',
      'ICDELE',
      'ICE',
      'ICEDELE',
      'ICELIST',
      'ICLIST',
      'INRTIA',
      'IRLF',
      'ISFILE',
      'KBC',
      'KUSE',
      'LDREAD',
      'LDREAD',
      'LMATRIX',
      'LNSRCH',
      'LSCLEAR',
      'LSDELE',
      'LSOPER',
      'LSREAD',
      'LSSOLVE',
      'LSWRITE',
      'LUMPM',
      'LVSCALE',
      'M',
      'MAGOPT',
      'MAGSOLV',
      'MAPSOLVE',
      'MASTER',
      'MDAMP',
      'MDELE',
      'MDPLOT',
      'MFANALYSIS',
      'MFBUCKET',
      'MFCALC',
      'MFCLEAR',
      'MFCMMAND',
      'MFCONV',
      'MFDTIME',
      'MFELEM',
      'MFEM',
      'MFEXTER',
      'MFFNAME',
      'MFIMPORT',
      'MFINTER',
      'MFITER',
      'MFLIST',
      'MFMAP',
      'MFORDER',
      'MFOUTPUT',
      'MFRELAX',
      'MFRSTART',
      'MFSURFACE',
      'MFTIME',
      'MFTOL',
      'MFVOLUME',
      'MGEN',
      'MLIST',
      'MODE',
      'MODOPT',
      'MONITOR',
      'MPCHG',
      'MSAVE',
      'MXPAND',
      'MXPAND',
      'NCNV',
      'NEQIT',
      'NLDIAG',
      'NLDPOST',
      'NLGEOM',
      'NLHIST',
      'NLOPT',
      'NRLSUM',
      'NROPT',
      'NSUBST',
      'NUMEXP',
      'OMEGA',
      'OPNCONTROL',
      'OUTOPT',
      'OUTPR',
      'OUTRES',
      'PCONV',
      'PEMOPTS',
      'PEXCLUDE',
      'PFACT',
      'PGRAPH',
      'PGSAVE',
      'PGWRITE',
      'PINCLUDE',
      'PLWAVE',
      'PMOPTS',
      'PPRANGE',
      'PRECISION',
      'PRED',
      'PSCONTROL',
      'PSDCOM',
      'PSDFRQ',
      'PSDGRAPH',
      'PSDSPL',
      'PSDUNIT',
      'PSDVAL',
      'PSDWAV',
      'PSOLVE',
      'PSTRES',
      'QDVAL',
      'QSOPT',
      'RADOPT',
      'RATE',
      'RDEC',
      'REMESH',
      'RESCONTROL',
      'REXPORT',
      'REZONE',
      'RIGID',
      'RIMPORT',
      'ROCK',
      'RSTOFF',
      'RSURF',
      'RSYMM',
      'SBCLIST',
      'SBCTRAN',
      'SED',
      'SEEXP',
      'SEGEN',
      'SEOPT',
      'SF',
      'SFA',
      'SFADELE',
      'SFALIST',
      'SFBEAM',
      'SFCUM',
      'SFDELE',
      'SFE',
      'SFEDELE',
      'SFELIST',
      'SFFUN',
      'SFGRAD',
      'SFL',
      'SFLDELE',
      'SFLIST',
      'SFLLIST',
      'SFSCALE',
      'SFTRAN',
      'SMBODY',
      'SMCONS',
      'SMFOR',
      'SMSURF',
      'SOLCONTROL',
      'SOLUOPT',
      'SOLVE',
      'SPCNOD',
      'SPCTEMP',
      'SPOPT',
      'SPSCAN',
      'SPSWP',
      'SPTOPT',
      'SRSS',
      'SSTIF',
      'STAOPT',
      'STEF',
      'SUBOPT',
      'SUBOPT',
      'SV',
      'SVTYP',
      'TIME',
      'TIMINT',
      'TINTP',
      'TOFFST',
      'TOTAL',
      'TREF',
      'TRNOPT',
      'TSRES',
      'TUNIF',
      'UPCOORD',
      'USRCAL',
      'V2DOPT',
      'VDDAM',
      'VFCALC',
      'VFOPT',
      'WRFULL',
      'WSPRINGS',
   );
   $self->listAdd('various_labels',
   );
   $self->contextdata({
      'Normal Text' => {
         callback => \&parseNormalText,
         attribute => 'Normal Text',
         lineending => '#pop',
      },
      'comment' => {
         callback => \&parsecomment,
         attribute => 'comment',
         lineending => '#pop',
      },
      'doublequotestring' => {
         callback => \&parsedoublequotestring,
         attribute => 'String',
      },
      'functions_arg' => {
         callback => \&parsefunctions_arg,
         attribute => 'NumFloat',
         lineending => '#pop',
      },
   });
   $self->deliminators('\\s||\\.|\\(|\\)|:|\\!|\\+|,|-|<|=|>|\\%|\\&|;|\\?|\\[|\\]|\\^|\\{|\\||\\}|\\~|\\\\|\\/|\\*');
   $self->basecontext('Normal Text');
   $self->keywordscase(0);
   $self->initialize;
   bless ($self, $class);
   return $self;
}

sub language {
   return 'Ansys';
}

sub parseNormalText {
   my ($self, $text) = @_;
   # String => 'C***'
   # attribute => 'comment'
   # context => 'comment'
   # firstNonSpace => 'true'
   # insensitive => 'true'
   # type => 'StringDetect'
   if ($self->testStringDetect($text, 'C***', 1, 0, 0, undef, 1, 'comment', 'comment')) {
      return 1
   }
   # attribute => 'comment'
   # char => '!'
   # context => 'comment'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '!', 0, 0, 0, undef, 0, 'comment', 'comment')) {
      return 1
   }
   # String => '^[A-Za-z0-9]+\='
   # attribute => 'Normal Text'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '^[A-Za-z0-9]+\\=', 0, 0, 0, undef, 0, '#stay', 'Normal Text')) {
      return 1
   }
   # String => 'elements'
   # attribute => 'Keyword'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'elements', 0, undef, 0, '#stay', 'Keyword')) {
      return 1
   }
   # String => 'material_properties'
   # attribute => 'MatProp'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'material_properties', 0, undef, 0, '#stay', 'MatProp')) {
      return 1
   }
   # String => 'force-displacement-labels'
   # attribute => 'Labels'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'force-displacement-labels', 0, undef, 0, '#stay', 'Labels')) {
      return 1
   }
   # String => 'parametric_functions'
   # attribute => 'Commands'
   # context => 'functions_arg'
   # type => 'keyword'
   if ($self->testKeyword($text, 'parametric_functions', 0, undef, 0, 'functions_arg', 'Commands')) {
      return 1
   }
   # String => 'session_cmds'
   # attribute => 'SESSIONcmd'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'session_cmds', 0, undef, 1, '#stay', 'SESSIONcmd')) {
      return 1
   }
   # String => 'database_cmds'
   # attribute => 'DBcmd'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'database_cmds', 0, undef, 1, '#stay', 'DBcmd')) {
      return 1
   }
   # String => 'graphic_cmds'
   # attribute => 'GRPH_cmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'graphic_cmds', 0, undef, 1, '#stay', 'GRPH_cmds')) {
      return 1
   }
   # String => 'APDL_commands'
   # attribute => 'APDLcmd'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'APDL_commands', 0, undef, 1, '#stay', 'APDLcmd')) {
      return 1
   }
   # String => 'prep7_commands'
   # attribute => 'PREP7Commands'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'prep7_commands', 0, undef, 1, '#stay', 'PREP7Commands')) {
      return 1
   }
   # String => 'solution_commands'
   # attribute => 'SOLUCommands'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'solution_commands', 0, undef, 1, '#stay', 'SOLUCommands')) {
      return 1
   }
   # String => 'POST1_commands'
   # attribute => 'POST1Commands'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'POST1_commands', 0, undef, 1, '#stay', 'POST1Commands')) {
      return 1
   }
   # String => 'POST26_cmds'
   # attribute => 'POST26Commands'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'POST26_cmds', 0, undef, 1, '#stay', 'POST26Commands')) {
      return 1
   }
   # String => 'aux2_cmds'
   # attribute => 'AUX2cmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'aux2_cmds', 0, undef, 1, '#stay', 'AUX2cmds')) {
      return 1
   }
   # String => 'aux3_cmds'
   # attribute => 'AUX3cmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'aux3_cmds', 0, undef, 1, '#stay', 'AUX3cmds')) {
      return 1
   }
   # String => 'aux12_cmds'
   # attribute => 'AUX12cmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'aux12_cmds', 0, undef, 1, '#stay', 'AUX12cmds')) {
      return 1
   }
   # String => 'aux15_cmds'
   # attribute => 'AUX15cmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'aux15_cmds', 0, undef, 1, '#stay', 'AUX15cmds')) {
      return 1
   }
   # String => 'runstats_cmds'
   # attribute => 'RUNSTATScmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'runstats_cmds', 0, undef, 1, '#stay', 'RUNSTATScmds')) {
      return 1
   }
   # String => 'optimization_cmds'
   # attribute => 'OPTIMIZATIONcmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'optimization_cmds', 0, undef, 1, '#stay', 'OPTIMIZATIONcmds')) {
      return 1
   }
   # String => 'probabilistic_cmds'
   # attribute => 'PROBcmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'probabilistic_cmds', 0, undef, 1, '#stay', 'PROBcmds')) {
      return 1
   }
   # String => 'display_cmds'
   # attribute => 'DISPLAYcmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'display_cmds', 0, undef, 1, '#stay', 'DISPLAYcmds')) {
      return 1
   }
   # String => 'reduced_order_cmds'
   # attribute => 'REDUORDERcmds'
   # context => '#stay'
   # firstNonSpace => 'true'
   # type => 'keyword'
   if ($self->testKeyword($text, 'reduced_order_cmds', 0, undef, 1, '#stay', 'REDUORDERcmds')) {
      return 1
   }
   # attribute => 'String'
   # char => '"'
   # context => 'doublequotestring'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '"', 0, 0, 0, undef, 0, 'doublequotestring', 'String')) {
      return 1
   }
   # attribute => 'variable'
   # char => '%'
   # char1 => '%'
   # context => '#stay'
   # type => 'RangeDetect'
   if ($self->testRangeDetect($text, '%', '%', 0, 0, undef, 0, '#stay', 'variable')) {
      return 1
   }
   # String => 'APDL_commands'
   # attribute => 'MatProp'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'APDL_commands', 0, undef, 0, '#stay', 'MatProp')) {
      return 1
   }
   # attribute => 'NumFloat'
   # context => '#stay'
   # type => 'Float'
   if ($self->testFloat($text, 0, undef, 0, '#stay', 'NumFloat')) {
      return 1
   }
   # attribute => 'NumInt'
   # context => '#stay'
   # items => 'ARRAY(0xef0140)'
   # type => 'Int'
   if ($self->testInt($text, 0, undef, 0, '#stay', 'NumInt')) {
      # String => '**'
      # attribute => 'NumInt'
      # context => '#stay'
      # type => 'StringDetect'
      if ($self->testStringDetect($text, '**', 0, 0, 0, undef, 0, '#stay', 'NumInt')) {
         return 1
      }
   }
   return 0;
};

sub parsecomment {
   my ($self, $text) = @_;
   return 0;
};

sub parsedoublequotestring {
   my ($self, $text) = @_;
   # attribute => 'String'
   # char => '"'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '"', 0, 0, 0, undef, 0, '#pop', 'String')) {
      return 1
   }
   return 0;
};

sub parsefunctions_arg {
   my ($self, $text) = @_;
   # attribute => 'Keyword'
   # char => '('
   # context => '#stay'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '(', 0, 0, 0, undef, 0, '#stay', 'Keyword')) {
      return 1
   }
   # attribute => 'Keyword'
   # char => ')'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ')', 0, 0, 0, undef, 0, '#pop', 'Keyword')) {
      return 1
   }
   return 0;
};


1;

__END__

=head1 NAME

Syntax::Highlight::Engine::Kate::Ansys - a Plugin for Ansys syntax highlighting

=head1 SYNOPSIS

 require Syntax::Highlight::Engine::Kate::Ansys;
 my $sh = new Syntax::Highlight::Engine::Kate::Ansys([
 ]);

=head1 DESCRIPTION

Syntax::Highlight::Engine::Kate::Ansys is a  plugin module that provides syntax highlighting
for Ansys to the Syntax::Haghlight::Engine::Kate highlighting engine.

This code is generated from the syntax definition files used
by the Kate project.
It works quite fine, but can use refinement and optimization.

It inherits Syntax::Higlight::Engine::Kate::Template. See also there.

=head1 AUTHOR

Hans Jeuken (haje <at> toneel <dot> demon <dot> nl)

=head1 BUGS

Unknown. If you find any, please contact the author