# Generated by default/object.tt
package Paws::IoTSiteWise::AssetModelStatus;
  use Moose;
  has Error => (is => 'ro', isa => 'Paws::IoTSiteWise::ErrorDetails', request_name => 'error', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::AssetModelStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::AssetModelStatus object:

  $service_obj->Method(Att1 => { Error => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::AssetModelStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->Error

=head1 DESCRIPTION

Contains current status information for an asset model. For more
information, see Asset and model states
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
in the I<AWS IoT SiteWise User Guide>.

=head1 ATTRIBUTES


=head2 Error => L<Paws::IoTSiteWise::ErrorDetails>

Contains associated error information, if any.


=head2 B<REQUIRED> State => Str

The current state of the asset model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

