#! /usr/bin/env false

use v6.d;

use Matrix::Client;

#| A wrapper to make handling text messages sent to a room easier for
#| end-users.
unit class Matrix::Bot::EventWrapper::RoomTextMessage;

#| The timestamp of the message, as given by the origin server.
has DateTime $.time is required;

#| The user ID that sent the message.
has Str $.user is required;

#| The room ID in which the message was sent
has Str $.room is required;

#| The text body of the message that was sent.
has Str $.message is required;

#| The full event details.
has $.event is required;

#| The client object to fancy stuff with.
has Matrix::Client $.client is required;

=begin pod

=NAME    Matrix::Bot::EventWrapper::RoomTextMessage
=AUTHOR  Patrick Spek <p.spek@tyil.work>
=VERSION 0.1.0

=head1 Synopsis

=head1 Description

=head1 Examples

=head1 See also

=end pod

# vim: ft=perl6 noet
