NAME
====

Log

VERSION
=======

0.1.1

AUTHOR
======

Patrick Spek <p.spek@tyil.nl>

Description
===========

The `Log` module provides a role which *should* be implemented by a logging system. It presents a standardized interface for use around the Raku ecosystem. This would allow module developers to add logging statements throughout their libraries, and these logs being in the same format as the application using the libraries.

Usage
=====

Usage of the `Log` module goes through implementations of it, such as `Log::Simple`, `Log::Colored`, or `Log::JSON`. The `Log` role itself only helps in ensuring the interfaces are the same, allowing easy replacement of the implementation if ever needed in the future.

Whatever imlementation of `Log` you use, it `must` be set in the `$*LOG` dynamic variable. This makes it available to all the libraries that are used in the program. You `should` set it as early as possible.

Because it must be using the `$*LOG` variable, module developers around the ecosystem can rely on it for their logging needs. However, not every application will implement this, and that needs to be accounted for, too. For this, make use of Raku's `with` flow control statement.

```raku
.notice('This is a log message') with $*LOG;
```

This can be used freely and safely, throughout all modules. Any application using that module and implementing `Log` will immediately be able to reap the benefits.

Implementing a Log class
------------------------

```raku
use Log;

unit class Log::Custom is Log;

# Implement all required methods
```

### Methods

There are 8 log levels, each with two method calls to invoke them. All of these *must* be implemented.

  * `multi method emergency (Str:D $) { * }`

  * `multi method emergency (Str:D $, *@) { * }`

  * `multi method alert (Str:D $) { * }`

  * `multi method alert (Str:D $, *@) { * }`

  * `multi method critical (Str:D $) { * }`

  * `multi method critical (Str:D $, *@) { * }`

  * `multi method error (Str:D $) { * }`

  * `multi method error (Str:D $, *@) { * }`

  * `multi method warning (Str:D $) { * }`

  * `multi method warning (Str:D $, *@) { * }`

  * `multi method notice (Str:D $) { * }`

  * `multi method info (Str:D $) { * }`

  * `multi method info (Str:D $, *@) { * }`

  * `multi method notice (Str:D $, *@) { * }`

  * `multi method debug (Str:D $0 { * }`

  * `multi method debug (Str:D $, *@) { * }`

Additionally, the following configuration method *must* be implemented.

  * `multi method add-output (IO::Handle:D $, Int() $ where Log::Level::Emergency ≤ * ≤ Log::Level::Debug, Callable $?) { * }`

Environment variables
---------------------

This logging standard defines two environment variables to respect.

Pod::Defn<94181713032224>

Pod::Defn<94181713537640>

LICENSE
=======

Copyright © 2020

This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, version 3.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this program. If not, see http://www.gnu.org/licenses/.

