#! /usr/bin/env perl6

use v6.d;

use Grammar::TodoTxt;
use Test;

my $input = q:to/EOF/;
2011-03-02 Document +TodoTxt task format
(A) 2011-03-02 Call Mom
(A) Call Mom 2011-03-02
EOF

plan $input.lines.elems;

my $todo = Grammar::TodoTxt.parse($input);

subtest 'Line 1', {
	plan 2;

	my $creation-date = $todo<records>[0]<creation>;

	ok $creation-date, 'There is a creation date';
	is $creation-date, '2011-03-02', 'Creation date is correct';
}

subtest 'Line 2', {
	plan 2;

	my $creation-date = $todo<records>[1]<creation>;

	ok $creation-date, 'There is a creation date';
	is $creation-date, '2011-03-02', 'Creation date is correct';
}

subtest 'Line 3', {
	plan 1;

	nok $todo<records>[2]<creation>, 'There is no creation date';
}



# vim: ft=perl6 noet
