use GPT::Class;
use GPT::DumbGenerator;

module GPT::FileGenerator {
  our %conf;
  my @files;
  my @user-excludes;

  sub read-gpt-file($filepath) is export {
    use MONKEY-SEE-NO-EVAL;
    %conf = EVAL($filepath.IO.slurp);
  }

  sub generate-module($att) is export {
    dg-init($att);
    @files := %conf<files> if %conf<files>:exists;
    @user-excludes := %conf<exclude-files> if %conf<exclude-files>:exists;
    my @exclude-structs;
    @exclude-structs := %conf<exclude-structs> if %conf<exclude-structs>:exists;
    my @exclude-functions;
    @exclude-functions := %conf<exclude-functions> if %conf<exclude-functions>:exists;
    my @exclude-enums;
    @exclude-enums := %conf<exclude-enums> if %conf<exclude-enums>:exists;
    my $file = %conf<module-name>.subst('::', '-') ~ '.pm6';
    note "Generating $file";
    my $fh = open $file, :w;
    
    $fh.say: '## This file was generated by the Great and Powerful Trixie';
    $fh.say: "use NativeCall;";
    $fh.say: "unit module %conf<module-name>;";
    $fh.say: 'sub GenMyLibName {';
    $fh.say: '  use NativeCall :TEST;';
    $fh.say: '  %*ENV<' ~ %conf<env-name> 
    ~ '> || guess_library_name(("' 
    ~ %conf<clib-name> ~  '", ' 
    ~ %conf<clib-abiversion>.perl ~ '))}';
    $fh.say: 'constant LIB = &GenMyLibName;';
    my %h = dg-generate-enums();
    $fh.say: '## Enumerations';
    my %sortedh = sort-by-file(%h.values);
    for %sortedh.kv -> $k, @v {
      $fh.say: "\n# == {$att.files{$k}} ==\n";
      for @v -> $ob {
        next if $ob<obj>.name (<=) @exclude-enums;
        $fh.say: $ob<p6str>;
      }
    }

    %h = dg-generate-structs();
    $fh.say: "";
    $fh.say: '## Structures' ~ "\n";
    %sortedh = sort-by-file(%h.values);
    for %sortedh.kv -> $k, @v {
      $fh.say: "\n# == {$att.files{$k}} ==\n";
      for @v.kv -> $i, $ob {
        if $ob<obj> ~~ Struct {
          if @v[$i + 1].defined and @v[$i + 1]<obj> ~~ AnonymousUnion and @v[$i + 1]<obj>.struct.defined {
            $fh.say: @v[$i + 1]<p6str>;
          }
        }
        if !($ob<obj> ~~ AnonymousUnion and $ob<obj>.struct.defined) {
          $fh.say: $ob<p6str>;
        }
      }
    }
    $fh.say: "";
    $fh.say: '## Extras stuff' ~ "\n";
    dg-generate-extra();
    %h = dg-generate-functions();
    $fh.say: '## Functions' ~ "\n";
    %sortedh = sort-by-file(%h.values);
    for %sortedh.kv -> $k, @v {
      $fh.say: "\n# == {$att.files{$k}} ==\n";
      for @v -> $ob {
        $fh.say: $ob<p6str>;
      }
    }
    $fh.say: "";
    $fh.say: '## Externs' ~ "\n";
    %h = dg-generate-externs();
    %sortedh = sort-by-file(%h.values);
    for %sortedh.kv -> $k, @v {
      $fh.say: "\n# == {$att.files{$k}} ==\n";
      for @v -> $ob {
        $fh.say: $ob<p6str>;
      }
    }
  
  sub files-filter($file-id, $file) returns Bool {
    my $basename = $file.IO.basename;
    
    #Autoexclude stuff
    return False if $basename ~~ /^std/;
    return False if $basename ~~ /^pthread/;
    return False if $basename eq 'libio.h';
    return False if $basename eq 'string.h';
    return False if $basename eq 'errno.h';
    return False if $file ~~ /'/usr/include/'.+?'-linux-gnu/bits/'/;
    return False if $file ~~ /'/usr/include/'.+?'-linux-gnu/sys/'/;
    
    if @files !== Empty {
      if $basename (<=) @files || ('@' ~ $file-id) (<=)  @files {
        return True;
      }
      return False;
    }
    if @user-excludes !== Empty {
      if $basename (<=) @user-excludes || ('@' ~ $file-id) (<=)  @user-excludes {
        return False;
      }
      return True;
    }
    return True;
  }
  
  sub sort-by-file(@array) {
    my %toret;
    for @array -> %s {
      %toret{%s<obj>.file-id}.push(%s) if files-filter(%s<obj>.file-id, $att.files{%s<obj>.file-id});
    }
    for %toret.keys -> $k {
      @(%toret{$k}).=sort: {$^a<obj>.start-line > $^b<obj>.start-line};
    }
    return %toret;
  }
    
  } 
}