#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 1;
use Test::MockModule;

use Git::Wrapper::More;

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'rev_parse',
    sub {
        my $self = shift;
        return 'dummy_git_repo_directory';
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my $ret = $gwm->toplevel();
like( $ret, qr/^dummy_git_repo_directory$/, 'toplevel returns a repo directory' );

exit

__END__
