=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsPicturesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_pictures_delete_worksheet_picture
#
# Delete a picture object in worksheet
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param int $picture_index Picture index (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'picture_index' => {
        data_type => 'int',
        description => 'Picture index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_delete_worksheet_picture' } = { 
    	summary => 'Delete a picture object in worksheet',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pictures_delete_worksheet_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_delete_worksheet_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_delete_worksheet_picture");
    }

    # verify the required parameter 'picture_index' is set
    unless (exists $args{'picture_index'}) {
      croak("Missing the required parameter 'picture_index' when calling cells_pictures_delete_worksheet_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'picture_index'}) {
        my $_base_variable = "{" . "pictureIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'picture_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pictures_delete_worksheet_pictures
#
# Delete all pictures in worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_delete_worksheet_pictures' } = { 
    	summary => 'Delete all pictures in worksheet.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pictures_delete_worksheet_pictures {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_delete_worksheet_pictures");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_delete_worksheet_pictures");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pictures_get_worksheet_picture
#
# GRead worksheet picture by number.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $picture_index The picture index. (required)
# @param string $format The exported object format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'picture_index' => {
        data_type => 'int',
        description => 'The picture index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported object format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_get_worksheet_picture' } = { 
    	summary => 'GRead worksheet picture by number.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_pictures_get_worksheet_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_get_worksheet_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_get_worksheet_picture");
    }

    # verify the required parameter 'picture_index' is set
    unless (exists $args{'picture_index'}) {
      croak("Missing the required parameter 'picture_index' when calling cells_pictures_get_worksheet_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'picture_index'}) {
        my $_base_variable = "{" . "pictureIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'picture_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_pictures_get_worksheet_pictures
#
# Read worksheet pictures.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_get_worksheet_pictures' } = { 
    	summary => 'Read worksheet pictures.',
        params => $params,
        returns => 'PicturesResponse',
        };
}
# @return PicturesResponse
#
sub cells_pictures_get_worksheet_pictures {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_get_worksheet_pictures");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_get_worksheet_pictures");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PicturesResponse', $response);
    return $_response_object;
}

#
# cells_pictures_post_worksheet_picture
#
# Update worksheet picture by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $picture_index The picture&#39;s index. (required)
# @param Picture $picture Picture object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'picture_index' => {
        data_type => 'int',
        description => 'The picture&#39;s index.',
        required => '1',
    },
    'picture' => {
        data_type => 'Picture',
        description => 'Picture object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_post_worksheet_picture' } = { 
    	summary => 'Update worksheet picture by index.',
        params => $params,
        returns => 'PictureResponse',
        };
}
# @return PictureResponse
#
sub cells_pictures_post_worksheet_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_post_worksheet_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_post_worksheet_picture");
    }

    # verify the required parameter 'picture_index' is set
    unless (exists $args{'picture_index'}) {
      croak("Missing the required parameter 'picture_index' when calling cells_pictures_post_worksheet_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'picture_index'}) {
        my $_base_variable = "{" . "pictureIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'picture_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'picture'}) {
        $_body_data = $args{'picture'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PictureResponse', $response);
    return $_response_object;
}

#
# cells_pictures_put_worksheet_add_picture
#
# Add a new worksheet picture.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param Picture $picture Pictute object (optional)
# @param int $upper_left_row The image upper left row. (optional, default to 0)
# @param int $upper_left_column The image upper left column. (optional, default to 0)
# @param int $lower_right_row The image low right row. (optional, default to 0)
# @param int $lower_right_column The image low right column. (optional, default to 0)
# @param string $picture_path The picture path, if not provided the picture data is inspected in the request body. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'picture' => {
        data_type => 'Picture',
        description => 'Pictute object',
        required => '0',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'The image upper left row.',
        required => '0',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'The image upper left column.',
        required => '0',
    },
    'lower_right_row' => {
        data_type => 'int',
        description => 'The image low right row.',
        required => '0',
    },
    'lower_right_column' => {
        data_type => 'int',
        description => 'The image low right column.',
        required => '0',
    },
    'picture_path' => {
        data_type => 'string',
        description => 'The picture path, if not provided the picture data is inspected in the request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_put_worksheet_add_picture' } = { 
    	summary => 'Add a new worksheet picture.',
        params => $params,
        returns => 'PicturesResponse',
        };
}
# @return PicturesResponse
#
sub cells_pictures_put_worksheet_add_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_put_worksheet_add_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_put_worksheet_add_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'lower_right_row'}) {
        $query_params->{'lowerRightRow'} = $self->{api_client}->to_query_value($args{'lower_right_row'});
    }

    # query params
    if ( exists $args{'lower_right_column'}) {
        $query_params->{'lowerRightColumn'} = $self->{api_client}->to_query_value($args{'lower_right_column'});
    }

    # query params
    if ( exists $args{'picture_path'}) {
        $query_params->{'picturePath'} = $self->{api_client}->to_query_value($args{'picture_path'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'picture'}) {
        $_body_data = $args{'picture'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PicturesResponse', $response);
    return $_response_object;
}

1;
