=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsOleObjectsApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_ole_objects_delete_worksheet_ole_object
#
# Delete OLE object.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param int $ole_object_index Ole object index (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'ole_object_index' => {
        data_type => 'int',
        description => 'Ole object index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_delete_worksheet_ole_object' } = { 
    	summary => 'Delete OLE object.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ole_objects_delete_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_delete_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_delete_worksheet_ole_object");
    }

    # verify the required parameter 'ole_object_index' is set
    unless (exists $args{'ole_object_index'}) {
      croak("Missing the required parameter 'ole_object_index' when calling cells_ole_objects_delete_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'ole_object_index'}) {
        my $_base_variable = "{" . "oleObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'ole_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_delete_worksheet_ole_objects
#
# Delete all OLE objects.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_delete_worksheet_ole_objects' } = { 
    	summary => 'Delete all OLE objects.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ole_objects_delete_worksheet_ole_objects {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_delete_worksheet_ole_objects");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_delete_worksheet_ole_objects");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_get_worksheet_ole_object
#
# Get OLE object info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $object_number The object number. (required)
# @param string $format The exported object format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'object_number' => {
        data_type => 'int',
        description => 'The object number.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported object format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_get_worksheet_ole_object' } = { 
    	summary => 'Get OLE object info.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_ole_objects_get_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_get_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_get_worksheet_ole_object");
    }

    # verify the required parameter 'object_number' is set
    unless (exists $args{'object_number'}) {
      croak("Missing the required parameter 'object_number' when calling cells_ole_objects_get_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects/{objectNumber}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'object_number'}) {
        my $_base_variable = "{" . "objectNumber" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'object_number'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_ole_objects_get_worksheet_ole_objects
#
# Get worksheet OLE objects info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_get_worksheet_ole_objects' } = { 
    	summary => 'Get worksheet OLE objects info.',
        params => $params,
        returns => 'OleObjectsResponse',
        };
}
# @return OleObjectsResponse
#
sub cells_ole_objects_get_worksheet_ole_objects {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_get_worksheet_ole_objects");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_get_worksheet_ole_objects");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OleObjectsResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_post_update_worksheet_ole_object
#
# Update OLE object.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param int $ole_object_index Ole object index (required)
# @param OleObject $ole Ole Object (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'ole_object_index' => {
        data_type => 'int',
        description => 'Ole object index',
        required => '1',
    },
    'ole' => {
        data_type => 'OleObject',
        description => 'Ole Object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_post_update_worksheet_ole_object' } = { 
    	summary => 'Update OLE object.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ole_objects_post_update_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_post_update_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_post_update_worksheet_ole_object");
    }

    # verify the required parameter 'ole_object_index' is set
    unless (exists $args{'ole_object_index'}) {
      croak("Missing the required parameter 'ole_object_index' when calling cells_ole_objects_post_update_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'ole_object_index'}) {
        my $_base_variable = "{" . "oleObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'ole_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'ole'}) {
        $_body_data = $args{'ole'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_put_worksheet_ole_object
#
# Add OLE object
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param OleObject $ole_object Ole Object (optional)
# @param int $upper_left_row Upper left row index (optional, default to 0)
# @param int $upper_left_column Upper left column index (optional, default to 0)
# @param int $height Height of oleObject, in unit of pixel (optional, default to 0)
# @param int $width Width of oleObject, in unit of pixel (optional, default to 0)
# @param string $ole_file OLE filename (optional)
# @param string $image_file Image filename (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'ole_object' => {
        data_type => 'OleObject',
        description => 'Ole Object',
        required => '0',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'Upper left row index',
        required => '0',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'Upper left column index',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Height of oleObject, in unit of pixel',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'Width of oleObject, in unit of pixel',
        required => '0',
    },
    'ole_file' => {
        data_type => 'string',
        description => 'OLE filename',
        required => '0',
    },
    'image_file' => {
        data_type => 'string',
        description => 'Image filename',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_put_worksheet_ole_object' } = { 
    	summary => 'Add OLE object',
        params => $params,
        returns => 'OleObjectResponse',
        };
}
# @return OleObjectResponse
#
sub cells_ole_objects_put_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_put_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_put_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'ole_file'}) {
        $query_params->{'oleFile'} = $self->{api_client}->to_query_value($args{'ole_file'});
    }

    # query params
    if ( exists $args{'image_file'}) {
        $query_params->{'imageFile'} = $self->{api_client}->to_query_value($args{'image_file'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'ole_object'}) {
        $_body_data = $args{'ole_object'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OleObjectResponse', $response);
    return $_response_object;
}

1;
