/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.VideoSize;
import com.sun.media.util.JMFI18N;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

class VideoSizeControl
extends Panel
implements ItemListener,
ComponentListener {
    private Choice comboSize;
    private Panel panelCustom;
    private TextField textWidth;
    private TextField textHeight;
    private Label labelX;
    private Hashtable htSizes = new Hashtable();
    private VideoSize sizeVideoDefault = null;
    private ActionListener listener;
    public static final String ACTION_SIZE_CHANGED = "Size Changed";
    static final String CUSTOM_STRING = JMFI18N.getResource("formatchooser.custom");

    public VideoSizeControl() {
        this((VideoSize)null);
    }

    public VideoSizeControl(VideoSize sizeVideoDefault) {
        this.sizeVideoDefault = sizeVideoDefault;
        this.init();
    }

    public void setEnabled(boolean boolEnable) {
        super.setEnabled(boolEnable);
        this.comboSize.setEnabled(boolEnable);
        this.textWidth.setEnabled(boolEnable);
        this.textHeight.setEnabled(boolEnable);
        this.labelX.setEnabled(boolEnable);
        if (boolEnable) {
            this.updateFields();
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public VideoSize getVideoSize() {
        VideoSize sizeVideo;
        String strItem = this.comboSize.getSelectedItem();
        Object objSize = this.htSizes.get(strItem);
        if (objSize == null || !(objSize instanceof VideoSize) || strItem.equals(CUSTOM_STRING)) {
            int nHeight;
            int nWidth;
            try {
                nWidth = Integer.valueOf(this.textWidth.getText());
            }
            catch (Exception exception) {
                nWidth = 0;
            }
            try {
                nHeight = Integer.valueOf(this.textHeight.getText());
            }
            catch (Exception exception) {
                nHeight = 0;
            }
            sizeVideo = new VideoSize(nWidth, nHeight);
        } else {
            sizeVideo = (VideoSize)objSize;
        }
        return sizeVideo;
    }

    public void addItem(VideoSize sizeVideo) {
        String strItem;
        if (sizeVideo == null) {
            sizeVideo = new VideoSize(-1, -1);
            strItem = CUSTOM_STRING;
        } else {
            strItem = sizeVideo.toString();
        }
        if (this.htSizes.containsKey(strItem)) {
            return;
        }
        this.comboSize.addItem(strItem);
        this.htSizes.put(strItem, sizeVideo);
        if (this.comboSize.getItemCount() == 1) {
            this.updateFields();
        }
    }

    public void removeAll() {
        this.comboSize.removeAll();
        this.htSizes = new Hashtable();
        this.updateFields();
    }

    public void select(VideoSize sizeVideo) {
        if (sizeVideo == null) {
            this.comboSize.select(CUSTOM_STRING);
        } else {
            this.comboSize.select(sizeVideo.toString());
        }
        this.updateFields();
    }

    public void select(int nIndex) {
        this.comboSize.select(nIndex);
        this.updateFields();
    }

    public int getItemCount() {
        return this.comboSize.getItemCount();
    }

    private void init() {
        this.setLayout(new GridLayout(0, 1, 4, 4));
        this.comboSize = new Choice();
        this.comboSize.addItem(CUSTOM_STRING);
        this.comboSize.addItemListener(this);
        this.add(this.comboSize);
        this.panelCustom = new Panel(null);
        this.panelCustom.addComponentListener(this);
        this.add(this.panelCustom);
        this.textWidth = this.sizeVideoDefault == null ? new TextField(3) : new TextField("" + this.sizeVideoDefault.width, 3);
        this.panelCustom.add((Component)this.textWidth, "Center");
        this.labelX = new Label("x", 1);
        this.panelCustom.add((Component)this.labelX, "West");
        this.textHeight = this.sizeVideoDefault == null ? new TextField(3) : new TextField("" + this.sizeVideoDefault.height, 3);
        this.panelCustom.add((Component)this.textHeight, "Center");
        this.updateFields();
    }

    private void updateFields() {
        boolean boolEnable;
        String strItem = this.comboSize.getSelectedItem();
        if (strItem == null || strItem.equals(CUSTOM_STRING)) {
            boolEnable = true;
        } else {
            VideoSize sizeVideo = (VideoSize)this.htSizes.get(strItem);
            this.textWidth.setText("" + sizeVideo.width);
            this.textHeight.setText("" + sizeVideo.height);
            boolEnable = false;
        }
        this.textWidth.setEnabled(boolEnable);
        this.textHeight.setEnabled(boolEnable);
        this.labelX.setEnabled(boolEnable);
    }

    private void resizeCustomFields() {
        Dimension dimPanel = this.panelCustom.getSize();
        Dimension dimLabelX = this.labelX.getPreferredSize();
        int nWidth = (dimPanel.width - dimLabelX.width) / 2;
        this.textWidth.setBounds(0, 0, nWidth, dimPanel.height);
        this.labelX.setBounds(nWidth, 0, dimLabelX.width, dimPanel.height);
        this.textHeight.setBounds(nWidth + dimLabelX.width, 0, nWidth, dimPanel.height);
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource != this.comboSize) {
            return;
        }
        this.updateFields();
        if (this.listener != null) {
            ActionEvent eventAction = new ActionEvent(this, 1001, ACTION_SIZE_CHANGED);
            this.listener.actionPerformed(eventAction);
        }
    }

    public void componentResized(ComponentEvent event) {
        this.resizeCustomFields();
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }
}

