/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class LevelResolver
implements EventResolver {
    private static final String[] SEVERITY_CODE_RESOLUTION_BY_STANDARD_LEVEL_ORDINAL;
    private static final EventResolver SEVERITY_CODE_RESOLVER;
    private final EventResolver internalResolver;

    LevelResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.internalResolver = LevelResolver.createResolver(context, config);
    }

    private static EventResolver createResolver(EventResolverContext context, TemplateResolverConfig config) {
        JsonWriter jsonWriter = context.getJsonWriter();
        String fieldName = config.getString("field");
        if ("name".equals(fieldName)) {
            return LevelResolver.createNameResolver(jsonWriter);
        }
        if ("severity".equals(fieldName)) {
            String severityFieldName = config.getString(new String[]{"severity", "field"});
            if ("keyword".equals(severityFieldName)) {
                return LevelResolver.createSeverityKeywordResolver(jsonWriter);
            }
            if ("code".equals(severityFieldName)) {
                return SEVERITY_CODE_RESOLVER;
            }
            throw new IllegalArgumentException("unknown severity field: " + config);
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    private static EventResolver createNameResolver(JsonWriter contextJsonWriter) {
        Map resolutionByLevel = Arrays.stream(Level.values()).collect(Collectors.toMap(Function.identity(), level -> contextJsonWriter.use(() -> {
            String name = level.name();
            contextJsonWriter.writeString(name);
        })));
        return (logEvent, jsonWriter) -> {
            Level level = logEvent.getLevel();
            String resolution = (String)resolutionByLevel.get(level);
            if (resolution != null) {
                jsonWriter.writeRawString(resolution);
            } else {
                String levelName = level.name();
                jsonWriter.writeString(levelName);
            }
        };
    }

    private static EventResolver createSeverityKeywordResolver(JsonWriter contextJsonWriter) {
        Map resolutionByLevel = Arrays.stream(Level.values()).collect(Collectors.toMap(Function.identity(), level -> contextJsonWriter.use(() -> {
            String severityKeyword = Severity.getSeverity((Level)level).name();
            contextJsonWriter.writeString(severityKeyword);
        })));
        return (logEvent, jsonWriter) -> {
            String resolution = (String)resolutionByLevel.get(logEvent.getLevel());
            jsonWriter.writeRawString(resolution);
        };
    }

    static String getName() {
        return "level";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    static {
        int levelCount = Level.values().length;
        String[] severityCodeResolutionByStandardLevelOrdinal = new String[levelCount + 1];
        for (Level level : Level.values()) {
            int standardLevelOrdinal = level.getStandardLevel().ordinal();
            int severityCode = Severity.getSeverity((Level)level).getCode();
            severityCodeResolutionByStandardLevelOrdinal[standardLevelOrdinal] = String.valueOf(severityCode);
        }
        SEVERITY_CODE_RESOLUTION_BY_STANDARD_LEVEL_ORDINAL = severityCodeResolutionByStandardLevelOrdinal;
        SEVERITY_CODE_RESOLVER = (logEvent, jsonWriter) -> {
            int standardLevelOrdinal = logEvent.getLevel().getStandardLevel().ordinal();
            String severityCodeResolution = SEVERITY_CODE_RESOLUTION_BY_STANDARD_LEVEL_ORDINAL[standardLevelOrdinal];
            jsonWriter.writeRawString(severityCodeResolution);
        };
    }
}

