/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;

public class CoordinateSharer<T> {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateSharer.class);
    boolean runtimeUnion;
    List<Coordinate> unionCoords = new ArrayList<Coordinate>();
    Coordinate runtimeAll;
    CoordinateBuilder runtimeAllBuilder = new CoordinateRuntime.Builder2(null);
    Set<Coordinate> runtimeBuilders = new HashSet<Coordinate>();
    Set<Coordinate> timeBuilders = new HashSet<Coordinate>();
    Set<Coordinate> timeIntvBuilders = new HashSet<Coordinate>();
    Set<Coordinate> vertBuilders = new HashSet<Coordinate>();
    Set<Coordinate> ensBuilders = new HashSet<Coordinate>();
    Set<Coordinate> time2DBuilders = new HashSet<Coordinate>();
    Map<Coordinate, Integer> coordMap;

    public CoordinateSharer(boolean runtimeUnion) {
        this.runtimeUnion = runtimeUnion;
    }

    public void addCoords(List<Coordinate> coords) {
        Coordinate runtime = null;
        for (Coordinate coord : coords) {
            switch (coord.getType()) {
                case runtime: {
                    if (this.runtimeUnion) {
                        this.runtimeAllBuilder.addAll(coord);
                    } else {
                        this.runtimeBuilders.add(coord);
                    }
                    runtime = coord;
                    break;
                }
                case time: {
                    this.timeBuilders.add(coord);
                    break;
                }
                case timeIntv: {
                    this.timeIntvBuilders.add(coord);
                    break;
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    this.time2DBuilders.add(coord);
                    CoordinateRuntime runtimeFrom2D = time2D.getRuntimeCoordinate();
                    if (runtimeFrom2D.equals(runtime)) break;
                    System.out.println("CoordinateSharer runtimes differ");
                    break;
                }
                case vert: {
                    this.vertBuilders.add(coord);
                    break;
                }
                case ens: {
                    this.ensBuilders.add(coord);
                }
            }
        }
    }

    public void finish() {
        if (this.runtimeUnion) {
            this.runtimeAll = this.runtimeAllBuilder.finish();
            this.unionCoords.add(this.runtimeAll);
        }
        for (Coordinate coord : this.runtimeBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.time2DBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.timeBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.timeIntvBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.vertBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.ensBuilders) {
            this.unionCoords.add(coord);
        }
        this.coordMap = new HashMap<Coordinate, Integer>();
        for (int i = 0; i < this.unionCoords.size(); ++i) {
            this.coordMap.put(this.unionCoords.get(i), i);
        }
    }

    public List<Coordinate> getUnionCoords() {
        return this.unionCoords;
    }

    public List<Integer> reindex2shared(List<Coordinate> prev) {
        CoordinateTime2D time2D;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Coordinate coord : prev) {
            Integer idx = this.coordMap.get(coord);
            if (idx == null) {
                if (coord.getType() == Coordinate.Type.runtime && this.runtimeUnion) {
                    result.add(0);
                    continue;
                }
                logger.error("CoordinateSharer can find coordinate {}", (Object)coord);
                continue;
            }
            result.add(idx);
        }
        for (Coordinate coord : prev) {
            switch (coord.getType()) {
                case time2D: {
                    CoordinateTime2D time2Dprev = (CoordinateTime2D)coord;
                    Integer idx = this.coordMap.get(coord);
                    time2D = (CoordinateTime2D)this.unionCoords.get(idx);
                    int ntimePrev = time2Dprev.getNtimes();
                    int ntimes = time2D.getNtimes();
                    if (ntimes == ntimePrev) break;
                    System.out.printf("HEY CoordinateSharer.reindex2shared: ntimes %d != orgNtimes %d%n", ntimes, ntimePrev);
                }
            }
        }
        Coordinate runtime = null;
        for (Integer idx : result) {
            Coordinate coord = this.unionCoords.get(idx);
            switch (coord.getType()) {
                case runtime: {
                    runtime = coord;
                    break;
                }
                case time2D: {
                    time2D = (CoordinateTime2D)coord;
                    CoordinateRuntime runtimeFrom2D = time2D.getRuntimeCoordinate();
                    if (runtimeFrom2D.equals(runtime)) break;
                    System.out.printf("HEY CoordinateSharer.reindex2shared: runtimeFrom2D %s != runtime %s%n", runtimeFrom2D, runtime);
                }
            }
        }
        return result;
    }

    public CoordinateND<T> reindex(CoordinateND<T> prev) {
        boolean needReindex = false;
        for (Coordinate coord : prev.getCoordinates()) {
            if (!this.runtimeUnion || coord.getType() != Coordinate.Type.runtime || coord.equals(this.runtimeAll)) continue;
            needReindex = true;
        }
        if (!needReindex) {
            return prev;
        }
        ArrayList<Coordinate> completeCoords = new ArrayList<Coordinate>();
        for (Coordinate coord : prev.getCoordinates()) {
            if (this.runtimeUnion && coord.getType() == Coordinate.Type.runtime && !coord.equals(this.runtimeAll)) {
                completeCoords.add(this.runtimeAll);
                continue;
            }
            completeCoords.add(coord);
        }
        CoordinateND<T> result = new CoordinateND<T>(completeCoords);
        result.reindex(prev);
        return result;
    }
}

