/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;

public abstract class BinaryDictionary
implements Dictionary {
    public static final String TARGETMAP_FILENAME_SUFFIX = "$targetMap.dat";
    public static final String DICT_FILENAME_SUFFIX = "$buffer.dat";
    public static final String POSDICT_FILENAME_SUFFIX = "$posDict.dat";
    public static final String DICT_HEADER = "ko_dict";
    public static final String TARGETMAP_HEADER = "ko_dict_map";
    public static final String POSDICT_HEADER = "ko_dict_pos";
    public static final int VERSION = 1;
    private final ByteBuffer buffer;
    private final int[] targetMapOffsets;
    private final int[] targetMap;
    private final POS.Tag[] posDict;
    public static final int HAS_SINGLE_POS = 1;
    public static final int HAS_READING = 2;

    protected BinaryDictionary(IOSupplier<InputStream> targetMapResource, IOSupplier<InputStream> posResource, IOSupplier<InputStream> dictResource) throws IOException {
        InputStreamDataInput in;
        try (BufferedInputStream mapIS = new BufferedInputStream((InputStream)targetMapResource.get());){
            in = new InputStreamDataInput((InputStream)mapIS);
            CodecUtil.checkHeader((DataInput)in, (String)TARGETMAP_HEADER, (int)1, (int)1);
            this.targetMap = new int[in.readVInt()];
            this.targetMapOffsets = new int[in.readVInt()];
            BinaryDictionary.populateTargetMap((DataInput)in, this.targetMap, this.targetMapOffsets);
        }
        try (BufferedInputStream posIS = new BufferedInputStream((InputStream)posResource.get());){
            in = new InputStreamDataInput((InputStream)posIS);
            CodecUtil.checkHeader((DataInput)in, (String)POSDICT_HEADER, (int)1, (int)1);
            int posSize = in.readVInt();
            this.posDict = new POS.Tag[posSize];
            for (int j = 0; j < posSize; ++j) {
                this.posDict[j] = POS.resolveTag(in.readByte());
            }
        }
        try (InputStream dictIS = (InputStream)dictResource.get();){
            in = new InputStreamDataInput(dictIS);
            CodecUtil.checkHeader((DataInput)in, (String)DICT_HEADER, (int)1, (int)1);
            int size = in.readVInt();
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size);
            ReadableByteChannel channel = Channels.newChannel(dictIS);
            int read = channel.read(tmpBuffer);
            if (read != size) {
                throw new EOFException("Cannot read whole dictionary");
            }
            this.buffer = tmpBuffer.asReadOnlyBuffer();
        }
    }

    private static void populateTargetMap(DataInput in, int[] targetMap, int[] targetMapOffsets) throws IOException {
        int accum = 0;
        int sourceId = 0;
        for (int ofs = 0; ofs < targetMap.length; ++ofs) {
            int val = in.readVInt();
            if ((val & 1) != 0) {
                targetMapOffsets[sourceId] = ofs;
                ++sourceId;
            }
            targetMap[ofs] = accum += val >>> 1;
        }
        if (sourceId + 1 != targetMapOffsets.length) {
            throw new IOException("targetMap file format broken; targetMap.length=" + targetMap.length + ", targetMapOffsets.length=" + targetMapOffsets.length + ", sourceId=" + sourceId);
        }
        targetMapOffsets[sourceId] = targetMap.length;
    }

    @Deprecated(forRemoval=true, since="9.1")
    public static final InputStream getResource(ResourceScheme scheme, String path) throws IOException {
        switch (scheme) {
            case CLASSPATH: {
                Objects.requireNonNull(path, "Deprecated API no longer works with null paths, to load default resources use default ctors.");
                return (InputStream)IOUtils.requireResourceNonNull((Object)BinaryDictionary.class.getClassLoader().getResourceAsStream(path), (String)path);
            }
            case FILE: {
                return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            }
        }
        throw new IllegalStateException("unknown resource scheme " + String.valueOf((Object)scheme));
    }

    public void lookupWordIds(int sourceId, IntsRef ref) {
        ref.ints = this.targetMap;
        ref.offset = this.targetMapOffsets[sourceId];
        ref.length = this.targetMapOffsets[sourceId + 1] - ref.offset;
    }

    @Override
    public int getLeftId(int wordId) {
        return this.buffer.getShort(wordId) >>> 2;
    }

    @Override
    public int getRightId(int wordId) {
        return this.buffer.getShort(wordId + 2) >>> 2;
    }

    @Override
    public int getWordCost(int wordId) {
        return this.buffer.getShort(wordId + 4);
    }

    @Override
    public POS.Type getPOSType(int wordId) {
        byte value = (byte)(this.buffer.getShort(wordId) & 3);
        return POS.resolveType(value);
    }

    @Override
    public POS.Tag getLeftPOS(int wordId) {
        return this.posDict[this.getLeftId(wordId)];
    }

    @Override
    public POS.Tag getRightPOS(int wordId) {
        POS.Type type = this.getPOSType(wordId);
        if (type == POS.Type.MORPHEME || type == POS.Type.COMPOUND || this.hasSinglePOS(wordId)) {
            return this.getLeftPOS(wordId);
        }
        byte value = this.buffer.get(wordId + 6);
        return POS.resolveTag(value);
    }

    @Override
    public String getReading(int wordId) {
        if (this.hasReadingData(wordId)) {
            int offset = wordId + 6;
            return this.readString(offset);
        }
        return null;
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes(int wordId, char[] surfaceForm, int off, int len) {
        POS.Type posType = this.getPOSType(wordId);
        if (posType == POS.Type.MORPHEME) {
            return null;
        }
        int offset = wordId + 6;
        boolean hasSinglePos = this.hasSinglePOS(wordId);
        if (!hasSinglePos) {
            // empty if block
        }
        int n = ++offset;
        ++offset;
        int length = this.buffer.get(n);
        if (length == 0) {
            return null;
        }
        Dictionary.Morpheme[] morphemes = new Dictionary.Morpheme[length];
        int surfaceOffset = 0;
        POS.Tag leftPOS = this.getLeftPOS(wordId);
        for (int i = 0; i < length; ++i) {
            String form;
            POS.Tag tag;
            POS.Tag tag2 = tag = hasSinglePos ? leftPOS : POS.resolveTag(this.buffer.get(offset++));
            if (posType == POS.Type.INFLECT) {
                form = this.readString(offset);
                offset += form.length() * 2 + 1;
            } else {
                byte formLen = this.buffer.get(offset++);
                form = new String(surfaceForm, off + surfaceOffset, (int)formLen);
                surfaceOffset += formLen;
            }
            morphemes[i] = new Dictionary.Morpheme(tag, form);
        }
        return morphemes;
    }

    private String readString(int offset) {
        int strOffset = offset;
        int len = this.buffer.get(strOffset++);
        char[] text = new char[len];
        for (int i = 0; i < len; ++i) {
            text[i] = this.buffer.getChar(strOffset + (i << 1));
        }
        return new String(text);
    }

    private boolean hasSinglePOS(int wordId) {
        return (this.buffer.getShort(wordId + 2) & 1) != 0;
    }

    private boolean hasReadingData(int wordId) {
        return (this.buffer.getShort(wordId + 2) & 2) != 0;
    }

    @Deprecated(forRemoval=true, since="9.1")
    public static enum ResourceScheme {
        CLASSPATH,
        FILE;

    }
}

