/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.jsp.lexer;

import java.util.Map;

public final class JspParseData {
    private Map<String, String> prefixMap;
    private boolean isELIgnored;
    private boolean isXMLSyntax;
    private boolean initialized;

    public JspParseData(Map<String, String> prefixMap, boolean isELIgnored, boolean isXMLSyntax, boolean isInitialized) {
        this.prefixMap = prefixMap;
        this.isELIgnored = isELIgnored;
        this.isXMLSyntax = isXMLSyntax;
        this.initialized = isInitialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean initialized() {
        boolean oldVal = this.initialized;
        this.initialized = true;
        return oldVal;
    }

    public void updateParseData(Map<String, String> prefixMap, boolean isELIgnored, boolean isXMLSyntax) {
        this.prefixMap = prefixMap;
        this.isELIgnored = isELIgnored;
        this.isXMLSyntax = isXMLSyntax;
    }

    public boolean isTagLibRegistered(CharSequence prefix) {
        if (this.prefixMap == null) {
            return false;
        }
        return this.prefixMap.containsKey(prefix.toString());
    }

    public boolean isELIgnored() {
        return this.isELIgnored;
    }

    public boolean isXMLSyntax() {
        return this.isXMLSyntax;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("JspParseData[prefixes=");
        if (this.prefixMap != null) {
            this.prefixMap.forEach((prefix, v) -> {
                buf.append((String)prefix);
                buf.append('-');
                buf.append((String)v);
                buf.append(',');
            });
        } else {
            buf.append("null");
        }
        buf.append("; isELIgnored=");
        buf.append(this.isELIgnored());
        buf.append("; isXMLSyntax=");
        buf.append(this.isXMLSyntax());
        buf.append(')');
        return buf.toString();
    }
}

