/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.jshell.model.ConsoleEvent;
import org.netbeans.modules.jshell.model.ConsoleListener;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;

public class GuardedBlockSuppressLayer
extends AbstractHighlightsContainer
implements ConsoleListener {
    private static final String LAYER_ID = GuardedBlockSuppressLayer.class.getName();
    private final Document document;
    private final PositionsBag bag;
    private final String mimeType;
    private ConsoleModel model;
    private volatile boolean invalid = true;

    public GuardedBlockSuppressLayer(JTextComponent component) {
        this.document = component.getDocument();
        this.bag = new PositionsBag(this.document);
        this.mimeType = "text/x-repl";
    }

    private synchronized boolean updateConsoleModel() {
        ConsoleModel nm = ConsoleModel.get(this.document);
        if (this.model != nm) {
            if (this.model != null) {
                this.model.removeConsoleListener(this);
            }
            if (nm != null) {
                nm.addConsoleListener(this);
            }
        }
        this.model = nm;
        return nm != null;
    }

    private AttributeSet getAttribs(String coloringName, boolean extendsEol, boolean extendsEmptyLine) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)this.mimeType).lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getFontColors(coloringName);
        if (attribs == null) {
            attribs = SimpleAttributeSet.EMPTY;
        } else if (extendsEol || extendsEmptyLine) {
            attribs = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attribs, AttributesUtilities.createImmutable((Object[])new Object[]{"org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", extendsEol, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", extendsEmptyLine})});
        }
        return attribs;
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (!this.updateConsoleModel()) {
            return HighlightsSequence.EMPTY;
        }
        if (this.invalid) {
            this.bag.clear();
            AttributeSet def = this.getAttribs("default", true, true);
            for (ConsoleSection s : this.model.getSections()) {
                if (s.getType().input) continue;
                try {
                    this.bag.addHighlight(this.document.createPosition(s.getStart()), this.document.createPosition(s.getEnd()), def);
                }
                catch (BadLocationException badLocationException) {}
            }
            this.invalid = false;
        }
        return this.bag.getHighlights(startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHighlightsChanged(ConsoleEvent ev) {
        int min = this.document.getLength();
        int max = 0;
        List<ConsoleSection> secs = ev.getAffectedSections();
        for (ConsoleSection s : secs) {
            if (s.getType().input) continue;
            min = Math.min(min, s.getStart());
            max = Math.max(max, s.getEnd());
        }
        if (max < min) {
            return;
        }
        GuardedBlockSuppressLayer guardedBlockSuppressLayer = this;
        synchronized (guardedBlockSuppressLayer) {
            this.invalid = true;
        }
        this.fireHighlightsChange(min, max);
    }

    @Override
    public void sectionCreated(ConsoleEvent e) {
        this.fireHighlightsChanged(e);
    }

    @Override
    public void sectionUpdated(ConsoleEvent e) {
        this.fireHighlightsChanged(e);
    }

    @Override
    public void executing(ConsoleEvent e) {
    }

    @Override
    public void closed(ConsoleEvent e) {
    }

    public static class HLF
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            Document d = context.getDocument();
            JTextComponent c = context.getComponent();
            return new HighlightsLayer[]{HighlightsLayer.create((String)LAYER_ID, (ZOrder)ZOrder.BOTTOM_RACK.forPosition(10), (boolean)true, (HighlightsContainer)new GuardedBlockSuppressLayer(c))};
        }
    }
}

