/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8StepAction;
import org.netbeans.lib.v8debug.commands.Continue;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class V8DebugActionsProvider
extends ActionsProviderSupport
implements V8Debugger.Listener {
    private static final Logger LOG = Logger.getLogger(V8DebugActionsProvider.class.getName());
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_START, ActionsManager.ACTION_KILL, ActionsManager.ACTION_CONTINUE, ActionsManager.ACTION_PAUSE, ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_FIX)));
    private final V8Debugger dbg;
    private final RequestProcessor killActionRP = new RequestProcessor(V8DebugActionsProvider.class.getName() + ".kill");
    private final PropertyChangeListener changeLiveListener = new ChangeLiveListener();

    public V8DebugActionsProvider(ContextProvider contextProvider) {
        this.dbg = (V8Debugger)contextProvider.lookupFirst(null, V8Debugger.class);
        this.dbg.addListener(this);
        this.dbg.getChangeLiveSupport().addPropertyChangeListener(this.changeLiveListener);
        this.setEnabled(ActionsManager.ACTION_START, true);
        this.setEnabled(ActionsManager.ACTION_KILL, true);
        this.setEnabled(ActionsManager.ACTION_FIX, false);
        this.notifySuspended(false);
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_KILL) {
            this.killActionRP.post(new Runnable(){
                final /* synthetic */ V8DebugActionsProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.dbg.finish();
                    }
                    finally {
                        actionPerformedNotifier.run();
                    }
                }
            });
        } else {
            super.postAction(action, actionPerformedNotifier);
        }
    }

    public void doAction(Object action) {
        LOG.fine("doAction(" + action + ")");
        if (action == ActionsManager.ACTION_START) {
            this.dbg.start();
        } else if (action == ActionsManager.ACTION_CONTINUE) {
            this.dbg.resume();
        } else if (action == ActionsManager.ACTION_PAUSE) {
            this.dbg.suspend();
        } else if (action == ActionsManager.ACTION_STEP_INTO) {
            Continue.Arguments ca = new Continue.Arguments(V8StepAction.in);
            this.dbg.sendCommandRequest(V8Command.Continue, (V8Arguments)ca);
        } else if (action == ActionsManager.ACTION_STEP_OVER) {
            Continue.Arguments ca = new Continue.Arguments(V8StepAction.next);
            this.dbg.sendCommandRequest(V8Command.Continue, (V8Arguments)ca);
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            Continue.Arguments ca = new Continue.Arguments(V8StepAction.out);
            this.dbg.sendCommandRequest(V8Command.Continue, (V8Arguments)ca);
        } else if (action == ActionsManager.ACTION_FIX) {
            this.dbg.getChangeLiveSupport().applyChanges();
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    @Override
    public void notifySuspended(boolean suspended) {
        this.setEnabled(ActionsManager.ACTION_CONTINUE, suspended);
        this.setEnabled(ActionsManager.ACTION_PAUSE, !suspended);
        this.setEnabled(ActionsManager.ACTION_STEP_INTO, suspended);
        this.setEnabled(ActionsManager.ACTION_STEP_OVER, suspended);
        this.setEnabled(ActionsManager.ACTION_STEP_OUT, suspended);
    }

    @Override
    public void notifyCurrentFrame(CallFrame cf) {
    }

    @Override
    public void notifyFinished() {
        this.dbg.getChangeLiveSupport().removePropertyChangeListener(this.changeLiveListener);
    }

    private class ChangeLiveListener
    implements PropertyChangeListener {
        private ChangeLiveListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            V8DebugActionsProvider.this.setEnabled(ActionsManager.ACTION_FIX, (Boolean)evt.getNewValue());
        }
    }
}

