/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.ui.FileNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class FilesNode
extends AbstractNode {
    private final Library.Version version;

    public FilesNode(Library.Version version, String[] installedFiles) {
        super((Children)new FilesChildren(version, installedFiles));
        this.version = version;
    }

    Library.Version getSelection() {
        if (this.version == null) {
            return null;
        }
        HashSet<String> refusedFiles = new HashSet<String>();
        this.collectRefusedFiles(refusedFiles);
        Library.Version selection = this.version.filterVersion(refusedFiles);
        return selection.getFiles().length == 0 ? null : selection;
    }

    void collectRefusedFiles(Collection<String> refusedFiles) {
        for (Node node : this.getChildren().getNodes(true)) {
            ((FileNode)node).collectRefusedFiles(refusedFiles);
        }
    }

    static class FilesChildren
    extends Children.Keys<String> {
        private final Set<String> installedFiles;

        FilesChildren(Library.Version version, String[] installedFiles) {
            this.installedFiles = installedFiles == null ? null : new HashSet<String>(Arrays.asList(installedFiles));
            this.setKeys(version == null ? new String[]{} : version.getFiles());
        }

        protected Node[] createNodes(String key) {
            boolean install = this.installedFiles != null && this.installedFiles.contains(key);
            return new Node[]{new FileNode(key, install)};
        }
    }
}

