/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.jpda.projects.FixClassesSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SourcePathProviderImpl
extends SourcePathProvider {
    private static final boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.projects");
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private ClassPath originalSourcePath;
    private Set<String> additionalSourceRoots;
    private Set<String> platformSourceRoots;
    private ClassPath smartSteppingSourcePath;
    private String[] projectSourceRoots;
    private ClassPath unorderedOriginalSourcePath;
    private int[] sourcePathPermutation;
    private PropertyChangeSupport pcs;
    private PathRegistryListener pathRegistryListener;
    private File baseDir;
    private final Map<String, String> urlCache = new URLCacheMap();
    private final Map<String, String> urlCacheGlobal = new URLCacheMap();
    private static boolean CAN_FIX_CLASSES_AUTOMATICALLY = Boolean.getBoolean("debugger.apply-code-changes.on-save");

    public SourcePathProviderImpl() {
        this.pcs = new PropertyChangeSupport((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourcePathProviderImpl(ContextProvider contextProvider) {
        this.pcs = new PropertyChangeSupport((Object)this);
        JPDADebugger debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        Map properties = (Map)contextProvider.lookupFirst(null, Map.class);
        HashSet<Object> srcRootsToListenForArtifactsUpdates = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Have properties = " + properties);
        }
        if (properties != null) {
            ClassPath additionalClassPath;
            this.baseDir = (File)properties.get("baseDir");
            this.smartSteppingSourcePath = (ClassPath)properties.get("sourcepath");
            ClassPath jdkCP = (ClassPath)properties.get("jdksources");
            if (jdkCP == null && JavaPlatform.getDefault() != null) {
                jdkCP = JavaPlatform.getDefault().getSourceFolders();
            }
            this.platformSourceRoots = SourcePathProviderImpl.getSourceRootsSet(jdkCP);
            if (this.baseDir != null) {
                additionalClassPath = this.getAdditionalClassPath(this.baseDir);
            } else {
                additionalClassPath = null;
                Exceptions.printStackTrace((Throwable)new NullPointerException("No base directory is defined. Properties = " + properties));
            }
            if (additionalClassPath != null) {
                this.smartSteppingSourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.smartSteppingSourcePath, additionalClassPath});
            }
            this.unorderedOriginalSourcePath = this.smartSteppingSourcePath = jdkCP == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{jdkCP, this.smartSteppingSourcePath});
            Map<String, Integer> map = SourcePathProviderImpl.getSourceRootsOrder(this.baseDir);
            String[] unorderedOriginalRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
            String[] sortedOriginalRoots = new String[unorderedOriginalRoots.length];
            this.sourcePathPermutation = SourcePathProviderImpl.createPermutation(unorderedOriginalRoots, map, sortedOriginalRoots);
            this.originalSourcePath = this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sortedOriginalRoots);
            Set<String> disabledRoots = this.baseDir != null ? this.getDisabledSourceRoots(this.baseDir) : null;
            if (disabledRoots != null && !disabledRoots.isEmpty()) {
                ArrayList<FileObject> enabledSourcePath = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                for (FileObject fileObject : new HashSet<FileObject>(enabledSourcePath)) {
                    if (!disabledRoots.contains(SourcePathProviderImpl.getRoot(fileObject))) continue;
                    enabledSourcePath.remove(fileObject);
                }
                this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(enabledSourcePath.toArray(new FileObject[0]));
            }
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            String listeningCP = (String)properties.get("listeningCP");
            if (listeningCP != null) {
                boolean isSourcepath = false;
                if ("sourcepath".equalsIgnoreCase(listeningCP)) {
                    listeningCP = ((ClassPath)properties.get("sourcepath")).toString(ClassPath.PathConversionMode.SKIP);
                    isSourcepath = true;
                }
                srcRootsToListenForArtifactsUpdates = new HashSet<Object>();
                for (String string : listeningCP.split(File.pathSeparator)) {
                    FileObject[] src;
                    logger.log(Level.FINE, "Listening cp = ''{0}''", string);
                    File f = new File(string);
                    f = FileUtil.normalizeFile((File)f);
                    URL entry = FileUtil.urlForArchiveOrDir((File)f);
                    if (entry == null) continue;
                    if (isSourcepath && (src = URLMapper.findFileObject((URL)entry)) != null) {
                        srcRootsToListenForArtifactsUpdates.add(src);
                    }
                    src = SourceForBinaryQuery.findSourceRoots((URL)entry).getRoots();
                    int n = src.length;
                    for (int i = 0; i < n; ++i) {
                        FileObject src2 = src[i];
                        srcRootsToListenForArtifactsUpdates.add(src2);
                    }
                }
                if (srcRootsToListenForArtifactsUpdates.isEmpty()) {
                    srcRootsToListenForArtifactsUpdates = null;
                }
            }
        } else {
            this.pathRegistryListener = new PathRegistryListener();
            GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.pathRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pathRegistryListener, (Object)JavaPlatformManager.getDefault()));
            ArrayList<FileObject> allSourceRoots = new ArrayList<FileObject>();
            HashSet<FileObject> preferredRoots = new HashSet<FileObject>();
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            Project mainProject = OpenProjects.getDefault().getMainProject();
            this.platformSourceRoots = new HashSet<String>();
            if (mainProject != null) {
                SourceGroup[] sgs = ProjectUtils.getSources((Project)mainProject).getSourceGroups("java");
                for (SourceGroup sourceGroup : sgs) {
                    ClassPath ecp = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/execute");
                    if (ecp == null) {
                        ecp = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/source");
                    }
                    if (ecp != null) {
                        FileObject[] binaryRoots;
                        for (FileObject fo : binaryRoots = ecp.getRoots()) {
                            FileObject[] roots;
                            if (hashSet.contains(fo)) continue;
                            hashSet.add(fo);
                            for (FileObject fr : roots = SourceForBinaryQuery.findSourceRoots((URL)fo.toURL()).getRoots()) {
                                if (preferredRoots.contains(fr)) continue;
                                allSourceRoots.add(fr);
                                preferredRoots.add(fr);
                            }
                        }
                    }
                    if ((ecp = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/boot")) == null) continue;
                    this.platformSourceRoots.addAll(SourcePathProviderImpl.getSourceRootsSet(ecp));
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: preferred source roots = " + preferredRoots + ")");
            }
            TreeSet<FileObject> globalRoots = new TreeSet<FileObject>(new FileObjectComparator());
            globalRoots.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            for (FileObject fo : globalRoots) {
                if (preferredRoots.contains(fo)) continue;
                allSourceRoots.add(fo);
            }
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                FileObject[] roots = platforms[i].getSourceFolders().getRoots();
                int jj = roots.length;
                for (int j = 0; j < jj; ++j) {
                    if (allSourceRoots.contains(roots[j])) continue;
                    allSourceRoots.add(roots[j]);
                }
                this.platformSourceRoots.addAll(SourcePathProviderImpl.getSourceRootsSet(platforms[i].getSourceFolders()));
            }
            List<FileObject> additional = this.getAdditionalRemoteClassPath();
            if (additional != null) {
                allSourceRoots.addAll(additional);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: GlobalPathRegistry roots = " + GlobalPathRegistry.getDefault().getSourceRoots() + ")");
                logger.fine("Platform roots:");
                for (int i = 0; i < platforms.length; ++i) {
                    logger.fine(" " + Arrays.asList(platforms[i].getSourceFolders().getRoots()).toString());
                }
                logger.fine("SourcePathProviderImpl: all source roots = " + allSourceRoots + ")");
            }
            Set<String> disabledRoots = this.getRemoteDisabledSourceRoots();
            SourcePathProviderImpl sourcePathProviderImpl = this;
            synchronized (sourcePathProviderImpl) {
                this.unorderedOriginalSourcePath = SourcePathProviderImpl.createClassPath(allSourceRoots.toArray(new FileObject[0]));
                Map<String, Integer> orderIndexes = SourcePathProviderImpl.getRemoteSourceRootsOrder();
                String[] unorderedOriginalRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
                String[] stringArray = new String[unorderedOriginalRoots.length];
                this.sourcePathPermutation = SourcePathProviderImpl.createPermutation(unorderedOriginalRoots, orderIndexes, stringArray);
                this.originalSourcePath = SourcePathProviderImpl.createClassPath(stringArray);
                this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
                srcRootsToListenForArtifactsUpdates = new HashSet(allSourceRoots);
                this.smartSteppingSourcePath = this.originalSourcePath;
                if (disabledRoots != null && !disabledRoots.isEmpty()) {
                    ArrayList<FileObject> enabledSourcePath = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                    for (FileObject fo : new HashSet<FileObject>(enabledSourcePath)) {
                        if (!disabledRoots.contains(SourcePathProviderImpl.getRoot(fo))) continue;
                        enabledSourcePath.remove(fo);
                    }
                    this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(enabledSourcePath.toArray(new FileObject[0]));
                }
            }
        }
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("new SourcePathProviderImpl(): contextProvider = " + contextProvider + ", properties = " + properties + ", srcRootsToListenForArtifactsUpdates = " + srcRootsToListenForArtifactsUpdates);
        }
        if (srcRootsToListenForArtifactsUpdates != null) {
            final HashSet<ArtifactsUpdatedImpl> artifactsListeners = new HashSet<ArtifactsUpdatedImpl>();
            for (FileObject fileObject : srcRootsToListenForArtifactsUpdates) {
                artifactsListeners.add(this.addArtifactsUpdateListenerFor(debugger, fileObject));
            }
            debugger.addPropertyChangeListener("state", new PropertyChangeListener(){
                final /* synthetic */ SourcePathProviderImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (4 == (Integer)evt.getNewValue()) {
                        for (ArtifactsUpdatedImpl al : artifactsListeners) {
                            BuildArtifactMapper.removeArtifactsUpdatedListener((URL)al.getURL(), (BuildArtifactMapper.ArtifactsUpdated)al);
                        }
                    }
                }
            });
        }
    }

    private ClassPath getAdditionalClassPath(File baseDir) {
        try {
            String root = BaseUtilities.toURI((File)baseDir).toURL().toExternalForm();
            Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            List additionalSourceRoots = (List)sourcesProperties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(root);
            if (additionalSourceRoots == null || additionalSourceRoots.isEmpty()) {
                return null;
            }
            ArrayList<FileObject> additionalSourcePath = new ArrayList<FileObject>(additionalSourceRoots.size());
            for (String ar : additionalSourceRoots) {
                FileObject fo = SourcePathProviderImpl.getFileObject(ar);
                if (fo == null || !fo.canRead()) continue;
                additionalSourcePath.add(fo);
            }
            this.additionalSourceRoots = new LinkedHashSet<String>(additionalSourceRoots);
            return SourcePathProviderImpl.createClassPath(additionalSourcePath.toArray(new FileObject[0]));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private List<FileObject> getAdditionalRemoteClassPath() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        List additionalSourceRoots = (List)sourcesProperties.getProperties("additional_source_roots").getCollection("src_roots", Collections.emptyList());
        if (additionalSourceRoots == null || additionalSourceRoots.isEmpty()) {
            return null;
        }
        ArrayList<FileObject> additionalSourcePath = new ArrayList<FileObject>(additionalSourceRoots.size());
        for (String ar : additionalSourceRoots) {
            FileObject fo = SourcePathProviderImpl.getFileObject(ar);
            if (fo == null || !fo.canRead()) continue;
            additionalSourcePath.add(fo);
        }
        this.additionalSourceRoots = new LinkedHashSet<String>(additionalSourceRoots);
        return additionalSourcePath;
    }

    private void storeAdditionalSourceRoots() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String projectRoot;
            try {
                projectRoot = BaseUtilities.toURI((File)this.baseDir).toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            Map map = sourcesProperties.getProperties("additional_source_roots").getMap("project", new HashMap());
            if (this.additionalSourceRoots != null) {
                map.put(projectRoot, new ArrayList<String>(this.additionalSourceRoots));
            } else {
                map.remove(projectRoot);
            }
            sourcesProperties.getProperties("additional_source_roots").setMap("project", map);
        } else if (this.additionalSourceRoots != null) {
            sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", new ArrayList<String>(this.additionalSourceRoots));
        } else {
            sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", null);
        }
    }

    private Set<String> getDisabledSourceRoots(File baseDir) {
        try {
            String root = BaseUtilities.toURI((File)baseDir).toURL().toExternalForm();
            Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            return (Set)sourcesProperties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(root);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Set<String> getRemoteDisabledSourceRoots() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Set)sourcesProperties.getProperties("source_roots").getCollection("remote_disabled", Collections.emptySet());
    }

    private void storeDisabledSourceRoots(Set<String> disabledSourceRoots) {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String projectRoot;
            try {
                projectRoot = BaseUtilities.toURI((File)this.baseDir).toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            Map map = sourcesProperties.getProperties("source_roots").getMap("project_disabled", new HashMap());
            map.put(projectRoot, disabledSourceRoots);
            sourcesProperties.getProperties("source_roots").setMap("project_disabled", map);
        } else {
            sourcesProperties.getProperties("source_roots").setCollection("remote_disabled", disabledSourceRoots);
        }
    }

    private static Map<String, Integer> getSourceRootsOrder(File baseDir) {
        try {
            String root = BaseUtilities.toURI((File)baseDir).toURL().toExternalForm();
            return SourcePathProviderImpl.getSourceRootsOrder(root);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static Map<String, Integer> getSourceRootsOrder(String root) {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Map)sourcesProperties.getProperties("source_roots").getMap("project_order", Collections.emptyMap()).get(root);
    }

    public static Map<String, Integer> getRemoteSourceRootsOrder() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return sourcesProperties.getProperties("source_roots").getMap("remote_order", Collections.emptyMap());
    }

    private static void storeSourceRootsOrder(File baseDir, String[] roots, int[] permutation) {
        String projectRoot;
        if (baseDir != null) {
            try {
                projectRoot = BaseUtilities.toURI((File)baseDir).toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        } else {
            projectRoot = null;
        }
        SourcePathProviderImpl.storeSourceRootsOrder(projectRoot, roots, permutation);
    }

    public static void storeSourceRootsOrder(String projectRoot, String[] roots, int[] permutation) {
        HashMap<String, Integer> sourceOrder = new HashMap<String, Integer>();
        if (roots.length != permutation.length) {
            throw new IllegalArgumentException("Incompatible array length: roots = " + roots.length + ", permutation = " + permutation.length);
        }
        for (int i = 0; i < roots.length; ++i) {
            sourceOrder.put(roots[permutation[i]], i);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.storeSourceRootsOrder():");
            logger.fine("  sourceOrder = " + sourceOrder);
        }
        SourcePathProviderImpl.storeSourceRootsOrder(projectRoot, sourceOrder);
    }

    private static void storeSourceRootsOrder(String projectRoot, Map<String, Integer> sourceOrder) {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (projectRoot != null) {
            Map map = sourcesProperties.getProperties("source_roots").getMap("project_order", new HashMap());
            map.put(projectRoot, sourceOrder);
            sourcesProperties.getProperties("source_roots").setMap("project_order", map);
        } else {
            sourcesProperties.getProperties("source_roots").setMap("remote_order", sourceOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String relativePath, boolean global) {
        Map<String, String> map;
        FileObject fo;
        Map<String, String> map2;
        if (verbose) {
            System.out.println("SPPI: getURL " + relativePath + " global " + global);
        }
        relativePath = SourcePathProviderImpl.normalize(relativePath);
        if (global) {
            map2 = this.urlCacheGlobal;
            synchronized (map2) {
                if (this.urlCacheGlobal.containsKey(relativePath)) {
                    if (verbose) {
                        System.out.println("Have cached global path for '" + relativePath + "' url = " + this.urlCacheGlobal.get(relativePath));
                    }
                    return this.urlCacheGlobal.get(relativePath);
                }
            }
        }
        map2 = this.urlCache;
        synchronized (map2) {
            if (this.urlCache.containsKey(relativePath)) {
                if (verbose) {
                    System.out.println("Have cached path for '" + relativePath + "' url = " + this.urlCache.get(relativePath));
                }
                return this.urlCache.get(relativePath);
            }
        }
        ClassPath ss = null;
        ClassPath os = null;
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            if (this.originalSourcePath != null) {
                ss = this.smartSteppingSourcePath;
                os = this.originalSourcePath;
            }
        }
        if (ss != null && os != null) {
            fo = ss.findResource(relativePath);
            if (fo == null && global) {
                fo = os.findResource(relativePath);
            }
            if (fo == null && global) {
                fo = GlobalPathRegistry.getDefault().findResource(relativePath);
            }
        } else {
            fo = GlobalPathRegistry.getDefault().findResource(relativePath);
        }
        if (fo == null && global) {
            Set cpaths = GlobalPathRegistry.getDefault().getPaths("classpath/compile");
            block15: for (ClassPath cp : cpaths) {
                FileObject[] roots;
                fo = cp.findResource(relativePath);
                if (fo == null) continue;
                for (FileObject r : roots = cp.getRoots()) {
                    if (!FileUtil.isParentOf((FileObject)r, (FileObject)fo)) continue;
                    this.addToSourcePath(r, false);
                    break block15;
                }
            }
        }
        if (verbose) {
            System.out.println("SPPI:   fo " + fo);
        }
        String url = fo == null ? null : fo.toURL().toString();
        if (global) {
            map = this.urlCacheGlobal;
            synchronized (map) {
                if (verbose) {
                    System.out.println("Storing path into global cache for '" + relativePath + "' url = " + url);
                }
                this.urlCacheGlobal.put(relativePath, url);
                if (verbose) {
                    System.out.println("  Global cache (" + this.urlCacheGlobal.size() + ") = " + this.urlCacheGlobal);
                }
            }
        }
        map = this.urlCache;
        synchronized (map) {
            if (verbose) {
                System.out.println("Storing path into cache for '" + relativePath + "' url = " + url);
            }
            this.urlCache.put(relativePath, url);
            if (verbose) {
                System.out.println("  Cache = (" + this.urlCache.size() + ") " + this.urlCache);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSourcePath(FileObject sourceRoot, boolean clearURLCaches) {
        URL newURL = sourceRoot.toURL();
        Object object = this;
        synchronized (object) {
            if (this.originalSourcePath == null) {
                return;
            }
            List<URL> sourcePaths = SourcePathProviderImpl.getURLRoots(this.originalSourcePath);
            sourcePaths.add(newURL);
            this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new URL[0]));
            sourcePaths = SourcePathProviderImpl.getURLRoots(this.smartSteppingSourcePath);
            sourcePaths.add(newURL);
            this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new URL[0]));
        }
        if (clearURLCaches) {
            object = this.urlCache;
            synchronized (object) {
                this.urlCache.clear();
            }
            object = this.urlCacheGlobal;
            synchronized (object) {
                this.urlCacheGlobal.clear();
            }
        }
        this.pcs.firePropertyChange("sourceRoots", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllURLs(String relativePath, boolean global) {
        List fos;
        if (verbose) {
            System.out.println("SPPI: getURL " + relativePath + " global " + global);
        }
        relativePath = SourcePathProviderImpl.normalize(relativePath);
        if (this.originalSourcePath == null) {
            fos = new ArrayList();
            for (ClassPath cp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                fos.addAll(cp.findAllResources(relativePath));
            }
        } else {
            SourcePathProviderImpl sourcePathProviderImpl = this;
            synchronized (sourcePathProviderImpl) {
                if (!global) {
                    fos = this.smartSteppingSourcePath.findAllResources(relativePath);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + fos);
                    }
                } else {
                    fos = this.originalSourcePath.findAllResources(relativePath);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + fos);
                    }
                }
            }
        }
        ArrayList<String> urls = new ArrayList<String>(fos.size());
        for (FileObject fo : fos) {
            urls.add(fo.toURL().toString());
        }
        return urls.toArray(new String[0]);
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        FileObject fo;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + url);
        }
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
            if (verbose) {
                System.out.println("SPPI:   fo " + fo);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (fo == null) {
            return null;
        }
        String relativePath = this.smartSteppingSourcePath.getResourceName(fo, directorySeparator, includeExtension);
        if (relativePath == null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp == null) {
                cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            }
            if (cp == null) {
                return null;
            }
            relativePath = cp.getResourceName(fo, directorySeparator, includeExtension);
        }
        return relativePath;
    }

    public synchronized String getSourceRoot(String url) {
        ClassPath cp;
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException ex) {
            fo = null;
        }
        FileObject[] roots = null;
        if (fo != null && fo.canRead() && (cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) != null) {
            roots = cp.getRoots();
        }
        if (roots == null) {
            roots = this.originalSourcePath.getRoots();
        }
        for (FileObject fileObject : roots) {
            String root;
            String rootURL = fileObject.toURL().toString();
            if (!url.startsWith(rootURL) || (root = SourcePathProviderImpl.getRoot(fileObject)) == null) continue;
            return root;
        }
        return null;
    }

    private String[] getSourceRoots(ClassPath classPath) {
        FileObject[] sourceRoots = classPath.getRoots();
        ArrayList<String> roots = new ArrayList<String>(sourceRoots.length);
        for (FileObject fo : sourceRoots) {
            String root = SourcePathProviderImpl.getRoot(fo);
            if (root == null) continue;
            roots.add(root);
        }
        return roots.toArray(new String[0]);
    }

    private static Set<String> getSourceRootsSet(ClassPath classPath) {
        FileObject[] sourceRoots = classPath.getRoots();
        HashSet<String> roots = new HashSet<String>(sourceRoots.length);
        for (FileObject fo : sourceRoots) {
            String root = SourcePathProviderImpl.getRoot(fo);
            if (root == null) continue;
            roots.add(root);
        }
        return roots;
    }

    public synchronized Set<String> getPlatformSourceRoots() {
        return Collections.unmodifiableSet(this.platformSourceRoots);
    }

    public synchronized String[] getOriginalSourceRoots() {
        return this.getSourceRoots(this.originalSourcePath);
    }

    public synchronized String[] getSourceRoots() {
        return this.getSourceRoots(this.smartSteppingSourcePath);
    }

    public synchronized Set<FileObject> getSourceRootsFO() {
        return new HashSet<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
    }

    public String[] getProjectSourceRoots() {
        return this.projectSourceRoots;
    }

    public synchronized String[] getAdditionalSourceRoots() {
        return this.additionalSourceRoots == null ? new String[]{} : this.additionalSourceRoots.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderOriginalSourceRoots(int[] permutation) {
        Object object = this;
        synchronized (object) {
            String[] srcRoots = this.getOriginalSourceRoots();
            if (permutation == null) {
                for (int i = 0; i < this.sourcePathPermutation.length; ++i) {
                    this.sourcePathPermutation[i] = i;
                }
                this.originalSourcePath = this.unorderedOriginalSourcePath;
                srcRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
            } else {
                if (srcRoots.length != permutation.length) {
                    throw new IllegalArgumentException("Bad length of permutation: " + permutation.length + ", have " + srcRoots.length + " source roots.");
                }
                int n = permutation.length;
                String[] unorderedOriginalRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
                String[] sortedOriginalRoots = new String[n];
                for (int i = 0; i < n; ++i) {
                    permutation[i] = this.sourcePathPermutation[permutation[i]];
                    sortedOriginalRoots[i] = unorderedOriginalRoots[permutation[i]];
                }
                System.arraycopy(permutation, 0, this.sourcePathPermutation, 0, n);
                this.originalSourcePath = SourcePathProviderImpl.createClassPath(sortedOriginalRoots);
                srcRoots = unorderedOriginalRoots;
            }
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            HashSet<String> smartSteppingRoots = new HashSet<String>(Arrays.asList(this.getSourceRoots(this.smartSteppingSourcePath)));
            String[] orderedSmartSteppingRoots = new String[smartSteppingRoots.size()];
            int i = 0;
            for (String root : this.projectSourceRoots) {
                if (!smartSteppingRoots.contains(root)) continue;
                orderedSmartSteppingRoots[i++] = root;
            }
            this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(orderedSmartSteppingRoots);
            SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, srcRoots, this.sourcePathPermutation);
        }
        object = this.urlCache;
        synchronized (object) {
            this.urlCache.clear();
        }
        object = this.urlCacheGlobal;
        synchronized (object) {
            this.urlCacheGlobal.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] sourceRoots, String[] additionalRoots) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(sourceRoots) + ", " + Arrays.asList(additionalRoots) + ")");
        }
        LinkedHashSet<String> newRoots = new LinkedHashSet<String>(Arrays.asList(sourceRoots));
        ClassPath[] oldCP_ptr = new ClassPath[]{null};
        ClassPath[] newCP_ptr = new ClassPath[]{null};
        Object object = this;
        synchronized (object) {
            LinkedHashSet<String> allAdditionalSourceRoots = new LinkedHashSet<String>(Arrays.asList(additionalRoots));
            int permLength = this.sourcePathPermutation.length;
            Set<String> disabledSourceRoots = this.setSourceRoots(newRoots, oldCP_ptr, newCP_ptr, allAdditionalSourceRoots);
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(disabledSourceRoots);
            if (permLength != this.sourcePathPermutation.length) {
                SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, this.getSourceRoots(this.unorderedOriginalSourcePath), this.sourcePathPermutation);
            }
        }
        object = this.urlCache;
        synchronized (object) {
            this.urlCache.clear();
        }
        object = this.urlCacheGlobal;
        synchronized (object) {
            this.urlCacheGlobal.clear();
        }
        if (oldCP_ptr[0] != null) {
            this.pcs.firePropertyChange("sourceRoots", oldCP_ptr[0], newCP_ptr[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] sourceRoots) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(sourceRoots) + ")");
        }
        LinkedHashSet<String> newRoots = new LinkedHashSet<String>(Arrays.asList(sourceRoots));
        ClassPath[] oldCP_ptr = new ClassPath[]{null};
        ClassPath[] newCP_ptr = new ClassPath[]{null};
        Object object = this;
        synchronized (object) {
            int permLength = this.sourcePathPermutation.length;
            Set<String> disabledSourceRoots = this.setSourceRoots(newRoots, oldCP_ptr, newCP_ptr, null);
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(disabledSourceRoots);
            if (permLength != this.sourcePathPermutation.length) {
                SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, this.getSourceRoots(this.unorderedOriginalSourcePath), this.sourcePathPermutation);
            }
        }
        object = this.urlCache;
        synchronized (object) {
            this.urlCache.clear();
        }
        object = this.urlCacheGlobal;
        synchronized (object) {
            this.urlCacheGlobal.clear();
        }
        if (oldCP_ptr[0] != null) {
            this.pcs.firePropertyChange("sourceRoots", oldCP_ptr[0], newCP_ptr[0]);
        }
    }

    private synchronized Set<String> setSourceRoots(Set<String> newRoots, ClassPath[] oldCP_ptr, ClassPath[] newCP_ptr, Set<String> allAdditionalSourceRoots) {
        ArrayList<FileObject> sourcePath = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
        ArrayList<FileObject> sourcePathOriginal = new ArrayList<FileObject>(Arrays.asList(this.originalSourcePath.getRoots()));
        ArrayList<FileObject> unorderedSourcePathOriginal = new ArrayList<FileObject>(Arrays.asList(this.unorderedOriginalSourcePath.getRoots()));
        LinkedHashSet<String> newOriginalRoots = new LinkedHashSet<String>(newRoots);
        for (FileObject fileObject : sourcePathOriginal) {
            newOriginalRoots.remove(SourcePathProviderImpl.getRoot(fileObject));
        }
        if (!newOriginalRoots.isEmpty()) {
            LinkedHashSet<String> addedOriginalRoots = new LinkedHashSet<String>(newOriginalRoots.size());
            for (String root : newOriginalRoots) {
                FileObject fo = SourcePathProviderImpl.getFileObject(root);
                if (fo == null || !fo.canRead()) continue;
                sourcePathOriginal.add(fo);
                unorderedSourcePathOriginal.add(fo);
                addedOriginalRoots.add(root);
            }
            newOriginalRoots = addedOriginalRoots;
            if (!newOriginalRoots.isEmpty()) {
                if (this.additionalSourceRoots == null) {
                    this.additionalSourceRoots = new LinkedHashSet<String>();
                }
                this.additionalSourceRoots.addAll(newOriginalRoots);
            }
        }
        LinkedHashSet<String> newSteppingRoots = new LinkedHashSet<String>(newRoots);
        for (FileObject fo : sourcePath) {
            newSteppingRoots.remove(SourcePathProviderImpl.getRoot(fo));
        }
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<FileObject> removedOriginalRoots = new HashSet<FileObject>();
        for (FileObject fo : sourcePath) {
            String spr = SourcePathProviderImpl.getRoot(fo);
            if (newRoots.contains(spr)) continue;
            hashSet.add(fo);
            if (this.additionalSourceRoots == null || !this.additionalSourceRoots.contains(spr) || allAdditionalSourceRoots != null && allAdditionalSourceRoots.contains(spr)) continue;
            removedOriginalRoots.add(fo);
            this.additionalSourceRoots.remove(spr);
            if (!this.additionalSourceRoots.isEmpty()) continue;
            this.additionalSourceRoots = null;
        }
        if (!removedOriginalRoots.isEmpty()) {
            sourcePathOriginal.removeAll(removedOriginalRoots);
        }
        if (!newOriginalRoots.isEmpty() || !removedOriginalRoots.isEmpty()) {
            for (FileObject fo : removedOriginalRoots) {
                int i;
                int index = unorderedSourcePathOriginal.indexOf(fo);
                unorderedSourcePathOriginal.remove(index);
                int pi = this.sourcePathPermutation[index];
                for (i = 0; i < this.sourcePathPermutation.length; ++i) {
                    if (this.sourcePathPermutation[i] <= pi) continue;
                    int n = i;
                    this.sourcePathPermutation[n] = this.sourcePathPermutation[n] - 1;
                }
                for (i = index; i < this.sourcePathPermutation.length - 1; ++i) {
                    this.sourcePathPermutation[i] = this.sourcePathPermutation[i + 1];
                }
            }
            int n = this.sourcePathPermutation.length - removedOriginalRoots.size() + newOriginalRoots.size();
            int[] newSourcePathPermutation = new int[n];
            System.arraycopy(this.sourcePathPermutation, 0, newSourcePathPermutation, 0, this.sourcePathPermutation.length - removedOriginalRoots.size());
            for (int i = this.sourcePathPermutation.length - removedOriginalRoots.size(); i < n; ++i) {
                newSourcePathPermutation[i] = i;
            }
            this.sourcePathPermutation = newSourcePathPermutation;
            this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePathOriginal.toArray(new FileObject[0]));
            this.unorderedOriginalSourcePath = SourcePathProviderImpl.createClassPath(unorderedSourcePathOriginal.toArray(new FileObject[0]));
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
        }
        if (newSteppingRoots.size() > 0 || hashSet.size() > 0) {
            for (String root : newSteppingRoots) {
                FileObject fo = SourcePathProviderImpl.getFileObject(root);
                if (fo == null || !fo.canRead()) continue;
                sourcePath.add(fo);
            }
            sourcePath.removeAll(hashSet);
            oldCP_ptr[0] = this.smartSteppingSourcePath;
            newCP_ptr[0] = this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePath.toArray(new FileObject[0]));
        }
        HashSet<FileObject> disabledRoots = new HashSet<FileObject>(sourcePathOriginal);
        disabledRoots.removeAll(sourcePath);
        HashSet<String> disabledSourceRoots = new HashSet<String>();
        for (FileObject fo : disabledRoots) {
            disabledSourceRoots.add(SourcePathProviderImpl.getRoot(fo));
        }
        return disabledSourceRoots;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public static String normalize(String path) {
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }

    public static String getRoot(FileObject fileObject) {
        File f = null;
        String path = "";
        try {
            if (fileObject.getFileSystem() instanceof JarFileSystem) {
                f = ((JarFileSystem)fileObject.getFileSystem()).getJarFile();
                if (!fileObject.isRoot()) {
                    path = "!/" + fileObject.getPath();
                }
            } else {
                f = FileUtil.toFile((FileObject)fileObject);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (f != null) {
            return f.getAbsolutePath() + path;
        }
        return null;
    }

    private static FileObject getFileObject(String file) {
        File f = new File(file);
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        String path = null;
        if (fo == null && file.contains("!/")) {
            int index = file.indexOf("!/");
            f = new File(file.substring(0, index));
            fo = FileUtil.toFileObject((File)f);
            path = file.substring(index + "!/".length());
        }
        if (fo != null && FileUtil.isArchiveFile((FileObject)fo)) {
            fo = FileUtil.getArchiveRoot((FileObject)fo);
            if (path != null) {
                fo = fo.getFileObject(path);
            }
        }
        return fo;
    }

    public static int[] createPermutation(String[] roots, Map<String, Integer> orderIndexes, String[] sortedRoots) {
        int i;
        int n = roots.length;
        if (orderIndexes == null) {
            int[] perm = new int[n];
            for (int i2 = 0; i2 < n; ++i2) {
                sortedRoots[i2] = roots[i2];
                perm[i2] = i2;
            }
            return perm;
        }
        class IndexedRoot {
            String root;
            Integer index;
            int order;

            IndexedRoot(String root, Integer index, int order) {
                this.root = root;
                this.index = index;
                this.order = order;
            }
        }
        IndexedRoot[] indexedRoots = new IndexedRoot[n];
        ArrayList<IndexedRoot> indexed = new ArrayList<IndexedRoot>();
        for (int i3 = 0; i3 < n; ++i3) {
            Integer index = orderIndexes.get(roots[i3]);
            indexedRoots[i3] = new IndexedRoot(roots[i3], index, i3);
            if (index == null) continue;
            indexed.add(indexedRoots[i3]);
        }
        class Cmp
        implements Comparator<IndexedRoot> {
            Cmp() {
            }

            @Override
            public int compare(IndexedRoot ir1, IndexedRoot ir2) {
                Integer i1 = ir1.index;
                Integer i2 = ir2.index;
                return i1 - i2;
            }
        }
        Cmp cmp = new Cmp();
        if (indexed.size() == indexedRoots.length) {
            Arrays.sort(indexedRoots, cmp);
        } else if (!indexed.isEmpty()) {
            indexed.sort(cmp);
            int indexedi = 0;
            for (i = 0; i < n; ++i) {
                if (indexedRoots[i].index == null) continue;
                indexedRoots[i] = (IndexedRoot)indexed.get(indexedi++);
            }
        }
        int[] perm = new int[n];
        for (i = 0; i < n; ++i) {
            sortedRoots[i] = indexedRoots[i].root;
            perm[i] = indexedRoots[i].order;
        }
        return perm;
    }

    private ClassPath reorder(ClassPath sourcePath, final Map<String, Integer> orderIndexes) {
        String[] roots = this.getSourceRoots(sourcePath);
        class Cmp
        implements Comparator<String> {
            final /* synthetic */ SourcePathProviderImpl this$0;

            Cmp() {
                this.this$0 = this$0;
            }

            @Override
            public int compare(String o1, String o2) {
                int i1 = (Integer)orderIndexes.get(o1);
                int i2 = (Integer)orderIndexes.get(o2);
                return i1 - i2;
            }
        }
        Cmp cmp = new Cmp();
        Arrays.sort(roots, cmp);
        return SourcePathProviderImpl.createClassPath(roots);
    }

    private static ClassPath createClassPath(String[] roots) {
        int n = roots.length;
        FileObject[] froots = new FileObject[n];
        for (int i = 0; i < n; ++i) {
            froots[i] = SourcePathProviderImpl.getFileObject(roots[i]);
        }
        return SourcePathProviderImpl.createClassPath(froots);
    }

    private static ClassPath createClassPath(FileObject[] froots) {
        ArrayList<PathResourceImplementation> pris = new ArrayList<PathResourceImplementation>();
        for (FileObject fo : froots) {
            if (fo == null || !fo.canRead()) continue;
            try {
                URL url = fo.toURL();
                pris.add(ClassPathSupport.createResource((URL)url));
            }
            catch (IllegalArgumentException iaex) {
                logger.warning(iaex.getLocalizedMessage());
            }
        }
        return ClassPathSupport.createClassPath(pris);
    }

    private static ClassPath createClassPath(URL[] urls) {
        ArrayList<PathResourceImplementation> pris = new ArrayList<PathResourceImplementation>();
        for (URL url : urls) {
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo == null || !fo.canRead()) continue;
            try {
                pris.add(ClassPathSupport.createResource((URL)url));
            }
            catch (IllegalArgumentException iaex) {
                logger.warning(iaex.getLocalizedMessage());
            }
        }
        return ClassPathSupport.createClassPath(pris);
    }

    private ArtifactsUpdatedImpl addArtifactsUpdateListenerFor(JPDADebugger debugger, FileObject src) {
        URL url = src.toURL();
        ArtifactsUpdatedImpl l = new ArtifactsUpdatedImpl(debugger, url, src);
        BuildArtifactMapper.addArtifactsUpdatedListener((URL)url, (BuildArtifactMapper.ArtifactsUpdated)l);
        return l;
    }

    private static List<URL> getURLRoots(ClassPath cp) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassPath.Entry entry : cp.entries()) {
            URL url = entry.getURL();
            urls.add(url);
        }
        return urls;
    }

    private static final class URLCacheMap
    extends LinkedHashMap<String, String> {
        private static final int URL_CACHE_SIZE = 500;

        public URLCacheMap() {
            super(500, 0.1f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() >= 500;
        }
    }

    private class PathRegistryListener
    implements GlobalPathRegistryListener,
    PropertyChangeListener {
        private RequestProcessor rp = new RequestProcessor(PathRegistryListener.class.getName(), 1);
        private RequestProcessor.Task task;
        private List<URL> addedRoots = null;
        private List<URL> removedRoots = null;
        private final Object rootsLock = new Object();

        public PathRegistryListener() {
            this.task = this.rp.create(new Runnable(){

                @Override
                public void run() {
                    PathRegistryListener.this.rootsChanged();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsAdded(GlobalPathRegistryEvent event) {
            List<URL> changedPaths = this.getChangedPaths(event);
            if (changedPaths == null) {
                return;
            }
            Object object = this.rootsLock;
            synchronized (object) {
                if (this.addedRoots == null) {
                    this.addedRoots = changedPaths;
                } else {
                    this.addedRoots.addAll(changedPaths);
                }
            }
            this.task.schedule(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsRemoved(GlobalPathRegistryEvent event) {
            List<URL> changedPaths = this.getChangedPaths(event);
            if (changedPaths == null) {
                return;
            }
            Object object = this.rootsLock;
            synchronized (object) {
                if (this.removedRoots == null) {
                    this.removedRoots = changedPaths;
                } else {
                    this.removedRoots.addAll(changedPaths);
                }
            }
            this.task.schedule(1000);
        }

        private List<URL> getChangedPaths(GlobalPathRegistryEvent event) {
            if (!"classpath/source".equals(event.getId())) {
                return null;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (ClassPath cp : event.getChangedPaths()) {
                for (ClassPath.Entry entry : cp.entries()) {
                    URL url = entry.getURL();
                    urls.add(url);
                }
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rootsChanged() {
            List sourcePaths;
            Object object;
            List<URL> removed;
            List<URL> added;
            Object object2 = this.rootsLock;
            synchronized (object2) {
                added = this.addedRoots;
                removed = this.removedRoots;
                this.addedRoots = null;
                this.removedRoots = null;
            }
            boolean changed = false;
            if (added != null && added.size() > 0) {
                object = SourcePathProviderImpl.this;
                synchronized (object) {
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    sourcePaths = SourcePathProviderImpl.getURLRoots(SourcePathProviderImpl.this.originalSourcePath);
                    sourcePaths.addAll(added);
                    SourcePathProviderImpl.this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new URL[0]));
                    sourcePaths = SourcePathProviderImpl.getURLRoots(SourcePathProviderImpl.this.smartSteppingSourcePath);
                    sourcePaths.addAll(added);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new URL[0]));
                }
                changed = true;
            }
            if (removed != null && removed.size() > 0) {
                object = SourcePathProviderImpl.this;
                synchronized (object) {
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    sourcePaths = SourcePathProviderImpl.getURLRoots(SourcePathProviderImpl.this.originalSourcePath);
                    sourcePaths.removeAll(removed);
                    SourcePathProviderImpl.this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new URL[0]));
                    sourcePaths = SourcePathProviderImpl.getURLRoots(SourcePathProviderImpl.this.smartSteppingSourcePath);
                    sourcePaths.removeAll(removed);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new URL[0]));
                }
                changed = true;
            }
            if (changed) {
                object = SourcePathProviderImpl.this.urlCache;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCache.clear();
                }
                object = SourcePathProviderImpl.this.urlCacheGlobal;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCacheGlobal.clear();
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){
                    final /* synthetic */ PathRegistryListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.propertyChange(evt);
                    }
                });
                return;
            }
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            boolean changed = false;
            Object object = SourcePathProviderImpl.this;
            synchronized (object) {
                if (SourcePathProviderImpl.this.originalSourcePath == null) {
                    return;
                }
                SourcePathProviderImpl.this.platformSourceRoots.clear();
                ArrayList<FileObject> sourcePaths = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                for (JavaPlatform jp : platforms) {
                    FileObject[] roots;
                    for (FileObject fo : roots = jp.getSourceFolders().getRoots()) {
                        if (sourcePaths.contains(fo)) continue;
                        sourcePaths.add(fo);
                        changed = true;
                    }
                    SourcePathProviderImpl.this.platformSourceRoots.addAll(SourcePathProviderImpl.getSourceRootsSet(jp.getSourceFolders()));
                }
                if (changed) {
                    SourcePathProviderImpl.this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new FileObject[0]));
                }
            }
            if (changed) {
                object = SourcePathProviderImpl.this.urlCache;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCache.clear();
                }
                object = SourcePathProviderImpl.this.urlCacheGlobal;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCacheGlobal.clear();
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }
    }

    public static final class FileObjectComparator
    implements Comparator<FileObject> {
        @Override
        public int compare(FileObject fo1, FileObject fo2) {
            String r1 = SourcePathProviderImpl.getRoot(fo1);
            String r2 = SourcePathProviderImpl.getRoot(fo2);
            if (r1 == null) {
                return -1;
            }
            if (r2 == null) {
                return 1;
            }
            return r1.compareTo(r2);
        }
    }

    private static class ArtifactsUpdatedImpl
    implements BuildArtifactMapper.ArtifactsUpdated {
        private Reference<JPDADebugger> debuggerRef;
        private final URL url;
        private FileObject src;

        public ArtifactsUpdatedImpl(JPDADebugger debugger, URL url, FileObject src) {
            this.debuggerRef = new WeakReference<JPDADebugger>(debugger);
            this.url = url;
            this.src = src;
        }

        public URL getURL() {
            return this.url;
        }

        public void artifactsUpdated(Iterable<File> artifacts) {
            String error = null;
            JPDADebugger debugger = this.debuggerRef.get();
            if (debugger == null) {
                error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoJPDADebugger");
            } else if (!debugger.canFixClasses()) {
                error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_CanNotFix");
            } else if (debugger.getState() == 4) {
                error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoDebug");
            }
            boolean canFixClasses = Properties.getDefault().getProperties("debugger.options.JPDA").getBoolean("ApplyCodeChangesOnSave", CAN_FIX_CLASSES_AUTOMATICALLY);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("artifactsUpdated(" + artifacts + ") error = '" + error + "', canFixClasses = " + canFixClasses);
            }
            if (error == null) {
                if (!canFixClasses) {
                    for (File f : artifacts) {
                        String className;
                        FileObject fo = FileUtil.toFileObject((File)f);
                        if (fo == null || (className = ArtifactsUpdatedImpl.fileToClassName(fo)) == null) continue;
                        FixClassesSupport.ClassesToReload.getInstance().addClassToReload(debugger, this.src, className, fo);
                    }
                    return;
                }
                HashMap<String, FileObject> classes = new HashMap<String, FileObject>();
                for (File f : artifacts) {
                    String className;
                    FileObject fo = FileUtil.toFileObject((File)f);
                    if (fo == null || (className = ArtifactsUpdatedImpl.fileToClassName(fo)) == null) continue;
                    classes.put(className, fo);
                }
                FixClassesSupport.reloadClasses(debugger, classes);
            } else {
                BuildArtifactMapper.removeArtifactsUpdatedListener((URL)this.url, (BuildArtifactMapper.ArtifactsUpdated)this);
            }
            if (error != null && canFixClasses) {
                FixClassesSupport.notifyError(debugger, error);
            }
        }

        private static String fileToClassName(FileObject fo) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
            if (cp == null) {
                logger.log(Level.WARNING, "Did not find EXECUTE class path for {0}", fo);
                return null;
            }
            return cp.getResourceName(fo, '.', false);
        }
    }
}

