/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.symfony2.SymfonyVersion;
import org.netbeans.modules.php.symfony2.commands.Bundle;
import org.netbeans.modules.php.symfony2.commands.SymfonyCommandVO;
import org.netbeans.modules.php.symfony2.commands.SymfonyCommandsXmlParser;
import org.netbeans.modules.php.symfony2.ui.options.SymfonyOptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.InputOutput;

public final class SymfonyScript {
    private static final Logger LOGGER = Logger.getLogger(SymfonyScript.class.getName());
    private static final String XML_CHARSET_NAME = "UTF-8";
    private static final String SHELL_INTERACTIVE = "SHELL_INTERACTIVE";
    private static final List<String> CACHE_CLEAR_COMMAND = Arrays.asList("cache:clear", "--verbose");
    private static final List<String> CACHE_WARMUP_COMMAND = Collections.singletonList("cache:warmup");
    private static final List<String> LIST_COMMANDS_COMMAND = Arrays.asList("list", "--format", "xml");
    private static final List<String> DEFAULT_PARAMS = Collections.singletonList("--ansi");
    public static final String SCRIPT_NAME = "console";
    private final String symfony2Path;

    private SymfonyScript(String symfony2Path) {
        this.symfony2Path = symfony2Path;
    }

    @CheckForNull
    public static SymfonyScript forPhpModule(PhpModule phpModule, boolean warn) {
        String error;
        FileObject script;
        String console = null;
        SymfonyVersion symfonyVersion = SymfonyVersion.forPhpModule(phpModule);
        if (symfonyVersion != null && (script = symfonyVersion.getConsole()) != null) {
            console = FileUtil.toFile((FileObject)script).getAbsolutePath();
        }
        if ((error = SymfonyScript.validate(console)) == null) {
            return new SymfonyScript(console);
        }
        if (warn) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_InvalidSymfony2Script(error), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return null;
    }

    public static String validate(String command) {
        return PhpExecutableValidator.validateCommand((String)command, (String)Bundle.SymfonyScript_script_label());
    }

    public void clearCache(PhpModule phpModule) {
        this.runCommand(phpModule, CACHE_CLEAR_COMMAND, null);
    }

    public void cacheWarmUp(PhpModule phpModule) {
        this.runCommand(phpModule, CACHE_WARMUP_COMMAND, null);
    }

    public void runCommand(PhpModule phpModule, List<String> parameters, Runnable postExecution) {
        this.createExecutable(phpModule).displayName(this.getDisplayName(phpModule)).additionalParameters(this.getAllParameters(parameters)).run(this.getDescriptor(postExecution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SymfonyCommandVO> getCommands(PhpModule phpModule) {
        File tmpFile;
        try {
            tmpFile = Files.createTempFile("nb-symfony23-commands-", ".xml", new FileAttribute[0]).toFile();
            tmpFile.deleteOnExit();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        Future result = this.createExecutable(phpModule).fileOutput(tmpFile, XML_CHARSET_NAME, true).additionalParameters(LIST_COMMANDS_COMMAND).run(this.getSilentDescriptor());
        try {
            if (result == null || (Integer)result.get() != 0) {
                this.runCommand(phpModule, LIST_COMMANDS_COMMAND, null);
                return null;
            }
        }
        catch (CancellationException ex) {
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/Symfony2");
            return null;
        }
        ArrayList<SymfonyCommandVO> commandsVO = new ArrayList<SymfonyCommandVO>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), XML_CHARSET_NAME));
            SymfonyCommandsXmlParser.parse(reader, commandsVO);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            if (!tmpFile.delete()) {
                LOGGER.info("Cannot delete temporary file");
            }
        }
        if (commandsVO.isEmpty()) {
            this.runCommand(phpModule, LIST_COMMANDS_COMMAND, null);
            return null;
        }
        return commandsVO;
    }

    private PhpExecutable createExecutable(PhpModule phpModule) {
        return new PhpExecutable(this.symfony2Path).environmentVariables(Collections.singletonMap(SHELL_INTERACTIVE, "true")).workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()));
    }

    private String getDisplayName(PhpModule phpModule) {
        SymfonyVersion symfonyVersion = SymfonyVersion.forPhpModule(phpModule);
        assert (symfonyVersion != null) : phpModule;
        return Bundle.SymfonyScript_command_title(symfonyVersion.getFrameworkName(true), phpModule.getDisplayName());
    }

    private List<String> getAllParameters(List<String> params) {
        ArrayList<String> allParams = new ArrayList<String>(DEFAULT_PARAMS.size() + params.size());
        allParams.addAll(DEFAULT_PARAMS);
        allParams.addAll(params);
        return allParams;
    }

    private ExecutionDescriptor getDescriptor(Runnable postExecution) {
        ExecutionDescriptor executionDescriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(SymfonyOptionsPanelController.getOptionsPath()).inputVisible(true);
        if (postExecution != null) {
            executionDescriptor = executionDescriptor.postExecution(postExecution);
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL);
    }
}

