/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.AttachVolumeDetails;
import com.oracle.bmc.core.model.EncryptionInTransitType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class AttachIScsiVolumeDetails
extends AttachVolumeDetails {
    @JsonProperty(value="useChap")
    private final Boolean useChap;
    @JsonProperty(value="encryptionInTransitType")
    private final EncryptionInTransitType encryptionInTransitType;
    @JsonProperty(value="isAgentAutoIscsiLoginEnabled")
    private final Boolean isAgentAutoIscsiLoginEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AttachIScsiVolumeDetails(String device, String displayName, String instanceId, Boolean isReadOnly, Boolean isShareable, String volumeId, Boolean useChap, EncryptionInTransitType encryptionInTransitType, Boolean isAgentAutoIscsiLoginEnabled) {
        super(device, displayName, instanceId, isReadOnly, isShareable, volumeId);
        this.useChap = useChap;
        this.encryptionInTransitType = encryptionInTransitType;
        this.isAgentAutoIscsiLoginEnabled = isAgentAutoIscsiLoginEnabled;
    }

    public Boolean getUseChap() {
        return this.useChap;
    }

    public EncryptionInTransitType getEncryptionInTransitType() {
        return this.encryptionInTransitType;
    }

    public Boolean getIsAgentAutoIscsiLoginEnabled() {
        return this.isAgentAutoIscsiLoginEnabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttachIScsiVolumeDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", useChap=").append(String.valueOf(this.useChap));
        sb.append(", encryptionInTransitType=").append(String.valueOf((Object)this.encryptionInTransitType));
        sb.append(", isAgentAutoIscsiLoginEnabled=").append(String.valueOf(this.isAgentAutoIscsiLoginEnabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachIScsiVolumeDetails)) {
            return false;
        }
        AttachIScsiVolumeDetails other = (AttachIScsiVolumeDetails)((Object)o);
        return Objects.equals(this.useChap, other.useChap) && Objects.equals((Object)this.encryptionInTransitType, (Object)other.encryptionInTransitType) && Objects.equals(this.isAgentAutoIscsiLoginEnabled, other.isAgentAutoIscsiLoginEnabled) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.useChap == null ? 43 : this.useChap.hashCode());
        result = result * 59 + (this.encryptionInTransitType == null ? 43 : this.encryptionInTransitType.hashCode());
        result = result * 59 + (this.isAgentAutoIscsiLoginEnabled == null ? 43 : this.isAgentAutoIscsiLoginEnabled.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="device")
        private String device;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="isReadOnly")
        private Boolean isReadOnly;
        @JsonProperty(value="isShareable")
        private Boolean isShareable;
        @JsonProperty(value="volumeId")
        private String volumeId;
        @JsonProperty(value="useChap")
        private Boolean useChap;
        @JsonProperty(value="encryptionInTransitType")
        private EncryptionInTransitType encryptionInTransitType;
        @JsonProperty(value="isAgentAutoIscsiLoginEnabled")
        private Boolean isAgentAutoIscsiLoginEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder device(String device) {
            this.device = device;
            this.__explicitlySet__.add("device");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            this.__explicitlySet__.add("isReadOnly");
            return this;
        }

        public Builder isShareable(Boolean isShareable) {
            this.isShareable = isShareable;
            this.__explicitlySet__.add("isShareable");
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            this.__explicitlySet__.add("volumeId");
            return this;
        }

        public Builder useChap(Boolean useChap) {
            this.useChap = useChap;
            this.__explicitlySet__.add("useChap");
            return this;
        }

        public Builder encryptionInTransitType(EncryptionInTransitType encryptionInTransitType) {
            this.encryptionInTransitType = encryptionInTransitType;
            this.__explicitlySet__.add("encryptionInTransitType");
            return this;
        }

        public Builder isAgentAutoIscsiLoginEnabled(Boolean isAgentAutoIscsiLoginEnabled) {
            this.isAgentAutoIscsiLoginEnabled = isAgentAutoIscsiLoginEnabled;
            this.__explicitlySet__.add("isAgentAutoIscsiLoginEnabled");
            return this;
        }

        public AttachIScsiVolumeDetails build() {
            AttachIScsiVolumeDetails model = new AttachIScsiVolumeDetails(this.device, this.displayName, this.instanceId, this.isReadOnly, this.isShareable, this.volumeId, this.useChap, this.encryptionInTransitType, this.isAgentAutoIscsiLoginEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttachIScsiVolumeDetails model) {
            if (model.wasPropertyExplicitlySet("device")) {
                this.device(model.getDevice());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("isReadOnly")) {
                this.isReadOnly(model.getIsReadOnly());
            }
            if (model.wasPropertyExplicitlySet("isShareable")) {
                this.isShareable(model.getIsShareable());
            }
            if (model.wasPropertyExplicitlySet("volumeId")) {
                this.volumeId(model.getVolumeId());
            }
            if (model.wasPropertyExplicitlySet("useChap")) {
                this.useChap(model.getUseChap());
            }
            if (model.wasPropertyExplicitlySet("encryptionInTransitType")) {
                this.encryptionInTransitType(model.getEncryptionInTransitType());
            }
            if (model.wasPropertyExplicitlySet("isAgentAutoIscsiLoginEnabled")) {
                this.isAgentAutoIscsiLoginEnabled(model.getIsAgentAutoIscsiLoginEnabled());
            }
            return this;
        }
    }
}

