from abc import ABC, abstractmethod


class NextcloudSyncWorkerConfiguration(ABC):
    """Nextcloud sync worker configuration interface."""

    @property
    @abstractmethod
    def nextcloud_endpoint(self) -> str:
        """Get Nextcloud endpoint.

        :return: Endpoint
        :rtype: str
        """
        raise NotImplementedError()

    @nextcloud_endpoint.setter
    @abstractmethod
    def nextcloud_endpoint(self, value: str) -> None:
        """Set Nextcloud endpoint.

        :param str value: New value
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def nextcloud_username(self) -> str:
        """Get Nextcloud username.

        :return: Username
        :rtype: str
        """
        raise NotImplementedError()

    @nextcloud_username.setter
    @abstractmethod
    def nextcloud_username(self, value: str) -> None:
        """Set Nextcloud username.

        :param str value: New value
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def nextcloud_prune_threshold(self) -> int:
        """Get Nextcloud prune threshold.

        :return: Threshold
        :rtype: int
        """
        raise NotImplementedError()

    @nextcloud_prune_threshold.setter
    @abstractmethod
    def nextcloud_prune_threshold(self, value: int) -> None:
        """Set Nextcloud prune threshold.

        :param int value: New value
        """
        raise NotImplementedError()
