/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;

public class KeyringFilePublicKeyService
implements PublicKeyService {
    private static final Logger LOGGER = Logging.getLogger(KeyringFilePublicKeyService.class);
    private final File keyRingFile;
    private LoadedKeys keys;

    public KeyringFilePublicKeyService(File keyRingFile) {
        this.keyRingFile = keyRingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedKeys load() {
        KeyringFilePublicKeyService keyringFilePublicKeyService = this;
        synchronized (keyringFilePublicKeyService) {
            if (this.keys == null) {
                try {
                    List<PGPPublicKeyRing> keyrings = SecuritySupport.loadKeyRingFile(this.keyRingFile);
                    HashMap<Fingerprint, PGPPublicKeyRing> keyToKeyringBuilder = new HashMap<Fingerprint, PGPPublicKeyRing>();
                    ImmutableListMultimap.Builder longIdLongPGPPublicKeyBuilder = ImmutableListMultimap.builder();
                    for (PGPPublicKeyRing keyring : keyrings) {
                        Iterator it = keyring.getPublicKeys();
                        while (it.hasNext()) {
                            PGPPublicKey key = (PGPPublicKey)it.next();
                            Fingerprint fingerprint = Fingerprint.of(key);
                            keyToKeyringBuilder.put(fingerprint, keyring);
                            longIdLongPGPPublicKeyBuilder.put((Object)key.getKeyID(), (Object)keyring);
                        }
                    }
                    this.keys = new LoadedKeys((Map<Fingerprint, PGPPublicKeyRing>)ImmutableMap.copyOf(keyToKeyringBuilder), (Multimap<Long, PGPPublicKeyRing>)longIdLongPGPPublicKeyBuilder.build());
                    LOGGER.info("Loaded {} keys from {}", (Object)this.keys.keyToKeyring.size(), (Object)this.keyRingFile);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            return this.keys;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void findByLongId(long keyId, PublicKeyResultBuilder builder) {
        for (PGPPublicKeyRing keyring : this.load().longIdToPublicKeys.get((Object)keyId)) {
            builder.keyRing(keyring);
            Iterator pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pkIt.next();
                if (key.getKeyID() != keyId) continue;
                builder.publicKey(key);
            }
        }
    }

    @Override
    public void findByFingerprint(byte[] bytes, PublicKeyResultBuilder builder) {
        Fingerprint fingerprint = Fingerprint.wrap(bytes);
        PGPPublicKeyRing keyring = (PGPPublicKeyRing)this.load().keyToKeyring.get(fingerprint);
        if (keyring != null) {
            builder.keyRing(keyring);
            Iterator pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pkIt.next();
                if (!Arrays.equals(key.getFingerprint(), bytes)) continue;
                builder.publicKey(key);
            }
        }
    }

    private static class LoadedKeys {
        private final Map<Fingerprint, PGPPublicKeyRing> keyToKeyring;
        private final Multimap<Long, PGPPublicKeyRing> longIdToPublicKeys;

        public LoadedKeys(Map<Fingerprint, PGPPublicKeyRing> keyToKeyring, Multimap<Long, PGPPublicKeyRing> longIdToPublicKeys) {
            this.keyToKeyring = keyToKeyring;
            this.longIdToPublicKeys = longIdToPublicKeys;
        }
    }
}

