# Generated by default/object.tt
package Paws::WorkSpaces::ConnectionAliasAssociation;
  use Moose;
  has AssociatedAccountId => (is => 'ro', isa => 'Str');
  has AssociationStatus => (is => 'ro', isa => 'Str');
  has ConnectionIdentifier => (is => 'ro', isa => 'Str');
  has ResourceId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkSpaces::ConnectionAliasAssociation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkSpaces::ConnectionAliasAssociation object:

  $service_obj->Method(Att1 => { AssociatedAccountId => $value, ..., ResourceId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkSpaces::ConnectionAliasAssociation object:

  $result = $service_obj->Method(...);
  $result->Att1->AssociatedAccountId

=head1 DESCRIPTION

Describes a connection alias association that is used for cross-Region
redirection. For more information, see Cross-Region Redirection for
Amazon WorkSpaces
(https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).

=head1 ATTRIBUTES


=head2 AssociatedAccountId => Str

The identifier of the AWS account that associated the connection alias
with a directory.


=head2 AssociationStatus => Str

The association status of the connection alias.


=head2 ConnectionIdentifier => Str

The identifier of the connection alias association. You use the
connection identifier in the DNS TXT record when you're configuring
your DNS routing policies.


=head2 ResourceId => Str

The identifier of the directory associated with a connection alias.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkSpaces>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

