/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.jdk8.Temporal;
import org.apache.sis.internal.util.ISOCalendar;

public final class StandardDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 1552761359761440473L;
    public static final String UTC = "UTC";
    public static final String SHORT_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss.SSSX";
    private static final int NUM_FRACTION_DIGITS = 3;
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    private boolean isUserSpecifiedPattern;

    public static Date toDate(Temporal temporal) {
        if (temporal == null) {
            return null;
        }
        return new Date(temporal.millis);
    }

    public StandardDateFormat() {
        this(Locale.CANADA);
    }

    public StandardDateFormat(Locale locale) {
        this(locale, TimeZone.getTimeZone(UTC));
    }

    public StandardDateFormat(Locale locale, TimeZone timeZone) {
        super(PATTERN, locale);
        this.calendar = new ISOCalendar(locale, timeZone);
    }

    @Override
    public void applyPattern(String string) {
        super.applyPattern(string);
        this.isUserSpecifiedPattern = true;
    }

    @Override
    public void applyLocalizedPattern(String string) {
        super.applyLocalizedPattern(string);
        this.isUserSpecifiedPattern = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!this.isUserSpecifiedPattern && date.getTime() % 86400000L == 0L && UTC.equals(this.getTimeZone().getID())) {
            try {
                super.applyPattern(SHORT_PATTERN);
                StringBuffer stringBuffer2 = super.format(date, stringBuffer, fieldPosition);
                return stringBuffer2;
            }
            finally {
                super.applyPattern(PATTERN);
            }
        }
        return super.format(date, stringBuffer, fieldPosition);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        if (this.isUserSpecifiedPattern) {
            return super.parse(string, parsePosition);
        }
        int n = parsePosition.getIndex();
        String string2 = StandardDateFormat.dateToISO(string, n, false);
        parsePosition.setIndex(0);
        Date date = super.parse(string2, parsePosition);
        parsePosition.setIndex(StandardDateFormat.adjustIndex(string, string2, n, parsePosition.getIndex()));
        parsePosition.setErrorIndex(StandardDateFormat.adjustIndex(string, string2, n, parsePosition.getErrorIndex()));
        return date;
    }

    public static String dateToISO(CharSequence charSequence, int n, boolean bl) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(30);
        int n2 = 0;
        int n3 = 2;
        boolean bl2 = false;
        boolean bl3 = false;
        block7: while (n < charSequence.length()) {
            char c;
            if ((c = charSequence.charAt(n++)) >= '0' && c <= '9') {
                if (++n2 > 3 && bl2) {
                    continue;
                }
            } else {
                switch (c) {
                    default: {
                        break block7;
                    }
                    case 'T': {
                        if (bl) break block7;
                        bl = true;
                        break;
                    }
                    case ':': {
                        if (!bl | bl2) break block7;
                        --n3;
                        break;
                    }
                    case '.': {
                        if (!bl | bl2 | bl3) break block7;
                        bl2 = true;
                        break;
                    }
                    case '-': {
                        if (!bl) break;
                    }
                    case '+': 
                    case 'Z': {
                        if (!bl | bl3) break block7;
                        if (!bl2) {
                            while (--n3 >= 0) {
                                stringBuilder.append(":00");
                            }
                            stringBuilder.append('.');
                            n2 = 0;
                        }
                        while (n2 < 3) {
                            stringBuilder.append('0');
                            ++n2;
                        }
                        bl2 = false;
                        bl3 = true;
                    }
                }
                if (n2 == 1) {
                    stringBuilder.insert(stringBuilder.length() - 1, '0');
                }
                n2 = 0;
            }
            stringBuilder.append(c);
        }
        if (n2 == 1) {
            stringBuilder.insert(stringBuilder.length() - 1, '0');
        }
        if (!bl3) {
            if (!bl) {
                stringBuilder.append("T00");
            }
            if (!bl2) {
                while (--n3 >= 0) {
                    stringBuilder.append(":00");
                }
                stringBuilder.append('.');
                n2 = 0;
            }
            while (n2 < 3) {
                stringBuilder.append('0');
                ++n2;
            }
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    static int adjustIndex(String string, String string2, int n, int n2) {
        if (n2 < 0) {
            return n2;
        }
        if (!string.isEmpty()) {
            for (int i = 0; i < n2 && (string2.charAt(i) != string.charAt(n) || ++n < string.length()); ++i) {
            }
        }
        return n;
    }
}

