package Number::ZipCode::JP::Table::Company;

use strict;
use warnings;

our $VERSION = '0.20230929';

# Table last modified: 2023-09-29
our %ZIP_TABLE = (
    '001' => '(?:8(?:5(?:[0-2]1|55|77|88)|612))',
    '002' => '(?:850[1-4])',
    '003' => '(?:8(?:5(?:20|58|77|8[0-258]|0[1-5]|3[01]|1[0159]|6[67])|6(?:[24]0|01|68|3[019]|1[02])|70[12]))',
    '004' => '(?:8(?:5(?:[67]7|23|0[23]|1[028]|[58][58]|3[0-3])|6(?:[34]1|[68]6|29|0[23]|1[0-368])))',
    '005' => '(?:8(?:5(?:[58]5|01|43)|6(?:12|0[12])|798))',
    '006' => '(?:8(?:5(?:[58]5|61)|612))',
    '007' => '(?:8(?:5(?:11|53|85|0[13578])|632|733))',
    '010' => '(?:(?:8(?:5(?:43|3[03]|2[05]|1[158]|6[045]|[58][08]|0[124-7]|7[0247])|6(?:[01]1|22|33|55|68|7[78])|794)|0(?:49[2-4]|[15]95)|1(?:49[23]|292)))',
    '011' => '(?:8(?:5(?:[58]5|01|20|77|1[01])|6(?:05|11|86)))',
    '012' => '(?:8(?:5(?:11|0[12])|6(?:51|0[14])))',
    '013' => '(?:(?:8(?:5(?:92|0[1-4])|60[129])|0498))',
    '014' => '(?:(?:0(?:39[2-4]|[25]92)|8(?:50|6[01])1|1(?:192|298)))',
    '015' => '(?:(?:8(?:5(?:30|43|67|85|1[015]|5[58]|0[15])|6(?:[24]2|11|30|66|0[12]|8[68]))|0295))',
    '016' => '(?:8(?:5(?:01|55)|60[12]))',
    '017' => '(?:(?:8(?:5(?:10|67|85|5[05])|686)|029[23]))',
    '018' => '(?:(?:1(?:39[23]|59[56]|79[23]|692)|3(?:59[2356]|39[23]|192)|0(?:49[23]|[16]92|795)|4(?:69[23]|392|494)|5(?:79[23]|292)|2498))',
    '019' => '(?:(?:1(?:397|692)|2[146]92|079[23]))',
    '020' => '(?:(?:8(?:5(?:3[0-38]|8[04-68]|1[0-358]|0[124578]|2[0-35-7]|6[0167]|7[0357]|4[034]|5[013578])|6(?:33|41|7[278]|2[02]|6[167]|5[05]|1[0-2]|8[68]|0[1256])|794)|0(?:1(?:8[2457]|9[68])|69[0-48]|59[2356]|49[56])))',
    '021' => '(?:8(?:5(?:11|44|55|66|77|0[1-46])|6(?:04|11|33|87)))',
    '022' => '(?:8(?:5(?:12|0[1-578])|602))',
    '023' => '(?:(?:049[23]|1192|8501))',
    '024' => '(?:(?:85(?:20|55|0[15-7]|1[0138])|0(?:19[2-5]|392)))',
    '025' => '(?:(?:8(?:60[12]|501)|039[2-5]))',
    '026' => '(?:8(?:5(?:50|67)|686))',
    '027' => '(?:(?:850[1-3]|0595))',
    '028' => '(?:(?:8(?:0(?:4[02]|3[01])|392|696)|7(?:39[2-7]|[15]92|995)|4(?:39[358]|19[35])|(?:0[135]|1[13])92|6(?:19[23568]|892)|3(?:69[2457]|392)|5495))',
    '029' => '(?:(?:4(?:19[245]|29[23]|59[23])|2(?:29[23]|396)|(?:01|56)92))',
    '030' => '(?:(?:8(?:5(?:3[03]|7[047]|8[058]|0[235]|[14][0135]|5[02-8]|2[0-4]|6[0167])|6(?:04|22|49|55|77|86|6[78]|1[01]))|01(?:9[26-8]|8[013-68])|1(?:49[26]|393|798)))',
    '031' => '(?:8(?:5(?:20|4[3-5]|3[38]|5[0158]|7[07]|8[58]|0[1457]|1[01])|6(?:55|86|1[17]|0[18])))',
    '033' => '(?:86(?:04|66|88))',
    '034' => '(?:(?:8(?:6(?:05|28|1[358])|5(?:65|78))|039[238]))',
    '035' => '(?:8686)',
    '036' => '(?:(?:8(?:5(?:11|22|45|77|0[1-3]|6[0-47]|5[0158]|8[58]|3[038])|6(?:01|42|55|66|8[689])|7(?:77|88))|1(?:59[23]|393|492)|039[26]))',
    '037' => '(?:(?:86(?:01|55|86)|0392))',
    '038' => '(?:(?:3(?:19[2-5]|39[2-4]|[68]92|595)|85(?:[08]5|[56]0)|0(?:19[24]|292)|139[23]|279[23]))',
    '039' => '(?:(?:2(?:2(?:9[23]|8[0-35-79])|59[2-578]|49[23]|79[23]|[13]92|696)|11(?:9[237]|8[0159])|0(?:[258]92|19[58])|4(?:29[23]|495|692)|3393))',
    '040' => '(?:8(?:5(?:77|3[03]|4[13]|5[0-258]|2[02]|8[0158]|1[0-2]|0[125]|6[017])|6(?:55|70|4[02]|[68][068]|3[12]|0[1-359]|1[016])|7(?:[12][07])))',
    '041' => '(?:(?:8(?:5(?:01|40|77|2[23]|8[89]|1[0-25]|6[07]|5[1-8])|6(?:[23]3|48|55|80|1[01])|711)|1(?:19[2-6]|49[6-8]|[36]92)))',
    '042' => '(?:8(?:5(?:[01]1|55|67|8[58])|6(?:39|42|78)))',
    '043' => '(?:(?:8(?:5(?:58|60)|6(?:09|51))|0[45]95|1498))',
    '044' => '(?:(?:85(?:44|88)|029[256]))',
    '045' => '(?:8(?:555|609))',
    '046' => '(?:(?:0(?:59[2-4]|19[24]|292)|8(?:5(?:46|55)|686)))',
    '047' => '(?:(?:8(?:5(?:[26]0|19|0[1-3]|5[058]|8[58])|6(?:77|86|0[19]|6[036])|794)|0(?:29[28]|192)))',
    '048' => '(?:(?:1(?:39[2-6]|59[25])|2(?:49[23]|292)|0192))',
    '049' => '(?:(?:0(?:69[23578]|19[23])|4(?:39[37]|59[25])|1(?:59[2-4]|392)|2(?:39[2-4]|192)|3(?:19[278]|592)|5[468]92))',
    '050' => '(?:8(?:5(?:[57]0|1[018]|8[258])|725))',
    '051' => '(?:85(?:24|30|46|5[058]|8[58]|1[12]|0[15]))',
    '052' => '(?:8(?:5(?:11|8[56])|6(?:[68]6|50)))',
    '053' => '(?:8(?:5(?:11|22|33|55|70|88|4[01]|0[56])|6(?:09|66|1[19]|5[34])|7(?:11|22)))',
    '054' => '(?:8660)',
    '055' => '(?:019[235])',
    '056' => '(?:8650)',
    '057' => '(?:85(?:11|58))',
    '058' => '(?:(?:0292|8501))',
    '059' => '(?:(?:1(?:39[2-6]|59[2-6]|69[23]|292)|0(?:59[2568]|99[3578]|49[236])|2(?:[14]92|598)|8[67]01|3195))',
    '060' => '(?:8(?:5(?:[38]\d|4[1-9]|[12][0-35-9]|6[0135-9]|7[02-9]|0[1-68]|5[0-46-9])|6(?:1\d|5[14-68]|8[6-8]|7[016-8]|0[1-9]|6[16-8]|2[1-57-9]|4[0-46-9]|3[0-24-9])|7(?:11|67|2[015]|9[5-7]|7[46]|0[35-7])|406))',
    '061' => '(?:(?:1(?:39[2-6]|49[236-8]|19[256])|0(?:29[2356]|59[25]|692)|3(?:29[2-6]|197|692)|2292|8501))',
    '062' => '(?:8(?:6(?:86|1[278]|0[1-357-9]|3[0135]|2[24]|4[12]|6[68])|5(?:01|20|7[025]|1[013467]|5[58]|3[029])))',
    '063' => '(?:8(?:5(?:22|0[17]|5[58]|[18][05])|6(?:0[1-36-8]|1[12]|4[15])))',
    '064' => '(?:8(?:5(?:2[1-46]|1[024-689]|6[0-7]|4[0-356]|5[014-8]|8[169]|0[23569]|7[0157]|3[35-7])|6(?:09|2[0-2489]|4[4589]|1[01]|3[039])|798))',
    '065' => '(?:8(?:5(?:[34]3|22|67|78|1[018]|5[058]|0[18])|6(?:0[19]|3[139]|1[0-2])))',
    '066' => '(?:8(?:5(?:20|33|1[025]|7[07]|6[67]|8[58]|5[0578]|0[1248])|6(?:01|22|49|55|86|3[379]|6[068]|1[01])|7(?:11|65|87)))',
    '067' => '(?:8(?:5(?:[05]1|47|85|6[45])|674))',
    '068' => '(?:(?:8(?:6(?:[03]9|42|50|6[068]|8[68])|5(?:11|88|5[058]))|1(?:19[2-5]|292)|0(?:194|492)|219[2-4]))',
    '069' => '(?:(?:1(?:29[236-8]|39[2-5])|85(?:[01]1|[58]5|33)|029[23]))',
    '070' => '(?:8(?:6(?:[02]1|[67][06]|1[0-26]|5[013]|8[068]|3[069]|4[0-24])|5(?:[35]0|2[015]|0[2357]|6[07]|1[05]|4[01])|7(?:01|70|2[02]|1[01])))',
    '071' => '(?:(?:0(?:19[28]|29[28]|59[67]|79[58])|1(?:49[2-7]|29[2358]|59[236])))',
    '072' => '(?:8660)',
    '073' => '(?:(?:8(?:5(?:85|0[12]|1[01])|68[68])|0(?:19[25-8]|[24]92)))',
    '074' => '(?:(?:8(?:6(?:50|86)|585)|049[2-5]))',
    '075' => '(?:8(?:50|71)1)',
    '076' => '(?:8(?:5(?:11|55)|6(?:09|66)|765))',
    '077' => '(?:(?:8(?:6(?:01|60|86)|5[01]1)|029[2356]))',
    '078' => '(?:(?:1(?:79[235-7]|49[235]|39[35])|85(?:55|1[013]|0[1-7])|4(?:19[346-8]|492)|3(?:39[2-4]|792)|2(?:19[23]|692)|039[27]))',
    '079' => '(?:(?:8(?:5(?:85|1[136]|5[05]|0[1357-9])|6(?:5[0-26]|1[0-3]))|0(?:39[2-47]|19[278]|59[235])|1(?:39[367]|192)))',
    '080' => '(?:(?:8(?:5(?:[67]0|0[1-3]|1[0158]|8[58]|5[05]|3[18])|6(?:23|39|42|55|6[06]|0[19]|7[07]|8[068])|7(?:[01][18]))|1(?:49[23]|292)|249[235-8]|019[6-8]))',
    '081' => '(?:(?:029[2-5]|8501))',
    '082' => '(?:865[01])',
    '083' => '(?:8(?:585|650))',
    '084' => '(?:8(?:5(?:[01]1|55|67)|6(?:70|86)))',
    '085' => '(?:(?:8(?:5(?:67|1[0-25]|3[35]|2[27]|5[01578]|8[01568]|0[125])|6(?:[34]9|77|5[05]|6[08]))|029[23]))',
    '086' => '(?:1(?:89[23]|197))',
    '087' => '(?:(?:8(?:5(?:55|88)|6(?:09|86)|711)|0192))',
    '088' => '(?:(?:0(?:39[2-5]|59[258]|19[23]|692)|1(?:19[235]|592)|3(?:29[23]|395)|259[23]))',
    '089' => '(?:(?:1(?:19[28]|39[25]|59[25]|795)|0(?:19[258]|59[258]|69[23])|2(?:69[235-7]|195|492)|5(?:39[23]|69[25])|3(?:392|797)))',
    '090' => '(?:8(?:5(?:40|3[23]|[58][058]|6[07]|1[189]|0[1-379])|6(?:[18]0|42|66|5[025])|7(?:01|2[239]|1[01])))',
    '091' => '(?:(?:019[2-4]|8666))',
    '092' => '(?:(?:8(?:65[01]|501)|0292))',
    '093' => '(?:(?:8(?:6(?:[01]9|[57]0|8[06])|5(?:[58]5|44)|7(?:28|1[01]))|0(?:59[2-4]|292)))',
    '094' => '(?:8(?:7(?:0[1-9]|1[02-7])|6(?:4[1-6]|0[129])|55[134]))',
    '095' => '(?:(?:86(?:09|86)|0492))',
    '096' => '(?:8(?:5(?:11|8[45]|5[58]|0[18])|6(?:[68]6|09|41)))',
    '097' => '(?:8(?:5(?:10|85|5[58]|2[57])|6(?:[03]9|[68]6|78)))',
    '098' => '(?:(?:5(?:[78]92|298|595)|(?:28|62|0[13])92|1(?:69[23]|792)|339[23568]))',
    '099' => '(?:(?:2(?:19[2-8]|49[235]|392)|1(?:49[2568]|19[78]|595)|3(?:29[23]|69[78])|4(?:19[256]|492)|(?:56|65)92|049[245]))',
    '100' => '(?:(?:8(?:9(?:4[015]|3[0-37]|6[0-2457-9]|8[0-3679]|9[46]|2[0-24679]|1[02-9]|0[1-579]|5[0-35689]|7[013-9])|1(?:7[2468]|1[0137-9]|8[124-9]|2[013-8]|0[1-57-9]|6[05689]|4[0-24]|5[0-24589]|3[0-69])|2(?:28|51|70|0[1357]|8[2358]|3[2-5]|1[4-69]|4[156]|6[0258])|3(?:70|5[015]|2[1245]|0[2367]|4[15]|1[01]|3[1-358]|8[038])|5(?:11|33|4[03]|5[058]|6[07]|8[58]|7[57]|2[0-2]|0[235-7])|6(?:55|2[019]|3[19]|6[356]|7[67]|1[07]|0[126]|4[049])|4(?:02|5[06]|1[015]|3[09]|2[147]|[48][48])|0(?:19|5[015]|7[07-9]|8[068]|6[56])|79[1-4])|6(?:1(?:62|7[0-57]|5[0-2])|2(?:55|77|6[02])|0(?:51|66|80)|75[1-6])|149[28]))',
    '101' => '(?:8(?:4(?:1[0568]|6[0-246]|7[057]|4[13-68]|3[0379]|8[05]|0[58]|5[0169]|2[1-59])|6(?:8[28]|0[356]|5[146]|6[578]|3[01367]|7[026]|4[235-8]|2[146-9]|1[01679])|5(?:3[0-245]|6[1258]|7[59]|4[28]|1[25]|0[249]|8[0569]|2[0-578]|5[24589])|3(?:6[26]|8[38]|5[013-589]|4[367]|0[17-9]|3[3568]|1[0138]|2[3-69]|7[258])|7(?:0[137]|1[0-25-8])|9(?:41|50|7[37]|8[36])|2(?:28|0[14]|1[0359])|0(?:11|5[04]|0[128])|1(?:01|89)))',
    '102' => '(?:8(?:1(?:2[02-58]|8[124-8]|5[0-25]|3[0-289]|0[1-39]|7[0-25-8]|9[0-5]|4[0-24]|6[016]|1[0-257-9])|5(?:0[2-468]|4[013]|5[2-9]|7[01378]|3[0-39]|2[02589]|1[0-3569]|6[013-79]|8[023568])|6(?:3[0-3579]|4[2-5]|2[0-26-8]|8[0589]|7[17-9]|1[0-47-9]|5[0156]|6[06-8]|0[1-4679])|4(?:7[047]|6[0-24-68]|5[0-259]|0[124-7]|4[0158]|2[0146]|8[489]|3[037]|1[01479])|2(?:5[015]|7[2357]|3[0-24-68]|6[045]|8[28]|2[1-68]|[01][15]|4[016])|3(?:7[0-37]|3[1-36]|2[124]|1[0134]|8[1-38]|6[24]|4[139]|5[0367]|0[1359])|0(?:30|77|8[0-358]|2[256]|5[05]|0[58]|1[125689])|7(?:30|9[58])))',
    '103' => '(?:8(?:4(?:7[0-3]|0[1-57]|6[0-24-68]|4[38]|3[0-589]|1[0-79]|2[24-7]|8[024578]|5[016])|2(?:5[0-2569]|3\d|6[01356]|7[036-8]|0[1-68]|8[2457]|1[0-248]|2[124589]|4[013578])|3(?:70|0[1378]|8[0348]|4[15-7]|1[1-478]|5[0-248]|6[036]|3[01357-9]|2[13-58])|5(?:1[0-257]|5[12468]|7[17]|0[1-36]|2[0-25]|6[67]|8[4-68]|3[4-8]|4[238])|6(?:40|5[0136]|3[169]|7[67]|6[068]|8[0469])|0[01]1))',
    '104' => '(?:(?:8(?:1(?:2[2-589]|5[018]|6[12578]|4[25]|8[389]|7[014-689]|3[0-589]|1[0-24-8]|0[124589])|3(?:1[023579]|7[07-9]|2[458]|8[013689]|6[35]|5[0167]|3[02358]|4[0-5]|0[12467])|5(?:1[028]|8[01458]|2[136-8]|5[014-689]|6[068]|3[03689]|4[35-8]|0[1256])|4(?:3[013589]|5[056]|1[369]|0[124-8]|8[168]|2[0-469]|6[08]|4[02-49])|2(?:38|40|71|6[26]|5[124578]|0[568]|8[0-59]|1[0-28])|6(?:14|78|5[06]|8[05]|6[15])|0(?:55|77|1[01]|0[1-37]))|6241))',
    '105' => '(?:(?:8(?:4(?:7[0-257]|8[2-6]|5[1-36-8]|3[13-7]|[46][014-9]|2[0347-9]|1[0-24-9]|0[1-378])|5(?:6[03578]|1[0-2568]|0[1-357-9]|5[013-8]|8[0-57-9]|7[4-9]|2[1-57-9]|3[0457]|4[03-6])|6(?:7[026-8]|3[04]|8[01569]|6[0568]|1[013-5]|2[0135-7]|5[468]|4[0-24]|0[3468])|3(?:3[01358]|0[1-8]|2[0235]|1[0-57-9])|0(?:10|39|55|0[1258]|7[07]|8[58])|7(?:88|0[127]|1[267]))|7(?:0(?:[58]0|77)|36[5-7]|444)|6[09]50))',
    '106' => '(?:(?:8(?:5(?:6[0-35-79]|0[78]|3[17]|1[458]|7[135-8]|2[12]|5[0-25689]|4[145]|8[0157-9])|6(?:77|4[0-2489]|5[25]|1[16]|6[58]|3[0569]|0[18]|2[0256])|0(?:11|39|0[17])|(?:10|79)7|4(?:01|87))|6(?:1(?:61|88)|06[06])))',
    '107' => '(?:8(?:4(?:20|34|5[06]|0[1-4]|7[17]|8[24]|1[0-246-9]|4[08]|6[038])|5(?:[37]2|81|1[14]|0[2578]|2[0178]|6[037]|5[0268]|4[56])|6(?:01|50|66|1[5-79]|7[46]|3[0-3689]|8[068]|2[0357])|3(?:60|4[0289]|7[013]|2[0346]|8[048]|3[026]|5[125])|0(?:[16]0|77|0[16])|797))',
    '108' => '(?:(?:8(?:5(?:2[0-35]|4[0358]|3[02369]|0[1-9]|6[0468]|1[0-25]|7[0135]|5[0-35-8]|8[0-3568])|3(?:2[25689]|1[0356]|7[2359]|8[013-689]|3[34]|5[058]|6[01]|4[15]|0[13578])|2(?:8[028]|2[0-245]|7[056]|4[0-38]|1[0-25-7]|0[1-36-9]|3[0-4]|5[05])|4(?:56|0[3-57]|2[013-5]|7[078]|1[014-7]|3[29]|6[68]|4[48])|6(?:50|1[0-25-7]|2[28]|3[1-3689]|0[267]|4[0-28])|0(?:[258]0|[17]1|0[15])|7(?:07|1[03])|11[78])|63(?:50|63)))',
    '109' => '(?:8792)',
    '110' => '(?:8(?:5(?:6[0-25-7]|4[01368]|7[5-8]|3[0-4679]|0[1-3579]|1[0135-7]|5[059]|8[02-468]|2[024])|6(?:53|2[0-2568]|6[0259]|3[0158]|4[124-6]|0[259]|8[015-7]|1[04589]|7[35-8])|7(?:8[027]|1[2-6]|2[235]|3[36]|0[68])|408|807))',
    '111' => '(?:8(?:6(?:3[01379]|[12][0-258]|7[6-8]|8[1368]|0[2568]|6[16]|5[05]|4[0248])|5(?:43|1[0-258]|8[058]|5[1568]|7[57]|6[0167]|2[125]|0[125-8]|3[0-59])|7(?:[56]5|21|98|0[178]|1[01])|081))',
    '112' => '(?:8(?:6(?:90|6[02-48]|4[245]|2[02579]|1[0-289]|7[01578]|5[0-57]|8[0-578]|0[14679]|3[0-5])|5(?:[78][0356]|4[018]|2[458]|1[124]|6[2369]|3[0138]|0[1-35689]|5[015-8])|7(?:[156]0|78|0[12])|0(?:[01]1|88)|138))',
    '113' => '(?:8(?:4(?:4[148]|7[1479]|8[3-58]|2[0-3]|1[0-358]|6[2-6]|3[13-5]|5[0169]|0[1248])|5(?:70|0[13-579]|3[04-68]|6[0-46]|4[1369]|1[02379]|2[0145]|5[1356])|6(?:77|3[38]|5[04-8]|0[1-468]|8[16]|1[0-2]|6[0-378])|7(?:01|1[0-29])|139|311))',
    '114' => '(?:8(?:5(?:95|0[1-35-8]|8[013-58]|6[0-25]|2[0-468]|7[147]|4[01356]|5[02-57]|3[0-24589]|1[02457-9])|6(?:11|86|0[2-6])))',
    '115' => '(?:8(?:5(?:55|8[568]|1[01]|2[49])|(?:00|71)1|6(?:22|50)))',
    '116' => '(?:8(?:5(?:71|6[127]|2[1-4]|5[0-46]|8[014-8]|4[0134689]|0[1-3578]|3[237])|621))',
    '120' => '(?:8(?:5(?:44|81|5[014-68]|0[17]|1[02]|7[05]|2[068]|3[0469])|60[12]))',
    '121' => '(?:8(?:5(?:77|1[025]|0[458]|8[58]|5[05]|2[01])|6(?:82|3[39]|1[01])|7(?:11|29)|080))',
    '123' => '(?:85(?:[58]8|40|1[1247]|0[135-9]))',
    '124' => '(?:85(?:60|77|2[04]|3[03589]|0[1-39]|8[58]|5[05]|1[01]))',
    '125' => '(?:8(?:5(?:0[3-8]|8[58]|1[1-47]|2[026])|601))',
    '130' => '(?:8(?:5(?:8[03-58]|2[0-258]|7[057]|3[013-589]|5[3-8]|4[3568]|6[135-7]|0[13-9]|1[0-8])|6(?:25|86|7[17]|3[367]|5[05]|6[068]|1[125]|0[1-689]|4[024])|7(?:[12]0|0[16])))',
    '131' => '(?:8(?:5(?:65|1[0-389]|3[03]|2[0467]|8[458]|5[05]|0[1357-9])|139|634|711))',
    '132' => '(?:8(?:5(?:[18]5|33|5[015]|0[137]|6[27])|6(?:01|74|[68][68])|7(?:11|3[029])))',
    '133' => '(?:8(?:5(?:[01]1|8[05]|5[238])|70[46]))',
    '134' => '(?:8(?:5(?:[15]5|20|33|7[05-7]|8[5-8]|0[237])|6(?:22|86|[14][02]|0[1-39]|3[01])|702))',
    '135' => '(?:8(?:5(?:48|7[057-9]|5\d|3[0-358]|2[1-3578]|8[1257]|1[0-478]|0[12458]|6[035-8])|4(?:4[0358]|2[27]|0[24]|5[18]|8[0-2]|7[037]|6[014]|1[15]|3[026])|6(?:86|0[28]|2[0-25]|6[168]|3[0-29]|7[078]|1[014-9]|5[059])|3(?:[25]0|8[3-57]|0[1368]|7[05]|6[023]|3[01]|1[0-28])|1(?:[46]5|21|50|78|1[01458]|0[89]|3[0479]|8[01])|7(?:97|3[0-3]|2[0-37]|0[17]|1[0178])|2(?:10|2[24])|0(?:74|80)))',
    '136' => '(?:8(?:5(?:3[135]|4[03]|5[056]|8[01589]|1[2357]|7[057]|6[07]|0[1257]|2[1-35])|6(?:51|8[06]|1[25]|[37][0157]|2[0267]|6[68]|4[08]|0[3578])|7(?:[23]3|11)|88[08]|405|908))',
    '137' => '(?:8(?:6(?:23|86)|08[18]|581))',
    '140' => '(?:8(?:5(?:90|4[0137-9]|3[0136-9]|7[1-46]|8[0346]|6[0367]|2[1-3569]|0[235-9]|5[1248]|1[1256])|6(?:4[04]|3[0147]|6[013689]|2[13568]|7[025-8]|5[03-68]|0[12]|8[0278]|1[14-79])|7(?:88|1[015-7]|2[12]|0[279])|810))',
    '141' => '(?:8(?:6(?:3[017-9]|0[2-79]|8[048]|6[03-5]|2[03679]|1[01356]|7[1-379]|4[0-46-8]|5[06-8])|5(?:34|4[04]|6[0-25-9]|5[59]|2[0-25]|0[13-57]|1[02579]|8[0-248]|7[267])|4(?:8[78]|1[1-3689]|2[0-6])|2(?:14|55|60|0[1-6])|7(?:1[056]|0[17])|001|924))',
    '142' => '(?:8(?:5(?:[01]1|33|40|5[058])|6(?:11|66)|777))',
    '143' => '(?:85(?:70|5[02578]|3[013589]|2[0158]|8[05]|6[0578]|1[13-5]|0[2457-9]|4[014]))',
    '144' => '(?:8(?:5(?:44|66|5[015]|8[018]|7[057]|2[25]|3[1-356]|1[01356]|0[56])|6(?:02|11|5[056]|7[78]|2[1-36]|6[016])))',
    '145' => '(?:85(?:[23]3|58|66|0[16]|1[15]))',
    '146' => '(?:8(?:5(?:22|31|67|0[135]|5[158]|8[058]|1[0-25]|7[67]|4[034])|6(?:[03]1|10|77|2[03]|5[056]|6[68])))',
    '150' => '(?:8(?:5(?:45|6[37]|2[256]|0[1-357-9]|7[57]|8[578]|1[0-24-7]|5[1-5]|3[038])|3(?:19|4[03]|7[37]|3[0368]|0[17]|8[45]|2[24-8]|5[05]|6[036])|4(?:12|36|55|0[289]|8[28]|4[08])|9(?:02|11|40|55|67|2[35]|3[258])|0(?:[08]1|1[059])|6(?:88|7[237])))',
    '151' => '(?:8(?:5(?:[34]\d|0[2-79]|5[024589]|1[016-9]|6[1-35-9]|2[0-57-9]|9[0-2]|7[0-46-8]|8[02-7])|6(?:5[1-3]|7[1-7]|0[01])|40[14]|070))',
    '152' => '(?:8(?:5(?:61|4[149]|2[0-257]|0[36-8]|7[08]|1[01]|5[0-28]|3[1-35])|9(?:1[03]|0[24579])|6[02]1))',
    '153' => '(?:8(?:5(?:7[1378]|2[0-356]|6[057]|5[0-68]|4[0135]|8[0-25-79]|0[1-68]|1[02568]|3[01679])|6(?:01|40|1[06]|8[78]|6[025689]|2[026]|5[02-57]|3[013568]|7[017])|9(?:1[134]|0[246]|2[357]|3[034679])))',
    '154' => '(?:8(?:5(?:8[0-245]|4[3-5]|3[02369]|6[05-8]|2[0135]|0[3-69]|5[1-5]|1[0156]|7[017])|7(?:03|32)))',
    '155' => '(?:86(?:10|26|33|55|6[38]))',
    '156' => '(?:8(?:5(?:33|55|88|0[246]|2[02]|1[01])|666))',
    '157' => '(?:85(?:43|50|6[1-35-7]|3[05]|0[18]|2[0-2]|7[0357]|1[01]))',
    '158' => '(?:8(?:5(?:3[1349]|5[0-278]|8[0568]|1[0-48]|6[167]|4[349]|2[0235]|7[578]|0[1-3589])|6(?:40|66|3[0-3]|2[28]|1[05]|0[12])|7[07]1))',
    '160' => '(?:8(?:3(?:89|7[3-58]|3[01468]|1[1369]|[24][17]|6[168]|5[1-38]|0[1469])|4(?:50|72|1[015]|3[03]|2[0239]|6[136]|4[147]|8[4-9]|0[1-37-9])|5(?:65|1[0-2569]|4[37]|0[17]|8[0-37-9]|2[0-249]|3[05]|7[157])|0(?:[01]1|70)|6(?:01|80)|8(?:01|12)|910))',
    '161' => '(?:8(?:5(?:08|11|75|3[19]|6[057]|5[236-8]|4[0156]|2[0-28])|710))',
    '162' => '(?:8(?:6(?:[78]0|1[24-6]|2[0468]|5[04-6]|[36][689]|4[046]|0[1248])|4(?:33|5[015]|6[04]|4[058]|7[1368]|8[048]|0[27]|2[12]|1[125])|5(?:75|4[03]|[16][25]|0[235]|3[05]|8[57]|5[16-8])|8(?:30|5[03]|0[1-8]|6[01])|0(?:55|60|2[0-2]|0[15])|7(?:0[17]|1[016-8])|953))',
    '163' => '(?:(?:0(?:5(?:5[378]|7[056]|6[0269])|6(?:7[5-7]|5[59]|6[359])|8(?:50|67|3[136])|2(?:78|87|6[18])|9(?:43|3[68])|4(?:56|78)|7[27]7)|1(?:3(?:50|63|71|4[59]|8[28])|0(?:7[13]|6[156]|5[35])|4(?:55|70|88)|5(?:88|3[37]))|8(?:6(?:02|80|2[06]|3[89]|7[17]|6[016])|0(?:0[13]|8[0-2]|1[29])|5(?:35|48))))',
    '164' => '(?:8(?:6(?:[25]0|66|8[26]|7[78]|1[167]|4[24]|[03][18])|5(?:[37]0|12|67|4[015]|2[25]|8[58]|5[05]|0[13-5])|7(?:25|0[15])))',
    '165' => '(?:8(?:(?:63|78)0|555))',
    '166' => '(?:85(?:20|88|0[1-3]|6[5-7]|4[025]|3[1-357-9]|7[078]))',
    '167' => '(?:8(?:5(?:[26]0|34|85|0[15-7]|1[05]|5[15])|6(?:10|28|0[12])|001))',
    '168' => '(?:8(?:5(?:[6-8]0|48|1[0-26]|5[058]|2[05]|0[13468]|3[035])|6(?:2[06]|[18][16]|0[18])|081))',
    '169' => '(?:8(?:5(?:8[06]|0[39]|2[0-25-7]|5[0568]|1[6-8]|6[18]|7[078]|4[01]|3[15])|6(?:39|77|5[05]|0[58]|1[0-36]|[46][48])|0(?:50|77|1[12])|7(?:[01]1|22)|(?:88|91)5|228))',
    '170' => '(?:(?:8(?:4(?:1[015-79]|7[0467]|2[013467]|0[124-69]|4[0-248]|5[015-9]|6[0256]|8[08]|3[02-468])|6(?:[68]6|55|0[25]|3[35])|0(?:55|73)|5(?:51|85))|6080))',
    '171' => '(?:8(?:5(?:5[23578]|3[19]|7[027]|4[045]|2[0-35-7]|1[0-2468]|6[0189]|0[1-3578]|8[0268])|422))',
    '173' => '(?:8(?:5(?:[06]1|[23]0|4[03]|1[0-25-9]|8[058]|5[258])|6(?:48|3[29]|1[01]|0[1256])|710))',
    '174' => '(?:8(?:5(?:[13]0|0[135]|6[027]|5[058]|2[014-6]|8[08])|6(?:12|46|51|3[0369]|8[068]|0[12])|7(?:[01]1|87|3[079]|4[0134])|860|903))',
    '175' => '(?:85(?:71|88))',
    '176' => '(?:85(?:[46]0|85|2[12568]|3[013-6]|0[1-37-9]|1[125-8]))',
    '177' => '(?:85(?:21|0[1-389]))',
    '178' => '(?:8(?:5(?:11|67|0[12])|6(?:[68]6|01|24)))',
    '179' => '(?:8(?:9(?:0[134679]|1[14])|501))',
    '180' => '(?:8(?:5(?:66|80|1[79]|2[027]|7[17]|3[138]|0[58])|6(?:29|33|1[018]|0[28])|7(?:50|77)))',
    '181' => '(?:8(?:5(?:41|67|3[135]|7[17]|8[568]|2[128]|1[178]|0[35]|5[15])|6(?:22|33|48|1[124]|0[18])|001))',
    '182' => '(?:8(?:5(?:08|67|70|85|2[025]|5[58]|1[0-2])|6(?:21|86|0[12])|00[16]))',
    '183' => '(?:8(?:5(?:61|70|85|1[1-469]|2[124-689]|5[013]|3[02469]|4[0189]|0[1256])|70[1-35-7]))',
    '184' => '(?:8(?:5(?:[34]3|22|95|1[015]|5[58]|7[57]|0[1-58]|8[1458])|795))',
    '185' => '(?:8(?:5(?:[24]0|33|6[27]|0[126]|1[01])|601|795))',
    '186' => '(?:8(?:6(?:50|0[1-3]|1[19]|8[068]|6[68])|5(?:19|85|0[15])|79[78]|001))',
    '187' => '(?:8(?:5(?:40|0[2357]|3[13]|5[1358]|2[02]|6[07]|8[1578]|7[078]|1[0-28])|(?:61|70)1))',
    '188' => '(?:8(?:5(?:[58]5|11)|6(?:66|80)|701))',
    '189' => '(?:85(?:[01]1|20|85|5[05]))',
    '190' => '(?:(?:8(?:5(?:90|2[028]|3[015-79]|5[013-578]|0[135-8]|6[0-256]|8[1-3689]|4[02-4]|1[013-9]|7[1-3589])|6(?:09|66|8[0168]))|129[23578]|0192))',
    '191' => '(?:8(?:5(?:20|0[1-3679]|1[0-2])|6(?:60|86)))',
    '192' => '(?:(?:8(?:5(?:77|85|2[025]|5[01368]|3[235-7]|[16][02568]|0[125-8])|6(?:11|22|33|5[05]|4[48])|702)|0(?:9(?:9[1-36]|8[1-3689])|39[2-8])))',
    '193' => '(?:(?:8(?:5(?:[57]0|2[05]|1[01]|0[15])|6[68]6)|09(?:85|9[178])))',
    '194' => '(?:(?:8(?:5(?:20|[15][015]|4[03]|7[07]|6[067]|0[1-3578]|8[05689]|3[038])|6(?:66|1[0-2]))|029[2-8]))',
    '195' => '(?:85(?:85|5[05]))',
    '196' => '(?:8(?:5(?:[67]0|01|22|33|[58][058]|1[01])|6(?:[01]1|86|6[68])))',
    '197' => '(?:8(?:5(?:[01]1|55)|6(?:01|23)))',
    '198' => '(?:8(?:5(?:[03]1|55|77|2[25]|1[02]|8[58])|7(?:22|60|[01][01])|6(?:[01]1|55|66)))',
    '201' => '(?:8(?:5(?:[01]1|8[58])|6(?:01|86)))',
    '202' => '(?:85(?:20|85|5[58]))',
    '203' => '(?:8(?:5(?:[12]1|55|8[58])|601|739))',
    '204' => '(?:85(?:[01]1|22|33|67|5[58]|8[589]))',
    '205' => '(?:8(?:5(?:11|55|0[13])|6(?:60|0[1467])))',
    '206' => '(?:8(?:5(?:30|77|4[03]|2[025]|8[568]|1[0-25]|6[167]|0[235]|5[15])|6(?:[01]1|[68]6)))',
    '207' => '(?:85(?:[18]5|01))',
    '208' => '(?:85(?:[58]5|0[1-3]))',
    '210' => '(?:(?:8(?:5(?:0[246]|6[0259]|2[13]|8[356]|3[178]|4[013-578]|7[067]|1[12]|5[127-9])|6(?:66|0[24]|8[016])|79[3-8])|9(?:5(?:11|26|55|67|82|3[03]|0[17])|650)))',
    '211' => '(?:8(?:5(?:40|66|3[03]|2[02]|7[07]|8[58]|5[05]|1[01]|0[125])|6(?:01|66|75|1[19])))',
    '212' => '(?:8(?:5(?:30|6[0467]|2[05]|5[147]|7[0267]|8[1-5]|0[2589]|1[01])|60[2-4]))',
    '213' => '(?:85(?:66|0[2357]|2[0-25]|1[125-7]|3[35]|7[0367]|5[0138]|8[06-9]))',
    '214' => '(?:85(?:[26]5|8[058]|7[01]))',
    '215' => '(?:85(?:09|30|42|66|7[06]|1[015]|8[58]|5[08]|2[017]))',
    '216' => '(?:8(?:5(?:[56]6|01|22|70|1[0-249])|631))',
    '220' => '(?:8(?:5(?:77|1[015]|6[05-7]|3[0689]|2[0-3]|5[89]|8[0568]|4[0-2]|0[127-9])|6(?:53|78|0[149]|1[1-6]|6[08]|8[046]|2[035])|7(?:11|39|65|2[02]|5[05])|080|173|401))',
    '221' => '(?:8(?:5(?:[46]0|37|88|2[0239]|5[08]|1[017])|7(?:41|65|1[28]|0[1-35])|6(?:[68]6|11|23)))',
    '222' => '(?:8(?:5(?:3[03]|8[056]|6[1-6]|7[57]|0[157-9]|1[15]|5[0268]|2[035])|6[25]2))',
    '223' => '(?:85(?:7[027]|[58][058]|1[0-25]|2[0-35-7]|6[067]|4[0-2]|0[125-8]|3[039]))',
    '224' => '(?:8(?:5(?:39|40|78|0[1-57]|8[058]|1[05]|5[01]|2[024])|68[68]))',
    '225' => '(?:85(?:[28]5|[56]0|13|0[1-38]|3[059]))',
    '226' => '(?:85(?:[25]5|70|1[02]|0[1-37]))',
    '227' => '(?:85(?:22|40|0[1258]|1[28]))',
    '230' => '(?:8(?:5(?:11|7[17]|0[14]|5[05])|6(?:[68]6|11|28)|765))',
    '231' => '(?:8(?:5(?:04|6[26]|8[58]|3[0469]|2[08]|4[49]|5[035])|3(?:07|2[01348]|3[0158]|4[036]|1[0-6])|4(?:[368]4|[45]5|7[78]|1[19])|6(?:16|23|31|60|5[124]|8[29])|7(?:50|7[12]|1[15])|00[18]|831|966))',
    '232' => '(?:8(?:5(?:31|8[057]|5[58]|1[05])|6(?:02|88)))',
    '233' => '(?:85(?:0[1-3]|5[056]))',
    '235' => '(?:85(?:58|2[23]|0[15]))',
    '236' => '(?:8(?:5(?:15|40|0[1-4]|5[05])|6(?:5[13]|4[158])))',
    '237' => '(?:85(?:23|55|1[05]))',
    '238' => '(?:(?:8(?:5(?:70|8[058]|3[356]|1[013]|2[02]|6[57]|5[08]|4[01])|6[18]6)|029[28]))',
    '239' => '(?:8(?:5(?:01|28|60|8[58]|5[08])|68[68]))',
    '240' => '(?:(?:8(?:5(?:[02]1|[45]0)|612)|019[235-8]))',
    '241' => '(?:8(?:5(?:25|1[25]|0[12])|606))',
    '242' => '(?:8(?:5(?:[58]5|77|0[27])|6(?:01|10)))',
    '243' => '(?:(?:8(?:5(?:88|5[015]|3[13]|7[17]|2[12]|1[01]|0[15])|6(?:89|0[14]))|0(?:4(?:60|9[2-467]|8[02-79])|2(?:81|9[278])|19[23578]|392)))',
    '244' => '(?:8(?:5(?:0[1-3]|7[17]|2[28]|5[058]|8[589]|6[679]|1[01]|3[039])|60[12]))',
    '245' => '(?:8(?:5(?:[16]0|42|89|5[058]|7[57])|65[01]))',
    '246' => '(?:85(?:20|5[06]))',
    '247' => '(?:8(?:5(?:[156]0|8[58]|7[078]|3[038])|6(?:[13]0|86)|730))',
    '248' => '(?:8(?:555|686))',
    '249' => '(?:8(?:510|686))',
    '250' => '(?:(?:0(?:2(?:80|9[2-68])|19[23]|39[28]|493|592)|85(?:11|55|60|88)))',
    '251' => '(?:8(?:5(?:22|70|4[03]|8[018]|5[0158]|3[0134]|1[0135]|6[067]|0[125])|601))',
    '252' => '(?:(?:5(?:2(?:01|33|77|9[3-578]|8[05-8]|2[0-25]|6[09]|1[0-5]|5[0258])|1(?:[56]2|8[13589]|7[27]|9[12]))|0(?:3(?:7[013-578]|8[13568]|9[258])|88[0-3568])|85(?:[02]2|11|40|85|3[89]|7[02]|6[067]|5[08])|119[235]))',
    '253' => '(?:(?:8(?:5(?:10|22|43|7[17]|8[58]|5[05]|3[01])|6(?:60|86))|019[356]))',
    '254' => '(?:8(?:5(?:10|43|55|78|0[1-3]|6[27]|3[023]|8[589])|6(?:01|86|1[024])))',
    '255' => '(?:8555)',
    '256' => '(?:8510)',
    '257' => '(?:85(?:[23]3|11|55|66|77|8[458]|0[12]))',
    '258' => '(?:(?:85(?:11|77|85|3[38]|0[16])|0195))',
    '259' => '(?:(?:0(?:1(?:9[2-467]|8[01])|39[2356])|1(?:1(?:8[5-8]|9[236-8])|[23]92)))',
    '260' => '(?:8(?:6(?:0[13467]|1[0-389]|2[0-24-79]|5[46]|4[2578]|6[0-35-8]|7[0-357]|8[258]|3[135-7])|5(?:40|7[0257]|5[1257-9]|8[0568]|0[1-35-9]|3[4-68]|6[0-467]|2[13478]|1[0-3568])|7(?:1[02357]|0[137]|3[34]|2[02])))',
    '261' => '(?:8(?:5(?:1[0-35]|6[0168]|3[0359]|7[57]|5[0248]|0[1-478]|8[125-8]|4[145]|2[0-28])|6(?:09|86)|733))',
    '262' => '(?:8(?:5(?:0[26]|1[0-24])|733))',
    '263' => '(?:8(?:5(?:[12]2|33|66|77|8[58]|5[05]|0[56])|733))',
    '264' => '(?:8(?:5(?:[135]0|8[25]|0[15])|6(?:04|46)|733))',
    '265' => '(?:8501)',
    '266' => '(?:8(?:550|733))',
    '270' => '(?:(?:1(?:3(?:8[0-3579]|9[23568])|19[2468]|49[2356]|69[3-5]|592)|2(?:2(?:8[08]|9[25-8])|39[23])|01(?:89|9[24-8])|85(?:[0-2]1|55)))',
    '271' => '(?:8(?:5(?:01|22|3[03]|[18][058]|5[157]|6[02-4])|6(?:66|72|2[05])))',
    '272' => '(?:(?:85(?:01|73|4[03]|5[058]|2[02]|8[0158]|1[0-468]|6[01]|3[038])|01(?:88|9[35])))',
    '273' => '(?:(?:8(?:5(?:3[03]|2[0-3]|8[458]|1[0-25]|7[048]|6[067]|4[023]|5[01568]|0[1-68])|6(?:01|10|27)|7(?:10|33))|019[2357]))',
    '274' => '(?:8(?:5(?:[12]0|77|85|3[03]|0[13-7]|5[58])|601))',
    '275' => '(?:8(?:5(?:02|11|33|[28][058]|6[05]|7[25-7]|5[01])|6(?:[01]1|66)))',
    '276' => '(?:85(?:01|80|2[3-7]))',
    '277' => '(?:8(?:5(?:1[1589]|0[13-57]|8[124-9]|5[0146-8]|3[139]|2[0-2]|7[0-479]|6[1-69])|6(?:86|5[45]|6[16])))',
    '278' => '(?:8(?:5(?:[02]1|10|33|7[07]|5[05])|6(?:01|86)))',
    '279' => '(?:8(?:5(?:41|67|5[0358]|8[0-358]|0[1-356]|2[124-69]|1[16-9]|3[0-2])|6(?:01|86)))',
    '282' => '(?:86(?:02|10))',
    '283' => '(?:(?:8(?:5(?:11|55|88|0[15])|6(?:50|86)|701)|0195))',
    '284' => '(?:8555)',
    '285' => '(?:8(?:5(?:33|50|67|8[0568]|2[0-2]|1[01]|0[1-359])|6(?:19|55|68)|7(?:41|65)))',
    '286' => '(?:(?:8(?:5(?:01|2[013]|8[58])|686)|0292))',
    '287' => '(?:(?:8(?:5(?:[58]5|10|0[1-3])|601)|0292))',
    '288' => '(?:8601)',
    '289' => '(?:(?:1(?:59[2-4]|[138]92|29[78]|69[23]|793)|0(?:[124-6]92|39[23])|2(?:19[278]|292|595)))',
    '290' => '(?:(?:8(?:5(?:40|77|0[13]|8[058]|5[0158]|6[067]|[13][01])|610)|019[2-4]))',
    '292' => '(?:8(?:5(?:01|2[025]|3[0359]|6[58]|5[05]|1[01])|6(?:11|86)))',
    '293' => '(?:85(?:06|11))',
    '294' => '(?:8(?:50[1-3]|[67]01))',
    '295' => '(?:(?:0192|8601))',
    '296' => '(?:(?:860[12]|0197))',
    '297' => '(?:(?:8(?:5(?:[01]1|33|67|88|5[058])|6(?:11|22|66))|0(?:19[2-8]|29[28])))',
    '298' => '(?:(?:029[25-7]|8501))',
    '299' => '(?:(?:4(?:39[24-7]|[126]92|49[23])|0(?:19[24-8]|29[235-8])|2(?:[1245]92|79[25])|5(?:29[25]|192)|119[245]))',
    '300' => '(?:(?:0(?:3(?:88|9[2-8])|19[235]|49[26]|59[35]|[67]92)|2(?:6(?:86|9[258])|49[2-578]|79[2357]|395|593)|1(?:29[24-6]|19[235]|[3-5]92|696)|8(?:5(?:50|67|88)|6(?:01|19|86))|4(?:29[35]|193|495|598)|3(?:59[258]|29[45])))',
    '301' => '(?:8(?:6(?:0[12]|1[01])|5(?:55|0[15])))',
    '302' => '(?:(?:85(?:0[12]|8[56])|0198))',
    '303' => '(?:850[13])',
    '304' => '(?:8[56]01)',
    '305' => '(?:8(?:5(?:85|0[1-6]|5[05]|7[1-7]|2[01]|1[05-9]|6[013-9])|6(?:34|42|66|8[67]|0[12459])|70[12]))',
    '306' => '(?:(?:0(?:49[235]|[236]92|595)|86(?:01|86)))',
    '307' => '(?:8[56]01)',
    '308' => '(?:(?:8(?:5(?:[45]0|2[1-4]|1[0-3])|6(?:[03]8|16))|019[34]))',
    '309' => '(?:1(?:29[2-7]|79[237]|19[25]|698))',
    '310' => '(?:8(?:5(?:[47]0|36|67|0[12589]|8[1568]|5[0158]|2[05]|1[12])|6(?:22|39|41|86|1[06]|7[17]|0[124]|6[68])|282))',
    '311' => '(?:(?:3(?:8(?:80|9[2-4])|19[2-57]|49[2-478])|1(?:39[23]|49[23]|59[23]|792)|4(?:19[3-68]|39[1-3]|59[25])|249[235]|019[23]))',
    '312' => '(?:85(?:0[1-578]|1[01]))',
    '313' => '(?:8(?:6(?:[68]6|11)|511))',
    '314' => '(?:(?:8(?:501|655)|019[2-578]))',
    '315' => '(?:(?:8(?:5(?:85|2[257]|1[1-368])|640)|0195))',
    '316' => '(?:85(?:11|33|0[12]))',
    '317' => '(?:8(?:5(?:[58]5|11)|60[12]))',
    '318' => '(?:85(?:11|0[15]))',
    '319' => '(?:(?:1(?:1(?:8[248]|9[24-7])|29[235]|59[23]|393)|0(?:39[3-57]|29[245]|19[28])|2[16]92|3595))',
    '320' => '(?:8(?:5(?:5[015]|3[0-38]|0[1-35-8]|8[058]|4[013]|7[07]|6[046]|2[1-358]|1[0-2457])|6(?:01|20|55|68|1[018]|8[068])))',
    '321' => '(?:(?:3(?:29[235-8]|39[2358]|49[378]|59[578])|0(?:29[2358]|19[458]|59[235]|692)|2(?:59[23568]|49[23]|792)|4(?:39[23568]|29[235])|1(?:29[238]|49[23])|85(?:[58]5|0[25])))',
    '322' => '(?:(?:8(?:5(?:11|0[1-3]|8[58]|5[05])|6(?:66|88|0[13]))|0(?:393|692)))',
    '323' => '(?:(?:8(?:5(?:11|58|67|8[56])|6(?:[01]1|78|86)|75[56])|019[24]|1192))',
    '324' => '(?:(?:8(?:5(?:[24]0|01|85|1[06]|5[015])|6(?:25|86|4[12])|765)|0(?:59[2-6]|29[23]|69[23]|492)))',
    '325' => '(?:039[23578])',
    '326' => '(?:(?:8(?:5(?:11|72|85|5[08]|2[01]|0[125])|6(?:[01]1|30|86))|039[25]))',
    '327' => '(?:(?:8(?:5(?:11|33|55|0[13])|6(?:78|0[13]))|0(?:59[25]|192|398)))',
    '328' => '(?:(?:8(?:5(?:33|0[1-4]|5[0568]|8[5-8])|6(?:86|6[68]))|0192))',
    '329' => '(?:(?:0(?:49[238]|59[568]|69[26]|195)|1(?:19[3468]|39[235]|292|493)|2(?:79[23]|99[23]|[12]92)|4(?:49[238]|392)|3292))',
    '330' => '(?:(?:9(?:5(?:90|5[013589]|4[03-58]|8[0-36-8]|6[4-6]|3[156]|2[05]|7[57]|1[12]|0[1-37-9])|7(?:9[1-367]|3[19]|2[07]|1[0357])|6(?:[69]6|11|30|88|0[18]|2[126])|3(?:30|77|0[13]|1[01])|0(?:11|45)|1(?:09|11)|850)|8(?:5(?:6[24-6]|4[78]|5[0-37]|0[13568]|3[238]|1[0189]|2[29]|7[129]|8[0159])|6(?:34|47|69|71|0[13]|8[68])|7(?:08|10|77))))',
    '331' => '(?:(?:8(?:5(?:[24]0|01|77|1[13]|8[05-8]|5[02]|6[07]|3[237])|6(?:25|33|58|8[6-8])|701)|95(?:[1-35]0|77)))',
    '332' => '(?:8(?:5(?:21|48|77|85|0[1-3]|5[568]|1[12])|6(?:[68]6|01|54)))',
    '333' => '(?:86[01]1)',
    '334' => '(?:8501)',
    '335' => '(?:8(?:5(?:10|22|33|[58][58]|0[12])|6(?:55|66)))',
    '336' => '(?:8(?:5(?:40|6[14]|1[25]|2[1-36]|8[67]|[05][58])|6(?:[36]6|55)|760))',
    '337' => '(?:85(?:[58]6|32|70|0[127]))',
    '338' => '(?:8(?:5(?:8[056]|1[0-35]|2[3-5]|7[057]|0[3-68]|6[67]|5[1578]|3[18]|4[01])|6(?:30|86)))',
    '339' => '(?:8(?:5(?:21|39|66|85|0[13]|5[18]|1[01])|6(?:01|86)))',
    '340' => '(?:(?:8(?:5(?:33|77|5[015]|2[04]|0[19]|8[58]|6[078]|1[01])|6(?:59|86|1[01]))|0(?:19[2-4]|295)))',
    '341' => '(?:85(?:01|5[058]|2[67]))',
    '342' => '(?:8(?:50[125]|601))',
    '343' => '(?:(?:8(?:5(?:[24]0|11|85|5[458]|0[12])|601)|019[23]))',
    '344' => '(?:8(?:5(?:11|40|55|66|7[78]|3[35]|8[58]|2[12]|0[68])|68[06]))',
    '345' => '(?:850[1248])',
    '346' => '(?:(?:8(?:5(?:[34]0|24|[01][16])|68[56])|01(?:8[13]|9[2-68])))',
    '347' => '(?:(?:85(?:67|85|0[1-4]|1[03]|5[05])|019[25]))',
    '348' => '(?:8(?:5(?:[258]5|30|1[23]|0[1-35-8]|4[09])|601))',
    '349' => '(?:(?:0(?:19[23568]|29[2-6])|1(?:19[23]|292)))',
    '350' => '(?:(?:1(?:1(?:9[24-8]|8[1-358])|3(?:8[035689]|9[258])|29[25-8])|0(?:2(?:9[25]|8[02-9])|39[2-6]|19[2357]|49[3-6])|8(?:5(?:[03]1|8[58]|5[05]|1[01])|6(?:01|66))|22(?:8[0-278]|9[25])))',
    '351' => '(?:(?:8(?:5(?:[26]0|55|0[138]|1[01]|8[56])|601)|01(?:88|9[2-46-8])))',
    '352' => '(?:8(?:5(?:01|10|23|49|8[89]|7[27]|5[58])|6(?:23|66)))',
    '353' => '(?:85(?:01|55))',
    '354' => '(?:85(?:33|77|[68][05]|5[58]|1[01]|0[145]))',
    '355' => '(?:(?:0(?:3(?:80|9[25])|19[2-5]|292)|8(?:5(?:01|85)|60[13-68])))',
    '356' => '(?:85(?:25|33|67|0[127]|5[056]|8[05]|1[01]))',
    '357' => '(?:85(?:[17]0|01|27|5[058]|8[58]))',
    '358' => '(?:85(?:[02]1|1[015]|[58][58]))',
    '359' => '(?:(?:8(?:5(?:[267]0|33|42|5[058]|1[013]|8[05]|0[157])|6(?:01|48|86))|11(?:9[23568]|8[089])))',
    '360' => '(?:(?:8(?:5(?:[67]7|32|43|2[0-3]|1[25]|8[05]|0[12]|5[589])|6(?:11|20|0[18]))|019[2-7]))',
    '361' => '(?:8(?:5(?:[58]5|39|1[013]|0[3-8])|60[1-4]))',
    '362' => '(?:8(?:5(?:[67]7|42|3[19]|2[013]|8[58]|0[1248]|5[035]|1[017])|688))',
    '363' => '(?:8(?:5(?:10|0[159]|5[58])|601))',
    '364' => '(?:8(?:5(?:[01]1|[58]5)|633))',
    '365' => '(?:8(?:5(?:85|1[24]|0[1-3568])|60[13]))',
    '366' => '(?:85(?:[28]1|67|1[015]|0[12]))',
    '367' => '(?:(?:0(?:29[26-8]|19[248]|393)|8(?:501|686)))',
    '368' => '(?:(?:8(?:6(?:66|8[06])|50[125])|0(?:19[235]|292)))',
    '369' => '(?:(?:1(?:29[2358]|89[2-5]|19[235]|59[236]|[34]92|998)|0(?:29[2357]|19[258]|39[235])))',
    '370' => '(?:(?:8(?:5(?:[01]1|[68]5|22|43|3[17]|5[05])|6(?:[01]1|22|86|6[68]))|1(?:39[2-6]|19[2356]|29[23]|592)|0(?:59[568]|49[25]|193|692|795)|2(?:39[23568]|49[58]|[12]92)|3(?:59[2-4]|[146]92|39[23])))',
    '371' => '(?:(?:8(?:5(?:[58][05-7]|0[1-578]|1[0-7]|2[0-2578]|4[38]|3[01359]|7[023]|6[017])|6(?:[36]6|01|40|77|1[167]|2[05]|8[68]))|0(?:29[2-4]|192)))',
    '372' => '(?:8(?:5(?:10|58|67|8[058]|0[128])|686))',
    '373' => '(?:8(?:5(?:21|78|1[0-35]|0[1589]|8[58]|5[0157]|3[01]|6[017])|6(?:01|22|[68][068]|1[01])|718))',
    '374' => '(?:(?:8(?:5(?:01|20|33|55|77|88|1[0-28])|6(?:11|22|40|86|0[18]))|019[23]))',
    '375' => '(?:8(?:50[1-7]|60[1-4]))',
    '376' => '(?:(?:8(?:5(?:31|85|1[056]|2[38]|5[58]|0[12])|6(?:86|6[68]))|0(?:19[2-4]|39[27])))',
    '377' => '(?:(?:0(?:8(?:8[23]|9[2-46-8])|2(?:80|9[2-4])|19[235]|39[25]|49[24]|792)|8(?:5(?:[67]7|20|33|55|1[013]|0[1-38]|8[58])|616)|1(?:79[2-7]|39[235]|59[3-5]|69[235])))',
    '378' => '(?:(?:0498|8501))',
    '379' => '(?:(?:2(?:1(?:8[014-7]|9[2-578])|39[258]|29[28])|1(?:29[78]|[16]92|393|498)|0(?:19[235-7]|292)))',
    '380' => '(?:8(?:5(?:0[1-35-8]|8[0-689]|2[014-6]|7[0235-7]|6[015-8]|5[0-3578]|4[03-6]|1[0-25689]|3[013-9])|6(?:55|77|0[158]|2[25]|8[268]|6[068]|4[08]|1[0-24]|3[039])|7(?:10|9[4-8])))',
    '381' => '(?:(?:8(?:5(?:1[015]|5[0168]|[67][07]|3[09]|0[138]|4[58]|2[05]|8[08])|6(?:02|86)|793)|0(?:2(?:88|9[235-8])|19[23]|49[78])|22(?:8[0-35-9]|9[258])|4(?:19[23]|393)))',
    '382' => '(?:8(?:5(?:33|55|77|0[1258]|8[578]|1[0-2])|633))',
    '383' => '(?:8(?:5(?:55|67|8[158]|[01][15])|6(?:14|86)))',
    '384' => '(?:(?:8(?:5(?:[01]1|58|8[58])|605)|0(?:69[2578]|393|798)|(?:11|22)92))',
    '385' => '(?:8(?:5(?:[01]1|22|33|8[568]|5[58])|6(?:[01]1|86)))',
    '386' => '(?:(?:8(?:5(?:[67]7|22|43|5[135]|8[458]|1[01]|0[15])|6(?:24|0[189]|8[3568]|6[68]|3[48]|1[01])|7(?:05|20|1[05]))|0(?:49[23578]|39[36]|[15]92)|1(?:19[23]|298)|2292))',
    '387' => '(?:8(?:5(?:[26]1|[58]5|0[1-3]|1[12])|60[13]))',
    '388' => '(?:85(?:11|22|55))',
    '389' => '(?:(?:0(?:6(?:8[128]|9[235-8])|19[2-8]|29[23568]|89[2378]|59[238])|1(?:19[256]|293|392)|2(?:[1357]92|29[28])))',
    '390' => '(?:(?:8(?:5(?:85|0[1-35-8]|2[0358]|4[013]|1[0158]|3[01359]|[56][05])|6(?:48|86|2[013]|3[09]|1[01]|0[1-35])|7(?:65|0[237]|1[0-24]))|1(?:1(?:9[378]|8[1-35-9])|29[358]|39[2-4]|[457]92)))',
    '391' => '(?:(?:85(?:31|40|0[13]|5[058]|6[0167]|1[0-2]|8[08]|2[125])|0(?:29[2-7]|39[2-6]|192)))',
    '392' => '(?:8(?:5(?:[58]5|20|7[78]|0[25]|4[089]|1[01])|6(?:86|2[78]|0[19]|1[01])))',
    '393' => '(?:8(?:5(?:[58]5|11|0[1-3])|601))',
    '394' => '(?:8(?:5(?:[24]0|77|1[0-25]|8[58]|5[05])|6(?:11|65|86)))',
    '395' => '(?:(?:8(?:5(?:[34]3|77|2[028]|5[568]|6[67]|8[58]|0[1-5]|1[15])|6(?:09|11|22|46|55|8[28]))|019[2356]))',
    '396' => '(?:(?:8(?:5(?:01|85|5[058]|1[01])|6(?:09|82|1[17]))|0293))',
    '397' => '(?:(?:8(?:5(?:67|71|8[58]|5[05])|60[29])|0[23]92))',
    '398' => '(?:8(?:6(?:86|0[12])|501))',
    '399' => '(?:(?:8(?:7(?:44|60|0[127]|2[0-258]|5[0145]|1[0-2]|3[0389])|2(?:9[2357]|8[1-3568])|3(?:86|92)|69[56]|192)|4(?:5(?:7[0-35-8]|6[4-8]|8[13-9]|9[2-578])|69[235-7]|39[2-5]|19[25]|498)|0(?:7(?:9[67]|8[1256])|49[235-8]|29[235])|3(?:19[23]|295|797|892)|1(?:392|511|689|895)|9(?:192|393|494)|719[24]|6493))',
    '400' => '(?:(?:8(?:5(?:2[015]|8[568]|1[0-25]|4[03-5]|7[01578]|5[025689]|0[125689]|6[56]|3[1356])|6(?:01|10|33|6[06])|794)|0(?:2(?:80|9[238])|19[2-6]|49[2358]|39[358]|59[238]|69[235])|159[2-478]))',
    '401' => '(?:(?:0(?:3(?:80|9[5-8])|59[257]|292)|8[56]01))',
    '402' => '(?:85(?:01|55|80))',
    '403' => '(?:8(?:5(?:22|55)|601))',
    '404' => '(?:8[56]01)',
    '405' => '(?:85(?:[58]5|01|77))',
    '406' => '(?:8(?:5(?:05|10|5[58])|601))',
    '407' => '(?:(?:85(?:11|49|55|0[12])|0192))',
    '408' => '(?:(?:85(?:22|33|85|5[05]|1[15])|01(?:88|92)))',
    '409' => '(?:(?:3(?:8(?:8[03589]|9[2-8])|39[23]|79[23]|293|692)|2(?:19[2-6]|59[2378]|398|992)|1(?:298|392)|019[2358]))',
    '410' => '(?:(?:8(?:5(?:67|0[148]|2[025]|5[0-258]|8[058]|3[0135]|4[013-5]|7[05]|1[0145])|6(?:10|8[69]|5[45]|0[12])|7(?:10|39))|2(?:39[2-6]|19[2-5]|29[257]|592)|1(?:19[2-8]|39[2-6])|0(?:39[568]|19[25])|3(?:69[36]|292)))',
    '411' => '(?:8(?:5(?:02|33|60|77|88|2[05]|5[15]|[14][01])|6(?:30|89|2[03]|4[148]|6[068]|5[0-2]|1[01])|7(?:[45]0|[78]7|2[025]|3[01])))',
    '412' => '(?:8(?:5(?:24|50|85|1[1-3]|0[15])|6(?:3[04]|0[159])|701))',
    '413' => '(?:(?:8(?:5(?:30|8[59]|0[25]|5[058]|6[067]|1[01])|6(?:26|78|1[18]))|0(?:29[238]|49[23]|196)))',
    '414' => '(?:85(?:11|5[05]))',
    '415' => '(?:(?:8(?:5(?:30|0[125-9]|[12][0-8])|6(?:11|0[23]))|0(?:19[2-4]|392)))',
    '416' => '(?:8(?:5(?:[02]1|77|4[04]|3[03]|5[58])|6(?:60|86|5[04-69])))',
    '417' => '(?:8(?:5(?:6[05-7]|3[01358]|8[058]|0[135-8]|1[0-29]|5[05]|7[0157]|2[029]|4[035])|6(?:[15]0|32|86|0[19])))',
    '418' => '(?:(?:86(?:[68]6|01)|0192))',
    '419' => '(?:0(?:19[23]|29[35]|392))',
    '420' => '(?:8(?:6(?:6[06]|2[02-48]|4[14]|0[1-468]|8[0158]|7[07]|3[03679]|5[05]|1[0-268])|5(?:70|1[0-257]|0[1-357-9]|8[0158]|6[07]|5[0578]|2[0-3578]|3[06-8])|7(?:0[3469]|[12][02]|3[389]|6[01])))',
    '421' => '(?:(?:0(?:1(?:88|9[23578])|39[2-7]|59[23568]|49[2356]|29[238])|3(?:29[25-7]|392)|1(?:29[58]|392)))',
    '422' => '(?:8(?:5(?:45|50|8[015]|[26]\d|0[24-79]|7[013-68]|3[01]|1[0-24-9])|6(?:5[04]|3[03]|7[07]|8[068]|6[68]|1[059]|2[0-28])|7(?:66|87)))',
    '424' => '(?:(?:8(?:6(?:48|50|0[1-3]|7[78]|3[1367]|[68][68]|1[01]|2[024])|7(?:82|3[04]|2[0147]|5[0-25]|6[07]|0[18]|1[579])|5(?:66|0[23]|5[058]|1[01]))|0(?:19[23]|292)))',
    '425' => '(?:8(?:5(?:[58]5|[67]0|11|22|33|0[1-358])|6(?:11|8[06])|7(?:11|0[18])))',
    '426' => '(?:(?:8(?:6(?:01|7[07]|3[1-38]|1[27]|4[026]|6[2368])|5(?:39|43|66|1[015]|0[13]|7[057])|7(?:11|22))|0292))',
    '427' => '(?:(?:8(?:5(?:22|41|55|0[12589]|8[18]|1[0-2])|6(?:86|0[12]))|019[356]))',
    '428' => '(?:(?:8(?:6(?:86|5[0-2])|50[1-3])|0192))',
    '430' => '(?:(?:8(?:6(?:11|20|8[0679]|3[09]|7[0578]|6[578]|5[02-5])|5(?:[246]0|7[057]|5[358]|8[0578]|3[036]|1[01]))|089[78]))',
    '431' => '(?:(?:0(?:49[2-6]|29[258]|19[23]|395)|3(?:19[2-6]|39[23]|492)|1(?:39[2-5]|49[5-7])|(?:22|41)95))',
    '432' => '(?:8(?:5(?:41|80|5[015]|0[178]|3[1279]|2[1-38]|6[12])|6(?:08|11|26|8[06])|777))',
    '433' => '(?:8(?:5(?:[01]1|67|5[058])|601))',
    '434' => '(?:8(?:5(?:11|33|50|0[125])|601))',
    '435' => '(?:8(?:5(?:40|75|3[39]|0[25]|2[02]|6[0178]|8[58]|1[05]|5[1578])|6(?:42|86|1[19]|6[01])))',
    '436' => '(?:8(?:5(?:55|0[1-3])|65[0-3]|701))',
    '437' => '(?:(?:1(?:6(?:9[2-8]|8[68])|19[2-7]|49[2-6]|39[2357]|59[2-4]|292)|8(?:5(?:[45]5|11|0[12])|6(?:[01]1|[68]6))|0(?:29[23]|69[23])))',
    '438' => '(?:(?:8(?:5(?:01|10|43|77|85|5[058])|6(?:[01]1|22|50|86)|71[18])|0(?:19[235]|292)))',
    '439' => '(?:865[01])',
    '440' => '(?:8(?:5(?:43|0[124-8]|3[013]|[12][0-8])|60[134]))',
    '441' => '(?:(?:8(?:5(?:6[06]|2[025]|5[058]|7[07]|4[05]|8[08]|0[1-37]|1[0-2579]|3[039])|6[68]6)|0(?:19[3-5]|29[25]|39[23])|3(?:19[2-6]|492|695)|1(?:29[2-5]|[346]92)))',
    '442' => '(?:8(?:5(?:20|3[0-358]|0[1-35-79]|6[169]|5[058]|1[0-35-8]|7[35-7]|8[015-8]|9[01]|4[013-6])|60[1-3]))',
    '443' => '(?:(?:8(?:5(?:[05]5|88)|6[01]1)|019[2-4]))',
    '444' => '(?:(?:8(?:5(?:77|3[03]|0[1378]|6[047]|2[025]|1[0-25-7]|4[0235]|8[01568]|5[1-58])|6(?:86|0[126]|1[0-2])|7(?:10|87))|0(?:3(?:81|9[1-8])|49[2-6]|59[2356]|19[2-4]|798)|1(?:3(?:8[5-8]|9[3478])|19[2358]|29[5-8])|3(?:59[2-5]|69[2568])|2(?:19[238]|89[23])))',
    '445' => '(?:8(?:5(?:[58]5|1[01]|0[1-35])|60[12]))',
    '446' => '(?:8(?:5(?:40|1[124578]|5[058]|3[35]|0[1-8]|8[58]|2[0-6])|6(?:35|41|86|0[12])))',
    '447' => '(?:8(?:5(?:0[1-35-7]|1[0-2])|6(?:[18]0|0[1358])))',
    '448' => '(?:8(?:6(?:10|22|0[1259]|5[0-35-7]|6[0156]|8[68]|7[017])|5(?:11|50|0[156]|2[35]|3[13-5]|4[023])|731))',
    '449' => '(?:029[23])',
    '450' => '(?:(?:8(?:5(?:40|85|0[135]|[23][03]|6[17]|7[57]|1[15])|6(?:[248]0|[05]1|1[1458])|7(?:11|65)|99[35-7])|6(?:(?:13|36)3|660)))',
    '451' => '(?:8(?:5(?:[14]1|2[02]|[56][0158]|0[1-38]|7[0157])|6(?:[15]0|66|88)|701))',
    '452' => '(?:8(?:5(?:70|0[1-3]|6[1-79])|60[12]))',
    '453' => '(?:8(?:5(?:40|8[015]|3[39]|7[07]|5[58]|6[57]|2[12]|0[15]|1[0-28])|6(?:[28]6|11|62|0[18])|7(?:58|65|77|0[124])))',
    '454' => '(?:8(?:5(?:3[03]|2[0-24-79]|5[058]|1[124-9]|6[05]|0[1-689])|651))',
    '455' => '(?:8(?:5(?:[458]5|60|1[25]|[02][15]|3[035])|6(?:[46]8|10|2[06]|3[09]|0[156]|7[01])|777))',
    '456' => '(?:8(?:5(?:23|30|44|0[1-3]|6[07]|1[16]|8[0578]|5[56])|6(?:20|91|0[12]|1[0-2]|[68][68])|7(?:11|39|63)))',
    '457' => '(?:8(?:5(?:22|45|77|3[0-35]|5[158]|1[0-25]|6[067]|8[58]|0[18])|71[12]))',
    '458' => '(?:85(?:30|55|8[015]|0[1258]|1[05]|2[0-2]|7[01]))',
    '459' => '(?:85(?:[01]1|22|40))',
    '460' => '(?:8(?:5(?:5[01589]|2[0-58]|3[0-24-68]|1[0-7]|8[0568]|6[067]|7[578]|0[13-9]|4[15])|6(?:90|7[0-2489]|2[135-8]|0[2568]|6[05-79]|5[01357]|3[0-3578]|1[04-9]|8[1346-9])|4(?:61|7[057]|2[256]|1[125-7]|[08][1-58]|5[0156]|9[01]|4[0457]|3[0-59])|3(?:02|6[06]|2[015]|5[018]|8[38]|3[0138]|1[0-24589])|7(?:20|0[346-8]|1[18])|20[1-4]))',
    '461' => '(?:8(?:5(?:60|8[0-2568]|2[025]|5[058]|3[0-249]|0[13-8]|7[57]|1[12]|4[01])|6(?:66|80|4[015]|5[01458]|1[02]|0[235]|3[0169]|2[016]|7[0-3568])|7(?:0[367]|2[159]|9[58]|1[0457])))',
    '462' => '(?:8(?:5(?:2[23]|7[5-7]|5[158]|0[189]|3[05]|1[129]|8[08]|4[035])|666|739))',
    '463' => '(?:85(?:10|5[057]|2[128]|8[05]|6[0157]|7[157]|0[1-35]|3[03568]|4[013578]))',
    '464' => '(?:8(?:5(?:85|91|4[05-7]|5[058]|2[0-25]|1[12]|6[0167]|3[01369]|7[017])|6(?:[78]1|0[1-3]|4[134]|3[1-357]|6[12]|1[0135-8]|5[0-24])|710))',
    '465' => '(?:8(?:5(?:20|6[05-7]|5[0-258]|0[15-8]|1[0156])|6(?:68|70|1[0-2]|5[01]|2[026])))',
    '466' => '(?:8(?:5(?:40|6[05-7]|3[39]|2[25]|8[058]|1[0-25]|0[125-7]|5[0458])|6(?:73|88|6[06]|5[05-7]|3[0356])|7(?:11|0[17])))',
    '467' => '(?:8(?:5(?:01|6[1-367]|7[17]|3[013]|8[0158]|5[58]|2[0-2]|1[01])|6(?:51|86|2[26]|0[1-3]|3[39]|1[01])))',
    '468' => '(?:8(?:5(?:51|2[02]|0[1-357]|1[0-4]|8[58]|3[1-467])|626))',
    '469' => '(?:879[367])',
    '470' => '(?:(?:0(?:1(?:9[2-8]|8[68])|29[2-57]|39[2-6]|49[2356]|592)|2(?:19[1-35-8]|39[2-58]|29[26-8]|49[23])|1(?:19[2-68]|29[2-6])|3(?:29[56]|495)))',
    '471' => '(?:8(?:5(?:7[1-4]|6[056]|3[0-25-7]|0[1-36-8]|1[0-35-8]|8[58]|5[05]|2[1257])|60[1-39]))',
    '472' => '(?:8(?:6(?:[68]6|39)|5[58]5))',
    '473' => '(?:85[01]1)',
    '474' => '(?:8(?:5(?:35|43|8[01458]|5[0578]|1[01]|0[1-35])|6(?:[05]1|42|[68][68]|1[01])|7(?:10|66|77|0[17])))',
    '475' => '(?:8(?:5(?:41|60|74|99|5[057]|2[28]|8[58]|1[01]|0[125])|6(?:[01]1|55|86|6[68])))',
    '476' => '(?:8(?:5(?:[67]7|10|22|33|0[13]|8[58])|6(?:[68]6|01)))',
    '477' => '(?:852[12])',
    '478' => '(?:8(?:5(?:55|0[1-5])|6(?:01|4[01])))',
    '479' => '(?:8(?:5(?:01|55|77|8[5-9]|1[018])|7(?:87|0[1-8]|1[12])|6(?:01|10|23|68)))',
    '480' => '(?:(?:0(?:2(?:8[1278]|9[1-47])|19[23578]|39[235])|1(?:1(?:8[89]|9[2-8])|298)))',
    '481' => '(?:8(?:5(?:26|88|4[03]|5[058]|1[0135]|0[1-68]|3[1359])|6(?:[08]1|15|78)))',
    '482' => '(?:8(?:5(?:01|55|1[01])|6(?:60|86|5[12])))',
    '483' => '(?:8(?:5(?:55|0[257])|7(?:14|0[14])))',
    '484' => '(?:8(?:5(?:0[1-8]|1[0-2])|609))',
    '485' => '(?:8(?:5(?:05|40|1[0-26]|5[0-257]|2[0-3]|3[013]|6[1-35])|65[0-5]|750))',
    '486' => '(?:8(?:5(?:01|40|67|75|2[23]|1[015]|8[58]|5[05])|6[68]6))',
    '487' => '(?:8(?:6(?:22|50)|501))',
    '488' => '(?:8(?:5(?:[58]5|01|20|78)|6(?:55|66|8[68])))',
    '489' => '(?:8(?:5(?:20|67|85|5[05]|1[01])|6(?:[58]0|11|4[25])|7(?:01|77)|450))',
    '490' => '(?:1(?:29[2-6]|19[2-48]|392))',
    '491' => '(?:(?:8(?:5(?:85|1[2356]|5[1358]|7[15-7]|0[125689]|6[12]|2[68]|3[1-35])|6(?:0[18]|1[0-2]|8[68]))|0(?:39[2-5]|192)))',
    '492' => '(?:8(?:5(?:2[013589]|4[0-25-8]|0[12]|1[023])|6(?:[05]1|46|2[128]|8[0-256])))',
    '494' => '(?:8(?:5(?:1[16]|0[1257])|6(?:[01]1|86)))',
    '495' => '(?:8(?:5(?:31|0[15]|1[017])|601))',
    '496' => '(?:8(?:5(?:[78]5|3[1-57]|0[138]|5[58])|6(?:01|48|86|3[39])|720))',
    '497' => '(?:8(?:5(?:[04][158]|3[138]|2[27]|1[0-2])|60[12]))',
    '498' => '(?:850[1-35])',
    '500' => '(?:8(?:6(?:[14][0568]|5[057]|7[0-26-8]|2[0-25]|0[1-357]|8[0-25-79]|3[05-9]|6[06-8])|5(?:88|6[0-25-7]|0[1-578]|1[0358]|4[0145]|2[1-5]|3[035]|7[017]|5[024-8])|7(?:65|4[0-38]|2[1-357-9]|1[015-8]|3[0-479]|5[0-5]|0[1-378])))',
    '501' => '(?:(?:0(?:49[2-8]|69[2-8]|29[2-6]|59[26]|79[78]|[13]92)|3(?:99[2-48]|29[356]|39[235]|89[2-4]|792)|6(?:1(?:9[2-8]|8[01])|29[235])|1(?:19[2-68]|39[23]|[25]92)|4(?:29[278]|19[23]|59[25])|2(?:[1258]92|69[578])|5(?:[146]92|393)))',
    '502' => '(?:8(?:5(?:[12]1|58|67|85|0[13])|792))',
    '503' => '(?:(?:8(?:5(?:5[02-46-9]|2[0-3]|[01][1-9]|7[01]|6[0-24-9])|60[134])|2(?:39[2-7]|49[2-5]|19[23])|0(?:19[258]|29[25]|[46]95|392)|1(?:39[2-6]|59[235]|696)))',
    '504' => '(?:8(?:5(?:[48]5|11|0[14]|5[15])|7(?:10|0[12])|6(?:01|42)))',
    '505' => '(?:(?:8(?:5(?:10|0[1358])|60[36])|0392))',
    '506' => '(?:(?:8(?:6(?:66|78|90|0[13]|8[6-8])|5(?:77|85|0[26]|5[05]))|1(?:49[23568]|19[56]|392)|019[24]|2192))',
    '507' => '(?:8(?:5(?:11|33|85|6[18]|2[237])|7(?:87|0[1-3568])|60[1-3578]))',
    '508' => '(?:(?:8(?:5(?:[58]5|11|0[0-2])|6(?:[68]6|11))|0(?:292|494)))',
    '509' => '(?:(?:0(?:2(?:89|9[2-8])|19[278]|393|492)|7(?:79[2357]|[258]92|49[23]|69[23])|1(?:39[2-6]|19[23]|69[25]|492)|5(?:19[23568]|292|494)|9(?:29[23568]|19[235])|2(?:59[2358]|29[235])|(?:83|4[1-3])92|3(?:195|292)|619[2-6]))',
    '510' => '(?:(?:8(?:5(?:[34]0|5[0257]|0[2-5]|8[058]|1[0-25]|7[57]|2[02568]|6[0-27])|6(?:[23]1|42|66|70|5[15]|1[56]|0[145]))|0(?:29[2-58]|[13]92)|1292))',
    '511' => '(?:(?:8(?:5(?:[67]7|02|33|5[058]|8[58]|1[01])|6(?:[68]6|01|78)|7(?:11|98))|0(?:29[2-68]|19[28]|49[28]|59[23])|1192))',
    '512' => '(?:85(?:12|38|50))',
    '513' => '(?:8(?:6(?:[57]0|01|8[06]|3[0-3]|6[016])|5(?:[1-3]0|0[15])|701))',
    '514' => '(?:(?:8(?:5(?:4[0356]|3[0-38]|1[0-58]|5[023578]|8[568]|7[0178]|2[0-2468]|0[1-3578]|6[06-8])|6(?:[01]1|86|6[6-8]|3[35]))|2(?:39[23568]|29[2-4]|192)|1(?:29[2-7]|19[235])|039[235-8]))',
    '515' => '(?:(?:8(?:5(?:77|3[03]|2[25]|8[568]|6[67]|1[0135]|5[0578]|0[1359])|688)|2(?:69[23]|592)|059[2568]))',
    '516' => '(?:(?:8(?:5(?:20|77|3[03]|5[0-58]|8[018]|4[3-9]|6[67]|1[12568]|0[1-35])|6(?:86|0[12]))|1(?:19[2568]|492)|019[2-48]|2195))',
    '517' => '(?:(?:0(?:59[23]|292|494)|85(?:01|1[17])))',
    '518' => '(?:(?:0(?:29[2-68]|49[2-6]|192)|85(?:01|18|33)))',
    '519' => '(?:(?:0(?:19[35-8]|59[2-5]|49[235]|292|393|696)|3(?:69[2-6]|[24]92)|2(?:59[23]|[17]92)|439[2-6]|529[23]|1192))',
    '520' => '(?:(?:8(?:5(?:[23]0|01|67|8[0568]|1[0-356]|7[057]|5[058])|6(?:39|66))|3(?:1(?:9[45]|8[02589])|08[0-58]|28[12589]|49[23]|393)|2(?:39[2-5]|59[24-6]|19[24]|492)|1(?:1(?:88|92)|[2568]92|49[25])|0(?:2(?:87|92)|58[08])))',
    '521' => '(?:(?:1(?:29[25]|39[28]|192)|8(?:60|5[01])1|0[23]92))',
    '522' => '(?:(?:8(?:5(?:11|0[135]|4[03]|3[39]|8[58]|2[023])|6(?:55|66))|029[27]))',
    '523' => '(?:8(?:5(?:[23]3|5[58]|1[05]|0[1-37])|651))',
    '524' => '(?:(?:85(?:01|24|77|85)|0292))',
    '525' => '(?:85(?:77|6[67]|2[0-256]|[58][58]|1[15]|0[125]))',
    '526' => '(?:(?:8(?:5(?:01|45|58|8[05])|6(?:60|86))|029[23]))',
    '527' => '(?:(?:8(?:5(?:[27]7|42|0[158]|8[058]|6[67]|1[12]|5[0458])|687)|0195))',
    '528' => '(?:8(?:5(?:[58]5|0[12]|1[01])|666))',
    '529' => '(?:(?:1(?:3(?:93|8[0-368])|59[2578]|49[235]|69[28]|195|892)|0(?:49[238]|[27]92)))',
    '530' => '(?:(?:8(?:2(?:4[015]|2[1246-8]|3[0249]|5[0-256]|6[0236]|1[0-8]|7[08]|0[1-79]|8[0-378])|5(?:44|2[1-3]|7[3-578]|6[05-8]|0[146]|3[15]|1[1-37]|8[023568]|5[0-3568])|3(?:3[348]|0[148]|8[389]|4[16]|2[1-47]|1[08]|5[035])|4(?:75|80|1[015]|0[128]|4[18])|6(?:60|1[018]|8[089]|0[1256])|79[136-8])|6070))',
    '531' => '(?:(?:8(?:5(?:[67]7|26|88|0[1-3]|1[019]|5[58])|787)|6053))',
    '532' => '(?:8(?:5(?:35|60|88|2[045]|1[1245]|5[58]|0[1578])|680))',
    '533' => '(?:8(?:5(?:33|85|5[58]|0[12])|651))',
    '534' => '(?:85(?:11|85|0[12]))',
    '535' => '(?:85(?:[58]5|01))',
    '536' => '(?:8(?:5(?:10|36|67|0[1358]|8[58]|2[237]|5[038])|686))',
    '537' => '(?:8(?:(?:50|91)1|686))',
    '538' => '(?:8(?:5(?:[58]5|01|10)|6(?:[68]6|55)))',
    '539' => '(?:8794)',
    '540' => '(?:(?:8(?:5(?:6[06]|5[0-3589]|4[0147]|2[1267]|8[15-7]|3[03-5]|0[1578]|7[01578]|1[0-2579])|6(?:86|1[015]|4[25]|2[02]|3[09]|0[2-8]|7[078]|6[08])|795)|6255))',
    '541' => '(?:(?:8(?:5(?:5[0136-9]|2[013-689]|7[2568]|1[135-9]|4[0-357]|8[1579]|0[1-35689]|6[0136-8]|3[014578])|630|765)|6666))',
    '542' => '(?:8(?:5(?:33|42|77|0[1-4]|8[0568]|6[67]|2[235]|5[0458]|1[01])|6(?:54|60|8[68])|745))',
    '543' => '(?:8(?:5(?:[34]3|11|0[1-3]|[58][58])|6(?:01|66|8[68])))',
    '544' => '(?:8(?:5(?:[58]5|01)|6[68]6))',
    '545' => '(?:85(?:[01]1|33|45|5[05]|8[56]))',
    '546' => '(?:8501)',
    '547' => '(?:85(?:01|80|1[04]))',
    '549' => '(?:85(?:11|22|85))',
    '550' => '(?:8(?:5(?:10|27|41|5[025]|8[057]|6[67]|7[0578]|3[08]|0[1-358])|6(?:59|60)))',
    '551' => '(?:85[015]1)',
    '552' => '(?:85(?:01|10))',
    '553' => '(?:8(?:5(?:67|1[1-3]|0[13]|5[0358]|8[58])|739))',
    '554' => '(?:85(?:[01]1|8[58]))',
    '555' => '(?:85(?:55|0[1-3]))',
    '556' => '(?:8(?:5(?:[38]5|1[056]|0[13]|5[058])|6(?:01|70|6[03-6])))',
    '557' => '(?:8501)',
    '558' => '(?:85(?:01|85|5[58]))',
    '559' => '(?:8(?:5(?:1[019]|5[03589]|8[58]|0[126]|6[01])|6(?:11|0[1245]|5[18])|729))',
    '560' => '(?:85(?:79|80|4[38]|5[0-25]|6[0157]|3[12]|0[56]))',
    '561' => '(?:85(?:[23]0|01|77|5[058]|1[01]))',
    '562' => '(?:8(?:5(?:11|22|43|55|8[0568]|0[58]|6[0278])|6(?:78|86)))',
    '563' => '(?:(?:85(?:[67]7|10|88)|0[23]92))',
    '564' => '(?:8(?:5(?:23|5[015]|0[13]|6[57]|1[15])|6(?:80|5[01])))',
    '565' => '(?:85(?:11|40|65))',
    '566' => '(?:8(?:5(?:[58]5|01|13|66)|686))',
    '567' => '(?:8(?:5(?:[34]0|57|1[015]|2[0135]|8[58]|6[57]|7[08]|0[1257])|6(?:51|80)))',
    '569' => '(?:(?:8(?:5(?:33|49|0[135]|5[158]|2[02]|8[58]|7[0157]|6[679]|1[0-2])|6(?:60|86))|1(?:19[2-7]|09[24-68])))',
    '570' => '(?:8(?:5(?:39|40|0[167]|[58][58]|1[15])|6(?:34|66)|787))',
    '571' => '(?:8(?:5(?:[45]5|33|67|71|8[05]|0[2-47])|6(?:[24]0|33|86)))',
    '572' => '(?:85(?:40|8[01589]|0[158]|2[28]|3[013]|7[02]|5[0158]|6[67]|1[01]))',
    '573' => '(?:(?:8(?:5(?:34|56|67|73|88|0[58]|1[01])|666)|10(?:[34]0|1[03]|0[1478])|019[356]))',
    '574' => '(?:85(?:[58]5|01|3[0-4]))',
    '575' => '(?:85(?:[01]1|30|[58][58]))',
    '576' => '(?:8501)',
    '577' => '(?:85(?:40|3[37]|0[2359]|5[01458]|8[1258]|6[067]|7[57]|2[0-2]|1[01]))',
    '578' => '(?:85(?:22|55|77|3[35]|8[58]|0[12]|1[15]))',
    '579' => '(?:8502)',
    '580' => '(?:8(?:50[1-5]|601))',
    '581' => '(?:8(?:5(?:11|39|58|85|0[25])|686))',
    '582' => '(?:85(?:01|55|8[25]))',
    '583' => '(?:85(?:01|22|63|3[3-5]|8[0358]|5[058]))',
    '584' => '(?:8(?:5(?:[13]1|22|40|85)|651))',
    '585' => '(?:85(?:01|85|5[05]))',
    '586' => '(?:85(?:[01]1|[58]5|77|2[18]))',
    '587' => '(?:85(?:55|77|8[56]))',
    '589' => '(?:85(?:11|85|0[12]))',
    '590' => '(?:(?:8(?:5(?:40|2[27-9]|7[67]|6[078]|1[157]|8[589]|[35][01]|0[1-35])|686)|0(?:4(?:9[3-6]|8[12])|592)))',
    '591' => '(?:8(?:5(?:11|55|0[125])|701))',
    '592' => '(?:85(?:50|85))',
    '593' => '(?:8504)',
    '594' => '(?:(?:8(?:50[12]|686)|119[28]))',
    '595' => '(?:8(?:6(?:50|86)|5[58]5))',
    '596' => '(?:8(?:5(?:10|22|88)|6(?:[25]4|86)))',
    '597' => '(?:8(?:5(?:22|55|8[58]|0[12]|1[15])|686))',
    '598' => '(?:85(?:[13]1|22|40|6[06]|0[389]|5[05]))',
    '599' => '(?:(?:0[23]92|8531))',
    '600' => '(?:8(?:5(?:44|3[03]|6[5-7]|1[19]|5[058]|8[1568]|0[1-356]|7[07]|2[0256])|6(?:01|52|65|8[68])|7(?:11|87|92)))',
    '601' => '(?:(?:8(?:5(?:[26]0|42|88|3[03]|5[09]|0[126]|1[01])|601)|1(?:192|397|495)|0(?:292|797)))',
    '602' => '(?:8(?:5(?:[27]0|01|55|66|8[058]|1[01])|6(?:02|11)|959))',
    '603' => '(?:85(?:11|22|55|77|88))',
    '604' => '(?:8(?:5(?:20|1[015]|8[058]|7[178]|6[07]|5[01568]|0[125])|666))',
    '605' => '(?:8(?:5[01]1|686))',
    '606' => '(?:85(?:11|22|36|40|[58][58]|0[1257]))',
    '607' => '(?:85[017]1)',
    '610' => '(?:(?:0(?:3(?:80|9[3-7])|19[256]|28[179])|119[2578]))',
    '611' => '(?:8(?:5(?:[58]5|01)|660))',
    '612' => '(?:8(?:5(?:01|22|77|85|3[03]|5[058]|1[15])|6(?:02|60|77|86)))',
    '613' => '(?:8585)',
    '614' => '(?:85(?:[01]1|88))',
    '615' => '(?:8(?:5(?:[34]0|01|77|85|2[02]|5[58]|1[01])|6[68]6))',
    '616' => '(?:8(?:5(?:[01]1|33|55|66|8[56])|666))',
    '617' => '(?:8(?:5(?:[01]1|[23]0|66|77|5[015]|8[58])|6(?:17|6[56])|772))',
    '618' => '(?:85(?:[28]5|67|70|5[58]|1[18]|0[12]))',
    '619' => '(?:(?:02(?:9[245]|8[02-9])|1(?:[12]95|393)))',
    '620' => '(?:(?:850[1-8]|149[23]))',
    '621' => '(?:8(?:5(?:[58]5|01)|686))',
    '622' => '(?:(?:0292|8651))',
    '623' => '(?:85(?:01|88))',
    '624' => '(?:8(?:555|686))',
    '625' => '(?:8(?:5(?:[58]5|0[1-3]|1[01])|666))',
    '626' => '(?:(?:85(?:[07]1|10)|0493))',
    '627' => '(?:8(?:5(?:55|67|70)|688))',
    '629' => '(?:(?:0(?:19[26-8]|39[28])|2(?:292|498)|1192))',
    '630' => '(?:(?:8(?:5(?:3[0356]|2[0289]|1[28]|6[367]|7[0578]|0[1-3568]|8[015-9]|4[038]|5[0258])|6(?:7[07]|[68][68]|5[15]))|0(?:2(?:88|9[23])|192)|2192))',
    '631' => '(?:85(?:[58]5|11|2[2-4]|0[1-35]))',
    '632' => '(?:(?:8(?:5(?:[14]0|[67]7|8[578]|5[258])|6(?:79|88))|0292))',
    '633' => '(?:(?:8(?:5(?:01|38|85)|686)|0(?:29[28]|39[28])|2[14]92))',
    '634' => '(?:85(?:5[015]|2[1-4]|8[056]|0[1-35-7]|1[01]|6[017]))',
    '635' => '(?:8(?:5(?:30|85|0[12]|2[08]|1[15])|787))',
    '636' => '(?:(?:0(?:29[2-58]|19[238]|39[238])|8(?:5(?:[358]5|11|0[13])|798)))',
    '637' => '(?:85[01]1)',
    '638' => '(?:(?:85(?:[0256]1|10)|0[23]92))',
    '639' => '(?:(?:1(?:1(?:9[26-8]|8[3468])|0(?:8[0-259]|9[35]))|2(?:19[578]|29[258])|3(?:192|594)|029[238]))',
    '640' => '(?:(?:8(?:5(?:6[04-7]|7[057]|2[045]|0[1-357-9]|4[014-6]|5[0-25-8]|8[0-25689]|1[0-69]|3[03568])|6(?:8[67]|6[68]|5[1-79])|787)|119[26]|0492))',
    '641' => '(?:8(?:5(?:0[189]|1[01])|770))',
    '642' => '(?:8501)',
    '643' => '(?:8501)',
    '644' => '(?:(?:86(?:55|86)|1292))',
    '645' => '(?:85[01]1)',
    '646' => '(?:(?:8(?:5(?:[01]1|8[058]|4[45]|5[08])|660)|(?:02|1[14])92))',
    '647' => '(?:(?:1(?:294|792)|855[15]))',
    '648' => '(?:(?:0(?:2(?:8\d|9[2-8])|198|392)|85(?:41|85)))',
    '649' => '(?:(?:6(?:49[2-4]|59[235]|[126]92)|(?:[04]1|35)92|219[2358]|719[245]))',
    '650' => '(?:8(?:5(?:1[015]|6[05-7]|5[01589]|2[0-258]|0[1-356]|3[0369]|7[015-7]|8[04-689]|4[36])|6(?:[68][06]|7[07])|7(?:87|94)))',
    '651' => '(?:(?:8(?:5(?:[58]5|67|70|1[124]|0[12]|2[56])|798)|2(?:1(?:9[467]|8[0178])|49[24]|295)|01(?:7[0-278]|9[35]|8[578])|1(?:195|596)))',
    '652' => '(?:85(?:[17]0|01|85|5[05]))',
    '653' => '(?:85(?:70|85))',
    '654' => '(?:(?:85(?:70|85)|019[2358]))',
    '655' => '(?:8570)',
    '656' => '(?:(?:1(?:59[28]|395|792)|2(?:[2-4]92|193)|8(?:6[568]6|555)|0(?:492|595)))',
    '657' => '(?:85(?:01|70))',
    '658' => '(?:85(?:01|70|5[58]))',
    '659' => '(?:85(?:11|0[1-3]))',
    '660' => '(?:85(?:[01]1|33|67|4[04]|5[058]|8[0258]))',
    '661' => '(?:8(?:5(?:[23]0|01|77|6[47]|5[058]|8[58]|1[01])|661))',
    '662' => '(?:85(?:[34]3|10|21|67|8[056]|5[258]|0[1-35]))',
    '663' => '(?:8(?:5(?:[13]0|[67]7|01|45|58|8[568])|601))',
    '664' => '(?:8(?:5(?:[58]8|33|2[02]|4[05]|0[1-3578]|1[01])|6(?:24|41|50|1[015])))',
    '665' => '(?:8(?:5(?:01|43|67|5[058]|8[58])|665))',
    '666' => '(?:(?:0292|8501))',
    '667' => '(?:(?:8(?:555|651)|0198))',
    '668' => '(?:(?:8(?:6(?:66|5[05])|501)|0(?:29[238]|393)))',
    '669' => '(?:(?:3(?:39[24-6]|19[28]|69[23]|495|892)|5(?:19[2378]|39[258]|292)|6(?:[2578]92|19[25])|2(?:[12]92|397)|159[25]|4[13]92))',
    '670' => '(?:8(?:5(?:3[03]|2[04]|4[34]|7[057]|8[058]|0[1-356]|6[067]|5[0458]|1[017])|6(?:5[25]|6[068]|7[57]|8[029])))',
    '671' => '(?:(?:1(?:2(?:9[235]|8[0-35689])|6(?:92|8[0-248])|1(?:92|8[018])|59[235]|39[23])|2(?:19[238]|59[358]|28[08])|419[23]|0295))',
    '672' => '(?:8(?:5(?:01|67|5[058]|8[58])|6(?:55|66|77)))',
    '673' => '(?:(?:8(?:5(?:[01]1|22|85)|6(?:66|8[68]))|1(?:49[3-5]|192|395)|0[45]92))',
    '674' => '(?:8(?:5(?:01|85)|686))',
    '675' => '(?:(?:8(?:5(?:22|33|66|77|88|1[019]|5[58]|0[15])|6(?:11|8[68]))|01(?:9[2-468]|8[0-68])|1(?:3(?:80|9[25])|192|297)|239[35]))',
    '676' => '(?:8(?:5(?:01|33|40|58|66|85|1[03])|6(?:55|7[07]|8[68])))',
    '677' => '(?:851[01])',
    '678' => '(?:(?:1(?:29[257]|19[58])|0(?:19[235]|292)|85(?:43|85)))',
    '679' => '(?:(?:5(?:3(?:92|8[0-3])|19[28]|292|595)|2(?:2(?:95|8[0-589])|392|493)|0(?:1(?:98|8[0178])|29[25])|4(?:19[235]|39[235]|298)|1[12]92|339[23]))',
    '680' => '(?:(?:8(?:5(?:41|3[13]|7[0-2578]|2[02]|6[16]|8[58]|0[12]|5[0-5]|1[017])|6(?:[01]1|[34]4|78|8[68])|701)|0(?:49[235]|197|792)|1192))',
    '681' => '(?:8501)',
    '682' => '(?:(?:8(?:5(?:[58]5|22|0[15])|6(?:[01]1|33))|0(?:19[2357]|498)))',
    '683' => '(?:8(?:5(?:20|1[0-268]|0[2-68])|6(?:70|86|0[1-5])))',
    '684' => '(?:8(?:5(?:[01]1|[58]5)|6(?:01|86)))',
    '685' => '(?:8(?:5(?:[58]5|12)|6(?:01|66)))',
    '689' => '(?:(?:2(?:29[2358]|39[235])|(?:[45]2|3[45])92|059[25]|119[23]))',
    '690' => '(?:(?:8(?:5(?:40|77|1\d|0[1-9]|5[0-68]|6[07]|2[0-35-8]|3[0-3569]|8[08])|6(?:[01]1|7[07]|6[068]|8[68])|794)|039[36]|219[28]|1492))',
    '691' => '(?:860[12])',
    '692' => '(?:8(?:5(?:[15]0|06)|6(?:86|0[16])))',
    '693' => '(?:8(?:5(?:01|23|66|3[013]|5[05]|8[57]|1[01])|6(?:01|14|8[69])))',
    '694' => '(?:850[12])',
    '695' => '(?:85(?:77|85|0[125]))',
    '696' => '(?:(?:0(?:19[2358]|393|692)|8510))',
    '697' => '(?:(?:8(?:5(?:01|85|1[12])|686|789)|0492))',
    '698' => '(?:(?:8(?:50[13-6]|65[01])|0292))',
    '699' => '(?:(?:0(?:5(?:88|9[23])|19[23]|29[23]|49[26]|69[67]|792)|1(?:39[2-6]|29[23]|592|898)|4(?:29[28]|692)|5(?:292|695)|2598))',
    '700' => '(?:8(?:5(?:2[0-2568]|4[04-69]|7[0-2578]|8[014-69]|0[1-8]|3[0-589]|5[0-24-8]|6[0-27-9]|1[0-24-9])|6(?:6[06]|7[78]|2[01358]|1[014-8]|5[057]|8[016-9]|0[1-8]|4[05]|3[459])|7(?:18|61|94|0[17]|2[27]|3[1-48])))',
    '701' => '(?:(?:0(?:29[25-8]|19[2357]|39[38])|4(?:39[248]|29[23]|59[23])|1(?:19[25]|29[26])|2(?:292|595)|329[23]))',
    '702' => '(?:8(?:5(?:44|0[1-35-8]|1[0-25])|60[1-35-79]))',
    '703' => '(?:8(?:5(?:20|44|6[06]|3[03]|8[0568]|0[1258]|5[058]|7[03-5]|1[016])|6(?:55|86)|750))',
    '704' => '(?:85(?:10|55|88|0[12]))',
    '705' => '(?:8(?:5(?:10|0[127]|[58][58]|7[57])|6(?:0[23]|1[45])))',
    '706' => '(?:8(?:5(?:01|55|88|3[13]|1[01])|65[15]))',
    '707' => '(?:85(?:85|0[12]))',
    '708' => '(?:(?:8(?:5(?:20|1[0-25-9]|0[1-35-79])|6(?:09|5[2-47]))|1(?:19[38]|39[23])|0(?:39[23]|698)))',
    '709' => '(?:(?:0(?:49[24-8]|89[2578]|792)|2(?:19[268]|39[38])|3(?:49[478]|198)|(?:12|4[23])92))',
    '710' => '(?:(?:8(?:5(?:11|43|75|8[158]|5[058]|[36][05]|0[15]|2[0258])|6(?:[347]8|[68]6|22|1[15]|0[125]))|029[2-48]|1398))',
    '711' => '(?:8(?:5(?:20|55|88|6[57]|1[01])|6(?:11|22|8[68])))',
    '712' => '(?:8(?:5(?:25|77|1[1-4]|3[34]|5[058]|8[58]|6[57]|0[125])|6(?:11|33|86)))',
    '713' => '(?:8(?:5(?:01|50|65|77|88)|6(?:01|86|6[68])|713))',
    '714' => '(?:(?:8(?:585|601)|129[78]|0192))',
    '715' => '(?:8(?:50[1-3]|60[1-3]))',
    '716' => '(?:(?:8(?:5(?:11|85|0[18])|601)|0(?:192|295|396)|1[13]92))',
    '717' => '(?:8501)',
    '718' => '(?:(?:85(?:[135]0|01|85)|0392))',
    '719' => '(?:(?:0(?:39[238]|19[25]|295)|3(?:19[2-57]|292)|119[235-8]))',
    '720' => '(?:(?:8(?:5(?:55|1[0-2578]|3[156]|0[1-47-9]|2[024-7])|6(?:01|50|3[6-9]|4[01357]))|039[278]|219[25]))',
    '721' => '(?:8(?:5(?:7[5-7]|6[47]|2[28]|8[568]|4[0135]|1[0145]|5[01568]|0[125])|6(?:31|88|0[17])))',
    '722' => '(?:(?:8(?:5(?:10|0[1-35-8])|60[1245])|2(?:19[238]|49[2-4]|39[23])|1(?:19[23]|[47]92)|039[23]))',
    '723' => '(?:8(?:5(?:01|20|55|1[0-25])|6(?:01|86|1[01])))',
    '725' => '(?:86[68]6)',
    '726' => '(?:8(?:6(?:28|32|1[04]|0[139])|5(?:[15]5|0[125])))',
    '727' => '(?:8501)',
    '728' => '(?:85(?:11|0[1-3]))',
    '729' => '(?:(?:3(?:19[238]|49[278]|592)|0(?:49[25]|292|393)|2(?:39[2-4]|292)|149[23]|4295|5792))',
    '730' => '(?:8(?:5(?:4[0-58]|6[1-35-7]|8[0235-79]|1[013-58]|5[0-289]|0[1-47-9]|7[015-7]|3[0-35689]|2[0-378])|6(?:7[02578]|4[1-36]|1[0-29]|8[067]|6[126-8]|5[0-8]|3[01]|2[026]|0[135689])|7(?:[23]0|87|0[1267]|9[4-7])))',
    '731' => '(?:(?:0(?:19[2-8]|29[235]|59[235]|692)|3(?:19[2-68]|39[358]|595)|4(?:39[236-8]|29[2-4])|1(?:59[57]|795)|519[35-8]|219[58]))',
    '732' => '(?:8(?:5(?:55|80|6[4-6]|7[05]|1[0-2]|0[13-57-9])|652|765))',
    '733' => '(?:8(?:6(?:89|3[03]|4[1-36-8]|6[09]|7[0578]|0[18]|2[1-7]|5[01]|1[016])|5(?:0[19]|4[0358]|5[0-358]|2[0158]|3[0135]|1[0-4])|701))',
    '734' => '(?:8(?:5(?:[37]0|22|43|58|6[07]|1[035])|798))',
    '735' => '(?:8(?:5(?:01|55|77|88|1[01])|6(?:70|86)))',
    '736' => '(?:8(?:5(?:10|55|0[124-9])|60[12]))',
    '737' => '(?:(?:8(?:5(?:20|41|54|0[1-9]|1[236-8])|6(?:09|11|86|5[0-3]))|2(?:29[357]|19[35]|39[37])|01(?:82|9[2358])))',
    '738' => '(?:(?:8(?:5(?:12|0[1-9])|60[1-3])|0292))',
    '739' => '(?:(?:8(?:5(?:01|30|1[1-4]|2[124-9])|6(?:0[1-3]|1[56]))|0(?:4(?:81|9[24-7])|69[23568]|19[238]|59[25])|1(?:19[25]|29[23]|79[24])|2(?:49[248]|69[235])))',
    '740' => '(?:8(?:5(?:[358]5|01|67|1[016])|6(?:11|39|86|4[26])))',
    '741' => '(?:8585)',
    '742' => '(?:(?:8(?:6(?:88|6[69]|2[25]|0[58]|4[56])|5(?:55|76|1[01])|7(?:14|87))|1(?:19[2-6]|59[28]|398)|0[34]92|219[23]))',
    '743' => '(?:(?:85(?:[15]0|61|77|0[12])|019[23]))',
    '744' => '(?:8(?:5(?:21|85)|6[01]1))',
    '745' => '(?:(?:8(?:6(?:[68]6|01|22|48|1[13]|5[56])|5(?:10|47|85|6[67]|2[29]))|069[68]))',
    '746' => '(?:8(?:6(?:01|66)|501))',
    '747' => '(?:(?:8(?:5(?:11|22|33|55|67|0[19]|8[58])|6(?:11|22|86))|0292))',
    '749' => '(?:0195)',
    '750' => '(?:(?:8(?:5(?:0[1-35-8]|2[0145]|1[0-3578])|6(?:10|0[1-378]))|069[23]|119[23]))',
    '751' => '(?:8(?:5(?:10|0[38])|630))',
    '752' => '(?:8(?:5(?:01|85|5[58]|1[01])|60[19]))',
    '753' => '(?:(?:8(?:5(?:88|1[017-9]|7[07]|3[013-8]|5[58]|0[1-4689]|2[0-25689])|65[034])|029[23]))',
    '754' => '(?:(?:8(?:5(?:[358]5|[01]1|22)|6(?:01|1[01]))|1(?:19[23]|292)|0291))',
    '755' => '(?:(?:8(?:5(?:22|43|8[058]|6[067]|1[01]|5[0457]|0[125])|6(?:33|42|0[19]|2[25]|1[01]))|019[25]))',
    '756' => '(?:8(?:5(?:85|0[12])|60[12]))',
    '757' => '(?:(?:8(?:5(?:11|85)|6(?:34|86))|029[28]))',
    '758' => '(?:8(?:6(?:15|86|4[58])|5(?:[58]5|70)))',
    '759' => '(?:(?:(?:22|55)92|029[2357]|419[2468]|659[25]))',
    '760' => '(?:8(?:5(?:90|4[5-7]|5[0-2457-9]|3[0346-9]|2[0-57]|6[0-246-9]|8[0235689]|1[0-8]|7[0-69]|0[2-578])|6(?:71|8[6-8]|6[0178]|3[04689]|5[05]|1[0458]|4[48]|2[013-6]|0[13478])))',
    '761' => '(?:(?:8(?:5(?:[014]1|20|8[124-689]|7[78]|6[5-7]|3[38]|5[0158])|601|777)|0(?:1(?:8[5-9]|9[2-8])|39[3-7]|49[23]|79[35]|692)|4(?:4(?:89|9[2-8])|3(?:88|9[235-8])|19[2-4])|1(?:79[2-5]|49[2-4]|592)|2(?:39[2356]|49[23])))',
    '762' => '(?:8(?:5(?:50|1[015]|0[23578])|60[12]))',
    '763' => '(?:8(?:5(?:0[1-478]|1[0-368])|60[358]))',
    '764' => '(?:85(?:20|0[1-3578]|1[01]))',
    '765' => '(?:850[235-8])',
    '766' => '(?:850[12])',
    '767' => '(?:85(?:07|85|1[03]))',
    '768' => '(?:(?:019[25]|860[12]))',
    '769' => '(?:(?:2(?:7(?:88|9[2-7])|69[2356]|19[235]|39[56]|[49]92)|0(?:19[2-578]|29[2356])|1(?:69[568]|192|593)))',
    '770' => '(?:8(?:5(?:7[0-3]|5[0-2458]|0[1-9]|1[0-68]|3[0-35-9]|2[0-689]|4[0146-8]|8[58]|6[0357])|6(?:10|48|0[15])|7(?:87|9[48])))',
    '771' => '(?:(?:0(?:1(?:9[2-8]|8[235-9])|2(?:8[1-57-9]|9[2-68]))|1(?:2(?:89|9[24578])|49[2-48]|[357]92|19[23]|695)|(?:33|2[135]|4[13]|5[24])95|6(?:192|495)))',
    '772' => '(?:8(?:5(?:20|1[015]|0[1-3])|601))',
    '773' => '(?:8(?:50[124]|601))',
    '774' => '(?:8[56]01)',
    '775' => '(?:(?:0[235]95|8570))',
    '776' => '(?:8(?:5(?:[01]1|55|8[2358])|6(?:11|86)))',
    '777' => '(?:(?:0395|8577))',
    '778' => '(?:(?:850[13-7]|0[12]95))',
    '779' => '(?:(?:3(?:39[3-5]|[4-6]95|29[58])|4(?:[478]95|19[35])|1(?:29[235]|195)|(?:53|2[13])95|019[2-5]))',
    '780' => '(?:8(?:5(?:3[024-69]|0[1-47-9]|4[0145]|5[03-589]|1[024-7]|2[0278]|6[125-8]|7[0-27])|6(?:86|7[067]|0[125]|6[013568])|787))',
    '781' => '(?:(?:9(?:5(?:[05]6|48|3[378]|2[569]|1[139])|68[3-9])|85(?:21|43|60|88|1[015]|5[1257])|5(?:19[25]|29[25]|79[23]|495)|(?:03|42|1[158])92|2(?:19[2-4]|492)|3(?:49[23]|692)|7185))',
    '782' => '(?:8502)',
    '783' => '(?:85(?:[58]5|0[125-9]|1[01]))',
    '784' => '(?:850[135])',
    '785' => '(?:(?:8(?:5(?:[01]1|20|33|85|7[046-8])|601)|0[156]95))',
    '786' => '(?:(?:0393|8501))',
    '787' => '(?:(?:0[38]92|8501))',
    '788' => '(?:8(?:501|686))',
    '789' => '(?:(?:1(?:[29]92|795)|0392))',
    '790' => '(?:8(?:5(?:0[12589]|4[0-356]|7[013-578]|5[13-7]|9[05]|6[015-7]|2[04589]|1[0-469]|3[0-579]|8[013-9])|6(?:01|32|7[78]|6[015-7]|8[68]|5[0-35689])|7(?:87|9[135-7])))',
    '791' => '(?:(?:8(?:5(?:5[015]|2[3-578]|1[0-36-8]|3[01568]|0[125-8])|6(?:0[34]|7[1257]))|0(?:2(?:8[018]|9[257])|3(?:85|9[2-578])|59[34])|3(?:19[2-8]|29[235]|[35]92)|(?:45|1[17])92|219[135]))',
    '792' => '(?:8(?:5(?:43|67|1[018]|8[0568]|5[05]|2[01]|0[15])|6(?:14|70|86)))',
    '793' => '(?:8(?:5(?:[58]5|1[056]|0[19])|601))',
    '794' => '(?:(?:8(?:5(?:[56]5|82|1[018]|0[28])|6(?:1[14]|0[12]))|2(?:[124]92|39[25]|59[23])|1(?:39[23]|[14]92)|019[23]))',
    '795' => '(?:(?:8(?:5(?:10|0[124-8])|60[13])|0392))',
    '796' => '(?:(?:0(?:29[235]|495)|850[12]))',
    '797' => '(?:(?:(?:02|1[257])92|85[01]1))',
    '798' => '(?:(?:8(?:6(?:01|1[14])|51[01])|4(?:19[2-7]|292|495)|1(?:39[2357]|192)|3(?:39[23]|792)|2192))',
    '799' => '(?:(?:1(?:5(?:8[128]|9[2-68])|39[2-5]|198|692)|2(?:29[2-4]|49[236]|19[25]|39[23]|69[26])|0(?:19[2-7]|49[235-8])|3(?:19[2-68]|79[23]|292)))',
    '800' => '(?:(?:8(?:5(?:10|85|5[05])|6(?:11|86|0[13]))|0(?:2(?:9[346-8]|8[12568])|39[2-6])))',
    '801' => '(?:8(?:5(?:85|5[05]|0[237]|1[01])|601))',
    '802' => '(?:8(?:5(?:33|8[015]|1[0-257]|0[1278]|5[058]|2[124]|6[0167]|4[035]|7[017])|6(?:42|51|77|86|0[14])|701))',
    '803' => '(?:8(?:5(?:20|43|3[0-35]|1[0-37]|6[17]|5[058]|8[068]|0[1458])|6(?:02|30|86|6[06])|787))',
    '804' => '(?:8(?:5(?:[126]0|77|88|0[135]|3[89]|5[08])|601))',
    '805' => '(?:8(?:5(?:[58]5|3[013-689]|2[0178]|0[1357-9]|1[02-468])|6(?:06|25)))',
    '806' => '(?:8(?:5(?:67|70|4[03]|0[19]|5[58]|1[01]|8[56])|6(?:[68]6|12|79)))',
    '807' => '(?:(?:85(?:01|8[568]|5[56])|019[28]|1392))',
    '808' => '(?:(?:8(?:5(?:1[045]|5[058]|8[58]|0[125])|606)|0196))',
    '809' => '(?:8501)',
    '810' => '(?:8(?:5(?:3[0-357-9]|1[1-9]|5[135-8]|7[01578]|2[0-578]|0[1-46-9]|8[13-57-9]|4[013-6]|6[0135-8])|6(?:8[035689]|3[134679]|4[28]|6[02-79]|7[03-7]|1[0179]|0[13-9]|2[0-2579]|5[0-6])|7(?:98|2[0-257]|3[14]|0[157]|1[06-8])))',
    '811' => '(?:(?:2(?:29[2-578]|19[2-6]|39[2358]|49[2568]|592)|3(?:19[23578]|29[3568]|492|598)|4(?:19[2358]|39[23]|292)|0(?:19[2-7]|295)|1(?:39[2-6]|292)|5192))',
    '812' => '(?:(?:8(?:6(?:8[0134679]|3\d|0[1-9]|4[0-35-8]|7[025-8]|5[0-79]|1[0-8]|2[0-24-9]|6[0-25689])|5(?:[1-3578]\d|0[1-9]|6[0-689]|4[0-8])|7(?:35|0[5-9]|1[78]|9[24]))|95(?:[24]0|11|8[89]|0[235]|5[12])))',
    '813' => '(?:8(?:5(?:29|33|55|77|1[39]|0[13]|8[58])|6(?:09|2[36]|8[01])))',
    '814' => '(?:(?:8(?:5(?:65|77|0[135]|8[58]|1[0-2]|2[0245]|5[03-6])|6(?:02|51)|798)|01(?:80|9[238])))',
    '815' => '(?:8(?:5(?:33|88|4[06]|0[13]|2[09]|5[05]|1[01])|6(?:[68]6|01)))',
    '816' => '(?:8(?:5(?:[67]7|01|30|[58][05]|1[01])|666))',
    '817' => '(?:(?:1(?:[26]92|797)|85(?:20|1[07])))',
    '818' => '(?:(?:8(?:5(?:16|55|67|0[1-3]|7[178]|4[09]|8[58])|6(?:42|86|6[68]))|019[2-578]))',
    '819' => '(?:(?:8(?:5(?:11|33|85|5[0-258]|0[124])|611)|1(?:19[235]|[36]92)|0(?:19[23]|395)))',
    '820' => '(?:(?:8(?:5(?:[24]0|33|1[02367]|5[05]|0[125-8])|60[1-357])|0(?:[2357]92|69[36])|119[23]))',
    '821' => '(?:8501)',
    '822' => '(?:(?:1(?:29[236]|19[23]|492)|8(?:5(?:[58]5|01)|666)))',
    '823' => '(?:8555)',
    '824' => '(?:(?:8(?:5(?:55|1[01])|6[01]1)|0[128]92))',
    '825' => '(?:8(?:5(?:[67]7|01|8[58])|601))',
    '826' => '(?:8(?:5(?:[58]5|29|67)|609))',
    '827' => '(?:8501)',
    '828' => '(?:8501)',
    '829' => '(?:0(?:39[23]|192))',
    '830' => '(?:(?:8(?:5(?:67|0[135]|3[03]|4[013]|1[0-25]|7[07]|[58][58]|2[0-2])|6(?:77|6[6-8]|0[1-36]|1[12]|2[29]|8[68]|3[01]))|1(?:19[2356]|298)|65(?:28|87)|0[12]92))',
    '831' => '(?:8(?:6(?:01|86)|501))',
    '832' => '(?:8(?:555|601))',
    '833' => '(?:8601)',
    '834' => '(?:(?:0(?:19[2-68]|292)|1[24]92|85[58]5))',
    '835' => '(?:(?:8[56]01|0192))',
    '836' => '(?:8(?:5(?:77|3[13]|0[25]|1[02]|6[67]|8[58])|6(?:[68]6|10)))',
    '837' => '(?:8501)',
    '838' => '(?:(?:8(?:6(?:[68]6|77|0[12])|5(?:85|1[25]))|1(?:39[78]|79[23]|[56]92)|0(?:19[378]|298)))',
    '839' => '(?:(?:1(?:39[3-6]|49[378]|298)|85(?:40|0[12568])|029[235]))',
    '840' => '(?:(?:8(?:5(?:[2-46]0|11|5[0-258]|8[058]|0[128]|7[01])|6(?:11|27|66|0[12]|8[689]))|2(?:19[2357]|295)|0(?:292|598)|1192))',
    '841' => '(?:8(?:5(?:11|85|0[1-5])|6(?:11|86|0[12])))',
    '842' => '(?:(?:8(?:5(?:85|0[12])|601)|0(?:19[2357]|29[23])))',
    '843' => '(?:(?:8(?:5(?:01|8[58]|5[05])|6(?:39|86))|039[2-4]))',
    '844' => '(?:8(?:6(?:16|25|0[12])|5(?:[58]5|01)))',
    '845' => '(?:85(?:01|1[01]))',
    '846' => '(?:8501)',
    '847' => '(?:(?:8(?:5(?:11|55|88)|601)|0(?:19[23]|39[23])|1292))',
    '848' => '(?:(?:0492|8501))',
    '849' => '(?:(?:85(?:14|22|77|0[1-3]|[58][58])|1(?:39[2-4]|[14]92|698)|3(?:19[23]|29[23])|419[2-5]|239[235]|519[238]|059[27]))',
    '850' => '(?:8(?:5(?:2[0-35]|8[0568]|1[0-258]|7[057]|5[0158]|0[13-8]|6[0367]|3[0167]|4[013578])|6(?:22|45|50|7[78]|1[018]|6[268]|8[5-8]|0[236])))',
    '851' => '(?:(?:0(?:49[2-478]|19[358]|39[25]|592)|2(?:1(?:85|9[5-8])|29[28]|492)|3(?:39[24]|[25]92)))',
    '852' => '(?:8(?:5(?:32|66|77|88|1[015]|0[17-9]|4[24]|5[58]|2[0-378])|601|794))',
    '853' => '(?:(?:8(?:50[12]|601)|(?:06|2[23])92))',
    '854' => '(?:(?:8(?:5(?:40|55|0[19])|6(?:01|50|66))|0(?:69[26-8]|59[235]|[24]92)))',
    '855' => '(?:8(?:5(?:01|5[05])|686))',
    '856' => '(?:8(?:5(?:[58]5|16|77|6[0-28])|6(?:70|86|0[19])))',
    '857' => '(?:(?:8(?:5(?:33|58|66|0[1-38]|8[58]|7[57]|1[01])|6(?:[68]6|11))|2(?:49[24]|392)|4(?:495|592)|119[2-578]|0[134]92))',
    '858' => '(?:85(?:01|55|8[0589]))',
    '859' => '(?:(?:3(?:79[2378]|29[238]|692)|0(?:49[2578]|19[23])|(?:1[2-5]|6[24])92|4(?:59[5-8]|892)|5(?:39[23]|192)))',
    '860' => '(?:8(?:5(?:3[013469]|1\d|8[014-8]|7[057]|0[1-9]|6[5-8]|5[0-24-8]|4[01357]|2[0-8])|6(?:2[245]|1[1589]|8[168]|5[05]|0[1-68]|6[08])|7(?:39|9[25-7])))',
    '861' => '(?:(?:0(?:59[2-68]|19[58]|69[28]|89[28]|[39]92)|4(?:1(?:89|9[23568])|[34]92|696)|1(?:19[23578]|39[24]|295)|3(?:19[2-6]|29[56]|592)|5(?:49[2-5]|59[28]|292)|85(?:01|14|38|2[089])|2(?:29[35-7]|[14]92)|6[13]95|7292))',
    '862' => '(?:8(?:6(?:6[06]|7[6-8]|2[02]|3[359]|0[139]|1[0-2]|8[08]|5[125])|7(?:44|1[06]|9[34]|0[12]|2[01])|5(?:[58]5|10|0[2458]|7[01])))',
    '863' => '(?:(?:8(?:6(?:31|86)|5[58]5)|2(?:292|895)|1992))',
    '864' => '(?:8(?:6(?:11|86)|501))',
    '865' => '(?:(?:85(?:[01]1|33|77|5[05])|019[23]))',
    '866' => '(?:(?:8(?:5(?:[58]5|33|0[1-3]|1[01])|6(?:60|86|0[125]))|0(?:29[235]|195)))',
    '867' => '(?:85(?:[58]5|01))',
    '868' => '(?:(?:8(?:5(?:55|1[15]|0[1-358])|601)|0(?:59[23578]|39[23]|795)))',
    '869' => '(?:(?:0(?:19[238]|29[235]|49[2-4]|59[238]|696)|2(?:59[2358]|69[2356]|49[23])|1(?:29[2358]|19[23])|5(?:39[23]|498|692)|3(?:296|692)|4292))',
    '870' => '(?:(?:8(?:5(?:70|0[1-46]|4[14]|1[013]|5[0158]|[38][58]|2[13-5]|6[02-4])|6(?:46|58|8[6-8]|1[169]|3[4-6]|7[67]|2[07]|6[05]|0[125]))|0(?:1(?:89|9[2-8])|39[235-8]|[29]92|401)|1(?:19[258]|292)))',
    '871' => '(?:(?:8(?:5(?:21|77|85|5[05]|0[12]|1[01])|6(?:[02]9|42|66|8[68]))|0(?:99[23]|[27]95|192)))',
    '872' => '(?:0592)',
    '873' => '(?:(?:0(?:29[238]|498)|8501))',
    '874' => '(?:8(?:5(?:[01]1|[67]7|38|8[58]|5[578])|6(?:11|39|6[06]|8[68])))',
    '875' => '(?:(?:8(?:6(?:86|1[26])|501)|0292))',
    '876' => '(?:(?:8(?:5(?:55|8[05])|6(?:01|66))|2492))',
    '877' => '(?:(?:8(?:5(?:01|55)|6(?:01|86))|0(?:39[23]|296)|1292))',
    '878' => '(?:8555)',
    '879' => '(?:(?:5(?:19[235-8]|59[235]|498)|4(?:49[28]|[26]92|194)|0(?:49[2358]|692)|(?:26|6[16])92|159[2358]|719[28]))',
    '880' => '(?:(?:8(?:5(?:7[05-7]|4[3-6]|2[02357]|1[0-357-9]|8[01368]|3[02359]|0[1-357-9]|6[167]|5[015-9])|6(?:10|25|49|3[39]|0[124-6]|6[68])|725)|1(?:19[2356]|39[28])|029[3-578]|229[23]))',
    '881' => '(?:85(?:01|67))',
    '882' => '(?:(?:8(?:6(?:11|66|78|8[68])|5(?:85|0[38]))|1(?:29[3-5]|192)|0192))',
    '883' => '(?:(?:85(?:01|10|33|55|8[58])|(?:01|13)92))',
    '884' => '(?:86(?:[01]1|55|66))',
    '885' => '(?:(?:8(?:5(?:11|33|55|67|8[58]|0[12])|6(?:01|36|1[018]))|129[258]))',
    '886' => '(?:(?:8(?:5(?:20|88|0[1-356]|1[0-2])|6(?:11|0[12]))|0[12]92))',
    '887' => '(?:8(?:585|686))',
    '888' => '(?:8555)',
    '889' => '(?:(?:1(?:49[2358]|69[2356]|99[4-7]|[18]92|795)|0(?:69[235-8]|59[25]|[13]92)|(?:4[2-5]|2[14])92))',
    '890' => '(?:8(?:5(?:6[05-7]|3[0-35]|1[0-2578]|0[1-9]|8[015689]|4[013-5]|2[0-57]|5[0258]|7[014578])|6(?:[68]6|10|0[13])|7(?:60|9[48])))',
    '891' => '(?:(?:0(?:1(?:8[02-46-9]|9[2-8])|49[378]|[67]92)|3(?:19[2-68]|69[23]|79[23])|1(?:39[2-5]|[15]92)|9(?:29[2-6]|192)|(?:[46]2|7[16])92|2(?:39[36]|192)|8293))',
    '892' => '(?:8(?:5(?:20|4[03]|1[25]|8[568]|5[058]|6[367]|3[01359]|0[125])|6(?:11|26|33|50|77|88|0[13])))',
    '893' => '(?:(?:1(?:19[28]|69[23]|298)|8(?:5(?:10|0[12])|611)|(?:02|2[34])92))',
    '894' => '(?:(?:8(?:5(?:11|55|67|0[17]|8[58])|6(?:01|55|77|88))|(?:3[13]|1[25])92|0(?:192|595)))',
    '895' => '(?:(?:8(?:5(?:40|55|88|0[1-6]|1[59])|6(?:01|50|86))|1(?:29[2356]|49[23]|595)|229[28]|0292))',
    '896' => '(?:(?:1(?:[13]92|696)|86(?:01|86)))',
    '897' => '(?:(?:039[23]|8501))',
    '898' => '(?:8501)',
    '899' => '(?:(?:5(?:19[235]|29[2-4]|69[348]|49[25]|392)|6(?:49[2-5]|19[23]|29[23]|592)|(?:3[14]|7[146]|8[16])92|2(?:59[2-6]|[127]92)|4(?:39[2-6]|[12]92)|0(?:29[23578]|492)|1(?:395|498|696)))',
    '900' => '(?:8(?:5(?:5\d|2[02457]|8[1568]|4[03-578]|1[02-467]|6[07]|3[013-5]|0[13-5]|7[01578])|6(?:10|66|78|0[1-589]|5[014]|8[68])|7(?:[01]1|35|9[4-7])))',
    '901' => '(?:(?:2(?:5(?:40|88|97|0[1267]|6[0679]|1[0-25]|5[0-35-9]|2[0156]|3[01])|6(?:86|0[127]|1[01])|7(?:01|10|33)|49[2356]|39[235])|0(?:19[2-467]|49[2-6]|29[245]|39[23]|592)|1(?:19[2356]|39[23]|49[25]|292|595)|3(?:[679]92|19[23]|59[25]|496|895)))',
    '902' => '(?:85(?:21|1[0-3]|8[58]|5[05]|7[01]))',
    '903' => '(?:(?:02(?:20|1[013-578]|0[13-7])|860[1-3]))',
    '904' => '(?:(?:0(?:49[2-7]|39[2-58]|19[2-5]|29[35])|2(?:19[2-46]|29[2-4]|39[2-4])|8(?:5(?:[01]1|85)|686)|1(?:29[2-4]|[13]92)))',
    '905' => '(?:(?:0(?:59[2-6]|79[2-6]|[24]92|695)|8(?:5(?:01|12|40|85)|6(?:11|68))|1(?:[23]92|495)|2192))',
    '906' => '(?:(?:8(?:5(?:01|50)|601)|0[256]92))',
    '907' => '(?:(?:850[1-3]|1[28]92))',
    '910' => '(?:(?:8(?:5(?:3[0235-9]|4[0-58]|8\d|0[1-47-9]|5[0-57-9]|1[0-79]|6[0-24-8]|2[0-8]|7[15689])|6(?:22|30|6[056]|0[136]|5[05]|8[068]|7[08]|1[01])|730)|1(?:19[2-5]|29[2-5]|392)|0(?:29[236-8]|39[23])|(?:23|36)92|419[35-8]))',
    '911' => '(?:8(?:5(?:[03]1|[14]0|85|5[58])|601))',
    '912' => '(?:(?:8(?:5(?:[58]5|24|40|67)|6[68]6)|0292))',
    '913' => '(?:8(?:5(?:[01]1|33|55|77|8[58])|611))',
    '914' => '(?:(?:8(?:5(?:[14]0|24|67|5[058]|8[05]|0[12])|6(?:09|66|8[68]))|019[258]))',
    '915' => '(?:(?:8(?:5(?:01|55|77|1[015]|3[03]|2[04]|8[568])|666)|0292|1195))',
    '916' => '(?:(?:8(?:5(?:67|5[058]|8[58]|1[05]|0[1578])|6(?:[468]6|01))|0(?:29[235]|[14]92)|1198))',
    '917' => '(?:(?:8(?:5(?:[24]4|33|77|6[17]|5[058]|1[12]|0[57]|8[0458])|6(?:01|86))|0(?:29[378]|[13]98)))',
    '918' => '(?:8(?:5(?:4[03]|6[05-8]|1[0158]|7[0578]|2[0235]|3[037]|5[02568]|8[03568]|0[1-3589])|6(?:68|8[168])))',
    '919' => '(?:(?:0(?:59[24578]|69[2578]|[124]92|898)|1(?:39[235-7]|[15]92)|2(?:29[2-4]|392)))',
    '920' => '(?:(?:8(?:5(?:4[0134]|2[0-25]|3[0135-9]|1[0-35-8]|7[0357]|0[1-57-9]|5[0-8]|[68][035-8])|6(?:2[0-358]|8[1568]|5[04-8]|0[125-79]|3[0-37-9]|7[0146-8]|4[0-248]|6[0156]|1[0-69])|7(?:[67]7|30|9[3-7]|0[17]|2[189]|1[0189]))|0(?:3(?:8[135-8]|9[23568])|29[235]|192)|1(?:1(?:92|8[0-245])|39[2367])|2(?:39[2-5]|19[256])|3198))',
    '921' => '(?:8(?:5(?:6[0-245]|5[025]|1[0-2578]|3[0-269]|0[15-8]|2[035-79]|8[0-589]|4[1468]|7[1-79])|6(?:01|16|50|3[079]|2[01])|798))',
    '922' => '(?:(?:8(?:5(?:[37]0|01|66|2[25]|8[58]|5[05]|1[01])|6(?:09|11|22|50|78|86))|0(?:29[3-578]|19[23]|49[57]|595)))',
    '923' => '(?:(?:8(?:5(?:6[05-7]|5[0-257]|8[0168]|7[058]|3[013]|2[0158]|0[1-357]|4[14-6]|1[01])|6(?:50|66|2[06]|4[02-46]|0[13569]|1[0156]|8[68]|3[039]))|1(?:29[2-7]|198)|039[238]))',
    '924' => '(?:8(?:5(?:22|33|44|77|6[06]|8[058]|5[58]|1[01])|68[68]|777))',
    '925' => '(?:(?:8(?:5(?:11|30|85|6[67]|0[12568]|5[05]|2[15])|6(?:[12]0|09|88))|0(?:19[38]|392|498|697)))',
    '926' => '(?:(?:8(?:5(?:[013]1|20|66|4[015]|8[568]|5[058])|6(?:[68]6|42|50|1[01]|0[1-359]))|0(?:29[23]|192)))',
    '927' => '(?:(?:0(?:49[235]|29[23]|695)|129[57]|219[23]|8601))',
    '928' => '(?:(?:8(?:5(?:[28]5|41|0[12])|609)|039[235]))',
    '929' => '(?:(?:1(?:2(?:87|9[23])|39[2-7]|19[23568]|49[2-4]|[6-8]92)|0(?:49[2-5]|19[238]|29[26]|39[23])|2(?:19[25]|[23]92)))',
    '930' => '(?:(?:8(?:5(?:2[0-25-7]|4[03-58]|0[14-9]|6[0-35-7]|3[0-35-9]|8[0135-9]|1[0-35-8]|7[013578]|5[024-68])|6(?:5[06]|0[3-5]|4[24]|3[067]|8[0167]|1[01]|6[06-8]))|0(?:19[3-68]|39[3-57]|29[238])|1(?:29[258]|392)|2198))',
    '931' => '(?:8(?:5(?:33|62|2[23]|4[03]|7[17]|0[128]|[58][58]|1[0157])|6(?:01|88)))',
    '932' => '(?:(?:8(?:5(?:40|67|75|1[0-258]|3[38]|5[0158]|8[58]|0[1-358]|2[0258])|611)|0(?:39[23568]|29[238]|19[38])))',
    '933' => '(?:(?:8(?:5(?:4[03]|6[367]|8[58]|1[01568]|0[126-8]|3[0-3578]|5[08]|2[035-8])|6(?:[28]8|66|1[01]|0[1356])|7(?:77|88))|0(?:39[235-8]|19[235]|29[35])))',
    '934' => '(?:8(?:5(?:22|77|6[78]|3[14]|8[058]|0[12]|5[08]|1[15])|6(?:[15]1|8[68])))',
    '935' => '(?:8(?:5(?:01|55|3[15])|6(?:01|86)))',
    '936' => '(?:8(?:5(?:36|77|0[127]|[58][58])|6(?:86|0[18])))',
    '937' => '(?:8(?:5(?:[58]5|03|11|6[67])|6(?:01|60|78)))',
    '938' => '(?:(?:8(?:6(?:1[0-3]|0[12])|5(?:[58]5|0[25]))|029[23]))',
    '939' => '(?:(?:8(?:5(?:21|67|0[127]|[58][058]|1[0157]|7[12])|6(?:01|50|3[06]|4[02]|1[01]))|1(?:39[2-8]|89[23578]|59[2356]|69[2-48]|19[23]|99[78]|492)|0(?:29[2-6]|79[2358]|39[258]|[15]92|693)|2(?:29[23578]|39[238]|69[24]|192|595|798)|3593))',
    '940' => '(?:(?:8(?:5(?:67|7[027]|3[02]|2[12]|0[18]|5[0458]|1[01]|8[03568])|6(?:41|60|86|3[013]|5[0134]|0[235]|[12][0-2])|707)|2(?:1(?:8[1-468]|9[258])|0(?:93|8[1-358])|59[25]|[34]92)|029[2-8]|119[3-68]))',
    '941' => '(?:8(?:6(?:[01]1|86)|50[12]))',
    '942' => '(?:(?:8(?:5(?:63|0[1258])|6(?:[01]1|66))|0(?:19[2-6]|39[238]|492)|1492))',
    '943' => '(?:(?:8(?:5(?:61|1[025]|4[045]|3[0134]|2[0-25]|8[58]|5[125]|0[1-35])|6(?:1[06]|0[147]))|0(?:19[23]|595|692)))',
    '944' => '(?:(?:8(?:5(?:01|88|5[05])|6(?:01|86))|0192))',
    '945' => '(?:(?:8(?:5(?:[01]1|[38]5|40|5[58])|6(?:[01]1|88))|1(?:39[23578]|[15]95)|0(?:19[2-4]|39[57])))',
    '946' => '(?:(?:8(?:513|601)|0292))',
    '947' => '(?:(?:8(?:5(?:[58]5|40|0[1-46])|7(?:01|65))|019[238]))',
    '948' => '(?:(?:8(?:50[1-4]|602)|0192))',
    '949' => '(?:(?:7(?:49[24-6]|59[24]|277|392)|3(?:29[2-468]|19[2-4]|494)|6(?:69[256]|[124]92|797)|4(?:19[2-4]|39[278])|2(?:19[2-4]|39[24])|5(?:49[2-4]|292)|039[238]|8492))',
    '950' => '(?:(?:8(?:5(?:6[05-7]|3[0-3579]|0[1-57]|4[013-578]|1[0-48]|5[0-35-9]|7[0-25-79]|8[0-689]|2[02-4])|6(?:7[78]|6[0168]|1[09]|5[0145]|0[1-3568]|[48][01]|2[0-69]|3[039])|7(?:0[17-9]|5[01359]|3[0235-8]|2[0-57]|1[015-8]|9[48]|4[0-24-9])|801)|1(?:1(?:79|9[2-7]|8[1-36-9])|29[2-68]|49[258])|2(?:0(?:8[24-9]|9[235-7])|1(?:8[18]|9[258])|292)|0(?:19[23568]|292)|319[578]))',
    '951' => '(?:8(?:5(?:70|4[04]|2[018]|1[0-489]|6[067]|3[01356]|8[0156]|0[2-478]|5[0-6])|6(?:01|40|78|8[056]|5[05]|3[023]|2[029]|1[0-2]|6[68])))',
    '952' => '(?:(?:1(?:59[23]|292|393)|850[12]))',
    '953' => '(?:(?:8(?:6(?:66|0[12])|50[13])|019[23]))',
    '954' => '(?:(?:86(?:19|58|86)|019[25]))',
    '955' => '(?:(?:8(?:5(?:43|67|0[135]|5[058]|7[57]|8[589]|1[01])|6(?:12|55|66|77|0[1-3]|8[68]))|0192))',
    '956' => '(?:(?:86(?:[23]5|0[1-3])|0192))',
    '957' => '(?:(?:8(?:5(?:[34]0|11|22|67|5[058]|8[58]|0[236])|6(?:[68]6|01)|701)|0(?:19[235-7]|293)))',
    '958' => '(?:(?:8(?:5(?:01|33|85|5[58])|6(?:01|86))|0292))',
    '959' => '(?:(?:0(?:29[2-6]|59[235-7]|19[2-4]|39[23]|492)|1(?:29[2-468]|39[2357]|69[235]|79[457])|2(?:6(?:88|93)|39[357]|09[23]|292|711)|3(?:19[2-46]|49[23]|292|993)|4(?:49[57]|392)))',
    '960' => '(?:(?:8(?:5(?:75|4[06]|8[014589]|5[058]|6[067]|3[0146]|2[0-4]|0[1-35-9]|1[1-3568])|6(?:48|3[39]|2[056]|7[07]|0[1-357]|6[068]|1[014]|8[68]|5[15]))|0(?:2(?:8[0239]|9[46-8])|1(?:9[245]|8[0145])|69[25]|596|893|992)|1(?:19[235-8]|29[235-7]|39[23]|[48]92)|2(?:19[3-6]|292)))',
    '961' => '(?:(?:8(?:5(?:22|1[16]|8[58]|0[18])|6(?:11|86|0[12]))|0[134]92))',
    '962' => '(?:(?:8(?:50[1-37-9]|601)|0[2356]92))',
    '963' => '(?:(?:8(?:5(?:20|4[03]|0[1-36-8]|[13][01359]|6[0346-8]|7[0578]|5[01568]|8[03568])|6(?:[24]2|55|7[05-7]|6[014-68]|3[07]|0[129]|1[01]|8[56])|292|794)|0(?:19[25-8]|29[67])|4(?:39[368]|[16]92)|(?:6[1-3]|3[46])92|5(?:49[23]|[16]92)|7(?:796|893)|138[036-8]))',
    '964' => '(?:(?:8(?:5(?:[67]7|01|58)|601)|0[23]92))',
    '965' => '(?:8(?:5(?:[347]0|67|0[1-6]|8[058]|2[02]|5[08]|1[016])|6(?:[01]1|78)))',
    '966' => '(?:(?:0(?:19[2-4]|485)|8601))',
    '967' => '(?:(?:0692|8501))',
    '968' => '(?:0498)',
    '969' => '(?:(?:1(?:1(?:8[0168]|9[235])|[2-46]92|79[23])|6(?:19[25]|59[23]|292|495)|0(?:19[67]|29[26]|[34]92)|3(?:39[2356]|[14]92|593)|2696|4495))',
    '970' => '(?:(?:8(?:6(?:[23]5|[48]6|11)|5(?:[05]1|1[16])|410|703)|119[2-4]))',
    '971' => '(?:8555)',
    '972' => '(?:85(?:01|55))',
    '973' => '(?:8(?:5(?:01|55)|601))',
    '974' => '(?:8686)',
    '975' => '(?:8(?:585|686))',
    '976' => '(?:85(?:01|10))',
    '979' => '(?:(?:0(?:19[25-8]|69[56])|2(?:39[2-4]|195|792)|1(?:[135]92|495)))',
    '980' => '(?:(?:8(?:4(?:7[78]|4[1-35-8]|8[014-8]|0[1-36-8]|2[0-369]|1[0145]|3[013569]|5[02-468]|6[016])|5(?:[15][015]|3[134]|7\d|4[346]|2[01569]|0[158]|6[0156]|8[013578])|6(?:40|86|5[0-26]|6[018]|0[1258]|3[1-36-9]|2[12]|7[017])|7(?:11|33|77|0[137]|9[2-578]))|6(?:0(?:55|88)|1(?:61|80))))',
    '981' => '(?:(?:3(?:2(?:8[0178]|9[235-8])|6(?:8[0-24-68]|9[278])|1(?:9[2-5]|8[0589])|49[4-7]|[35]92)|85(?:10|33|85|2[23]|6[03]|5[0-26-8]|0[25]|7[07]|4[035])|1(?:5(?:8[1-3]|9[2356])|29[2-58])|4(?:29[2-4]|392)|0394|2192))',
    '982' => '(?:8(?:5(?:31|44|66|77|2[13]|8[58]|5[15]|1[01]|0[125])|601|798))',
    '983' => '(?:8(?:5(?:70|85|6[0257]|0[1247]|3[367]|4[35]|2[023]|1[1-37]|5[1256])|6(?:01|22|39)|477))',
    '984' => '(?:8(?:5(?:0[135]|7[057]|2[25]|6[0178]|8[0458]|3[0389]|1[0-2689]|5[0-3578]|4[035])|6(?:42|54|7[056]|0[13]|8[068]|6[689])))',
    '985' => '(?:8(?:5(?:77|5[015]|2[12]|1[01]|0[12467]|3[13578])|6(?:55|0[17])))',
    '986' => '(?:(?:85(?:40|55|0[17]|2[25]|8[05])|0(?:195|792)|229[23]))',
    '987' => '(?:(?:2(?:29[23]|59[23]|195|392)|0(?:59[235]|19[25]|792)|860[23578]|139[35]))',
    '988' => '(?:(?:85(?:55|0[12])|039[23]))',
    '989' => '(?:(?:6(?:1(?:9[235]|8[1-358])|49[23]|[38]92)|1(?:69[2-5]|29[235]|39[2-4]|592|795)|2(?:4(?:8[0134]|9[236])|292|393)|0(?:29[2-6]|[58]92|998)|5(?:[3-5]92|69[23])|(?:32|4[15-7])92))',
    '990' => '(?:(?:8(?:5(?:8[057]|5[0158]|1[0-29]|6[067]|4[05]|7[01578]|0[126]|2[125]|3[1359])|6(?:[24]2|11|68|0[16]|7[078])|794)|95(?:06|59|67|78|3[06]|8[0-258])|0(?:49[23]|[37]92)|2(?:196|292)))',
    '991' => '(?:8(?:5(?:[58]5|21|1[1-3]|0[158])|6(?:01|1[03])))',
    '992' => '(?:(?:8(?:5(?:[1245]0|0[12])|6(?:01|10))|0(?:39[23]|[48]92)))',
    '993' => '(?:8(?:6(?:11|42|0[12])|5[01]1))',
    '994' => '(?:8(?:5(?:01|85|1[01])|6[01]1))',
    '995' => '(?:8666)',
    '996' => '(?:8(?:5(?:01|85)|602))',
    '997' => '(?:(?:8(?:5(?:01|67|2[23]|1[015]|[58][58])|6(?:[01]1|55))|0(?:29[26]|[14]92)|1392))',
    '998' => '(?:(?:8(?:5(?:[14]0|8[058]|5[05]|0[12])|6(?:11|33))|019[24]))',
    '999' => '(?:(?:3(?:79[25-7]|19[23]|292)|7(?:69[56]|292)|0(?:193|696)|[1458]292|229[23]))',
);

1;
__END__
