# Generated by default/object.tt
package Paws::GameLift::InstanceDefinition;
  use Moose;
  has InstanceType => (is => 'ro', isa => 'Str', required => 1);
  has WeightedCapacity => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::InstanceDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::InstanceDefinition object:

  $service_obj->Method(Att1 => { InstanceType => $value, ..., WeightedCapacity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::InstanceDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->InstanceType

=head1 DESCRIPTION

B<This data type is used with the GameLift FleetIQ and game server
groups.>

An allowed instance type for a GameServerGroup. All game server groups
must have at least two instance types defined for it. GameLift FleetIQ
periodically evaluates each defined instance type for viability. It
then updates the Auto Scaling group with the list of viable instance
types.

=head1 ATTRIBUTES


=head2 B<REQUIRED> InstanceType => Str

An EC2 instance type designation.


=head2 WeightedCapacity => Str

Instance weighting that indicates how much this instance type
contributes to the total capacity of a game server group. Instance
weights are used by GameLift FleetIQ to calculate the instance type's
cost per unit hour and better identify the most cost-effective options.
For detailed information on weighting instance capacity, see Instance
Weighting
(https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html)
in the I<Amazon EC2 Auto Scaling User Guide>. Default value is "1".



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

