# Generated by default/object.tt
package Paws::Chime::DNISEmergencyCallingConfiguration;
  use Moose;
  has CallingCountry => (is => 'ro', isa => 'Str', required => 1);
  has EmergencyPhoneNumber => (is => 'ro', isa => 'Str', required => 1);
  has TestPhoneNumber => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::DNISEmergencyCallingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::DNISEmergencyCallingConfiguration object:

  $service_obj->Method(Att1 => { CallingCountry => $value, ..., TestPhoneNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::DNISEmergencyCallingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CallingCountry

=head1 DESCRIPTION

The Dialed Number Identification Service (DNIS) emergency calling
configuration details associated with an Amazon Chime Voice Connector's
emergency calling configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CallingCountry => Str

The country from which emergency calls are allowed, in ISO 3166-1
alpha-2 format.


=head2 B<REQUIRED> EmergencyPhoneNumber => Str

The DNIS phone number to route emergency calls to, in E.164 format.


=head2 TestPhoneNumber => Str

The DNIS phone number to route test emergency calls to, in E.164
format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

