// 
//  Copyright (C) 1995,2007,2010  Smithsonian Astrophysical Observatory
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with this program; if not, write to the Free Software Foundation, Inc.,
//  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

/*H****************************************************************************
 
* FILE NAME: %M%
 
* DEVELOPEMENT: UI
 
* DESCRIPTION:
 
        This file conatins the class definition for the Host Level 
	Parameter interface. This class incapsulates the IRAF Compatible
	Parameter interface library into a class.
 
* NOTES:
 
        This class is based on the IRAF Compatible Parameter interface.
	This class does not support the structure option.
	This class is tuned to work directly with the ASCDS Parameter
	Dialog Box
 
* REVISION HISTORY:
 
        Ref. No.        Date
        --------        ----
        %I%             %G%
 
*H****************************************************************************/

#ifndef PARAMETER_HH
#define PARAMETER_HH

#include <list>
#include <string>
#include "ParamItem.hh"

#include "parameter.h"

using namespace std;

class Parameter
{

public:

  friend ostream & operator<< (ostream &, Parameter &);
  friend istream & operator>> (istream &, Parameter &);

  // Constructor
    Parameter ();
    Parameter (string pfname, int argc = 0, char **argv = NULL, int arg1 = 1);
    Parameter (int argc, char **argv);

  // Destructor
    virtual ~ Parameter ();

  // Opens and reads the parameter contents into memory. An error code 
  // of BAD is returned if an error occurs.
  int Load (int argc = 0, char **argv = NULL);

  // Returns the changes made to the parameter file
  string GetChanges ();

  // Returns a string containing param1=value1 param2=value2 ...
  // evaluate parameter specifies whether or not to evaluate indirections 
  string GetValues (int evaluate = 0);

  bool GetReadOnly ()
  {
    return read_only;
  };

  string GetFileRead ()
  {
    return _fileRead;
  }
  // cancel changes made
  void CancelChanges ();

  // get information in sorted order
  char **GetCharsByPosition (int);
  short *GetWidthsByPosition (int);

  // Writes out the parameter file. An error code of BAD is returned if an 
  // error occursstatus.
  int Write (string fname, int updateHidden = 0);

  // Save output to specified filename. If overwrite is 0 and file exists
  // then exit w/ error. Works in two phases- 1st copies the input file to
  // the output file then updates the file with current changes.  
  int SaveAs (char *fname, int overwrite = 0, int updateHidden = 0);

  // check if pval would be valid for pname (pval evaluates to eval)
  int CheckValidity (char *pname, char *pval, char *eval);

  // Sets the values from the command line
  void SetValues (int argc, char **argv);

  // Returns the number parameters in the list
  int GetLength ();

  // Returns the Parameter for an index or position
  //void GetIndex(int index,ParamItem &item);    removed 
  void GetPosition (int pos, ParamItem & item);

  // Returns the Parameter for the given name
  bool GetParameterByName (const char *name, ParamItem & item);
  bool GetParameterByName (string name, ParamItem & item);
  bool GetParameterByName (const char *name, ParamItem ** item_p);
  bool GetParameterByName (string name, ParamItem ** item_p);

  // Sets a new value in the parameter at index. A 0 is returned
  // if an error was encountered.
  //int SetValueAtIndex(int index,string value);  removed

  // Sets a new value in the parameter at position. A 0 is returned
  // if an error was encountered.
  int SetValueAtPosition (int pos, string value);

  string GetParamPath ();

  string EvalIndir (char *param, char *val);

  // Read the parameter file from the input stream
  virtual void Read (istream &);
  virtual void Read (istream &, paramfile * parfile);
  virtual void Read (istream &, paramfile * parfile, char *filenam);

  // Print the parameter file to the output stream
  virtual void Print (ostream &);

  // Accessor functions
  list < ParamBoolean > &GetBooleanlist ()
  {
    return bool_list;
  };
  list < ParamInteger > &GetIntegerlist ()
  {
    return int_list;
  };
  list < ParamReal > &GetReallist ()
  {
    return real_list;
  };
  list < ParamString > &GetStringlist ()
  {
    return str_list;
  };

  // The following members refer to information used to build a matrix
  // table from the parameter file entries (and each item within each
  // entry.  Check the implementation file (Parameter.cc) for the exact
  // values and meaning of each member.
  static const char *ITEMNAMES[];
  static const int ITEMNAME_COUNT;
  static const short ITEMNAME_WIDTHS[];
  static const int ITEMNAME_MAXWIDTHS[];
  static const int EDITABLE_ITEM;

private:
  // Objects
  list < ParamBoolean > bool_list;
  list < ParamInteger > int_list;
  list < ParamReal > real_list;
  list < ParamString > str_list;
  string filename;
  string *param_path;
  string _fileRead;

  int start_arg;
  bool read_only;		// is param file read-only (T) or read-write (F)

  // Reads a parameter and saves it to the linked list.
  int ReadParam (string param);

  // Returns the changes made w/in each list of parameter types
  string GetBooleanChanges ();
  string GetIntegerChanges ();
  string GetRealChanges ();
  string GetStringChanges ();


  // Returns the param=value strings for each list of parameter types
  string GetBooleanValues (int evaluate = 0);
  string GetIntegerValues (int evaluate = 0);
  string GetRealValues (int evaluate = 0);
  string GetStringValues (int evaluate = 0);


};

#endif
