#!/usr/bin/perl -w
# based on fl11.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 9 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer2, "frame is layer II");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 192, "bitrate");
	is($frame->sample, 44100, "sample rate");
	ok((($_-1) % 5 == 0) ? $frame->stereo : $frame->joint_stereo, "stereo xor joint stereo");
	is($frame->modext, (0, 0, 3, 2, 1)[$_ % 5], "modext");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
 fUwfeUD2""$          PÜ9˜Ϭӏ4͸ۍ۝~y +_~}}}{ض6>|Zf 47\MlCнoDt]l[o>|k_|v#a	2_̱	\BV=srTx0`toG̈́Wb$PI<<9twx[ϫkXɇBL?J]>f?_WH:a2k$eY+X
ػ2n̚f>0|`i@
e٢:*,mw0qck.e=Oe"ZHt`nvCuVs[;@Nu7jŻV3:ct'IYGNtke"fyȄ%`=9drFlLDUU	-)SrZBpe/GhM>2,]IyQav]nD~s9gs c;3t ")gl%,Yk&.˶8`Æֵ9Gq;N*v&mR2Ǳb'@$HnDkX pB`D3DDDDD33Cm"I$   UUUU}-yjyǜu<<s<yϜ|]q|
,}|
,=Gzy;ͻniL3
C9i4'3BWW+'W+'!CtIj޷"n-bgs+U6R ol>hl>hpl$J+I6̪Tk6͞YVK
MnK
Mj?yѝḰ,0k"yVf$Hcofe\ofe\5kna`XI!
Xe6Q(B1M0C0C𠨑Q6kf:ο7\6kcmtkZִ* 4* msn+૪v7e֬$m>g<sph`@ph`@4infz,baH8jKQm<*U!199=+h2\&޷'44ZҕQZQZ[NSTѴfQtK%m>}kTqޓq޵5jkn#Qdðe@dV*&#q/u((h(lO8v9c|4
I;\.6m
2P\BԀ`aU3UUUDD333mH    UUUUU UUygsqs<s>ϼs< ׀ ׂt8D#>0[=l(T0bm6
	4 l/ӈG/ӈekzM^u]Me
B)*E"T):MPVaMPVaet谋	(fJFm6e=8nٴMnٴMRuԝp9Ü*9?Af3
[.5+ww*J̪L<E4Rضf^c0RBUY3M|3M|+r
!bb&ikZe8N7Wi4U[U[8phC4X,BqYlxϛxϛ~_)`vffbw'x^YG6e2VMmFF@FF@3܍#$N&iƱnZUN"pssu/v{su/v{`IhYqVUe"!]^#7RieLJÁȑÁȐ˲22,O(,0ۉ̦M֔h]f~_]f~_r*ADVEdwgvPiZN'myaҀPWU3fffUDTID  9睹۞yy89y8㮸ǇyǇy)kZa"UD!k+0b dq糵>N&6E';slƱX>hC{DFrƯƯr\Xfl{IihVb8*)|R;QC;QCꍺB+N*&TL<,TiS_`]_`]ێv㟡:T1ʃ*&M(RVm%qG@j@jdY6ʬ\XSV.BC0TBcTTBc]χsYBQ!fR$a:!qb2qb2u7Mխ2dFWlB|Ihv@lhv@l[ٕbEn|\{mt(wiZ+3v36R3v36Sk꘩tL*U<⺤
!'5!'5ј4f	Ɯe9jr̕r)#HfmjF#vޚޚ7iT^+V슢=xtNr@@%DDwwff[l  ꪪ3y9߮y|x99xiIvUiIvVSwQTy)V$fTjȑ_oZt\ҬҬ{g>Ϭ}'%ܳ-s4ҵrp-̎'[9'[93f)J*r\Cմ)JFMPj'X^b^bKB$pP+4*r!s5757X̱5z'6ViN4a`oui&(<(+{7[nGBLTBt^Gij1Yc.HNc.HKǗ&yW9p#~SiS[{Jm-Vmmq<k[ַځ6M30l9ڲ6jNcNbqF:ueMSF"Ƚ8.J`6[QFOC3(
C3(
	22쌺<
8Ԯ%iq(L!y$kv^y$kv^B܅2
h:RWgfhm+gw4Pƨ2(2"E#(Q&C	7ܙ	wA5TJZeF D2DUUDD33CI$$        

8뮺y:y8yy  6l):,/#-DM&!BtABnBnWb)Pt[u:Bxf6[!@ѫ,Xr4Ar4M[4P`)N4Dn8$tŅ)*j3[=*j3[=A܂mҴP/K
*0ABT._kaqSԞqSةSX&*;.lcƄh2kYs"s"9)TP C1!2-Ki,j,T(^
*
"[L¹.S%2K!Bi4q8ԩ5NNN$MI2L,,i"Hmq]$GaB!	J~e	J~e
*/vj晦)ӧ|V{{Z*`1|^jNkjk6i,iСkXQ;}Q;w.\.09k*imI&ŋrAʢ>ʢ>RN
KZ֓	0h0<uLZnׄ p=
C"DUU3D333m$$   URUUWUQu<<qus<]qsAx?1*x?1*ǕQ(}V`iJFq8Tq6t*ԩp"G)p"GU,a FjR)J$NmmJTi%IefVQY{tJ%d1ۇ2
2
湭ve*sQqMF#M&j!vw.cc=^c=^ɦHl !bud)%SVe柢&.&."Gi#H&Rj^¡Unq8m( AG7mDI"7mDI"6tiI"Hڢ!VmۍmF
zvY8QY8+8Q~h&DB(f
өԒI½xlpjlpj;B
XŉbI)@"B$Zrs0rrs0r.rY-l[JYl~n\]QaϘo_Po_P9f}ffYnal
NψLH3TH3T4H'	,Y9XN'RTV+`P`33UfUDDDDDn$H   UUUUg<^׼os<|{ϼusw<:k	C:k	EQƼ 6m<.9HJ.l:H:dT:dTl7xa7JnKP+d7`@w9i77!	 Ax@(Rh'Q78#Dt8#DtmjT(2At3HRh9NRHKfҖ]ɴKkNeFU0#;h)kz*AAjI4J$M1|_-kZ:T;C賴%j%j\*̬'M+Jse!{49ٹ{49(s7,qkb%a4|,%f|rr]E>A%K.q00,
jU)K\axx/ꎨK5=b$(6R,
}O<O<KTC;43BNĝ꫺f+H4M9NUML
H[mL
H[r*VnկLT-b8?op\, h4 P}dDDUfUUUUI"  jh9ߞw߮|89:߭:߭vv{"رS8)UUUٝcQH`h9|ph h&]<p] 2+"lZد	yD/fXItrbih-VUe{\a,g2-z_Lq,q-RZ>}P'OJdJ!,4.2h2cuFshNz׍ycv6	|C 'RIl#ps#psHITJؕ4Lx̔G/bIAm(H(HcnܶmZDL(IhfRoow^1w^1;wMVڭ5sQ\"LYŜJ4U*%IAH^AH^@t:\t)(VPlTEDsw7 fK1Hihh:jU:B%lJاzL4br|11-\Cd6j^Ծie&Qp5SU`iU`iDh[
Er+º6#c;$Dz-I@@nUDfgfe]d  꾪39xxzߎ:yz߭ᜲ~f~f:^UrX䱾wҬ%T]=xI_hSՋn1͋n15}2eL83LC'	C¨_5dnF^dnFU/KV2ВOM$c~A~8[~8Hr)={s"EyfRNg)
n؃(]]jVMT1%)<J<<.9N96)I.
\btY؉%+(6pt[z11:Uʏq3(:UR<YNBR9,IDhIDhئv6Y3~X
b=<jպ5h!h"Hђ4d4ii)$zFhO6+$%P6ԕP6ԓd.tMW
o.-΢oKNCbCb
s\\$JpgM 80/rTϔzTϔkl9His큕>󶔤˶,6J]b)!  ED33UDDD333m$$        
Zy뮺~8ߝy瞷~88瘐6U6U	m$2ZeFtH["J1˖)8&8&yHYE1sqfEdrE"nU.Rcѝe&"d2QeAW҉AXF<zņD_g}:D_g}:.!АH}_Ud[cq[
tltl1Daqgj7r9!mX|2bDbDh^(a2MEv]WRqDf\N*H!/}\ajm\ajh1vWe\H]bXbXe[-jJnPnPK6ifGŵmdMv;h6XoEoEKr*I6g=Ϯ+M)MFHZS%:8%:8|TdXl[ijڴ
6e2mϨka4W(5U4W(5TI%QHX:H5q\1v6R2g<
<
4,hZiSu7oMn[c0nZ-	J>kB p33UUUD3333I    UWURUF\[;<]u\]<0F0FQÜ9JJĬ	Jm&EtҤ
TU]d]dUZ+DDL$Lz*m6o5jT+׫JJMJM*Jԫ;2*#2+]6AqV\hۢ00)1+ì<NLB$,8F"n)S^(B:3ɾ:3έj-Yř2#-2ԩ*HVK$[ץʝVʝV-BMTʬ6Scbؙ'ęLp˙g1g1M\[%,BĬJԵ9\C%jtJ<fG[CG[CA+TeCJ+"N4G#-tJxѰS!Q[!Q\i]43DKB*uJuY$Kשh`4P`4Rm*ҭ9SSqt @mnzbb*S2&b\L A\^E.?}E.?{@4T%F%^k\ˀW+fY,J<x2DP`33UUUDUDDCH   UUUUz}Ugqs]ws{|sos<.pg
s.pg
0#M\4!*
N2*ڶ0Z[LzX
EI
EIZ,2´+63cj:i[Iq ߓ
U ߓ
UDJ#23"2#!9{;Ʊְb#HcJD.i$ߎ.i$]ٻ۽I{<qpM2G7vi]vi]>\ļKM#R55-L;.˛FӪlK%j&xqxqѴ+BM<SBL$fܽKU-`̪=ZFi=ZFC1TED3;C;5Y+; #%o[P	2B钹2B钹K,4C7KtI\:``UfԎ<Č77KT!1<+,?Ã84Z&"sVF?TF?T:;+R4C$2U5J+@4,+
Hqe*pp1IDUC<DI7DK*,mhnJ5lnJ5:#+43<Y-EDSf٣hۃKiF P$\U3fUfUUTG#D  j9y{x9箸<yx;pp(J3q1wwwt`.bb7&h99LL@a³;:÷4ncuh_h_cR#;=r*	ꌨ%w+d|\1|\1?tOD@YHoflي(*RH&)2)2)F꒝)\Թq(Q*ʬbf-OVsuM~%>
->
-s(=LTLܙ2+
:4'(IY7V^7V^UayG9gpamv'y<ΎLIrѲrѲm[fh%bVEz׬H`KbGv;v;/7ђ%{gJ讉r*LfV#J]l*؄*؄Is3aÎmf֮A\4LINUX5٬1A1Bl$rG}d12TdiU\xjz[!UU:Ϊkf'ZNʺ=2,Vh/R5?i @gfDffvekdi  *3yywߎ8㮸|y89箺8Q#C}Q#C}kkXÂkҾpVKsQm0IHv踓&,,Ϩ3E
{E$
ZE~J}ܡc}ܡ`wzҏ7Sw*
6F;
FLqLq =+W
fj=h]V6$k ﹷyxyxN
pa:*	"ubGJMp];];Ǚr<ˊ	c|8}tRfD2"nE#XE#XY.w)
>}:`ǨujҙW^vW^w5)0a#Gz3N.3IúTYJvVvU*VRc=sINp'Sqf5 sZp>E/c|&E/c|#
(U;0sfRV߯>28VKqq<Sn
B&DfJb{,,
ߵndzYК+ڐ4d^VC {<"3DUDUD33"m$$       

0yy㎺߭8y988yܨwC$&iy;麪vR`~H!j4'WY?&nNhH1)gv;>q*zD%z3)+ќEki6!HzWt7xv^Z՝>|97Kjɞ[VLIe\4Y^$qTj1(v[/XpRJnvrUs6NTXVvIkֽr\bzG#ݺ՚І
C00R1`2*
BYAs9tX	1YImEj-mVUfѴ(Vպn8iۍR*p!֩jNW4$b2bf&X,YŝcM(d2ݴv$Dɺt{.9iuWx.VUh!:/T)<yhӯUj08~nXRDnUt]2)ŲM&n7-qv߾,VsV)W-iJhVEdqKt)cG4umkA*tM+r孽qˏg^I\o%bKl$0N&mJrŅJc-` pU3TUDD3333m$    UUUUUU}Ug]qq<<s<|s]seNC/wYh2,/uJHrL0jdЄ N\Lpe-FkQ43BS/23LH!LM6r)MgUo:3}LqCj
ˬWi4mu*t@aJ1G=nS[,!6Sd%eK1)ؙ05h̓9lmt1/xnK#h,Hd,K5qbcVQ_vxּ#+j_k'ii4R$ ^}d{#<+2tBT"꺬+E2uneT)Ci	`,'HKa;NꓳS5Fh/\.Fj
fR
5l]OJ}
TB4+B0NzM"
R)<^%2[z#:(DУ(;2*汬%&*3J&Jj#`sQ`#o,]2k[eov;b9r1ʜGUCtЉHY
Ѵm#Ha#mlQ"-p `JD3UUUUD3D3I   UWUUUUQq<q]q]q]q<<<׿<<Yp#<HB B*ض'#(
J6
PlFg;#GrG#;Cʼcf6=u]Krn/Y}k(M;KļK0KֵqK
mmcf&$k11'5l#<CD6JԽJƱa)E-lEݤRˆ"].B*5Yl˽ض-VjD1pfcؐssĂӳKȼŬ\\ʝ)-AuO34clc-8cm"*DS:DBQļK"RI,$+009Mn>%K:53Q3;3Km[VRIP3\PɹZL1Nc<!̜	L4JFmf
?: m1f{ 3)S-RL$ë:!	М3kq4-LyC݌dўc%/%2SK4^K|k5sΌ;)LCG&>4M)S<ʩX"(6Hk^!(I)Y8P-f3UefUUTXD  *k꾨8~x{8:߭|箸㎸yfc5Ͽƫ\YY%t%J'r-pßWhmچo2Ѝ͜

$K"+avh
Kj1c2G=:^Vl֫T9qJJ)ʏU5qWWG=d"
 =Jr"EN`IsuLԫ$i !;w1	۹mMiN+E,X;Q`)
T2T¤%o!kyUQC1.#9&rITI:IYX{<)kOLwwwkXLȵZKṭf_>RLdӳ;5QÚgB8ɮib9Ԫ"5Ns~L/saPުe"RAt/K=Rk&#P	fatVL`.uXݡ3Fh4HMV[D5K,8Qg9 .ss,˦Nl٢,U]M.2L֒'#j*KyVRZ魷Mm놸kIӖ͋)!zD6)2 @"DDwwvV[l  j3x9xz9xxxzxm8Ζ"m8Ζ"YYo{YOXc.VDR55ti"s\\XBiLwJA*(v?G?Gr.)LRZym8a5QtnzRCfkqg(kqg(n~&4L9-⻬}}9jg"ZE@T{)&	ƈԝ	ƈԑ3glv{^>0ѡ5TwgWO:V!3ȂGmGpQP1$Q/[gU?Sn$,abab.<pa.Ieݸ\Ã4$+ƹQdi"E
N*BE
N*B%LqL,l;132Mj>LޢƟQwQw\-[fiZy7aaځNRav*l/dadaa(T/+S9$h{PhgUӯy#$ӯy#$2
dU&UgVAAQ
4ne̒M@eM@eL_׷S4;&+t  U3DDDDD2D"I$$       


0}xyyy}yy8*}J4ti"کD6IRTEF-mH6kvܹz!Idbk_.˞Y7[VՕeEQvKql[7	THx9M{_
$c^]8N({BPG!1euyHal!BpGϚw+-]T#NUf,K2E$Rvu*Esit!o [v[~˔X0
ӗct:.STյmjJm[Vն)N8$I>kTpµ0FiY:NiZUgH%} x^0lX tgNY"lH10eiX$InŲ,[aB

֏*+rܤgvwkTe]WUq\m[ViZpݱ ~!"o([
*ѝ1y^Qi-KUGi)ZV@'ϩRREo`V[6c,n>WUՑd*P9g.R$դ.ŋ(_IRe&wcVնGQ4M˚TDv1J p.f3DUUD333"m$$    UURUPUUf]q\u<]s]yw<seGt5w:{̬J)BGuؔJS2V̭U!xwîQ*Ҭ9	$LqYXu*KY
pNJB`,nύxf:M#	b1Si=z+^)
q
l\P*Rk&;Y:+J])(N,>|5-khg>Ù¯Nzr(p,$L6ټلӧl @=
R31DxQYfO$橪,N1FiComפ&Ink@~ 1nePnb1ݺL&W.plLl3:)L4Uy0yv8E&LrCPݽ:p}/
z@S+QeKLu0@I)pLqJ˗-kfmbٶXG*<iL%Kjfc0yUsnǖOH0RCvk2l.Hv:bg/^IOUUOLzehmb1O'!iѢpmh `)f3UUUTDDC3m4H   WUUUUUUg<q<<<]qu<g˔=~\i{M,̄HD$BB:	BRJA$[@?Y"󪟝TJ1Rnض
rllV*Uc>Ad~
&[F:61;R,C$2%Úk6L45l8V^.ԩJ1w4
:QZ,eqCeUi,~m&Ici.XrƫU5RF$b,6;cIF/IPmaV0+Z]՘@@%,l1Srj8*=Zs916h~<O鮝;33:%B.
Kc,"I؛
NPun;t+P)20JQ26-(-F'"d(@!FPPˌ"R$
D$B8#KۭVG#DAgkV";_xEX*⮮
 Âin7FC}]s6+ʼN[5TKڶ)S)+MZw	BӸH/<wHήYt7N0GZmiܳpPڋf3fUfUDDG#D  j6
Þxy箺y;뾸:88M#bM#b4vDDDy""K|tWDI]v-:ΎQs~Sys~S}
l(kam5jYOD6I'#l<0-bЋy=)VTUybm߸ښMȞWښMȞMHhC1=ry',Y̜ɤ)6m)xxܮ:5Yܮ:5Y_5c64ͩXeZ["RFC#ttɨMDGr:C={1sZ9KJ̴MӇC/cӇC/cK\VIH-vh5iaUYGi7(؇{U&pU&p]b{4sG9rάa0c;b'!3܅:,:-'?}Wl$JalRجWuj2FΠ-Q'O"u~QO"u~Um43O-#NkmdQ6mu-цz-ц{YZa
[EEIty5`jMO<lÏQ\ÏQF{3^+Ls 3sTK)U"R@"c3fveU[d  h+J蓮7yx8ߞx{zd~9>d~9>RxIdIǽtGŝcbv1x3L11K11^{xO9]% EeTQ3ndyxՈu\j,j/EQ!G%zW-TUX񄪘gz_mMk!Mk6:'@1SuI3@Ɖ*8B|oGl54#l54"רn^7ԝBdDqS>ㆉv>ㆉQ\BEq
A6SekjrGe'K).%.%zk#G煑)ח96)
5uU9|NgMgMSGINnGl޹ky\[7dbBLfY_jfY_jEC!U`*7eHM}˸}˸j%b|^uHw4琣EU9{f{f@x*hZfD̖WtZ9H)oYYhRIeVT͙6&dHiZzUj95,  %33DD33"3"I$I         

0ȟr'yy88瞺8(p(py<HaFVͳN.fK)RJmn4WCn4WCeی]eJҹr(mV+ViL`A`Aٷ%Ilے`&'bn\N.<[m՝:rZY"#:Y"#0PO(эQGQԭ+M҉DɤCfRNwM^M^ө"ԑW]e!HP(JhܮZTEڞ`Tڞ`Tv5!z)]EsIe(\CȑJkTPOf2POf2:a	JE"IdafNSiݻ@cLFLFjH5G#IcUԊDHe:tܹ+smm61cY
]H6
iL	Dj߿t\c
hRc
hRJ%OY鐙iIBضe2I+o:Tv+ZKM^BKM^B*GayH$"HKeN^Zb]Gb]Gմ::DzV Z-B$IDp*n F0pr3DDCD""""II     WU-UUUQ6k<]s<u<<<균균+ror)TED%hvPEm[2gN1ZCM8esM8et@^NDIZV+׎Nfg;ZY̤ڋY̤Sҥ8*ҍ(ieAP;+6xpժtiW8aB8aBt6t-gCgQǱpb$n-[BF(dF(b8Д	IAhȲ*YVWϞ]+@!Э-Э-C˒u<'_<_mSj\|f2B%:oƎZoƎIiYVIj*t9G_]ӪT&iկqq23 N%]cX̓%F.ѰH	DZmTPTPҍ%m(Q&<JTAAt߽J&XʃbŊbōa4ٶL"H\4!Oo7aλ]]cOEf4]138*
 ϛv>tpdhHhnZNgkZڙeKNO^Yш`ڣ2DUDDC3"H@   WU}U}UQ$om[sw|q}|w]q<':I':ItwP8۩{4H~8e\9
LN
LJ(TQ<(&[Uq5$ISk!C|Y&fʶ'ʶ'2֪\eT
(/aCvvE#ۻT<xT<x'%OKMSBsLjZUDc%	B	<	=Sq ALs骚fH5Xn\{54p4p4D&JhLQ-cX@`X!$r8ֿ~rn#rn!h2fC4d̥(Ĺ.lvEA|ZiS	cɍlՈlՈ2e/*1Q3L:p*g:T\q.q.Z;aa"`
xm[SEEW<uThuTy39+qt]eUAr|mBiƗii&Da@LhVֶѴ}\&BmΕ-.Q\'\&]@
f͂=*ɽn). P?DDUUDC36$   *4yx뎹yyy|:y\/\/Ȭ
X%EP#1QcXfHE@.Kl1D.Kl1FTJU}E/bhu]^hMb5(`I0Vn°%rW*riV$GXrDYuO$_λ$_κOl
,FmfmԦ)[+ tqk$tqk&uiϋ9s331nB!w$HGKB" ZR7VoU&R*ؗ%̦$*&+hWhWߋſQ}U%R]SCUtnCo<Gd<Gd8?pwH5k!`
 @ %Q+5L!}3r!}3r{Y4iQ^V*7
1M-xI==GUE%ЇAVEyVEeXV*dJX?-U-Tx2 ew1c[6)R̳T@Mk_Ԇ#_Ԇ#	CIQN!^EZhTn^ @/UUeTD6$  Q5y8xy:뮹89lklkm
=
m{xL6sҭ+Mxr[PiLhHhQ) i{8UMTQUvG0ˠ'bHvU
MvU
M1SSj'mpcᲛ"$@Hr
Hr
>}E!<df!_puGd=pô=p÷ Joޭ HLRK|cĤD00*ٽGM9N43C
1nq(mkK4)Kҋ4)KҲ"Q)"#,0ebqM$j5#R]VWlWN_R%KN.|ps4o) o) N%(mMBD1^WpF[D&ǸPQ+PQ+}/~1|^p±άsO4RetnNp՘GY`Z`Z{\ƒvs^W+Rֆݗ,O62
Yąg
Yąn^zuLTԃ3V
OUF  6
3D3D333""E"I         
AMy88㎺yy+}	\LuY*WtIHTH0o^p@>OxjzU*
k7!șڍHNŊ$Ef M-^xgcm[\Db2	U"J2r!+؛׋^nQIe̒e[ [aɓ|^<XX	QmJmx%+JV8cpfi2C-&R$pen4t0W aނN(ZUҩVVo|g
>6DHd՚arY&F3T|cRI^
Jl2KP$6eZY!il۷p
>JZq+Dj+`WFWUw%ɩT.(xp6F6K\7 "}w Dލv]u!HnbFRLf.Ńz3ͻ|lvyǜX&S(zU&yJ1 ݥDPLA18np$p[ a pID3C3333I"I$    R}}UU}*jنsϜ<<]ssϜt9	XrmgL֊EM$QkNwN9v\ %6 K,|HYb]TA!+l&۶v-Rl[Psؠ."ӑ#敨FnE"I$D0g02e=BH%tK'!\BEiDF#'"@ֵo7#o(i-H*],]Ks
2hBRkeQ|(-7>Zo_fF̈\-n6[1(m6qb$DZщĥ]eJj!
R7v;o7+1kPtka;ɦw-EۗJܺ].]#J*NvrJDxމe$!HE7o+92BҚTc缝;g
_djIWq8q6{}F/_3;.ے]%OShp8؛ 2e*ÅJI焓	gH9tUKfrDuRI&7)MZ5`L3CDUD3333m@    PURUUUT]g\cq<s<<q]q ڪX/
X/
$bA XVj
\n3!L+^\yrSLֈ6Lֈ6|u4I<ZJaIZ[xIWcxIWc;)#`h&im9H\g-q{{֝i8$K|j4dK,bI%F
HO I>$q$q3[5Nc 6Sel&
5M&%R
b1C:[cmi,ٶmVFq8Z=7W+\i֑륦i֑p$Ѵmb)B$r<^.fy<Uˤqƣye8iye8i rG$~JM15d2<N\椟"|P-KR-KR43AGdGƎSiJTnR)+L1Z=ߡZ=ߧUuU_,rQM&i4dL03,jUϪUϵ'RpcXY)j5-uGSl9MtHoHoE)M&RFmS(  P7FfDTUUD46D   *nL2x9箸㮹x|8A*
fkfkz4_F.!3s7I_ۈAVAMm~Z~ZG4Ċ"%1JTkZsrF5oۜ#D#DT2QDV:l""(pƔƵ^Ƶ^~z!m
JTia
O$ꇟjT pݦ pݦKr	s)YfvgI"ޚʪyԳHc
Hc
\7(K
jHDdF-s<.K]xݼǭxݼǭ>6'g.hvXu,\ %t{VeYVeYJRJW8Ul-(UUUs\J(G6()FƸ&Ƹ&ۏb5".DKJhZ[H3b^Pe2,$|,$|pT/
q)ugVXV[ J)c^

%
2EyPxWaBZ`6XRlkf.@d~.@d~X\=|_(LHd5BgO@ @MUDVeE[\  (*1u]Dx899x::߭_-c  Aqa\]MFPr]t4##75vssWkx=Z@sKS첹,FZsEZsEu(R\ 1LÉFY>^(NGy-+gJoAHoAHh8STJhD[JoRiyD	͇D	͝j8R.h5&T,O^ST#jk#jkY7{Uxs*N&];4!HeWYWY303?Fѻn:v9"4wGBмY7SY7S
	BM02]M,XbaR&b>.>.t 'A
DX[S0ֲ(h<ֲL
^n
^mmz7Q\$ɴ	)S#)U1ULjdXjdXY5
gMZZ(ʆɶkhUhUEh Vbذ9 I	r+8  ^""3D3"""i"I$        
Zy5P4|9zxy{8862S062S1aX]veJ[0bl߿Ptքݕ3ݕ3B)..RJ)
LMbȑi|ԧk  1!sgÇStX!Rz]:]:$22C!qu:YFD.<zt&>}Z///_pL)Mwkݴɖ,X\ck^O{{q01J+.Jy @
{ll$cKrO64|GQY2n<fLj~T\/3j3jc7Óv3|97919Hi*XPH)TczKUFKUG[թ8a*"J4U*M9kmba1*Ѱ*Ѱ639#c1ǎ[pq7N]q9pWpFLZWpFLZa>6|!RIRRLٸpLčRT(yw(yw)X:Ql>|H`XT0`&N>|kZ p"333"C3m$    PU-UUWUsK6͘gs<s<]q<|q<<T-h_oZEjHVK#u}1ZiZI<YΏ\heI)QQ\Ņ7tP8mjSts4+=klIɅW+ZZTW950rIQJfu.aXiJlSBR1Vk=z#ID\ 
i6`֙#f)Ml&h#鮮8eNWkMVK:l];=ӭsie2p̈T!ݻk)J	"'L Y;L@4ʯd)J[$H̆IsR)7lId0YikUJL&[ID1Hƅ
֫^pZ1߻ 
;[UÂhdBNf9lPLOϪb~N}Q/XҔWn6hXFK%nG$X1BYqRKDқn7:Vc`nW*+l[WiΗK_ށ)l|"VK%ǖ6mR7.5h `A"w3333DCmH   TU_U1vpa}ou\qq<s=u18eY/i}<SOL>GIXdE9Nar
u+7gqkŮ\r`9{gYl"NW.mkٍQ{U
*;G<J9_MNls
f#FM4J'沙N`Lwndow$,4R)$%RZm"q'+:od	ֈb\CanAIjڵ&QȜ[MUfgU3$-	V:M$r8S)rljHE+`r9"M4:_Bgmz#T!E~[ aEh:1uGe8?8s)h 
F	E"9IpRfg 6W9-[VC($1(S{>##s؍Qo7>Viq(Ȳ-q>+,ȏ">=74Q詸UT
#[OEQ	i!ӥ[M(n'F[-EhJ$n	< Ptt3e3DEXh  yL?yzx:뮷ߞy|U^,TªC,C,LW+^MlEr7"K&W:$a%y
Nn:Bn:UdjT[Zmqu0K
=	iZpN6ss4ce2rKP"ϙhqQ)#j #jqhxu5eOLEh=]0T݇E݇Evds/y	#.	9XkVMdӴV*
rh
rh,Wj+K\bU*cq*]lcRҫ~qɿ8	C	U"beZUa&L:L:ɺ.blc3lb'rq>'ڼxV	.ڼxV	]3z.
k3SQp7d[|rh
DZ2k2k(Y,~ZQ,KZ\+@ZIlfK\8``z``z{pٽ8vd'
ns**[ƖuCN;ӵQ4w&Q4wlvXb\.$i,0&Hjv@3DDUm  |3x8y7}8㮹Fm7)St~et~eBf
4ade5d+6tBBV5Y2%b@]Nab@]Naqnc `m){GD2)T]`	78	73)gRY}43޵ˍ
EQQJJ=Fþz{vyYӬjMb%2X-I%!]
JBj4cmU>7(â(dq44雿^T7~Fm	JC.(*ambɼXgeXgeBn=ykeںZ-5J;MA5~5~MoSާrH U*͊hjUrvaNh{晔h{晔"EN&`uūk򻊲=vloWffAFh$M!]*NdKR
!S'GrI*rI*8Zqo{7uީHNn9ܤbKt	666ߘǒk'1$F}8P'  "3w  "3Cm$       
8rcާwy;yyy8E!b:B	7 wxTgϩJ:Rۻ]mǣ͆×55TH8R9h\r;mttI$~RI$;߾k[M&j[fT6eN"/D?_fsrSBZIRVcY:3G79,{Csc3s@\
l8jU-cn7
e9kF:U(z|엧,-X[g` XeZE"m^¡Or,v@h	/6䭹, Mm:UJve)ҷ|aȿw=ꆍa	2QhaZXl/^h)R)KĻl::åU: n}ӟtey P*Q<{ZqY<APS
0=c{um2iO%JQm۵q8lzj6 36hfl&є$\8*U&aÅ	sJ*ڝPu
y9DzrRd͘[;VQ8J0
J(3ڎ<ݛVg=68{qug0Iۭ.mkZpn1""U  33mH   UU}UUUUu]qz]s]ss>sϜ<qV=/ةة":굥.S(S)ƣE"tDin!y@!Bi@!BiD{]ӽwB21)ШN7q8-*Jf3,`23O3LR:-Z$Y[DʩSlm$in3˰n3;` ͔-C!IXT(H3UL2,7@27@2ԍQܒ5Gr9<n6"u0
LDr?񔆭tX9Ѕrmp8<ybcc;wgmwgm|2̥$$	BDb,MF-*PjEBpOgObxuS^$f2Nr9VdsڲY$2=ջ-ջ(!cpn*k5=jl:pG3q݃uu  d"hnVqXd̉flϥ5}xD|5D]d5L.͍{um?/ݵm~Uݵm~S)-g5ilK-u;ÂM8 `h33DD  "CnH   UUU]qu)5:MNak/Z<<qu<Ä8CM]xo|7'eiZUJ-\;gO{CJ{CJ5ӠSZ-:fJe1vdJf/b'O~.Bm.BmbJƵaXj5&BE'p!b4i--II%4]C2;vDAl2։2Ca#+2Ag+2AgUԩ<u]J1\uqC&8sJ4d$I	Ju	JtlZno,Dmiν>nOEf6/u6/wq (BFm)eMhO%[Y5st86(86(ѣi6zt(Fhd._Q$ʾ욤IFCᝁFCᘼ}ȜGb7ϛf2>"}HD>De}De}_Zlml<[#Ч
r/+{V 7l7 7l$oN6fXQ"
0'
oZ቉Ny҉NyM$1-JժQ'ZDă PM3DD  9,  Bꪫy7~@D;y랸㮼8x㮹NsKVViyyؑbG]Wd)!Re%K##I `4I `	Y|%fP)Ivi3%I\oLޚ9s\\ƤƤj}$O0"0Zf؅6mj>pj>g8W]-#=v\sHZNLMԛ((y!y!FWL!wIhbdZkdek!k!33ͭmA-9odRN__4XR4XNz9G{
TQ&jacNaGcGcȶȗL2]3@7XE'KؕIUwɋw$rw$B˓B˓BRJnȒq7oMSԢSԨ++(;H7)Z+WI2<t=j-=j-? EkqaR\-5kbhWVWV㉹x2㉹x}y0us2qS@DUe9mѴ  (+9瞹mEL3<;ߞy9x뎹箻gOni/`%c-+hK+@KlB܉H՚LEa{dv۸칐]
"
oC .SEq'ѵ)SNc{JZU[^~
#@Sj
D1"0ӋlٵKR;#]NWmt܁uySy@Cy&cB{ϕ3$~#6[}.HXh舭\Y<Kj],H"\lTgOl> RZ0b`Qi{F*ɊE(eic+Ly2fĄm1ܸ\jfh]6qZV=ME#$ԣek'(fUX*5ؖsBoX
jԐ$2}Cҝf,nUR?43e;Fc83fh-Pj}~X|ʔQ5A).'/{
wõ\t9LeK?]XFd.""vJu G2IKjTiuF0|߆13pk %40  $33Dff     bI"I      _y~߾81Ly88y璒)+j={CqlnY8nY:#;gts,)ǊRֲc&MۨQ
hZ/XZ/RVBl/q4b@4phS
]dY8ƝdY8 d߫V2.mhɲdEIqdqd"dRQ]˜aIFDd|9
5ZJXX(u]ks0yz*R5:tjhԮ1\bhiyc8Ltb,*H 1c%YB4cHWggA&ׂgA&ܾw;e!o[Qҍ(E.	23.3.e/5W4JXʓ5]Qu`Y@LK DK F6×ծ]_`#Zֳ1&m)"REU«;l*lvEMLǯmhf&c;^v6*l^DĤDĔj8ҍGX7 @ֵN02aCkmU22FVre%H^ p,33Dfw    I%   UUPPUUW<<?OцL(w]u<<
@ì.]*$TS6]ow9_.wǴ\o-lbGxjvWR?+Ej&J~QKQ[+2$HHc@bpX-kg~2
$_8g*vl+%ZJObZ>0#ӕ`
*`R,ֵmeļ9#VyF򋵲lM7 bѾsyP
*sw
QOB<Uezˌa;5L;ý_ʿT$pN:-;藂m/r@YHh)
RBk7,ͥgJ8qB&=KE#;+iFwV΋>gڥlxVlz[ƶssvBe9K݇){ғ[jNQu		3LJe80ú2tevnJU+f+3:4&s'*j\Jr+U'ޑYO#&r2CBFnnn>ϽԌ./R0Jd&	!7DsծQ   `s33DfwD̈   Q    UUPPUUW>qϜs<<.dg)Ċs<<
S;&MeBi
Ӂ[|
BKOBjz7$Mm*GkŬk:c8KȣoHQl*/tKtjW
BڶNj
	<D"~trb(kT֨QjZo[E:춊t1IXORlҍ(U/_L7!CkM׊KS`?zL^]5eQIΣ+FUDEu|'ZѺry`aٌΰ}t: Afn6"8xpP̈́\f.`WRU'O\qt3t7| N8@5ƚMUg-$J^8s0-M+SJ
xR
:DA<v㷶j(6j+TVMrf]>OKQo7S]͛lڶr&Be970mWj<2N%wKkN9ukr׆XenSNyenEG" +xD"6' P3DDvwwD  $  ;9yxԤ5)
7X9޽^Y呹s:uY:nx뼻.ð" dz" dza6/sR3|}'&nX!<ɔrvd}*Vgғc*Nj*N|=*z"U^vl*a^s|02LR4J*9]$"UP:<Lxr&ɴ,C;n;npt~M!ZbM^{WUcrCTbsTbsPS2)YcϺs{7޸.noڱnoڿvY>
քZ#<Fxy4ȭdi
x¿@oM@oM 
lXi
v6mcAh_Sԓ$݋Ͻ
GϽ
Gi?}
*=QB\Icƪ-QEuMQEu]>wּ la's'U{lV;}}/4>gaSdIꤷ-[md$
OP$
OM+g@ 
