package Daje::Workflow::GeneratePerl::Generate::Fields;
use Mojo::Base 'Daje::Workflow::GeneratePerl::Base::Common', -base, -signatures;

# NAME
# ====
#
# Daje::Workflow::GeneratePerl::Generate::Fields -
#
#
# REQUIRES
# ========
#
#    use Mojo::Base
#
#
# METHODS
# =======
#
#


our $VERSION = '0.01';


has 'select' ;
has 'primary_key' ;
has 'foreign_keys';

sub generate($self) {
    my $column_names = $self->json->{column_names};
    my $length = scalar @{$column_names};
    my @keys;
    for (my $i = 0; $i < $length; $i++) {
        if (index(@{$column_names}[$i]->{column_name},'_pkey') > -1){
            $self->primary_key(@{$column_names}[$i]->{column_name});
        }
        if (index(@{$column_names}[$i]->{column_name},'_fkey') > -1){
            push (@keys, @{$column_names}[$i]->{column_name});
        }
        if (defined($self->select) and length($self->select) > 0) {
            my $select = $self->select();
            $self->select($select .= ", " . @{$column_names}[$i]->{column_name});
        } else {
            $self->select(@{$column_names}[$i]->{column_name});
        }
    }
    $self->foreign_keys(\@keys) if @keys and scalar(@keys) > 0;
}

1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::GeneratePerl::Generate::Fields -




=head1 REQUIRES


   use Mojo::Base




=head1 METHODS





=cut

