use v5.40;
use experimental 'class';

class Daje::Workflow::Roadmap::Load {
    use Daje::Config;
use Data::Dumper;

    field $workflow :reader;
    field $path :param;
    field $type :param = "workflow";

    method load() {
        $workflow = Daje::Config->new(
            path => $path,
            type => $type,
        )->load();

        return 1;
    }

    # Get the entire workflow as a hashref
    method get_workflow() {
        return $workflow->{workflow};
    }

    method get_state( $workflow_name, $state_name) {
        my $flow = $workflow->{$workflow_name};
        say Dumper($flow);
        say $state_name;
        my $length = scalar @{$flow};
        my $state;
        for (my $i = 0; $i < $length; $i++) {
            if (@{$flow}[$i]->{name} eq $state_name) {
                $state = @{$flow}[$i];
            }
        }
        return $state;
    }

    method get_pre_checks( $workflow_name, $state_name) {
        my $state = $self->get_state($workflow_name, $state_name);
        return $state->{state}->{pre_checks};
    }

    method get_post_checks( $workflow_name, $state_name) {
        my $state = $self->get_state($workflow_name, $state_name);
        return $state->{state}->{post_checks};
    }

    method get_next_state($workflow_name, $state_name) {
        my $state = $self->get_state($workflow_name, $state_name);
        return $state->{next_state};
    }

    method get_state_observers($workflow_name, $state_name) {
        my $state = $self->get_state($workflow_name, $state_name);
        return $state->{state}->{observers};
    }

    method get_activity($workflow_name, $state_name, $activity_name) {
        my $activity;
        my $activities = $self->get_state($workflow_name, $state_name)->{state}->{activities};
        my $length = scalar @{$activities};
        for (my $i = 0; $i < $length; $i++) {
            if (@{$activities}[$i]->{name} eq $activity_name) {
                $activity = @{$activities}[$i];
            }
        }
        return $activity;
    }

    method get_activity_pre_checks( $workflow_name, $state_name, $activity_name) {
        my $activity = $self->get_activity($workflow_name, $state_name, $activity_name);
        return $activity->{pre_checks};
    }

    method get_activity_post_checks( $workflow_name, $state_name, $activity_name) {
        my $activity = $self->get_activity($workflow_name, $state_name, $activity_name);
        return $activity->{post_checks};
    }
}

1;





#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

lib::Daje::Workflow::Roadmap::Load - lib::Daje::Workflow::Roadmap::Load


=head1 DESCRIPTION

Get the entire workflow as a hashref


=head1 REQUIRES

L<Daje::Config> 

L<experimental> 

L<v5.40> 


=head1 METHODS


=cut

