# Generated by default/object.tt
package Paws::Connect::OutboundCallerConfig;
  use Moose;
  has OutboundCallerIdName => (is => 'ro', isa => 'Str');
  has OutboundCallerIdNumberId => (is => 'ro', isa => 'Str');
  has OutboundFlowId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::OutboundCallerConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::OutboundCallerConfig object:

  $service_obj->Method(Att1 => { OutboundCallerIdName => $value, ..., OutboundFlowId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::OutboundCallerConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->OutboundCallerIdName

=head1 DESCRIPTION

The outbound caller ID name, number, and outbound whisper flow.

=head1 ATTRIBUTES


=head2 OutboundCallerIdName => Str

The caller ID name.


=head2 OutboundCallerIdNumberId => Str

The caller ID number.


=head2 OutboundFlowId => Str

The outbound whisper flow to be used during an outbound call.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

