# Generated by default/object.tt
package Paws::LakeFormation::ColumnLFTag;
  use Moose;
  has LFTags => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::LFTagPair]');
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LakeFormation::ColumnLFTag

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LakeFormation::ColumnLFTag object:

  $service_obj->Method(Att1 => { LFTags => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LakeFormation::ColumnLFTag object:

  $result = $service_obj->Method(...);
  $result->Att1->LFTags

=head1 DESCRIPTION

A structure containing the name of a column resource and the tags
attached to it.

=head1 ATTRIBUTES


=head2 LFTags => ArrayRef[L<Paws::LakeFormation::LFTagPair>]

The tags attached to a column resource.


=head2 Name => Str

The name of a column resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LakeFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

