# Generated by default/object.tt
package Paws::FMS::App;
  use Moose;
  has AppName => (is => 'ro', isa => 'Str', required => 1);
  has Port => (is => 'ro', isa => 'Int', required => 1);
  has Protocol => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::App

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::App object:

  $service_obj->Method(Att1 => { AppName => $value, ..., Protocol => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::App object:

  $result = $service_obj->Method(...);
  $result->Att1->AppName

=head1 DESCRIPTION

An individual AWS Firewall Manager application.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AppName => Str

The application's name.


=head2 B<REQUIRED> Port => Int

The application's port number, for example C<80>.


=head2 B<REQUIRED> Protocol => Str

The IP protocol name or number. The name can be one of C<tcp>, C<udp>,
or C<icmp>. For information on possible numbers, see Protocol Numbers
(https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

