package Net::Amazon::EMR::Instance;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::EbsVolume;
use Net::Amazon::EMR::InstanceStatus;

has 'EbsVolumes' => ( is => 'ro', 
                            isa => 'Net::Amazon::EMR::Type::ArrayRefofEbsVolume',
                            coerce => 1,
    );

has 'Ec2InstanceId' => ( is => 'ro', 
                         isa => 'Str' );

has 'Id' => ( is => 'ro', 
              isa => 'Str' );

has 'InstanceGroupId' => ( is => 'ro', 
                           isa => 'Str' );

has 'PrivateDnsName' => ( is => 'ro', 
                          isa => 'Str' );

has 'PrivateIpAddress' => ( is => 'ro', 
                            isa => 'Str' );

has 'PublicDnsName' => ( is => 'ro', 
                         isa => 'Str' );

has 'PublicIpAddress' => ( is => 'ro', 
                           isa => 'Str' );

has 'Status' => ( is => 'ro', 
                  isa => 'Net::Amazon::EMR::Type::InstanceStatus',
                  coerce => 1,
              );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::Instance

=head1 DESCRIPTION

Implements the Instance data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_Instance.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
